/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import java.io.File;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.gui.abstractdialog.BaseDialog;
import org.dbgl.model.conf.mount.DirMount;
import org.dbgl.model.conf.mount.ImageMount;
import org.dbgl.model.conf.mount.Mount;
import org.dbgl.model.conf.mount.PhysFsMount;
import org.dbgl.model.factory.MountFactory;
import org.dbgl.service.TextService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class GrabButton {
    private final Button button;

    public GrabButton(Composite composite, final Text text, final List source, final boolean isBooter) {
        this.button = BaseDialog.createImageButton(composite, TextService.getInstance().get("button.grab"), "grab.png");
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = source.getSelectionIndex();
                if (index == -1 && source.getItemCount() == 1) {
                    source.select(0);
                    index = 0;
                }
                if (index != -1) {
                    try {
                        Mount mnt = MountFactory.create(source.getItem(index));
                        if (isBooter && mnt instanceof ImageMount) {
                            text.setText(((ImageMount)mnt).getImgPaths()[0].getPath());
                        } else if (mnt instanceof DirMount) {
                            text.setText(((DirMount)mnt).getPath().getPath() + File.separatorChar);
                        } else if (mnt instanceof ImageMount) {
                            text.setText(((ImageMount)mnt).getImgPaths()[0].getPath() + File.separatorChar);
                        } else if (mnt instanceof PhysFsMount) {
                            text.setText(((PhysFsMount)mnt).getPath().getPath() + File.separatorChar);
                        }
                        text.selectAll();
                        text.setFocus();
                    }
                    catch (InvalidMountstringException invalidMountstringException) {
                        // empty catch block
                    }
                }
            }
        });
    }
}

