/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.dbgl.gui.controls.ChangeTrackingControl;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.conf.Autoexec;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class MetaControl
extends ChangeTrackingControl {
    private Function<Template, String> templateStringGetter_;
    private BiConsumer<Template, String> templateStringUpdater_;
    private Function<Profile, String> profileStringGetter_;
    private BiFunction<Profile, Integer, String> profileIndexedStringGetter_;
    private BiConsumer<Profile, String> profileStringUpdater_;
    private TriConsumer<Profile, Integer, String> profileIndexedStringUpdater_;
    private Function<Autoexec, String> autoexecStringGetter_;
    private BiConsumer<Autoexec, String> autoexecStringUpdater_;
    private BiFunction<Autoexec, Integer, String> autoexecIndexedStringGetter_;
    private TriConsumer<Autoexec, Integer, String> autoexecIndexedStringUpdater_;
    private int index_;

    public MetaControl(Label label, Control control) {
        super(label, new Control[]{control});
    }

    public MetaControl connectTemplate(Function<Template, String> getMethod, BiConsumer<Template, String> updateMethod) {
        this.templateStringGetter_ = getMethod;
        this.templateStringUpdater_ = updateMethod;
        return this;
    }

    public MetaControl connectProfile(Function<Profile, String> getMethod, BiConsumer<Profile, String> updateMethod) {
        this.profileStringGetter_ = getMethod;
        this.profileStringUpdater_ = updateMethod;
        return this;
    }

    public MetaControl connectProfile(int i, BiFunction<Profile, Integer, String> getMethod, TriConsumer<Profile, Integer, String> updateMethod) {
        this.index_ = i;
        this.profileIndexedStringGetter_ = getMethod;
        this.profileIndexedStringUpdater_ = updateMethod;
        return this;
    }

    public MetaControl connectAutoexec(Function<Autoexec, String> getMethod, BiConsumer<Autoexec, String> updateMethod) {
        this.autoexecStringGetter_ = getMethod;
        this.autoexecStringUpdater_ = updateMethod;
        return this;
    }

    public MetaControl connectAutoexec(int i, BiFunction<Autoexec, Integer, String> getMethod, TriConsumer<Autoexec, Integer, String> updateMethod) {
        this.index_ = i;
        this.autoexecIndexedStringGetter_ = getMethod;
        this.autoexecIndexedStringUpdater_ = updateMethod;
        return this;
    }

    @Override
    public String getCurrentValue() {
        String[] fieldValues = (String[])Stream.of(this.controls_).map(x -> MetaControl.getFieldValue(x, false)).filter(x -> x != null).toArray(String[]::new);
        return fieldValues.length == this.controls_.length ? defaultConvertor.toConfValue(fieldValues) : null;
    }

    private void internalSetControl(String value, boolean multiEdit) {
        if (value == null) {
            this.setOriginalValue(value, multiEdit);
        } else {
            MetaControl.setFieldIfEnabled(value, this.controls_[0], false);
            this.setOriginalValue(this.getCurrentValue(), multiEdit);
        }
    }

    public void setControlByTemplate(Template template, boolean multiEdit) {
        if (this.allControlsDisabled()) {
            return;
        }
        this.internalSetControl(this.templateStringGetter_.apply(template), multiEdit);
    }

    public void setControlByProfile(Profile profile, boolean multiEdit) {
        if (this.allControlsDisabled()) {
            return;
        }
        this.internalSetControl(this.profileIndexedStringGetter_ != null ? this.profileIndexedStringGetter_.apply(profile, this.index_) : this.profileStringGetter_.apply(profile), multiEdit);
    }

    public void setControlByAutoexec(Autoexec overrideAuto, Autoexec combinedAuto, boolean multiEdit) {
        if (this.allControlsDisabled()) {
            return;
        }
        Autoexec autoexec = multiEdit ? overrideAuto : combinedAuto;
        this.internalSetControl(this.autoexecIndexedStringGetter_ != null ? this.autoexecIndexedStringGetter_.apply(autoexec, this.index_) : this.autoexecStringGetter_.apply(autoexec), multiEdit);
    }

    public void updateTemplateByControl(Template template) {
        this.templateStringUpdater_.accept(template, this.getCurrentValue());
    }

    public void updateProfileByControl(Profile profile) {
        if (this.profileIndexedStringUpdater_ != null) {
            this.profileIndexedStringUpdater_.accept(profile, this.index_, this.getCurrentValue());
        } else {
            this.profileStringUpdater_.accept(profile, this.getCurrentValue());
        }
    }

    public void updateAutoexecByControl(Autoexec autoexec) {
        if (this.autoexecIndexedStringUpdater_ != null) {
            this.autoexecIndexedStringUpdater_.accept(autoexec, this.index_, this.getCurrentValue());
        } else {
            this.autoexecStringUpdater_.accept(autoexec, this.getCurrentValue());
        }
    }

    public String toString() {
        return this.label_.getText();
    }

    @FunctionalInterface
    public static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);

        default public TriConsumer<T, U, V> andThen(TriConsumer<? super T, ? super U, ? super V> after) {
            Objects.requireNonNull(after);
            return (a, b, c) -> {
                this.accept(a, b, c);
                after.accept(a, b, c);
            };
        }
    }
}

