/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.model.ImgSizeCommand;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class EditImgSizeDialog
extends SizeControlledTabbedDialog<String> {
    private ImgSizeCommand sizeCommand;

    public EditImgSizeDialog(Shell parent, String command) {
        super(parent, "imgsizedialog");
        this.sizeCommand = new ImgSizeCommand(command);
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.imgsize.title");
    }

    @Override
    protected void onShellCreated() {
        final Composite composite = this.createTabWithComposite(this.text_.get("dialog.imgsize.params"), 2);
        final Spinner bytesPerSector = EditImgSizeDialog.createLabelAndSpinner(composite, this.text_.get("dialog.imgsize.bytespersector"), this.sizeCommand.getBytesPerSector(), 1, 4096, 0, 1, 512);
        final Spinner sectorsPerTrack = EditImgSizeDialog.createLabelAndSpinner(composite, this.text_.get("dialog.imgsize.sectorspertrack"), this.sizeCommand.getSectorsPerTrack(), 1, 255, 0, 1, 64);
        final Spinner heads = EditImgSizeDialog.createLabelAndSpinner(composite, this.text_.get("dialog.imgsize.heads"), this.sizeCommand.getHeads(), 1, 64, 0, 1, 16);
        final Spinner cylinders = EditImgSizeDialog.createLabelAndSpinner(composite, this.text_.get("dialog.imgsize.cylinders"), this.sizeCommand.getCylinders(), 1, 8192, 0, 1, 20);
        bytesPerSector.setFocus();
        final Text totalSize = EditImgSizeDialog.createLabelAndText(composite, this.text_.get("dialog.imgsize.totalsize"), this.text_.get("dialog.imgsize.totalsize.value", new Long[]{this.sizeCommand.getTotalSize(), this.sizeCommand.getTotalSizeInMB()}));
        totalSize.setEditable(false);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                EditImgSizeDialog.this.sizeCommand = new ImgSizeCommand(bytesPerSector.getSelection(), sectorsPerTrack.getSelection(), heads.getSelection(), cylinders.getSelection());
                totalSize.setText(EditImgSizeDialog.this.text_.get("dialog.imgsize.totalsize.value", new Long[]{EditImgSizeDialog.this.sizeCommand.getTotalSize(), EditImgSizeDialog.this.sizeCommand.getTotalSizeInMB()}));
                composite.layout();
            }
        };
        bytesPerSector.addModifyListener(listener);
        sectorsPerTrack.addModifyListener(listener);
        heads.addModifyListener(listener);
        cylinders.addModifyListener(listener);
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditImgSizeDialog.this.result_ = EditImgSizeDialog.this.sizeCommand.toString();
                EditImgSizeDialog.this.shell_.close();
            }
        });
    }
}

