/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.gui.controls.BrowseButton;
import org.dbgl.model.NativeCommand;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditNativeCommandDialog
extends SizeControlledTabbedDialog<NativeCommand> {
    private final NativeCommand nativeCommand_;

    public EditNativeCommandDialog(Shell parent, NativeCommand cmd) {
        super(parent, "nativecommanddialog");
        this.nativeCommand_ = cmd;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get(this.nativeCommand_ == null ? "dialog.nativecommand.title.add" : "dialog.nativecommand.title.edit");
    }

    @Override
    protected void onShellCreated() {
        Composite composite = this.createTabWithComposite(this.text_.get("dialog.nativecommand.tab.info"), 3);
        final Text command = EditNativeCommandDialog.createLabelAndText(composite, this.text_.get("dialog.nativecommand.command"));
        command.setFocus();
        BrowseButton cmdBrowseButton = new BrowseButton(composite);
        final Text parameters = EditNativeCommandDialog.createLabelAndText(composite, this.text_.get("dialog.nativecommand.parameters"), 2);
        final Text cwd = EditNativeCommandDialog.createLabelAndText(composite, this.text_.get("dialog.nativecommand.cwd"));
        BrowseButton cwdBrowseButton = new BrowseButton(composite);
        cmdBrowseButton.connect(this.shell_, command, cwd, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.NATIVE_EXE, false, null);
        cwdBrowseButton.connect(this.shell_, cwd, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.NATIVE_EXE, false, null);
        final Button waitFor = EditNativeCommandDialog.createLabelAndCheckButton(composite, this.text_.get("dialog.nativecommand.waitfor"), 2);
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditNativeCommandDialog.this.isValid(command, cwd)) {
                    return;
                }
                int orderNr = EditNativeCommandDialog.this.nativeCommand_ == null ? -1 : EditNativeCommandDialog.this.nativeCommand_.getOrderNr();
                EditNativeCommandDialog.this.result_ = new NativeCommand(command.getText(), parameters.getText(), cwd.getText(), waitFor.getSelection(), orderNr);
                EditNativeCommandDialog.this.shell_.close();
            }
        });
        if (this.nativeCommand_ != null) {
            command.setText(this.nativeCommand_.getCommand().getPath());
            parameters.setText(this.nativeCommand_.getParameters());
            cwd.setText(this.nativeCommand_.getCwd().getPath());
            waitFor.setSelection(this.nativeCommand_.isWaitFor());
        }
    }

    private boolean isValid(Text command, Text cwd) {
        GeneralPurposeDialogs.initErrorDialog();
        if (StringUtils.isBlank((CharSequence)command.getText())) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.nativecommand.required.command"), (Control)command);
        } else if (StringUtils.isBlank((CharSequence)cwd.getText())) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.nativecommand.required.cwd"), (Control)cwd);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell_);
    }
}

