/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.EditConfigurableDialog;
import org.dbgl.gui.controls.MetaControl;
import org.dbgl.gui.dialog.SettingsDialog;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.entity.TemplateProfileBase;
import org.dbgl.model.entity.TitledEntity;
import org.dbgl.model.factory.TemplateFactory;
import org.dbgl.model.repository.DosboxVersionRepository;
import org.dbgl.model.repository.TemplateRepository;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditTemplateDialog
extends EditConfigurableDialog<Template> {
    private static final boolean multiEdit = false;
    private Text title_;
    private Template template_;
    private final boolean editing_;

    public EditTemplateDialog(Shell parent, Template template) {
        super(parent, "templatedialog");
        this.template_ = template;
        this.editing_ = this.template_ != null;
    }

    @Override
    protected String getDialogTitle() {
        return this.editing_ ? this.text_.get("dialog.template.title.edit", new Object[]{this.template_.getTitle(), this.template_.getId()}) : this.text_.get("dialog.template.title.add");
    }

    @Override
    protected boolean prepare() {
        if (!super.prepare()) {
            return false;
        }
        try {
            if (this.editing_) {
                this.dbversionIndex_ = DosboxVersionRepository.indexOf(this.dbversionsList_, this.template_.getDosboxVersion());
            } else {
                this.template_ = TemplateFactory.create((DosboxVersion)DosboxVersionRepository.findDefault(this.dbversionsList_));
            }
            String warningsLog = this.template_.resetAndLoadConfiguration();
            if (StringUtils.isNotBlank((CharSequence)warningsLog)) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), warningsLog);
            }
            return true;
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e);
            return false;
        }
    }

    private void updateControlsByTemplate() {
        this.metaControls_.forEach(x -> x.setControlByTemplate(this.template_, false));
        this.updateControlsByConfigurable(this.template_, false);
    }

    private void updateTemplateByControls() {
        this.metaControls_.forEach(x -> x.updateTemplateByControl(this.template_));
        this.updateConfigurableByControls(this.template_);
    }

    @Override
    protected void doPerformDosboxConfAction(EditConfigurableDialog.DosboxConfAction action, DosboxVersion newDosboxVersion) {
        try {
            this.updateConfigurableByControls(this.template_);
            StringBuffer warningsLog = new StringBuffer(newDosboxVersion.resetAndLoadConfiguration());
            if (action == EditConfigurableDialog.DosboxConfAction.SET) {
                warningsLog.append(this.template_.setToDosboxVersion(newDosboxVersion));
            } else if (action == EditConfigurableDialog.DosboxConfAction.SWITCH) {
                warningsLog.append(this.template_.switchToDosboxVersion(newDosboxVersion));
            } else if (action == EditConfigurableDialog.DosboxConfAction.RELOAD) {
                warningsLog.append(this.template_.reloadDosboxVersion(newDosboxVersion));
            }
            this.updateControlsByConfigurable(this.template_, false);
            if (StringUtils.isNotEmpty((CharSequence)warningsLog)) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), warningsLog.toString());
            }
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e);
        }
    }

    @Override
    protected void onShellCreated() {
        this.createInfoTab();
        this.createGeneralTab(this.text_.get("dialog.profile.automatic"), this.editing_ ? this.template_.getConfigurationCanonicalFile().getPath() : SettingsDialog.confFilenames[0]);
        this.createDisplayTab();
        this.createMachineTab();
        this.createAudioTab();
        this.createIOTab();
        this.createCustomCommandsTab(this.template_, false);
        this.createMountingTab(this.template_, false);
        this.createOkCancelButtons();
        this.updateControlsByTemplate();
        if (!this.editing_) {
            this.title_.setFocus();
        }
    }

    protected void createInfoTab() {
        Composite composite = this.createTabWithComposite(this.text_.get("dialog.template.tab.info"), 2);
        this.title_ = this.createLabelAndTextMetaControl(composite, this.text_.get("dialog.template.title"), TitledEntity::getTitle, TitledEntity::setTitle);
        this.createLabelAndCheckboxMetaControl(composite, this.text_.get("dialog.template.default"), Template::getDefault, Template::setDefault);
    }

    @Override
    protected void createMountingTab(TemplateProfileBase configurable, boolean multiEdit) {
        super.createMountingTab(configurable, multiEdit);
        Composite booterComposite = (Composite)this.booterExpandItem_.getControl();
        booterComposite.setLayout((Layout)new GridLayout());
        EditTemplateDialog.createLabel(booterComposite, this.text_.get("dialog.profile.booterimage1"));
        Composite dosComposite = (Composite)this.dosExpandItem_.getControl();
        dosComposite.setLayout((Layout)new GridLayout());
        EditTemplateDialog.createLabel(dosComposite, this.text_.get("dialog.profile.mainexe"));
    }

    protected void createOkCancelButtons() {
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditTemplateDialog.this.isValid()) {
                    return;
                }
                try {
                    EditTemplateDialog.this.updateTemplateByControls();
                    if (EditTemplateDialog.this.editing_) {
                        new TemplateRepository().update(EditTemplateDialog.this.template_);
                        EditTemplateDialog.this.result_ = EditTemplateDialog.this.template_;
                    } else {
                        EditTemplateDialog.this.result_ = new TemplateRepository().add(EditTemplateDialog.this.template_);
                    }
                }
                catch (Exception e) {
                    GeneralPurposeDialogs.warningMessage(EditTemplateDialog.this.shell_, e);
                }
                EditTemplateDialog.this.shell_.close();
            }
        });
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title_.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.template.required.title"), (Control)this.title_, this.getTabItemByControl((Control)this.title_));
        }
        if (this.setButton_.isEnabled()) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.template.required.dosboxassociation"), (Control)this.setButton_, this.getTabItemByControl((Control)this.setButton_));
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell_);
    }

    private Text createLabelAndTextMetaControl(Composite composite, String labelText, Function<Template, String> getMethod, BiConsumer<Template, String> updateMethod) {
        Label label = EditTemplateDialog.createLabel(composite, labelText);
        Text text = EditTemplateDialog.createText(composite);
        this.metaControls_.add(new MetaControl(label, (Control)text).connectTemplate(getMethod, updateMethod));
        return text;
    }

    private Button createLabelAndCheckboxMetaControl(Composite composite, String labeltext, Function<Template, String> getMethod, BiConsumer<Template, String> updateMethod) {
        Label label = EditTemplateDialog.createLabel(composite, labeltext);
        Button checkButton = EditTemplateDialog.createCheckButton(composite, false);
        this.metaControls_.add(new MetaControl(label, (Control)checkButton).connectTemplate(getMethod, updateMethod));
        return checkButton;
    }
}

