/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.util.Collections;
import java.util.List;
import org.dbgl.gui.abstractdialog.SizeControlledButtonDialog;
import org.dbgl.model.entity.SharedConf;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class LoadSharedConfDialog
extends SizeControlledButtonDialog<SharedConfLoading> {
    private String title_;
    private List<SharedConf> confs_;

    public LoadSharedConfDialog(Shell parent, String title, List<SharedConf> confs) {
        super(parent, "sharedconfbrowser");
        this.title_ = title;
        this.confs_ = confs;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.loadsharedconf.title");
    }

    @Override
    protected void onShellCreated() {
        this.contents_.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(this.contents_, 256);
        sashForm.setLayout((Layout)new FillLayout());
        final Table table = new Table((Composite)sashForm, 67584);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                SharedConf selWebProfile = (SharedConf)LoadSharedConfDialog.this.confs_.get(table.getSelectionIndex());
                TableColumn column = (TableColumn)e.widget;
                switch ((Integer)column.getData()) {
                    case 0: {
                        Collections.sort(LoadSharedConfDialog.this.confs_, new SharedConf.byTitle());
                        break;
                    }
                    case 1: {
                        Collections.sort(LoadSharedConfDialog.this.confs_, new SharedConf.byYear());
                        break;
                    }
                    case 2: {
                        Collections.sort(LoadSharedConfDialog.this.confs_, new SharedConf.byVersion());
                        break;
                    }
                }
                table.removeAll();
                LoadSharedConfDialog.this.populate(table);
                table.setSortColumn(column);
                table.setSortDirection(128);
                for (int i = 0; i < LoadSharedConfDialog.this.confs_.size(); ++i) {
                    if (selWebProfile != LoadSharedConfDialog.this.confs_.get(i)) continue;
                    table.setSelection(i);
                    break;
                }
            }
        };
        String[] titles = new String[]{this.text_.get("dialog.profile.title"), this.text_.get("dialog.profile.year"), this.text_.get("dialog.confsharing.gameversion")};
        for (int i = 0; i < titles.length; ++i) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(titles[i]);
            column.setData((Object)i);
            column.addListener(13, sortListener);
            if (i == 0) {
                table.setSortColumn(column);
                table.setSortDirection(128);
            }
            Collections.sort(this.confs_, new SharedConf.byTitle());
        }
        TabFolder tabFolder = new TabFolder((Composite)sashForm, 0);
        sashForm.setWeights(new int[]{40, 60});
        Composite composite = LoadSharedConfDialog.createTabWithComposite(tabFolder, this.text_.get("dialog.confsharing.tab.info"), 3);
        final Text author = LoadSharedConfDialog.createLabelAndText(composite, this.text_.get("dialog.confsharing.author"), 2);
        author.setEditable(false);
        final Text dosbox = LoadSharedConfDialog.createLabelAndText(composite, this.text_.get("dialog.loadsharedconf.dosboxversion"), 2);
        dosbox.setEditable(false);
        final Text incrConf = LoadSharedConfDialog.createLabelAndTextarea(composite, this.text_.get("dialog.confsharing.explanation"), true);
        final Text explanation = LoadSharedConfDialog.createTextarea(composite, true, true, 1, 1, null);
        final Text notes = LoadSharedConfDialog.createLabelAndTextarea(composite, this.text_.get("dialog.confsharing.notes"), true, true, 2, 1);
        final Button reloadDosboxDefaults = LoadSharedConfDialog.createCheckButton(composite, 3, this.text_.get("dialog.loadsharedconf.reloaddefaults"), false);
        table.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                LoadSharedConfDialog.this.displaySharedConfData(table, author, dosbox, incrConf, explanation, notes);
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                LoadSharedConfDialog.this.result_ = new SharedConfLoading((SharedConf)LoadSharedConfDialog.this.confs_.get(table.getSelectionIndex()), reloadDosboxDefaults.getSelection());
                LoadSharedConfDialog.this.shell_.close();
            }
        });
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LoadSharedConfDialog.this.result_ = new SharedConfLoading((SharedConf)LoadSharedConfDialog.this.confs_.get(table.getSelectionIndex()), reloadDosboxDefaults.getSelection());
                LoadSharedConfDialog.this.shell_.close();
            }
        });
        this.populate(table);
        for (int i = 0; i < titles.length; ++i) {
            table.getColumn(i).pack();
        }
        table.setSelection(LoadSharedConfDialog.getEntryBestMatchIndex(this.title_, this.confs_));
        table.showSelection();
        this.displaySharedConfData(table, author, dosbox, incrConf, explanation, notes);
    }

    private void populate(Table table) {
        for (SharedConf p : this.confs_) {
            TableItem item = new TableItem(table, 0);
            item.setText(0, p.getGameTitle());
            item.setText(1, p.getGameYear());
            item.setText(2, p.getGameVersion());
        }
    }

    public static int getEntryBestMatchIndex(String search, List<SharedConf> confs) {
        String[] titles = new String[confs.size()];
        for (int i = 0; i < confs.size(); ++i) {
            titles[i] = confs.get(i).getGameTitle();
        }
        return StringRelatedUtils.findBestMatchIndex(search, titles);
    }

    private void displaySharedConfData(Table table, Text author, Text dosbox, Text incrConf, Text explanation, Text notes) {
        int selection = table.getSelectionIndex();
        if (selection != -1) {
            SharedConf conf = this.confs_.get(selection);
            author.setText(conf.getAuthor());
            dosbox.setText(conf.getDosboxTitle() + " (" + conf.getDosboxVersion() + ")");
            incrConf.setText(conf.getIncrConf());
            explanation.setText(conf.getExplanation());
            notes.setText(conf.getNotes());
        }
    }

    public class SharedConfLoading {
        public SharedConf conf_;
        public boolean reloadDosboxDefaults_;

        public SharedConfLoading(SharedConf conf, boolean reloadDosboxDefaults) {
            this.conf_ = conf;
            this.reloadDosboxDefaults_ = reloadDosboxDefaults;
        }
    }
}

