/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.util.List;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.SizeControlledButtonDialog;
import org.dbgl.gui.thread.LoaderThread;
import org.dbgl.model.aggregate.Profile;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProfileLoader
extends SizeControlledButtonDialog<List<Profile>> {
    private LoaderThread job_;
    private ProgressBar progressBar_;
    private Label status_;
    private Text log_;
    private final List<Profile> profs_;
    private boolean warningsDisplayed_;

    public ProfileLoader(Shell parent, List<Profile> profs) {
        super(parent, "profileloaderdialog");
        this.profs_ = profs;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.profileloader.title", new Object[]{this.profs_.size()});
    }

    @Override
    protected void onShellOpened() {
        this.job_ = new LoaderThread(this.log_, this.progressBar_, this.status_, this.profs_);
        this.job_.start();
    }

    @Override
    protected void shellDispatchCallback() {
        if (this.job_ != null && !this.job_.isAlive() && !this.warningsDisplayed_) {
            if (!this.job_.isEverythingOk()) {
                String msg = this.text_.get("dialog.profileloader.error.reading");
                if (!this.job_.getResult().isEmpty()) {
                    this.okButton_.setEnabled(true);
                    msg = msg + "\n\n" + this.text_.get("dialog.profileloader.confirm.continue", new Object[]{this.job_.getResult().size()});
                }
                GeneralPurposeDialogs.warningMessage(this.shell_, msg);
                this.status_.setText(this.text_.get("dialog.migration.reviewlog"));
                this.status_.pack();
            } else {
                this.result_ = this.job_.getResult();
                this.shell_.close();
            }
            this.warningsDisplayed_ = true;
        }
    }

    @Override
    protected void onShellCreated() {
        this.contents_.setLayout((Layout)new FillLayout());
        Group progressGroup = ProfileLoader.createGroup(this.contents_, this.text_.get("dialog.migration.progress"), (Layout)new GridLayout());
        this.progressBar_ = ProfileLoader.createProgressBar((Composite)progressGroup);
        this.progressBar_.setMaximum(this.profs_.size());
        this.status_ = ProfileLoader.createLabel((Composite)progressGroup);
        this.log_ = ProfileLoader.createTextarea((Composite)progressGroup, true);
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProfileLoader.this.result_ = ProfileLoader.this.job_.getResult();
                ProfileLoader.this.shell_.close();
            }
        });
        this.okButton_.setEnabled(false);
    }
}

