/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import org.dbgl.gui.abstractdialog.BaseDialog;
import org.dbgl.gui.interfaces.ProgressNotifyable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class ProgressDialog
extends BaseDialog<Object>
implements ProgressNotifyable {
    private final String title_;
    private Thread thread_;
    private ProgressBar progressBar_;

    public ProgressDialog(Shell parent, String title) {
        super(parent);
        this.title_ = title;
    }

    public void setThread(Thread thread) {
        this.thread_ = thread;
    }

    @Override
    protected String getDialogTitle() {
        return this.title_;
    }

    @Override
    protected void onShellCreated() {
        this.shell_.setSize(600, 140);
        this.shell_.setLayout((Layout)new GridLayout());
        Group progressGroup = ProgressDialog.createGroup((Composite)this.shell_, (Object)new GridData(4, 0x1000000, true, true), this.text_.get("dialog.migration.progress"), (Layout)new GridLayout());
        this.progressBar_ = ProgressDialog.createProgressBar((Composite)progressGroup);
    }

    @Override
    protected void onShellOpened() {
        this.thread_.start();
    }

    @Override
    protected void shellDispatchCallback() {
        if (!this.thread_.isAlive()) {
            this.shell_.close();
        }
    }

    @Override
    public void setTotal(final long total) {
        if (!this.display_.isDisposed() && !this.progressBar_.isDisposed()) {
            this.display_.syncExec(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.progressBar_.setMaximum((int)(total / 1024L));
                }
            });
        }
    }

    @Override
    public void incrProgress(final long progress) {
        if (!this.display_.isDisposed() && !this.progressBar_.isDisposed()) {
            this.display_.syncExec(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.progressBar_.setSelection(ProgressDialog.this.progressBar_.getSelection() + (int)(progress / 1024L));
                }
            });
        }
    }

    @Override
    public void setProgress(final long progress) {
        if (!this.display_.isDisposed() && !this.progressBar_.isDisposed()) {
            this.display_.syncExec(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.progressBar_.setSelection((int)(progress / 1024L));
                }
            });
        }
    }
}

