/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog.wizard;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.GenericType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.EditConfigurableDialog;
import org.dbgl.gui.abstractdialog.WizardDialog;
import org.dbgl.gui.controls.BrowseButton;
import org.dbgl.gui.controls.SearchEngineSelector;
import org.dbgl.gui.dialog.BrowseSearchEngineDialog;
import org.dbgl.gui.dialog.LoadSharedConfDialog;
import org.dbgl.model.FileLocation;
import org.dbgl.model.Link;
import org.dbgl.model.WebProfile;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.entity.SharedConf;
import org.dbgl.model.factory.ProfileFactory;
import org.dbgl.model.repository.DosboxVersionRepository;
import org.dbgl.model.repository.ProfileRepository;
import org.dbgl.model.repository.TemplateRepository;
import org.dbgl.service.FileLocationService;
import org.dbgl.service.ImageService;
import org.dbgl.util.DosGameUtils;
import org.dbgl.util.ExecuteUtils;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.iso.ISO9660FileSystem;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class AddGameWizardDialog
extends WizardDialog<Profile> {
    private List<DosboxVersion> dbversionsList_;
    private List<Template> templatesList_;
    private Profile profile_;
    private Text title_;
    private Text mainText_;
    private Text setupText_;
    private Text installExe_;
    private Text installParameters_;
    private Text patchExe_;
    private Text patchParameters_;
    private Text dstDirectory_;
    private Text imagesDstDirectory_;
    private SearchEngineSelector engineSelector_;
    private ToolItem loadSharedConfButton_;
    private Combo main_;
    private Combo setup_;
    private Combo machine_;
    private Combo core_;
    private Combo cycles_;
    private Combo mapper_;
    private Button moveImages_;
    private Button btnPreinstalledGame_;
    private Button btnGameNeedsToBeInstalled_;
    private Button btnInstallManual_;
    private Button btnPatchManual_;
    private org.eclipse.swt.widgets.List mountingpoints_;
    private org.eclipse.swt.widgets.List installedFilesList_;
    private org.eclipse.swt.widgets.List orgImagesList_;
    private List<FileLocation> orgImages_;
    private List<FileLocation> installedFiles_;

    public AddGameWizardDialog(Shell parent) {
        super(parent, "addgamewizard");
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.addgamewizard.title");
    }

    @Override
    protected boolean prepare() {
        try {
            this.dbversionsList_ = new DosboxVersionRepository().listAll();
            this.templatesList_ = new TemplateRepository().listAll(this.dbversionsList_);
            StringBuffer warningsLog = new StringBuffer();
            DosboxVersion dbVersion = DosboxVersionRepository.findDefault(this.dbversionsList_);
            warningsLog.append(dbVersion.resetAndLoadConfiguration());
            Template template = TemplateRepository.findDefault(this.templatesList_);
            if (template != null) {
                warningsLog.append(template.resetAndLoadConfiguration());
            }
            this.profile_ = ProfileFactory.create(dbVersion, template);
            if (StringUtils.isNotBlank((CharSequence)warningsLog)) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), warningsLog.toString());
            }
            return true;
        }
        catch (Exception e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e);
            return false;
        }
    }

    @Override
    protected void onShellCreated() {
        Group step0Group = AddGameWizardDialog.createGroup((Composite)this.shell_, this.text_.get("dialog.addgamewizard.step1"), 3);
        this.title_ = AddGameWizardDialog.createLabelAndText((Composite)step0Group, this.text_.get("dialog.profile.title"));
        ToolBar toolBar = new ToolBar((Composite)step0Group, 0x800000);
        this.engineSelector_ = new SearchEngineSelector(toolBar, true);
        this.engineSelector_.addToggleSelectionListener(this.settings_.getBooleanValue("addgamewizard", "consultsearchengine"));
        boolean loadSharedConfEnabledByDefault = this.settings_.getBooleanValue("addgamewizard", "consultdbconfws");
        this.loadSharedConfButton_ = AddGameWizardDialog.createImageToolItem(toolBar, 8, loadSharedConfEnabledByDefault ? ImageService.getResourceImage(this.shell_.getDisplay(), "share.png") : ImageService.createDisabledImage(ImageService.getResourceImage(this.shell_.getDisplay(), "share.png")), this.text_.get("button.consultconfsearchengine", new String[]{"DBConfWS"}), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (((Boolean)AddGameWizardDialog.this.loadSharedConfButton_.getData("selected")).booleanValue()) {
                    AddGameWizardDialog.this.loadSharedConfButton_.setImage(ImageService.createDisabledImage(ImageService.getResourceImage(AddGameWizardDialog.this.shell_.getDisplay(), "share.png")));
                    AddGameWizardDialog.this.loadSharedConfButton_.setData("selected", (Object)false);
                    AddGameWizardDialog.this.settings_.setBooleanValue("addgamewizard", "consultdbconfws", false);
                } else {
                    AddGameWizardDialog.this.loadSharedConfButton_.setImage(ImageService.getResourceImage(AddGameWizardDialog.this.shell_.getDisplay(), "share.png"));
                    AddGameWizardDialog.this.loadSharedConfButton_.setData("selected", (Object)true);
                    AddGameWizardDialog.this.settings_.setBooleanValue("addgamewizard", "consultdbconfws", true);
                }
            }
        });
        this.loadSharedConfButton_.setData("selected", (Object)loadSharedConfEnabledByDefault);
        AddGameWizardDialog.createLabel((Composite)step0Group, 3, 1);
        AddGameWizardDialog.createLabel((Composite)step0Group, 0, new GridData(1, 0x1000000, false, false, 3, 1), this.text_.get("dialog.addgamewizard.thisgame"));
        boolean requiresInstallation = this.settings_.getBooleanValue("addgamewizard", "requiresinstallation");
        this.btnPreinstalledGame_ = AddGameWizardDialog.createRadioButton((Composite)step0Group, this.text_.get("dialog.addgamewizard.preinstalled"), 3, !requiresInstallation);
        this.btnGameNeedsToBeInstalled_ = AddGameWizardDialog.createRadioButton((Composite)step0Group, this.text_.get("dialog.addgamewizard.notyetinstalled"), 3, requiresInstallation);
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddGameWizardDialog.this.settings_.setBooleanValue("addgamewizard", "requiresinstallation", event.widget == AddGameWizardDialog.this.btnGameNeedsToBeInstalled_);
            }
        };
        this.btnPreinstalledGame_.addSelectionListener((SelectionListener)adapter);
        this.btnGameNeedsToBeInstalled_.addSelectionListener((SelectionListener)adapter);
        this.addStep(step0Group);
        Group step1Group = AddGameWizardDialog.createGroup((Composite)this.shell_, this.text_.get("dialog.addgamewizard.step2"), 3);
        this.installExe_ = AddGameWizardDialog.createLabelAndText((Composite)step1Group, this.text_.get("dialog.addgamewizard.installexe"));
        this.installExe_.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                if (event.text.length() > 1) {
                    AddGameWizardDialog.this.profile_.addRequiredMount(false, event.text, true);
                    AddGameWizardDialog.this.mountingpoints_.setItems(AddGameWizardDialog.this.profile_.getMountStringsForUI());
                }
            }
        });
        new BrowseButton((Composite)step1Group).connect(this.shell_, this.installExe_, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.INSTALLER, false, null);
        this.installParameters_ = AddGameWizardDialog.createLabelAndText((Composite)step1Group, this.text_.get("dialog.profile.mainparameters"), 2);
        this.btnInstallManual_ = AddGameWizardDialog.createLabelAndCheckButton((Composite)step1Group, this.text_.get("dialog.addgamewizard.manualmode"), 2, this.text_.get("dialog.addgamewizard.manualmodeinfo"));
        AddGameWizardDialog.createLabel((Composite)step1Group, 3, 1);
        Group mountGroup = AddGameWizardDialog.createGroup((Composite)step1Group, (Object)new GridData(4, 0x1000000, true, false, 3, 1), this.text_.get("dialog.template.mountingoverview"), 2);
        this.mountingpoints_ = AddGameWizardDialog.createList((Composite)mountGroup, 1, 3);
        this.mountingpoints_.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (AddGameWizardDialog.this.mountingpoints_.getSelectionIndex() == -1) {
                    EditConfigurableDialog.doAddMount(AddGameWizardDialog.this.shell_, false, AddGameWizardDialog.this.mountingpoints_, AddGameWizardDialog.this.profile_);
                } else {
                    EditConfigurableDialog.doEditMount(AddGameWizardDialog.this.shell_, AddGameWizardDialog.this.mountingpoints_, AddGameWizardDialog.this.profile_);
                }
            }
        });
        AddGameWizardDialog.createButton((Composite)mountGroup, this.text_.get("dialog.template.mount.add"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.doAddMount(AddGameWizardDialog.this.shell_, false, AddGameWizardDialog.this.mountingpoints_, AddGameWizardDialog.this.profile_);
            }
        });
        AddGameWizardDialog.createButton((Composite)mountGroup, this.text_.get("dialog.template.mount.edit"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.doEditMount(AddGameWizardDialog.this.shell_, AddGameWizardDialog.this.mountingpoints_, AddGameWizardDialog.this.profile_);
            }
        });
        AddGameWizardDialog.createButton((Composite)mountGroup, this.text_.get("dialog.template.mount.remove"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.doRemoveMount(AddGameWizardDialog.this.mountingpoints_, AddGameWizardDialog.this.profile_);
            }
        });
        Group associationGroup = AddGameWizardDialog.createGroup((Composite)step1Group, (Object)new GridData(4, 0x1000000, true, false, 3, 1), this.text_.get("dialog.template.association"), 2);
        int dbversionIndex = DosboxVersionRepository.indexOf(this.dbversionsList_, this.profile_.getDosboxVersion());
        final Combo dbversion = AddGameWizardDialog.createLabelAndCombo((Composite)associationGroup, this.text_.get("dialog.template.dosboxversion"), (String[])this.dbversionsList_.stream().map(x -> x.getTitle()).toArray(String[]::new), 20, dbversionIndex);
        dbversion.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        dbversion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    String warningsLog = AddGameWizardDialog.this.profile_.switchToDosboxVersion((DosboxVersion)AddGameWizardDialog.this.dbversionsList_.get(dbversion.getSelectionIndex()));
                    AddGameWizardDialog.this.resetMounts();
                    if (StringUtils.isNotEmpty((CharSequence)warningsLog)) {
                        GeneralPurposeDialogs.warningMessage(AddGameWizardDialog.this.getParent(), warningsLog.toString());
                    }
                }
                catch (IOException e) {
                    GeneralPurposeDialogs.warningMessage(AddGameWizardDialog.this.getParent(), e);
                }
            }
        });
        this.addStep(step1Group);
        Group step2Group = AddGameWizardDialog.createGroup((Composite)this.shell_, this.text_.get("dialog.addgamewizard.step3"), 3);
        this.patchExe_ = AddGameWizardDialog.createLabelAndText((Composite)step2Group, this.text_.get("dialog.addgamewizard.patcherexe"));
        new BrowseButton((Composite)step2Group).connect(this.shell_, this.patchExe_, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.INSTALLER, false, null);
        this.patchParameters_ = AddGameWizardDialog.createLabelAndText((Composite)step2Group, this.text_.get("dialog.profile.mainparameters"), 2);
        this.btnPatchManual_ = AddGameWizardDialog.createLabelAndCheckButton((Composite)step2Group, this.text_.get("dialog.addgamewizard.manualmode"), 2, this.text_.get("dialog.addgamewizard.manualpatchmodeinfo"));
        this.addStep(step2Group);
        Group step3Group = AddGameWizardDialog.createGroup((Composite)this.shell_, this.text_.get("dialog.addgamewizard.step4"), 2);
        this.main_ = AddGameWizardDialog.createLabelAndWideCombo((Composite)step3Group, this.text_.get("dialog.profile.mainexe"));
        this.setup_ = AddGameWizardDialog.createLabelAndWideCombo((Composite)step3Group, this.text_.get("dialog.profile.setupexe"));
        this.addStep(step3Group);
        Group step4Group = AddGameWizardDialog.createGroup((Composite)this.shell_, this.text_.get("dialog.addgamewizard.step4"), 3);
        this.mainText_ = AddGameWizardDialog.createLabelAndText((Composite)step4Group, this.text_.get("dialog.profile.mainexe"));
        new BrowseButton((Composite)step4Group).connect(this.shell_, this.mainText_, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, null);
        this.setupText_ = AddGameWizardDialog.createLabelAndText((Composite)step4Group, this.text_.get("dialog.profile.setupexe"));
        new BrowseButton((Composite)step4Group).connect(this.shell_, this.setupText_, this.mainText_, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, null);
        this.addStep(step4Group);
        Group step5Group = AddGameWizardDialog.createGroup((Composite)this.shell_, this.text_.get("dialog.addgamewizard.step5"), (Layout)new GridLayout());
        Group installedFilesGroup = AddGameWizardDialog.createGroup((Composite)step5Group, (Object)new GridData(4, 0x1000000, true, false), this.text_.get("dialog.addgamewizard.installedfiles"), 3);
        this.installedFilesList_ = AddGameWizardDialog.createList((Composite)installedFilesGroup, 2562, 3, 1);
        this.dstDirectory_ = AddGameWizardDialog.createLabelAndText((Composite)installedFilesGroup, this.text_.get("dialog.migration.to"), FileLocationService.getInstance().getDosroot().getPath());
        new BrowseButton((Composite)installedFilesGroup).connect(this.shell_, this.dstDirectory_, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.NONE, false, null);
        Group orgImagesGroup = AddGameWizardDialog.createGroup((Composite)step5Group, (Object)new GridData(4, 0x1000000, true, false), this.text_.get("dialog.addgamewizard.originalimages"), 2);
        this.orgImagesList_ = AddGameWizardDialog.createList((Composite)orgImagesGroup, 2562, 2, 1);
        this.moveImages_ = AddGameWizardDialog.createLabelAndCheckButton((Composite)orgImagesGroup, this.text_.get("dialog.addgamewizard.moveimages"), false);
        this.imagesDstDirectory_ = AddGameWizardDialog.createLabelAndText((Composite)orgImagesGroup, this.text_.get("dialog.migration.to"));
        this.imagesDstDirectory_.setEnabled(this.moveImages_.getSelection());
        this.moveImages_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddGameWizardDialog.this.imagesDstDirectory_.setEnabled(AddGameWizardDialog.this.moveImages_.getSelection());
            }
        });
        this.addStep(step5Group);
        Group step6Group = AddGameWizardDialog.createGroup((Composite)this.shell_, this.text_.get("dialog.addgamewizard.step6"), 3);
        final Combo template = AddGameWizardDialog.createLabelAndCombo((Composite)step6Group, this.text_.get("dialog.profile.template"), (String[])this.templatesList_.stream().map(x -> x.getTitle()).toArray(String[]::new), 10, TemplateRepository.indexOfDefault(this.templatesList_));
        AddGameWizardDialog.createButton((Composite)step6Group, null, this.text_.get("dialog.profile.reloadsettings"), this.text_.get("dialog.profile.reloadsettings.tooltip"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (template.getSelectionIndex() != -1) {
                    AddGameWizardDialog.this.doReloadTemplate((Template)AddGameWizardDialog.this.templatesList_.get(template.getSelectionIndex()));
                }
            }
        });
        this.machine_ = AddGameWizardDialog.createLabelAndCombo((Composite)step6Group, this.text_.get("dialog.template.machine"), 2, this.profile_.getDosboxVersion().isUsingNewMachineConfig() ? this.settings_.getValues("profile", "machine073") : this.settings_.getValues("profile", "machine"), 20, this.text_.get("dialog.template.machine.tooltip"));
        this.core_ = AddGameWizardDialog.createLabelAndCombo((Composite)step6Group, this.text_.get("dialog.template.core"), 2, this.settings_.getValues("profile", "core"), 20, this.text_.get("dialog.template.core.tooltip"));
        this.cycles_ = AddGameWizardDialog.createLabelAndEditableCombo((Composite)step6Group, this.text_.get("dialog.template.cycles"), 2, this.settings_.getValues("profile", "cycles"), 15, this.text_.get("dialog.template.cycles.tooltip"));
        this.mapper_ = AddGameWizardDialog.createLabelAndCombo((Composite)step6Group, this.text_.get("dialog.template.mapperfile"), 2, new String[]{this.text_.get("dialog.addgamewizard.mapper.generic"), this.text_.get("dialog.addgamewizard.mapper.specific")}, 5, this.text_.get("dialog.template.mapperfile.tooltip"));
        this.mapper_.select(this.settings_.getBooleanValue("addgamewizard", "useuniquemapperfile") ? 1 : 0);
        this.mapper_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddGameWizardDialog.this.settings_.setBooleanValue("addgamewizard", "useuniquemapperfile", ((Combo)event.widget).getSelectionIndex() == 1);
            }
        });
        this.addStep(step6Group);
        this.updateControlsByProfile();
    }

    @Override
    protected void onShellOpened() {
        super.onShellOpened();
        this.title_.setFocus();
    }

    @Override
    protected int stepSize(int step, boolean forward) {
        if (this.btnPreinstalledGame_.getSelection()) {
            if (forward && step == 0 || !forward && step == 4) {
                return 4;
            }
            if (forward && step == 4 || !forward && step == 6) {
                return 2;
            }
        } else if (forward && step == 3 || !forward && step == 5) {
            return 2;
        }
        return super.stepSize(step, forward);
    }

    @Override
    protected boolean onNext(int step) {
        GeneralPurposeDialogs.initErrorDialog();
        if (step == 0) {
            return this.titleEntered() && this.doWebSearch();
        }
        if (step == 1) {
            return this.installExeEntered() && this.runInstallerAndCheckResults();
        }
        if (step == 2) {
            return this.determineMainAndSetup();
        }
        if (step == 3) {
            return this.mainExeEntered() && this.setMain();
        }
        if (step == 4) {
            return this.mainExeEntered() && this.setMain();
        }
        if (step == 5) {
            return this.conditionsOkForStep5();
        }
        if (step == 6) {
            return this.createProfile();
        }
        return false;
    }

    @Override
    protected void onClose() {
        super.onClose();
        try {
            FileUtils.deleteDirectory((File)FileLocationService.getInstance().getTmpInstallDir());
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.shell_, e);
        }
    }

    private void updateControlsByProfile() {
        Configuration combinedConf = this.profile_.getCombinedConfiguration();
        this.machine_.setText(combinedConf.getValue("dosbox", "machine"));
        this.core_.setText(combinedConf.getValue("cpu", "core"));
        this.cycles_.setText(combinedConf.getValue("cpu", "cycles"));
    }

    private void updateProfileByControls() {
        this.profile_.setValue("dosbox", "machine", this.machine_.getText());
        this.profile_.setValue("cpu", "core", this.core_.getText());
        this.profile_.setValue("cpu", "cycles", this.cycles_.getText());
    }

    private void doReloadTemplate(Template template) {
        try {
            StringBuffer warningsLog = new StringBuffer();
            warningsLog.append(template.resetAndLoadConfiguration());
            warningsLog.append(this.profile_.reloadTemplate(this.profile_.getDosboxVersion(), template));
            this.updateControlsByProfile();
            if (StringUtils.isNotEmpty((CharSequence)warningsLog)) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), warningsLog.toString());
            }
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e);
        }
    }

    private boolean titleEntered() {
        if (StringUtils.isBlank((CharSequence)this.title_.getText())) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.profile.required.title"), (Control)this.title_);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell_);
    }

    private boolean doWebSearch() {
        String currTitle = this.title_.getText();
        if (((Boolean)this.loadSharedConfButton_.getData("selected")).booleanValue()) {
            try {
                Client client = ClientBuilder.newClient();
                GenericType<List<SharedConf>> confType = new GenericType<List<SharedConf>>(){};
                List confs = (List)client.target(this.settings_.getValue("confsharing", "endpoint")).path("/configurations/bytitle/{i}").resolveTemplate("i", (Object)currTitle).request().accept(new String[]{"application/xml"}).get((GenericType)confType);
                client.close();
                if (confs.size() == 0) {
                    GeneralPurposeDialogs.infoMessage(this.shell_, this.text_.get("general.notice.searchenginenoresults", new String[]{"DBConfWS", currTitle}));
                } else {
                    LoadSharedConfDialog.SharedConfLoading result = (LoadSharedConfDialog.SharedConfLoading)new LoadSharedConfDialog(this.shell_, currTitle, confs).open();
                    if (result != null) {
                        if (result.reloadDosboxDefaults_) {
                            this.profile_.getConfiguration().clearSections();
                        }
                        this.profile_.loadConfigurationData(this.text_, result.conf_.getIncrConf(), new File(result.conf_.getGameTitle()));
                        this.updateControlsByProfile();
                    }
                }
            }
            catch (Exception e) {
                GeneralPurposeDialogs.warningMessage(this.shell_, this.text_.get("general.error.retrieveinfosearchengine", new String[]{"DBConfWS", currTitle, StringRelatedUtils.toString(e)}), e);
            }
        }
        if (this.engineSelector_.isSelected()) {
            WebSearchEngine engine = WebSearchEngine.getBySimpleName(this.settings_.getValue("gui", "searchengine"));
            try {
                WebProfile thisGame = null;
                List<WebProfile> webGamesList = engine.getEntries(currTitle, this.settings_.getValues(engine.getSimpleName(), "platform_filter"));
                if (webGamesList.size() >= 1) {
                    thisGame = (WebProfile)new BrowseSearchEngineDialog(this.shell_, currTitle, webGamesList, engine).open();
                }
                if (thisGame != null) {
                    WebProfile profExt = engine.getEntryDetailedInformation(thisGame);
                    if (this.settings_.getBooleanValue(engine.getSimpleName(), "set_title")) {
                        this.title_.setText(profExt.getTitle());
                    }
                    if (this.settings_.getBooleanValue(engine.getSimpleName(), "set_developer")) {
                        this.profile_.setDeveloper(profExt.getDeveloperName());
                    }
                    if (this.settings_.getBooleanValue(engine.getSimpleName(), "set_publisher")) {
                        this.profile_.setPublisher(profExt.getPublisherName());
                    }
                    if (this.settings_.getBooleanValue(engine.getSimpleName(), "set_year")) {
                        this.profile_.setYear(profExt.getYear());
                    }
                    if (this.settings_.getBooleanValue(engine.getSimpleName(), "set_genre")) {
                        this.profile_.setGenre(profExt.getGenre());
                    }
                    if (this.settings_.getBooleanValue(engine.getSimpleName(), "set_link")) {
                        this.profile_.getLinks()[0] = new Link(this.text_.get("dialog.profile.searchengine.link.maininfo", new String[]{engine.getName()}), profExt.getUrl());
                    }
                    if (this.settings_.getBooleanValue(engine.getSimpleName(), "set_description")) {
                        this.profile_.setNotes(profExt.getNotes());
                    }
                    if (this.settings_.getBooleanValue(engine.getSimpleName(), "set_rank")) {
                        this.profile_.getCustomInts()[0] = profExt.getRank();
                    }
                }
            }
            catch (Exception e) {
                GeneralPurposeDialogs.warningMessage(this.shell_, this.text_.get("general.error.retrieveinfosearchengine", new String[]{engine.getName(), currTitle, StringRelatedUtils.toString(e)}), e);
            }
        }
        if (this.btnGameNeedsToBeInstalled_.getSelection() && StringUtils.isBlank((CharSequence)this.installExe_.getText())) {
            this.resetMounts();
        }
        return true;
    }

    private boolean installExeEntered() {
        if (StringUtils.isBlank((CharSequence)this.installExe_.getText())) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.addgamewizard.required.installexe"), (Control)this.installExe_);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell_);
    }

    private boolean runInstallerAndCheckResults() {
        try {
            File[] files;
            File[] firstImageMountPath;
            FileUtils.deleteDirectory((File)FileLocationService.getInstance().getTmpInstallDir());
            FilesUtils.createDir(FileLocationService.getInstance().getTmpInstallDir());
            this.profile_.setAutoexecSettings(this.installExe_.getText(), this.installParameters_.getText());
            ExecuteUtils.doRunProfile(ExecuteUtils.ProfileRunMode.INSTALLER, this.profile_, this.btnInstallManual_.getSelection(), this.display_);
            this.shell_.forceFocus();
            this.shell_.forceActive();
            this.orgImages_ = new ArrayList<FileLocation>();
            for (File file : firstImageMountPath = this.profile_.getConfiguration().getAutoexec().findFirstImageMountCanonicalPath()) {
                this.orgImages_.add(AddGameWizardDialog.toImageFileLocation(file));
            }
            ArrayList<FileLocation> additionalImageFiles = new ArrayList<FileLocation>();
            for (FileLocation orgImage : this.orgImages_) {
                File binFile;
                File file;
                file = orgImage.getCanonicalFile();
                if (!file.getName().toLowerCase().endsWith(FilesUtils.CDIMAGES[1]) || (binFile = ISO9660FileSystem.parseCueSheet(file)) == null || !file.getParentFile().equals(binFile.getParentFile())) continue;
                additionalImageFiles.add(AddGameWizardDialog.toImageFileLocation(binFile));
            }
            this.orgImages_.addAll(additionalImageFiles);
            this.installedFiles_ = new ArrayList<FileLocation>();
            for (File file : files = FileLocationService.getInstance().getTmpInstallDir().listFiles()) {
                this.installedFiles_.add(AddGameWizardDialog.toImageFileLocation(file));
            }
            if (this.installedFiles_.isEmpty()) {
                GeneralPurposeDialogs.warningMessage(this.shell_, this.text_.get("dialog.addgamewizard.error.nofilesinstalled"));
                return false;
            }
            return true;
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.shell_, e);
            return false;
        }
    }

    private static FileLocation toImageFileLocation(File file) {
        return new FileLocation(file.getPath(), FileLocationService.getInstance().dosrootRelative());
    }

    private boolean determineMainAndSetup() {
        int mainFileIndex;
        if (StringUtils.isNotBlank((CharSequence)this.patchExe_.getText())) {
            try {
                this.profile_.setAutoexecSettings(this.patchExe_.getText(), this.patchParameters_.getText());
                ExecuteUtils.doRunProfile(ExecuteUtils.ProfileRunMode.INSTALLER, this.profile_, this.btnPatchManual_.getSelection(), this.shell_.getDisplay());
                this.shell_.forceFocus();
                this.shell_.forceActive();
            }
            catch (IOException e) {
                GeneralPurposeDialogs.warningMessage(this.shell_, e);
                return false;
            }
        }
        this.orgImagesList_.removeAll();
        if (this.orgImages_ != null) {
            for (FileLocation fileLocation : this.orgImages_) {
                this.orgImagesList_.add(fileLocation.getFile().getPath());
            }
        }
        this.orgImagesList_.selectAll();
        this.orgImagesList_.pack();
        this.orgImagesList_.getParent().layout();
        this.installedFilesList_.removeAll();
        File gameDir = null;
        for (FileLocation installedFile : this.installedFiles_) {
            if (installedFile.getFile().isDirectory()) {
                this.installedFilesList_.add("[ " + installedFile.getFile().getPath() + " ]");
                if (gameDir != null) continue;
                gameDir = installedFile.getCanonicalFile();
                continue;
            }
            this.installedFilesList_.add(installedFile.getFile().getPath());
        }
        this.installedFilesList_.selectAll();
        this.installedFilesList_.pack();
        this.installedFilesList_.getParent().layout();
        this.moveImages_.setEnabled(this.profile_.getConfiguration().getAutoexec().countImageMounts() == 1L);
        String string = this.settings_.getValue("directory", "orgimages");
        File imagesSubDir = gameDir != null ? new File(gameDir.getName(), string) : new File(string);
        this.imagesDstDirectory_.setText(imagesSubDir.getPath());
        List<File> executables = FilesUtils.listExecutablesInDirRecursive(FileLocationService.getInstance().getTmpInstallDir());
        this.main_.removeAll();
        this.setup_.removeAll();
        this.setup_.add("");
        for (File f : executables) {
            String filename = AddGameWizardDialog.toImageFileLocation(f).getFile().getPath();
            this.main_.add(filename);
            this.setup_.add(filename);
        }
        if (executables.isEmpty()) {
            this.main_.add(this.installExe_.getText());
        }
        if ((mainFileIndex = DosGameUtils.findMostLikelyMainIndex(this.title_.getText(), executables)) != -1) {
            this.main_.select(mainFileIndex);
        } else {
            this.main_.select(0);
        }
        int setupFileIndex = DosGameUtils.findSetupIndex(executables);
        if (setupFileIndex != -1) {
            this.setup_.select(setupFileIndex + 1);
        } else {
            this.setup_.select(0);
        }
        this.setup_.setEnabled(this.setup_.getItemCount() > 1);
        return true;
    }

    private boolean mainExeEntered() {
        if (this.btnPreinstalledGame_.getSelection()) {
            if (StringUtils.isBlank((CharSequence)this.mainText_.getText())) {
                GeneralPurposeDialogs.addError(this.text_.get("dialog.profile.required.mainexe"), (Control)this.mainText_);
            }
        } else if (StringUtils.isBlank((CharSequence)this.main_.getText())) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.profile.required.mainexe"), (Control)this.main_);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell_);
    }

    private boolean setMain() {
        if (this.btnPreinstalledGame_.getSelection()) {
            if (this.profile_.getRequiredMount(false, this.mainText_.getText(), false, false) != null) {
                this.profile_.addRequiredMount(false, this.mainText_.getText(), false);
            }
            this.profile_.setAutoexecSettings(this.mainText_.getText(), "");
        } else {
            if (this.profile_.getRequiredMount(false, this.main_.getText(), false, false) != null) {
                this.profile_.addRequiredMount(false, this.main_.getText(), false);
            }
            this.profile_.setAutoexecSettings(this.main_.getText(), "");
        }
        return true;
    }

    private boolean conditionsOkForStep5() {
        if (this.btnPreinstalledGame_.getSelection()) {
            return true;
        }
        try {
            if (this.installedFilesList_.getSelectionCount() > 0) {
                File destDir = new File(this.dstDirectory_.getText());
                if (!destDir.isDirectory() && GeneralPurposeDialogs.confirmMessage(this.shell_, this.text_.get("dialog.addgamewizard.confirm.createdestinationdir", new String[]{destDir.toString()}))) {
                    destDir.mkdirs();
                }
                if (!destDir.isDirectory()) {
                    GeneralPurposeDialogs.addError(this.text_.get("dialog.addgamewizard.error.destinationdirmissing", new String[]{destDir.toString()}), (Control)this.dstDirectory_);
                } else {
                    for (int i = 0; i < this.installedFiles_.size(); ++i) {
                        File destFile;
                        if (!this.installedFilesList_.isSelected(i) || !FileUtils.directoryContains((File)destDir, (File)(destFile = new File(destDir, this.installedFiles_.get(i).getFile().getName())))) continue;
                        GeneralPurposeDialogs.addError(this.text_.get("dialog.addgamewizard.error.gamedatadirexists", new String[]{destFile.toString()}), (Control)this.dstDirectory_);
                    }
                }
            } else {
                GeneralPurposeDialogs.addError(this.text_.get("dialog.addgamewizard.error.gamedatamustbemoved"), (Control)this.installedFilesList_);
            }
            return !GeneralPurposeDialogs.displayErrorDialog(this.shell_);
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.shell_, e);
            return false;
        }
    }

    private boolean createProfile() {
        try {
            String setupString = this.btnPreinstalledGame_.getSelection() ? this.setupText_.getText() : this.setup_.getText();
            this.profile_.setTitle(this.title_.getText());
            this.profile_.setSetupFileLocation(setupString);
            if (this.installedFilesList_.getSelectionCount() > 0) {
                FileLocation destDir = new FileLocation(this.dstDirectory_.getText(), FileLocationService.getInstance().dosrootRelative());
                this.profile_.migrate(FileLocationService.getInstance().getTmpInstallLocation(), destDir);
                this.profile_.removeFloppyMounts();
                this.profile_.removeUnnecessaryMounts();
                for (int i = 0; i < this.installedFiles_.size(); ++i) {
                    File src = this.installedFiles_.get(i).getCanonicalFile();
                    if (!this.installedFilesList_.isSelected(i)) continue;
                    FileUtils.moveToDirectory((File)src, (File)destDir.getCanonicalFile(), (boolean)true);
                }
                if (this.moveImages_.getSelection()) {
                    File imgDestDir = new File(destDir.getCanonicalFile(), this.imagesDstDirectory_.getText());
                    for (int i = 0; i < this.orgImages_.size(); ++i) {
                        FileLocation src = this.orgImages_.get(i);
                        if (!this.orgImagesList_.isSelected(i)) continue;
                        FileUtils.moveToDirectory((File)src.getCanonicalFile(), (File)imgDestDir, (boolean)true);
                        FileLocation dst = new FileLocation(FilesUtils.concat(imgDestDir, src.getFile().getName()), destDir.getCanonicalizer());
                        this.profile_.getConfiguration().getAutoexec().migrate(src, dst);
                    }
                }
            }
            if (this.mapper_.getSelectionIndex() == 1) {
                this.profile_.setValue("sdl", "mapperfile", this.settings_.getValue("profile", "uniquemapperfile"));
            }
            this.updateProfileByControls();
            this.result_ = new ProfileRepository().add(this.profile_);
        }
        catch (IOException | SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell_, e);
        }
        return true;
    }

    private void resetMounts() {
        this.profile_.getConfiguration().getAutoexec().getMountingpoints().clear();
        this.profile_.unmountDosboxMounts();
        this.profile_.getConfiguration().getAutoexec().addMount("mount C \"" + FileLocationService.getInstance().getTmpInstallDir() + "\"");
        this.mountingpoints_.setItems(this.profile_.getMountStringsForUI());
    }
}

