/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog.wizard;

import SevenZip.Archive.IArchiveExtractCallback;
import SevenZip.Archive.IInArchive;
import SevenZip.Archive.SevenZip.Handler;
import SevenZip.Archive.SevenZipEntry;
import SevenZip.IInStream;
import SevenZip.MyRandomAccessFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.constants.Constants;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.JobWizardDialog;
import org.dbgl.gui.dialog.ProgressDialog;
import org.dbgl.gui.interfaces.ProgressNotifyable;
import org.dbgl.gui.thread.ImportThread;
import org.dbgl.model.GamePack;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.entity.GamePackEntry;
import org.dbgl.model.repository.DosboxVersionRepository;
import org.dbgl.service.FileLocationService;
import org.dbgl.service.ImportExportProfilesService;
import org.dbgl.service.TextService;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.archive.SevenzipExtractSingleFileCallback;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ImportDialog
extends JobWizardDialog<Boolean> {
    private Button fullGames_;
    private Button fullSettingsButton_;
    private Button importCapturesButton_;
    private Button importMapperfilesButton_;
    private Button importNativeCommandsButton_;
    private Button useOrgConf_;
    private Button customValues_;
    private Button customFields_;
    private Table profilesTable_;
    private Table impDbVersionsList_;
    private List<DosboxVersion> dbversionsList_;
    private List<File> archive_;
    private List<GamePack> gamePackList_;
    private GamePack gamePack_;
    private StringBuffer messageLog_;
    private List<Integer> dbmapping_;

    public ImportDialog(Shell parent, List<DosboxVersion> dbList, File archive, String[] fileNames) {
        super(parent, "import");
        this.dbversionsList_ = dbList;
        this.archive_ = fileNames != null && fileNames.length > 0 ? Stream.of(fileNames).map(x -> new File((String)x)).collect(Collectors.toList()) : Collections.singletonList(archive);
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.import.title");
    }

    @Override
    protected boolean prepare() {
        this.messageLog_ = new StringBuffer();
        try {
            this.gamePackList_ = new ArrayList<GamePack>();
            Set<DosboxVersion> combinedDosboxVersions = new LinkedHashSet<DosboxVersion>();
            for (File archiveFile : this.archive_) {
                Document doc = this.getProfilesXmlDocFromZip(archiveFile);
                if (doc == null) {
                    throw new ZipException(this.text_.get("dialog.import.error.gamepackarchivemissingprofilesxml"));
                }
                GamePack gamePack = new GamePack(archiveFile);
                gamePack.setDosboxVersions(combinedDosboxVersions);
                this.messageLog_.append(ImportExportProfilesService.doImport(doc, gamePack));
                combinedDosboxVersions = gamePack.getDosboxVersions();
                this.gamePackList_.add(gamePack);
                this.messageLog_.append(this.text_.get("dialog.import.notice.importinformation", new Object[]{archiveFile.getName(), gamePack.getVersion(), gamePack.getCreationDate(), gamePack.getCreationApp(), gamePack.getCreationAppVersion()})).append('\n');
            }
            this.gamePack_ = this.combineGamePacks();
        }
        catch (ZipException | ParserConfigurationException | SAXException e) {
            GeneralPurposeDialogs.fatalMessage(this.getParent(), e.getMessage(), e);
            return false;
        }
        catch (IOException e) {
            this.messageLog_.append(this.text_.get("general.error.openfile", new Object[]{this.archive_})).append('\n').append(e.toString()).append('\n');
            GeneralPurposeDialogs.fatalMessage(this.getParent(), this.messageLog_.toString(), e);
            e.printStackTrace();
            return false;
        }
        catch (ParseException e) {
            this.messageLog_.append(e.toString()).append('\n');
            e.printStackTrace();
        }
        catch (XPathExpressionException e) {
            this.messageLog_.append(this.text_.get("dialog.import.error.profilesxmlinvalidformat", new Object[]{e.toString()})).append('\n');
            e.printStackTrace();
        }
        return true;
    }

    public Document getProfilesXmlDocFromZip(File archiveFile) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        String archive = archiveFile.getPath();
        Document doc = null;
        if (archive.toLowerCase().endsWith(FilesUtils.ARCHIVES[0])) {
            ZipFile zf = new ZipFile(archive);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().equalsIgnoreCase("profiles.xml")) continue;
                doc = builder.parse(zf.getInputStream(entry));
                break;
            }
            zf.close();
            return doc;
        }
        if (archive.toLowerCase().endsWith(FilesUtils.ARCHIVES[1])) {
            Handler zArchive = new Handler();
            MyRandomAccessFile istream = new MyRandomAccessFile(archive, "r");
            if (zArchive.Open((IInStream)istream) != 0) {
                throw new IOException(TextService.getInstance().get("general.error.opensevenzip", new Object[]{archive}));
            }
            final ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (int i = 0; i < zArchive.size(); ++i) {
                SevenZipEntry entry = zArchive.getEntry(i);
                if (entry.isDirectory() || !entry.getName().equalsIgnoreCase("profiles.xml")) continue;
                ProgressDialog prog = new ProgressDialog(this.getParent(), this.text_.get("dialog.import.notice.processing7zip"));
                class Extract
                extends Thread {
                    private int entryId_;
                    private SevenzipExtractSingleFileCallback extractCallback_;
                    private IOException exception_;
                    final /* synthetic */ IInArchive val$zArchive;

                    Extract(int entryId, ProgressNotifyable prog) {
                        this.val$zArchive = iInArchive;
                        this.entryId_ = entryId;
                        this.extractCallback_ = new SevenzipExtractSingleFileCallback(prog, out);
                        this.exception_ = null;
                    }

                    @Override
                    public void run() {
                        try {
                            this.val$zArchive.Extract(new int[]{this.entryId_}, 1, 0, (IArchiveExtractCallback)this.extractCallback_);
                        }
                        catch (IOException e) {
                            this.exception_ = e;
                        }
                    }

                    public IOException getIOException() {
                        return this.exception_;
                    }
                }
                Extract extract = new Extract(i, prog);
                prog.setThread(extract);
                prog.open();
                if (extract.getIOException() != null) {
                    zArchive.close();
                    out.close();
                    throw extract.getIOException();
                }
                doc = builder.parse(new ByteArrayInputStream(out.toByteArray()));
                break;
            }
            zArchive.close();
            out.close();
            return doc;
        }
        return null;
    }

    private GamePack combineGamePacks() {
        if (this.gamePackList_.size() == 0) {
            return null;
        }
        if (this.gamePackList_.size() == 1) {
            return this.gamePackList_.get(0);
        }
        GamePack combined = new GamePack();
        try {
            combined.setVersion(String.valueOf(this.gamePackList_.stream().mapToDouble(x -> Double.parseDouble(x.getVersion())).min()));
        }
        catch (Exception e) {
            combined.setVersion("1.3");
        }
        combined.setCustomFieldTitles(new String[14]);
        for (int i = 0; i < 14; ++i) {
            int idx = i;
            Optional<String> val = this.gamePackList_.stream().map(x -> x.getCustomFieldTitles()[idx]).filter(x -> StringUtils.isNotBlank((CharSequence)x)).findFirst();
            combined.getCustomFieldTitles()[idx] = val.isPresent() ? val.get() : "";
        }
        combined.setCreationApp("DOSBox Game Launcher");
        combined.setCreationAppVersion(Constants.PROGRAM_VERSION);
        combined.setCreationDate(new Date());
        combined.setTitle(this.gamePackList_.stream().map(x -> x.getTitle()).collect(Collectors.joining(", ")));
        combined.setAuthor(this.gamePackList_.stream().map(x -> x.getAuthor()).distinct().collect(Collectors.joining(", ")));
        combined.setNotes(this.gamePackList_.stream().map(x -> "=== " + x.getTitle() + " ===\n" + x.getNotes()).collect(Collectors.joining(Text.DELIMITER)));
        combined.setCapturesAvailable(this.gamePackList_.stream().anyMatch(x -> x.isCapturesAvailable()));
        combined.setMapperfilesAvailable(this.gamePackList_.stream().anyMatch(x -> x.isMapperfilesAvailable()));
        combined.setNativecommandsAvailable(this.gamePackList_.stream().anyMatch(x -> x.isNativecommandsAvailable()));
        combined.setGamedataAvailable(this.gamePackList_.stream().anyMatch(x -> x.isGamedataAvailable()));
        combined.setDosboxVersions(this.gamePackList_.stream().flatMap(x -> x.getDosboxVersions().stream()).collect(Collectors.toSet()));
        combined.setEntries(this.gamePackList_.stream().flatMap(x -> x.getEntries().stream()).collect(Collectors.toList()));
        return combined;
    }

    @Override
    protected boolean onNext(int step) {
        if (step == 2) {
            return this.conditionsForStep3Ok() && this.refillImportedDBVersionsList();
        }
        if (step == 4) {
            try {
                int i;
                for (i = 0; i < this.gamePack_.getEntries().size(); ++i) {
                    for (int j = 0; j < i; ++j) {
                        GamePackEntry pI = this.gamePack_.getEntries().get(i);
                        GamePackEntry pJ = this.gamePack_.getEntries().get(j);
                        if (!pI.getGameDir().equals(pJ.getGameDir())) continue;
                        pI.setImportedId(pJ.getImportedId());
                    }
                }
                for (i = this.gamePack_.getEntries().size() - 1; i >= 0; --i) {
                    TableItem it = this.profilesTable_.getItem(i);
                    if (it.getChecked()) {
                        GamePackEntry entry = this.gamePack_.getEntries().get(i);
                        int dosboxId = entry.getProfile().getDosboxVersion().getId();
                        int dosboxIndex = DosboxVersionRepository.findIndexById(new ArrayList<DosboxVersion>(this.gamePack_.getDosboxVersions()), dosboxId);
                        entry.getProfile().setDosboxVersion(DosboxVersionRepository.findById(this.dbversionsList_, this.dbmapping_.get(dosboxIndex)));
                        continue;
                    }
                    this.gamePack_.getEntries().remove(i);
                }
                for (GamePackEntry entry : this.gamePack_.getEntries()) {
                    GamePack gamePack;
                    gamePack.setCapturesAvailable((gamePack = entry.getGamePack()).isCapturesAvailable() && this.importCapturesButton_.getSelection());
                    gamePack.setMapperfilesAvailable(gamePack.isMapperfilesAvailable() && this.importMapperfilesButton_.getSelection());
                    gamePack.setNativecommandsAvailable(gamePack.isNativecommandsAvailable() && this.importNativeCommandsButton_.getSelection());
                    gamePack.setGamedataAvailable(gamePack.isGamedataAvailable() && this.fullGames_.getSelection());
                }
                this.job_ = new ImportThread(this.log_, this.progressBar_, this.status_, this.gamePack_, this.useOrgConf_.getSelection(), this.fullSettingsButton_.getSelection(), this.customValues_.getSelection(), this.customFields_.getSelection());
            }
            catch (IOException | SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell_, e);
                this.job_ = null;
            }
        } else if (step == 5) {
            if (this.job_.isEverythingOk()) {
                GeneralPurposeDialogs.infoMessage(this.shell_, this.text_.get("dialog.import.notice.importok"));
            } else {
                GeneralPurposeDialogs.warningMessage(this.shell_, this.text_.get("dialog.import.error.problem"));
            }
            this.status_.setText(this.text_.get("dialog.export.reviewlog"));
            this.status_.pack();
            this.result_ = this.job_ != null && this.customFields_.getSelection();
        }
        return true;
    }

    private boolean conditionsForStep3Ok() {
        GeneralPurposeDialogs.initErrorDialog();
        this.atLeastOneProfileSelected();
        if (this.fullGames_.getSelection()) {
            for (int i = 0; i < this.profilesTable_.getItemCount(); ++i) {
                if (!this.profilesTable_.getItem(i).getChecked()) continue;
                GamePackEntry entry = this.gamePack_.getEntries().get(i);
                if (entry.getCanonicalFullDir().exists()) {
                    GeneralPurposeDialogs.addError(this.text_.get("dialog.import.error.gamedatadirexists", new Object[]{entry.getCanonicalFullDir()}), (Control)this.profilesTable_);
                }
                for (int j = 0; j < i; ++j) {
                    if (!this.profilesTable_.getItem(j).getChecked()) continue;
                    GamePackEntry pJ = this.gamePack_.getEntries().get(j);
                    if (!entry.getGameDir().equals(pJ.getGameDir()) || !entry.getBaseDir().equals(pJ.getBaseDir()) || entry.getGamePack() == pJ.getGamePack()) continue;
                    GeneralPurposeDialogs.addError(this.text_.get("dialog.import.error.gamedatadirequal", new Object[]{entry.getProfile().getTitle(), pJ.getProfile().getTitle(), entry.getGameDir()}), (Control)this.profilesTable_);
                }
            }
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell_);
    }

    private void atLeastOneProfileSelected() {
        for (TableItem item : this.profilesTable_.getItems()) {
            if (!item.getChecked()) continue;
            return;
        }
        GeneralPurposeDialogs.addError(this.text_.get("dialog.import.required.oneprofiletoimport"), (Control)this.profilesTable_);
    }

    private boolean refillImportedDBVersionsList() {
        int idx = 0;
        for (DosboxVersion dbversion : this.gamePack_.getDosboxVersions()) {
            int dbid = dbversion.getId();
            TableItem ti = this.impDbVersionsList_.getItem(idx);
            ti.setForeground(this.isUsed(dbid) ? null : this.display_.getSystemColor(15));
            ++idx;
        }
        return true;
    }

    private boolean isUsed(int dbVersionId) {
        for (int i = 0; i < this.gamePack_.getEntries().size(); ++i) {
            int dbid = this.gamePack_.getEntries().get(i).getProfile().getDosboxVersion().getId();
            if (!this.profilesTable_.getItem(i).getChecked() || dbVersionId != dbid) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void onShellCreated() {
        Group step1 = ImportDialog.createGroup((Composite)this.shell_, this.text_.get("dialog.import.step1"), 2);
        ImportDialog.createLabelAndText((Composite)step1, this.text_.get("dialog.export.exporttitle"), this.gamePack_.getTitle()).setEditable(false);
        ImportDialog.createLabelAndText((Composite)step1, this.text_.get("dialog.export.author"), this.gamePack_.getAuthor()).setEditable(false);
        ImportDialog.createLabelAndTextarea((Composite)step1, this.text_.get("dialog.export.notes"), true, true, 1, 1, this.gamePack_.getNotes());
        Text confLogText = ImportDialog.createLabelAndTextarea((Composite)step1, this.text_.get("dialog.import.log"), true, true, 1, 1, this.messageLog_.toString());
        GridData twoLines = new GridData(4, 1024, true, false);
        twoLines.heightHint = confLogText.getLineHeight() * 2;
        confLogText.setLayoutData((Object)twoLines);
        this.addStep(step1);
        Group page2 = ImportDialog.createGroup((Composite)this.shell_, this.text_.get("dialog.import.step2"), 2);
        ImportDialog.createLabel((Composite)page2, this.text_.get("dialog.import.import"));
        Group settingsOrGamesGroup = ImportDialog.createGroup((Composite)page2, (Layout)new GridLayout());
        ImportDialog.createRadioButton((Composite)settingsOrGamesGroup, this.text_.get("dialog.export.export.profiles"), 1, !this.gamePack_.isGamedataAvailable());
        this.fullGames_ = ImportDialog.createRadioButton((Composite)settingsOrGamesGroup, this.text_.get("dialog.export.export.games"), 1, this.gamePack_.isGamedataAvailable());
        this.fullGames_.setEnabled(this.gamePack_.isGamedataAvailable());
        ImportDialog.createLabel((Composite)page2, 1, 3);
        Group confGroup = ImportDialog.createGroup((Composite)page2, (Layout)new GridLayout());
        ImportDialog.createRadioButton((Composite)confGroup, this.text_.get("dialog.import.import.incrconf"), 1, true);
        this.fullSettingsButton_ = ImportDialog.createRadioButton((Composite)confGroup, this.text_.get("dialog.import.import.fullconf"));
        Group extrasGroup = ImportDialog.createGroup((Composite)page2, (Layout)new GridLayout());
        this.importCapturesButton_ = ImportDialog.createCheckButton((Composite)extrasGroup, 1, this.text_.get("dialog.template.captures"), this.gamePack_.isCapturesAvailable());
        this.importCapturesButton_.setEnabled(this.gamePack_.isCapturesAvailable());
        this.importMapperfilesButton_ = ImportDialog.createCheckButton((Composite)extrasGroup, 1, this.text_.get("dialog.template.mapperfile"), this.gamePack_.isMapperfilesAvailable());
        this.importMapperfilesButton_.setEnabled(this.gamePack_.isMapperfilesAvailable());
        this.importNativeCommandsButton_ = ImportDialog.createCheckButton((Composite)extrasGroup, 1, this.text_.get("dialog.export.nativecommands"), false);
        this.importNativeCommandsButton_.setEnabled(this.gamePack_.isNativecommandsAvailable());
        Group customGroup = ImportDialog.createGroup((Composite)page2, (Layout)new GridLayout());
        this.customValues_ = ImportDialog.createCheckButton((Composite)customGroup, 1, this.text_.get("dialog.import.import.customvalues"), true);
        this.customFields_ = ImportDialog.createCheckButton((Composite)customGroup, 1, this.text_.get("dialog.import.import.customfields"), false);
        ImportDialog.createLabel((Composite)page2, this.text_.get("dialog.main.profile.view.conf"));
        Group existingConfGroup = ImportDialog.createGroup((Composite)page2, (Layout)new GridLayout());
        boolean useGameDirForConfFile = this.settings_.getIntValue("profiledefaults", "confpath") == 1;
        this.useOrgConf_ = ImportDialog.createRadioButton((Composite)existingConfGroup, this.text_.get("dialog.import.useorgconf"), 1, useGameDirForConfFile);
        this.useOrgConf_.setEnabled(useGameDirForConfFile);
        ImportDialog.createRadioButton((Composite)existingConfGroup, this.text_.get("dialog.import.createnewconf")).setEnabled(useGameDirForConfFile);
        this.addStep(page2);
        Group profilesGroup = ImportDialog.createGroup((Composite)this.shell_, this.text_.get("dialog.import.step3"), 2);
        this.profilesTable_ = new Table((Composite)profilesGroup, 67616);
        GridData gd = new GridData(4, 4, true, true, 1, 2);
        gd.heightHint = 80;
        this.profilesTable_.setLayoutData((Object)gd);
        this.profilesTable_.setHeaderVisible(true);
        this.profilesTable_.setLinesVisible(true);
        this.profilesTable_.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                int idx = ImportDialog.this.profilesTable_.getSelectionIndex();
                GamePackEntry entry = ImportDialog.this.gamePack_.getEntries().get(idx);
                DirectoryDialog dialog = new DirectoryDialog(ImportDialog.this.shell_);
                dialog.setFilterPath(entry.getCanonicalBaseDir().getPath());
                String result = dialog.open();
                if (result != null) {
                    entry.setBaseDir(result);
                    ImportDialog.this.profilesTable_.getSelection()[0].setText(1, entry.getBaseDir().getPath());
                }
            }
        });
        ImportDialog.createTableColumn(this.profilesTable_, 260, this.text_.get("dialog.main.profiles.column.title"));
        ImportDialog.createTableColumn(this.profilesTable_, 100, this.text_.get("dialog.import.column.basedir"));
        ImportDialog.createTableColumn(this.profilesTable_, 120, this.text_.get("dialog.export.column.gamedir"));
        for (GamePackEntry entry : this.gamePack_.getEntries()) {
            TableItem item = new TableItem(this.profilesTable_, 0);
            item.setText(entry.getProfile().getTitle());
            item.setText(1, entry.getBaseDir().getPath());
            item.setText(2, entry.getGameDir().getPath());
            item.setChecked(true);
        }
        ImportDialog.createButton((Composite)profilesGroup, this.text_.get("button.all"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (TableItem item : ImportDialog.this.profilesTable_.getItems()) {
                    item.setChecked(true);
                }
            }
        });
        ImportDialog.createButton((Composite)profilesGroup, this.text_.get("button.none"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (TableItem item : ImportDialog.this.profilesTable_.getItems()) {
                    item.setChecked(false);
                }
            }
        });
        Composite buttonsGroup = ImportDialog.createInnerComposite((Composite)profilesGroup, new GridData(4, 0x1000000, true, false, 2, 1), 3);
        ImportDialog.createButton(buttonsGroup, this.text_.get("button.setbasedir"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ImportDialog.this.shell_);
                dialog.setFilterPath(FileLocationService.getInstance().getDosroot().getPath());
                String result = dialog.open();
                if (result != null) {
                    for (int i = 0; i < ImportDialog.this.profilesTable_.getItems().length; ++i) {
                        TableItem item = ImportDialog.this.profilesTable_.getItem(i);
                        if (!item.getChecked()) continue;
                        ImportDialog.this.gamePack_.getEntries().get(i).setBaseDir(result);
                        item.setText(1, ImportDialog.this.gamePack_.getEntries().get(i).getBaseDir().getPath());
                    }
                }
            }
        });
        ImportDialog.createButton(buttonsGroup, this.text_.get("button.addgametitletobasedir"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (int i = 0; i < ImportDialog.this.profilesTable_.getItems().length; ++i) {
                    TableItem item = ImportDialog.this.profilesTable_.getItem(i);
                    if (!item.getChecked()) continue;
                    ImportDialog.this.gamePack_.getEntries().get(i).appendGameTitleToBaseDir();
                    item.setText(1, ImportDialog.this.gamePack_.getEntries().get(i).getBaseDir().getPath());
                }
            }
        });
        ImportDialog.createButton(buttonsGroup, this.text_.get("button.removegametitlefrombasedir"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (int i = 0; i < ImportDialog.this.profilesTable_.getItems().length; ++i) {
                    TableItem item = ImportDialog.this.profilesTable_.getItem(i);
                    if (!item.getChecked()) continue;
                    ImportDialog.this.gamePack_.getEntries().get(i).stripGameTitleFromBaseDir();
                    item.setText(1, ImportDialog.this.gamePack_.getEntries().get(i).getBaseDir().getPath());
                }
            }
        });
        this.addStep(profilesGroup);
        Group dosboxVersionsGroup = ImportDialog.createGroup((Composite)this.shell_, this.text_.get("dialog.import.step4"), 3);
        ImportDialog.createLabel((Composite)dosboxVersionsGroup, this.text_.get("dialog.import.dosboxversioninimport"));
        ImportDialog.createVerticalSeparator((Composite)dosboxVersionsGroup, 2);
        ImportDialog.createLabel((Composite)dosboxVersionsGroup, this.text_.get("dialog.import.dosboxversioninstalled"));
        this.impDbVersionsList_ = new Table((Composite)dosboxVersionsGroup, 67584);
        this.impDbVersionsList_.setLayoutData((Object)new GridData(4, 4, true, true));
        final org.eclipse.swt.widgets.List myDbVersionsList = ImportDialog.createList((Composite)dosboxVersionsGroup, 1, 1);
        myDbVersionsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = ImportDialog.this.impDbVersionsList_.getSelectionIndex();
                if (idx != -1) {
                    int myIdx = myDbVersionsList.getSelectionIndex();
                    ImportDialog.this.dbmapping_.set(idx, ((DosboxVersion)ImportDialog.this.dbversionsList_.get(myIdx)).getId());
                }
            }
        });
        this.impDbVersionsList_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDialog.this.selectDbVersionForSelectedImpDbVersion(myDbVersionsList);
            }
        });
        for (DosboxVersion ver : this.dbversionsList_) {
            myDbVersionsList.add(ver.getTitle() + " (" + ver.getVersion() + ")");
        }
        this.dbmapping_ = new ArrayList<Integer>();
        for (DosboxVersion dbversion : this.gamePack_.getDosboxVersions()) {
            TableItem item = new TableItem(this.impDbVersionsList_, 0);
            item.setText(dbversion.getTitle() + " (" + dbversion.getVersion() + ")");
            this.dbmapping_.add(DosboxVersionRepository.findBestMatch(this.dbversionsList_, dbversion).getId());
        }
        this.impDbVersionsList_.setSelection(0);
        this.selectDbVersionForSelectedImpDbVersion(myDbVersionsList);
        this.addStep(dosboxVersionsGroup);
        this.addFinalStep(this.text_.get("dialog.import.step5"), this.text_.get("dialog.import.start"));
    }

    private void selectDbVersionForSelectedImpDbVersion(org.eclipse.swt.widgets.List myDbVersionsList) {
        int impIdx = this.impDbVersionsList_.getSelectionIndex();
        int mappedId = this.dbmapping_.get(impIdx);
        int myIdx = DosboxVersionRepository.findIndexById(this.dbversionsList_, mappedId);
        myDbVersionsList.select(myIdx);
    }
}

