/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.thread;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.interfaces.ProgressNotifyable;
import org.dbgl.service.ITextService;
import org.dbgl.service.TextService;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public abstract class UIThread<T>
extends Thread
implements ProgressNotifyable {
    protected static final String PREFIX_OK = "  + ";
    protected static final String PREFIX_ERR = "  - ";
    protected static final ITextService text_ = TextService.getInstance();
    protected final StringBuffer messageLog_ = new StringBuffer();
    private final Text log_;
    private final ProgressBar progressBar_;
    private final Label status_;
    private final Display display_;
    private final boolean extensiveLogging_;
    private List<T> objects_;
    private boolean everythingOk_ = true;

    public UIThread(Text log, ProgressBar progressBar, Label status, boolean extensiveLogging) {
        this.log_ = log;
        this.progressBar_ = progressBar;
        this.status_ = status;
        this.display_ = log.getShell().getDisplay();
        this.extensiveLogging_ = extensiveLogging;
    }

    protected List<T> getObjects() {
        return this.objects_;
    }

    protected void setObjects(List<T> objects) {
        this.objects_ = objects;
        this.progressBar_.setMaximum(objects.size());
    }

    @Override
    public void run() {
        for (T o : this.objects_) {
            try {
                String warnings;
                if (this.extensiveLogging_) {
                    this.messageLog_.append(this.getTitle(o)).append(":\n");
                }
                if (StringUtils.isNotEmpty((CharSequence)(warnings = this.work(o)))) {
                    if (!this.extensiveLogging_) {
                        this.messageLog_.append(this.getTitle(o));
                    }
                    this.messageLog_.append(PREFIX_ERR).append(warnings);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!this.extensiveLogging_) {
                    this.messageLog_.append(this.getTitle(o));
                }
                this.messageLog_.append(PREFIX_ERR).append(StringRelatedUtils.toString(e)).append('\n');
                this.everythingOk_ = false;
            }
            if (this.display_.isDisposed() || this.log_.isDisposed() || this.progressBar_.isDisposed() || this.status_.isDisposed()) break;
            this.display_.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (UIThread.this.messageLog_.length() > 0) {
                        String additionalOutput = UIThread.this.messageLog_.toString();
                        UIThread.this.log_.append(additionalOutput);
                        System.out.print(additionalOutput);
                        UIThread.this.messageLog_.setLength(0);
                    }
                    UIThread.this.incrProgress(1024L);
                }
            });
        }
        try {
            this.preFinish();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.completeProgress();
    }

    public void displayTitle(final String title) {
        if (!this.display_.isDisposed() && !this.status_.isDisposed()) {
            this.display_.syncExec(new Runnable(){

                @Override
                public void run() {
                    UIThread.this.status_.setText(title);
                    UIThread.this.status_.pack();
                }
            });
        }
    }

    @Override
    public void setTotal(final long total) {
        if (!this.display_.isDisposed() && !this.progressBar_.isDisposed()) {
            this.display_.syncExec(new Runnable(){

                @Override
                public void run() {
                    UIThread.this.progressBar_.setMaximum((int)(total / 1024L) + UIThread.this.objects_.size());
                }
            });
        }
    }

    @Override
    public void incrProgress(final long progress) {
        if (!this.display_.isDisposed() && !this.progressBar_.isDisposed()) {
            this.display_.syncExec(new Runnable(){

                @Override
                public void run() {
                    UIThread.this.progressBar_.setSelection(UIThread.this.progressBar_.getSelection() + (int)(progress / 1024L));
                }
            });
        }
    }

    @Override
    public void setProgress(final long progress) {
        if (!this.display_.isDisposed() && !this.progressBar_.isDisposed()) {
            this.display_.syncExec(new Runnable(){

                @Override
                public void run() {
                    UIThread.this.progressBar_.setSelection((int)(progress / 1024L));
                }
            });
        }
    }

    private void completeProgress() {
        if (!this.display_.isDisposed() && !this.progressBar_.isDisposed()) {
            this.display_.syncExec(new Runnable(){

                @Override
                public void run() {
                    UIThread.this.progressBar_.setSelection(UIThread.this.progressBar_.getMaximum());
                }
            });
        }
    }

    public boolean isEverythingOk() {
        return this.everythingOk_;
    }

    public abstract String getTitle(T var1);

    public abstract String work(T var1) throws IOException, SQLException;

    public abstract void preFinish() throws IOException;
}

