/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import SevenZip.Archive.SevenZip.Handler;
import SevenZip.Archive.SevenZipEntry;
import SevenZip.IInStream;
import SevenZip.MyRandomAccessFile;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.FileLocation;
import org.dbgl.service.TextService;
import org.dbgl.util.SystemUtils;
import org.dbgl.util.fat.FatFileSystem;
import org.dbgl.util.fat.FatLfnDirectory;
import org.dbgl.util.fat.FatLfnDirectoryEntry;
import org.dbgl.util.fat.FileDisk;
import org.dbgl.util.iso.ISO9660FileEntry;
import org.dbgl.util.iso.ISO9660FileSystem;

public class FilesUtils {
    public static final String[] CDIMAGES = new String[]{".iso", ".cue", ".bin"};
    public static final String[] EXECUTABLES = new String[]{".exe", ".com", ".bat"};
    private static final String[] EXECUTABLES_UPPERCASE = new String[]{"EXE", "COM", "BAT"};
    public static final String[] ARCHIVES = new String[]{".zip", ".7z"};
    private static final String[] FATIMAGES = new String[]{".ima"};
    private static final String[] BOOTERIMAGES = new String[]{".cp2", ".dcf", ".img", ".jrc", ".td0", ".fdd", ".fdi", ".d88", ".hdi"};
    private static final String[] PICTURES = new String[]{".png", ".gif", ".jpg", ".tif", ".tiff", ".ico", ".bmp"};
    public static final String NATIVE_EXE_FILTER = SystemUtils.IS_WINDOWS ? "*.exe;*.EXE" : (SystemUtils.IS_OSX ? "*.app" : "*");
    public static final String CNF_FILTER = "*.conf;*.CONF";
    public static final String EXE_FILTER = "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT";
    public static final String ARC_FILTER = "*.zip;*.ZIP;*.7z;*.7Z";
    public static final String DBGLZIP_FILTER = "*.dbgl.zip;*.DBGL.ZIP";
    public static final String BTR_FILTER = "*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0;*.fdd;*.FDD;*.fdi;*.FDI;*.d88;*.D88;*.hdi;*.HDI";
    public static final String HDI_FILTER = "*.hdi;*.HDI";
    public static final String CDI_FILTER = "*.iso;*.ISO;*.cue;*.CUE";
    public static final String FATI_FILTER = "*.ima;*.IMA;";
    public static final String ALL_FILTER = "*";
    public static final String XML_EXT = ".xml";
    public static final String CONF_EXT = ".conf";
    public static final String MAPPER_EXT = ".map";
    public static final String GAMEPACKARCHIVE_EXT = ".dbgl.zip";
    private static final String INVALID_FILENAME_CHARS_REGEXP = "[^a-zA-Z_0-9()]";

    public static boolean isExistingFile(File file) {
        return file != null && file.isFile() && file.exists();
    }

    public static boolean isReadableFile(File file) {
        return file != null && file.isFile() && file.canRead();
    }

    public static boolean isExistingDirectory(File dir) {
        return dir != null && dir.isDirectory() && dir.exists();
    }

    public static boolean isWritableDirectory(File dir) {
        try {
            File.createTempFile("chkperm", null, dir).delete();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isStoredOnFloppyDrive(File file) {
        if (SystemUtils.IS_OSX) {
            return false;
        }
        FileSystemView fsv = FileSystemView.getFileSystemView();
        for (File f : File.listRoots()) {
            if (!FilesUtils.areRelated(f, file)) continue;
            return fsv.isFloppyDrive(f);
        }
        return false;
    }

    public static boolean isStoredOnCDRomDrive(File file) {
        if (SystemUtils.IS_OSX) {
            return false;
        }
        FileSystemView fsv = FileSystemView.getFileSystemView();
        for (File f : File.listRoots()) {
            if (!FilesUtils.areRelated(f, file)) continue;
            return fsv.isDrive(f) && fsv.getSystemTypeDescription(f).toUpperCase().contains("CD");
        }
        return false;
    }

    public static boolean isConfFile(String filename) {
        return filename.toLowerCase().endsWith(CONF_EXT);
    }

    public static boolean isGamePackArchiveFile(String filename) {
        return filename.toLowerCase().endsWith(GAMEPACKARCHIVE_EXT);
    }

    public static boolean isExecutable(String filename) {
        return Stream.of(EXECUTABLES).anyMatch(x -> filename.toLowerCase().endsWith((String)x));
    }

    public static boolean isArchive(String filename) {
        return Stream.of(ARCHIVES).anyMatch(x -> filename.toLowerCase().endsWith((String)x));
    }

    public static boolean isFatImage(String filename) {
        return Stream.of(FATIMAGES).anyMatch(x -> filename.toLowerCase().endsWith((String)x));
    }

    public static boolean isBooterImage(String filename) {
        return Stream.of(BOOTERIMAGES).anyMatch(x -> filename.toLowerCase().endsWith((String)x));
    }

    public static boolean isCdImageFile(String filename) {
        return Stream.of(CDIMAGES).anyMatch(x -> filename.toLowerCase().endsWith((String)x));
    }

    public static boolean isPhysFS(String filename) {
        return Stream.of(ARCHIVES).anyMatch(x -> filename.toLowerCase().endsWith(x + ':' + File.separatorChar));
    }

    public static int fatImageIndex(String filename) {
        return Stream.of(FATIMAGES).filter(x -> filename.toLowerCase().contains(x + File.separatorChar)).mapToInt(x -> filename.toLowerCase().indexOf(x + File.separatorChar) + x.length()).findFirst().orElse(-1);
    }

    public static int cdImageIndex(String filename) {
        return Stream.of(CDIMAGES).filter(x -> filename.toLowerCase().contains(x + File.separatorChar)).mapToInt(x -> filename.toLowerCase().indexOf(x + File.separatorChar) + x.length()).findFirst().orElse(-1);
    }

    public static int physFsIndex(String filename) {
        return Stream.of(ARCHIVES).filter(x -> filename.toLowerCase().contains(x + File.separatorChar)).mapToInt(x -> filename.toLowerCase().indexOf(x + File.separatorChar) + x.length()).findFirst().orElse(-1);
    }

    public static String[] listFileNames(List<File> files) {
        return (String[])files.stream().map(x -> x.getName()).toArray(String[]::new);
    }

    public static String[] listFileNames(FileLocation[] fileLocations) {
        return fileLocations == null ? null : (String[])Stream.of(fileLocations).map(x -> x != null ? x.getFile().getName() : null).toArray(String[]::new);
    }

    public static String[] listFilePaths(List<File> files) {
        return (String[])files.stream().map(x -> x.getPath()).toArray(String[]::new);
    }

    public static String[] listFilePaths(FileLocation[] fileLocations) {
        return fileLocations == null ? null : (String[])Stream.of(fileLocations).map(x -> x != null ? x.getFile().getPath() : "").toArray(String[]::new);
    }

    public static File[] listPictureFiles(File[] files) {
        return files == null ? null : (File[])Stream.of(files).filter(f -> Stream.of(PICTURES).anyMatch(x -> f.getName().toLowerCase().endsWith((String)x))).sorted().toArray(File[]::new);
    }

    public static List<File> listExecutablesInDirRecursive(File dir) {
        ArrayList<File> executables = new ArrayList<File>(FileUtils.listFiles((File)dir, (String[])EXECUTABLES_UPPERCASE, (boolean)true));
        Collections.sort(executables, new FileComparator());
        return executables;
    }

    public static String[] listExecutablesInZipOrIsoOrFat(String archive) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        File arcFile = new File(archive);
        if (archive.toLowerCase().endsWith(ARCHIVES[0])) {
            try (ZipFile zfile = new ZipFile(arcFile);){
                Enumeration<? extends ZipEntry> entries = zfile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory() || !FilesUtils.isExecutable(name)) continue;
                    result.add(FilesUtils.toNativePath(name));
                }
            }
        } else if (archive.toLowerCase().endsWith(ARCHIVES[1])) {
            Handler zArchive = new Handler();
            MyRandomAccessFile istream = new MyRandomAccessFile(archive, "r");
            if (zArchive.Open((IInStream)istream) != 0) {
                throw new IOException(TextService.getInstance().get("general.error.opensevenzip", new Object[]{archive}));
            }
            for (int i = 0; i < zArchive.size(); ++i) {
                SevenZipEntry entry = zArchive.getEntry(i);
                String name = entry.getName();
                if (entry.isDirectory() || !FilesUtils.isExecutable(name)) continue;
                result.add(FilesUtils.toNativePath(name));
            }
            zArchive.close();
        } else if (FilesUtils.isCdImageFile(archive)) {
            ISO9660FileSystem iso = new ISO9660FileSystem(new File(archive));
            Enumeration<ISO9660FileEntry> entries = iso.getEntries();
            while (entries.hasMoreElements()) {
                ISO9660FileEntry entry = entries.nextElement();
                String name = entry.getPath();
                if (entry.isDirectory() || !FilesUtils.isExecutable(name)) continue;
                result.add(FilesUtils.toNativePath(name));
            }
            iso.close();
        } else if (FilesUtils.isFatImage(archive)) {
            FileDisk device = new FileDisk(new File(archive));
            result.addAll(FilesUtils.listFatExecutables(new FatFileSystem(device).getRoot(), ""));
            device.close();
        }
        Collections.sort(result, new FilenameComparator());
        return result.toArray(new String[result.size()]);
    }

    private static List<String> listFatExecutables(FatLfnDirectory dir, String dirPath) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<FatLfnDirectoryEntry> entries = dir.iterator();
        while (entries.hasNext()) {
            FatLfnDirectoryEntry entry = entries.next();
            String name = entry.getShortName();
            if (name.length() > 8) {
                name = name.substring(0, 8).trim() + '.' + name.substring(8).trim();
            }
            if (entry.isDirectory() && !name.equals(".") && !name.equals("..")) {
                result.addAll(FilesUtils.listFatExecutables(entry.getDirectory(), dirPath + name + File.separatorChar));
                continue;
            }
            if (!entry.isFile() || !FilesUtils.isExecutable(name)) continue;
            result.add(dirPath + name);
        }
        return result;
    }

    public static File[] listFileSequence(File file) {
        File[] files;
        File dir;
        ArrayList<File> result = new ArrayList<File>();
        result.add(file);
        int i = 1;
        String name = FilenameUtils.removeExtension((String)file.getName());
        String ext = FilenameUtils.getExtension((String)file.getName());
        if (name.endsWith(String.valueOf(i)) && (dir = file.getParentFile()) != null && (files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile();
            }
        })) != null) {
            int index;
            Object[] fileNames = FilesUtils.listFileNames(Arrays.asList(files));
            do {
                String nextFileName;
                if ((index = ArrayUtils.indexOf((Object[])fileNames, (Object)(nextFileName = StringUtils.chop((String)name) + String.valueOf(++i) + '.' + ext))) < 0) continue;
                result.add(files[index]);
            } while (index >= 0);
        }
        return result.toArray(new File[0]);
    }

    public static void createDir(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            System.err.println(TextService.getInstance().get("general.error.createdir", new Object[]{dir}));
        }
    }

    public static void createDirIfNonExisting(File dir) {
        if (!dir.isDirectory()) {
            System.out.println(TextService.getInstance().get("general.notice.createdir", new Object[]{dir.getPath()}));
            if (!dir.mkdirs()) {
                System.err.println(TextService.getInstance().get("general.error.createdir", new Object[]{dir.getPath()}));
            }
        }
    }

    public static void copyDirIfDestinationDoesNotExist(File src, File dst) {
        try {
            if (!FilesUtils.isExistingDirectory(dst) && FilesUtils.isExistingDirectory(src)) {
                FileUtils.copyDirectoryToDirectory((File)src, (File)dst.getParentFile());
            }
        }
        catch (IOException e) {
            System.err.println(TextService.getInstance().get("general.error.copydirtodir", new String[]{src.getPath(), dst.getPath()}));
        }
    }

    public static void setLastModified(File file, long time) {
        if (time < 0L || !file.setLastModified(time)) {
            System.err.println(TextService.getInstance().get("general.error.setlastmodifiedfile", new Object[]{file.getPath()}));
        }
    }

    public static void setReadOnly(File file) {
        if (!file.setReadOnly()) {
            System.err.println(TextService.getInstance().get("general.error.setreadonlyfile", new Object[]{file.getPath()}));
        }
    }

    public static void removeFile(File file) {
        if (!file.isFile() || !file.delete()) {
            System.err.println(TextService.getInstance().get("general.error.deletefile", new Object[]{file.getPath()}));
        }
    }

    public static void removeFilesInDirAndDir(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                System.err.println(TextService.getInstance().get("general.error.dirtobedeletedcontainsdir", new Object[]{dir.getPath()}));
                return;
            }
            for (File file : files) {
                if (file.delete()) continue;
                System.err.println(TextService.getInstance().get("general.error.deletefile", new Object[]{file}));
            }
        }
        if (!dir.isDirectory() || !dir.delete()) {
            System.err.println(TextService.getInstance().get("general.error.deletedir", new Object[]{dir.getPath()}));
        }
    }

    public static String toUrl(File file) throws MalformedURLException {
        return file == null ? null : file.toURI().toURL().toString();
    }

    public static String toSafeFilename(String filename) {
        return filename.replaceAll(INVALID_FILENAME_CHARS_REGEXP, "");
    }

    public static String toSafeFilenameForWebImages(String filename) {
        return FilesUtils.toSafeFilename(filename.replaceAll(" ", "_"));
    }

    public static String toNativePath(String path) {
        return path == null ? null : path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public static String toDosPath(String nativePath) {
        return nativePath == null ? null : nativePath.replace(File.separatorChar, '\\');
    }

    public static String toArchivePath(File archiveEntry, boolean isDirectory) {
        return isDirectory ? archiveEntry.getPath().replace('\\', '/') + '/' : archiveEntry.getPath().replace('\\', '/');
    }

    public static String determineFullArchiveName(String archive, String fileEntry) {
        if (FilesUtils.isArchive(archive) || FilesUtils.isCdImageFile(archive) || FilesUtils.isFatImage(archive)) {
            return archive + File.separatorChar + fileEntry;
        }
        return null;
    }

    public static File determineMainFile(File file) {
        String f = file.getPath();
        int isoIdx = FilesUtils.cdImageIndex(f);
        int pfsIdx = FilesUtils.physFsIndex(f);
        int fatIdx = FilesUtils.fatImageIndex(f);
        if (isoIdx != -1) {
            return new File(f.substring(0, isoIdx));
        }
        if (pfsIdx != -1) {
            return new File(f.substring(0, pfsIdx));
        }
        if (fatIdx != -1) {
            return new File(f.substring(0, fatIdx));
        }
        return file;
    }

    public static FileLocation concat(File basePath, FileLocation fullFilenameToAdd) {
        return new FileLocation(FilesUtils.concat(basePath, fullFilenameToAdd.getFile()), fullFilenameToAdd.getCanonicalizer());
    }

    public static String concat(File basePath, File fullFilenameToAdd) {
        return FilesUtils.concat(basePath.getPath(), fullFilenameToAdd.getPath());
    }

    public static String concat(File basePath, String fullFilenameToAdd) {
        return FilesUtils.concat(basePath.getPath(), fullFilenameToAdd);
    }

    public static String concat(String basePath, String fullFilenameToAdd) {
        if (basePath.equals(".")) {
            return fullFilenameToAdd;
        }
        return FilenameUtils.concat((String)basePath, (String)fullFilenameToAdd);
    }

    public static String relativize(File base, File target) {
        Path pathBase = base.toPath().normalize();
        Path pathAbsolute = target.toPath().normalize();
        return pathBase.relativize(pathAbsolute).toString();
    }

    public static File makeRelativeTo(File base, File file) {
        if (!file.isAbsolute()) {
            return file;
        }
        if (file.equals(base)) {
            return new File(".");
        }
        File remainder = new File(file.getName());
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (parent.equals(base)) {
                return remainder;
            }
            remainder = new File(parent.getName(), remainder.getPath());
        }
        return file;
    }

    public static boolean areRelated(File parent, File child) {
        for (File remainder = child.getParentFile(); remainder != null; remainder = remainder.getParentFile()) {
            if (!parent.equals(remainder)) continue;
            return true;
        }
        return false;
    }

    public static File migrate(File path, File from, File to) {
        return new File(FilesUtils.concat(to, FilesUtils.makeRelativeTo(from, path)));
    }

    public static FileLocation migrate(FileLocation path, FileLocation from, FileLocation to) {
        return new FileLocation(FilesUtils.concat(to.getCanonicalFile(), FilesUtils.makeRelativeTo(from.getCanonicalFile(), path.getCanonicalFile())), path.getCanonicalizer());
    }

    public static final class FilenameComparator
    implements Comparator<String> {
        @Override
        public int compare(String string1, String string2) {
            int count2;
            int count1 = StringUtils.countMatches((CharSequence)string1, (CharSequence)"\\");
            return count1 == (count2 = StringUtils.countMatches((CharSequence)string2, (CharSequence)"\\")) ? string1.compareTo(string2) : count1 - count2;
        }
    }

    public static final class FileComparator
    implements Comparator<File> {
        @Override
        public int compare(File file1, File file2) {
            return new FilenameComparator().compare(file1.getPath(), file2.getPath());
        }
    }
}

