/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.File;
import org.dbgl.service.TextService;
import org.eclipse.swt.program.Program;

public class SystemUtils {
    public static final String EOLN = System.getProperty("line.separator");
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String JVM_ARCH = System.getProperty("sun.arch.data.model");
    public static final String JVM_VERSION = System.getProperty("java.version");
    public static final boolean IS_WINDOWS = OS_NAME.startsWith("Windows");
    public static final boolean IS_LINUX = OS_NAME.startsWith("Linux");
    public static final boolean IS_OSX = OS_NAME.startsWith("Mac OS");
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String SWT_LIB_PATH = System.getProperty("swt.library.path");
    public static final boolean USE_DBGL_DATA_LOCAL_APP_DATA = Boolean.valueOf(System.getProperty("dbgl.data.localappdata"));
    public static final boolean USE_DBGL_DATA_USER_HOME = Boolean.valueOf(System.getProperty("dbgl.data.userhome"));
    public static final boolean USE_USER_HOME_DIR = USE_DBGL_DATA_LOCAL_APP_DATA || USE_DBGL_DATA_USER_HOME;
    public static final File USER_DATA_DIR = IS_WINDOWS ? new File(System.getenv("LOCALAPPDATA"), "/DBGL") : new File(System.getProperty("user.home"), "/.dbgl");

    public static void openForEditing(File file) {
        if (!Program.launch((String)file.getPath()) && IS_LINUX && !SystemUtils.tryToRun(new String[]{"xdg-open", "gnome-open"}, file.getPath())) {
            System.err.println(TextService.getInstance().get("general.error.openfile", new Object[]{file}));
        }
    }

    public static void openForBrowsing(String url) {
        if (!Program.launch((String)url) && IS_LINUX && !SystemUtils.tryToRun(new String[]{"xdg-open", "gnome-open"}, url)) {
            System.err.println(TextService.getInstance().get("general.error.openurl", new Object[]{url}));
        }
    }

    public static void openDirForViewing(File file) {
        if (!Program.launch((String)file.getPath()) && IS_LINUX && !SystemUtils.tryToRun(new String[]{"nautilus", "dolphin", "kfmclient"}, file.getPath())) {
            System.err.println(TextService.getInstance().get("general.error.opendir", new Object[]{file}));
        }
    }

    private static boolean tryToRun(String[] executables, String param) {
        for (String exe : executables) {
            try {
                Runtime.getRuntime().exec(new String[]{exe, param}, null, null);
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }
}

