/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.fat;

import java.io.IOException;
import org.dbgl.util.fat.FatDirectoryEntry;
import org.dbgl.util.fat.FatLfnDirectory;

public final class FatLfnDirectoryEntry {
    private final FatLfnDirectory parent_;
    final FatDirectoryEntry realEntry_;
    private final String fileName_;

    FatLfnDirectoryEntry(FatLfnDirectory parent, FatDirectoryEntry realEntry, String fileName) {
        this.parent_ = parent;
        this.realEntry_ = realEntry;
        this.fileName_ = fileName;
    }

    static FatLfnDirectoryEntry extract(FatLfnDirectory dir, int offset, int len) {
        String fileName;
        FatDirectoryEntry realEntry = dir.dir_.getEntry(offset + len - 1);
        if (len == 1) {
            fileName = realEntry.getShortName().asSimpleString();
        } else {
            StringBuilder name = new StringBuilder(13 * (len - 1));
            for (int i = len - 2; i >= 0; --i) {
                FatDirectoryEntry entry = dir.dir_.getEntry(i + offset);
                name.append(entry.getLfnPart());
            }
            fileName = name.toString().trim();
        }
        return new FatLfnDirectoryEntry(dir, realEntry, fileName);
    }

    public String getName() {
        return this.fileName_;
    }

    public String getShortName() {
        return this.realEntry_.getShortName().asSimpleString();
    }

    public FatLfnDirectory getDirectory() throws IOException {
        return this.parent_.getDirectory(this.realEntry_);
    }

    public String toString() {
        return "LFN = " + this.fileName_ + " / SFN = " + this.realEntry_.getShortName();
    }

    public boolean isFile() {
        return this.realEntry_.isFile();
    }

    public boolean isDirectory() {
        return this.realEntry_.isDirectory();
    }
}

