/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.iso;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.iso.EntryEnumeration;
import org.dbgl.util.iso.ISO9660FileEntry;
import org.dbgl.util.iso.ISO9660VolumeDescriptorSet;

public class ISO9660FileSystem {
    public static final int COOKED_SECTOR_SIZE = 2048;
    public static final int VCD_SECTOR_SIZE = 2336;
    public static final int RAW_SECTOR_SIZE = 2352;
    public static final String DEFAULT_ENCODING = "US-ASCII";
    private static final int RESERVED_SECTORS = 16;
    private int blockSize_;
    private boolean mode2_;
    private ISO9660VolumeDescriptorSet volumeDescriptorSet_;
    private RandomAccessFile channel_;

    public ISO9660FileSystem(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File not found");
        }
        if (file.getName().toLowerCase().endsWith(FilesUtils.CDIMAGES[1])) {
            File binFile = ISO9660FileSystem.parseCueSheet(file);
            if (binFile == null) {
                throw new IOException("Couldn't parse cue sheet");
            }
            file = binFile;
        }
        this.channel_ = new RandomAccessFile(file, "r");
        this.volumeDescriptorSet_ = new ISO9660VolumeDescriptorSet(this);
        if (!(this.canReadVolumeDescriptors(2048, false) || this.canReadVolumeDescriptors(2352, false) || this.canReadVolumeDescriptors(2336, true) || this.canReadVolumeDescriptors(2352, true))) {
            throw new IOException("Couldn't find volume descriptor, the cd-image doesn't seem to be in ISO9660 file format");
        }
    }

    public Enumeration<ISO9660FileEntry> getEntries() {
        this.ensureOpen();
        return new EntryEnumeration(this, this.volumeDescriptorSet_.getRootEntry());
    }

    public String getEncoding() {
        return this.volumeDescriptorSet_.getEncoding();
    }

    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.channel_.close();
        }
        catch (IOException ex) {
            throw new IOException("Couldn't close file channel");
        }
        finally {
            this.channel_ = null;
        }
    }

    byte[] getBytes(ISO9660FileEntry entry) throws IOException {
        int size = entry.getSize();
        int sectorsToRead = (size + 2048 - 1) / 2048;
        byte[] buf = new byte[sectorsToRead * 2048];
        for (int i = 0; i < sectorsToRead; ++i) {
            this.readBlock(entry.getStartBlock() + (long)i, buf, i * 2048);
        }
        return buf;
    }

    public static File parseCueSheet(File file) throws IOException {
        File result = null;
        try (FileReader reader = new FileReader(file);
             BufferedReader configData = new BufferedReader(reader);){
            String orgTextLine;
            while ((orgTextLine = configData.readLine()) != null) {
                if ((orgTextLine = orgTextLine.trim()).length() <= 0 || !orgTextLine.startsWith("FILE")) continue;
                int idx1 = orgTextLine.indexOf(34, 5);
                int idx2 = orgTextLine.lastIndexOf(34);
                if (idx1 == -1 || idx2 == -1 || idx1 >= idx2) continue;
                String binFilename = orgTextLine.substring(idx1 + 1, idx2);
                result = new File(binFilename).isAbsolute() ? new File(binFilename) : new File(file.getParent(), binFilename);
                break;
            }
        }
        return result;
    }

    private boolean canReadVolumeDescriptors(int sectorSize, boolean mode2) {
        this.blockSize_ = sectorSize;
        this.mode2_ = mode2;
        byte[] buffer = new byte[2048];
        try {
            int block = 16;
            while (this.readBlock(block, buffer, 0) && !this.volumeDescriptorSet_.deserialize(buffer)) {
                ++block;
            }
        }
        catch (IOException e) {
            return false;
        }
        return this.volumeDescriptorSet_.getRootEntry() != null;
    }

    private boolean readBlock(long block, byte[] buffer, int bufOffset) throws IOException {
        int bytesRead = this.readData(block * (long)this.blockSize_, buffer, bufOffset, 2048);
        if (bytesRead <= 0) {
            return false;
        }
        if (2048 != bytesRead) {
            throw new IOException("Could not deserialize a complete block");
        }
        return true;
    }

    private int readData(long startPos, byte[] buffer, int offset, int len) throws IOException {
        this.ensureOpen();
        long pos = startPos;
        if (this.blockSize_ == 2352 && !this.mode2_) {
            pos += 16L;
        }
        if (this.mode2_) {
            pos += 24L;
        }
        this.channel_.seek(pos);
        return this.channel_.read(buffer, offset, len);
    }

    private boolean isClosed() {
        return this.channel_ == null;
    }

    private void ensureOpen() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("File has been closed");
        }
    }
}

