/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.constants;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.dbgl.util.searchengine.MetropolisSearchEngine;
import org.dbgl.util.searchengine.MobyGamesSearchEngine;
import org.dbgl.util.searchengine.PouetSearchEngine;
import org.dbgl.util.searchengine.TheGamesDBSearchEngine;
import org.dbgl.util.searchengine.WebSearchEngine;

public class Constants {
    public static final String PROGRAM_NAME_SHORT = "DBGL";
    public static final String PROGRAM_NAME_FULL = "DOSBox Game Launcher";
    public static final String PROGRAM_VERSION;
    public static final int RO_COLUMN_NAMES = 10;
    public static final int EDIT_COLUMN_NAMES_1 = 10;
    public static final int EDIT_COLUMN_NAMES_2 = 4;
    public static final int EDIT_COLUMN_NAMES = 14;
    public static final int STATS_COLUMN_NAMES = 8;
    public static final List<String> SUPPORTED_LANGUAGES;
    public static final List<WebSearchEngine> ALL_WEBSEARCH_ENGINES;
    public static final List<WebSearchEngine> WEBSEARCH_ENGINES;
    public static final String DBCONFWS = "DBConfWS";

    static {
        Properties prop = new Properties();
        try {
            prop.load(Constants.class.getClassLoader().getResourceAsStream("version.properties"));
        }
        catch (IOException iOException) {
        }
        finally {
            PROGRAM_VERSION = prop.getProperty("majorversion", "?") + '.' + prop.getProperty("minorversion", "?");
        }
        SUPPORTED_LANGUAGES = Arrays.asList("ar", "da", "de", "el", "en", "es", "es__Capitalizado", "fi", "fr", "it", "ko", "nl", "pl", "pt_BR", "ru", "sl", "sv", "zh", "zh_TW");
        ALL_WEBSEARCH_ENGINES = Arrays.asList(MobyGamesSearchEngine.getInstance(), MetropolisSearchEngine.getInstance(), PouetSearchEngine.getInstance(), TheGamesDBSearchEngine.getInstance());
        WEBSEARCH_ENGINES = ALL_WEBSEARCH_ENGINES.stream().filter(x -> x.available()).collect(Collectors.toList());
    }
}

