/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Combo_;
import org.dbgl.gui.controls.DaControl;
import org.dbgl.gui.controls.Label_;
import org.dbgl.gui.controls.List_;
import org.dbgl.gui.controls.MetaControl;
import org.dbgl.gui.controls.Scale_;
import org.dbgl.gui.controls.Spinner_;
import org.dbgl.gui.controls.TextControl_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.gui.interfaces.DaControlConvertor;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.conf.Autoexec;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class Chain {
    private final Control[] controls_;
    private final Label[] labels_;
    private final Text[] texts_;
    private final Combo[] combos_;
    private final Button[] buttons_;
    private final org.eclipse.swt.widgets.List[] lists_;
    private final Spinner[] spinners_;
    private final Scale[] scales_;

    public Chain(Builder builder) {
        this.controls_ = builder.controls_.toArray(new Control[builder.controls_.size()]);
        this.labels_ = builder.labels_.toArray(new Label[builder.labels_.size()]);
        this.texts_ = builder.texts_.toArray(new Text[builder.texts_.size()]);
        this.combos_ = builder.combos_.toArray(new Combo[builder.combos_.size()]);
        this.buttons_ = builder.buttons_.toArray(new Button[builder.buttons_.size()]);
        this.lists_ = builder.lists_.toArray(new org.eclipse.swt.widgets.List[builder.lists_.size()]);
        this.spinners_ = builder.spinners_.toArray(new Spinner[builder.spinners_.size()]);
        this.scales_ = builder.scales_.toArray(new Scale[builder.scales_.size()]);
        if (builder.da_ != null) {
            builder.da_.add(builder.daControlBuilder_.label(this.labels_[0]).controls(this.controls_).build());
        } else if (builder.meta_ != null) {
            builder.meta_.add(builder.metaControlBuilder_.label(this.labels_[0]).controls(this.controls_).build());
        }
    }

    public Label[] getLabels() {
        return this.labels_;
    }

    public Label getLabel() {
        return this.labels_[0];
    }

    public Text[] getTexts() {
        return this.texts_;
    }

    public Text getText() {
        return this.texts_[0];
    }

    public Combo[] getCombos() {
        return this.combos_;
    }

    public Combo getCombo() {
        return this.combos_[0];
    }

    public Button[] getButtons() {
        return this.buttons_;
    }

    public Button getButton() {
        return this.buttons_[0];
    }

    public org.eclipse.swt.widgets.List[] getLists() {
        return this.lists_;
    }

    public org.eclipse.swt.widgets.List getList() {
        return this.lists_[0];
    }

    public Spinner[] getSpiners() {
        return this.spinners_;
    }

    public Spinner getSpinner() {
        return this.spinners_[0];
    }

    public Scale[] getScales() {
        return this.scales_;
    }

    public Scale getScale() {
        return this.scales_[0];
    }

    public static Builder on(Composite composite) {
        return new Builder(composite);
    }

    public static final class Builder {
        private final Composite composite_;
        private List<Control> controls_;
        private List<Label> labels_;
        private List<Text> texts_;
        private List<Combo> combos_;
        private List<Button> buttons_;
        private List<org.eclipse.swt.widgets.List> lists_;
        private List<Spinner> spinners_;
        private List<Scale> scales_;
        private List<DaControl> da_;
        private DaControl.Builder daControlBuilder_ = DaControl.builder();
        private List<MetaControl> meta_;
        private MetaControl.Builder metaControlBuilder_ = MetaControl.builder();

        public Builder(Composite composite) {
            this.composite_ = composite;
            this.controls_ = new ArrayList<Control>();
            this.labels_ = new ArrayList<Label>();
            this.texts_ = new ArrayList<Text>();
            this.combos_ = new ArrayList<Combo>();
            this.buttons_ = new ArrayList<Button>();
            this.lists_ = new ArrayList<org.eclipse.swt.widgets.List>();
            this.spinners_ = new ArrayList<Spinner>();
            this.scales_ = new ArrayList<Scale>();
        }

        public Builder lbl(Function<Label_.Builder, Label_.Builder> lb) {
            this.labels_.add(lb.apply(Label_.on(this.composite_)).ctrl());
            return this;
        }

        public Builder txt(Function<Text_.Builder, Text_.Builder> tb) {
            this.texts_.add(tb.apply(Text_.on(this.composite_)).ctrl());
            this.controls_.add((Control)this.texts_.get(this.texts_.size() - 1));
            return this;
        }

        public Builder cmb(Function<Combo_.Builder, Combo_.Builder> cb) {
            this.combos_.add(cb.apply(Combo_.on(this.composite_)).ctrl());
            this.controls_.add((Control)this.combos_.get(this.combos_.size() - 1));
            return this;
        }

        public Builder but(Function<Button_.Builder, Button_.Builder> bb) {
            TextControl_ textControl = !this.texts_.isEmpty() ? new TextControl_(this.texts_.get(this.texts_.size() - 1)) : (!this.combos_.isEmpty() ? new TextControl_(this.combos_.get(this.combos_.size() - 1)) : null);
            Button button = bb.apply(Button_.on(this.composite_)).ctrl(textControl);
            this.buttons_.add(button);
            if (IntStream.of(16, 2, 32).anyMatch(x -> (button.getStyle() & x) == x)) {
                this.controls_.add((Control)button);
            }
            return this;
        }

        public Builder lst(Function<List_.Builder, List_.Builder> lb) {
            this.lists_.add(lb.apply(List_.on(this.composite_)).ctrl());
            this.controls_.add((Control)this.lists_.get(this.lists_.size() - 1));
            return this;
        }

        public Builder spn(Function<Spinner_.Builder, Spinner_.Builder> sb) {
            this.spinners_.add(sb.apply(Spinner_.on(this.composite_)).ctrl());
            this.controls_.add((Control)this.spinners_.get(this.spinners_.size() - 1));
            return this;
        }

        public Builder scl(Function<Scale_.Builder, Scale_.Builder> sb) {
            this.scales_.add(sb.apply(Scale_.on(this.composite_)).ctrl());
            this.controls_.add((Control)this.scales_.get(this.scales_.size() - 1));
            return this;
        }

        public Builder da(List<DaControl> daControls) {
            this.da_ = daControls;
            return this;
        }

        public Builder section(String section) {
            this.daControlBuilder_.section(section);
            return this;
        }

        public Builder section(String sectionOld, String sectionNew) {
            this.daControlBuilder_.section(sectionOld, sectionNew);
            return this;
        }

        public Builder item(String item) {
            this.daControlBuilder_.item(item);
            return this;
        }

        public Builder item(String itemOld, String itemNew) {
            this.daControlBuilder_.item(itemOld, itemNew);
            return this;
        }

        public Builder onOff() {
            this.daControlBuilder_.onOff();
            return this;
        }

        public Builder convert(DaControlConvertor convertor) {
            this.daControlBuilder_.convert(convertor);
            return this;
        }

        public Builder meta(List<MetaControl> metaControls) {
            this.meta_ = metaControls;
            return this;
        }

        public Builder template(Function<Template, String> getMethod, BiConsumer<Template, String> updateMethod) {
            this.metaControlBuilder_.template(getMethod, updateMethod);
            return this;
        }

        public Builder profile(Function<Profile, String> getMethod, BiConsumer<Profile, String> updateMethod) {
            this.metaControlBuilder_.profile(getMethod, updateMethod);
            return this;
        }

        public Builder profile(int i, BiFunction<Profile, Integer, String> getMethod, MetaControl.TriConsumer<Profile, Integer, String> updateMethod) {
            this.metaControlBuilder_.profile(i, getMethod, updateMethod);
            return this;
        }

        public Builder autoexec(Function<Autoexec, String> getMethod, BiConsumer<Autoexec, String> updateMethod) {
            this.metaControlBuilder_.autoexec(getMethod, updateMethod);
            return this;
        }

        public Builder autoexec(int i, BiFunction<Autoexec, Integer, String> getMethod, MetaControl.TriConsumer<Autoexec, Integer, String> updateMethod) {
            this.metaControlBuilder_.autoexec(i, getMethod, updateMethod);
            return this;
        }

        public Chain build() {
            return new Chain(this);
        }

        public Label label() {
            return this.build().getLabel();
        }

        public Text text() {
            return this.build().getText();
        }

        public Combo combo() {
            return this.build().getCombo();
        }

        public Button button() {
            return this.build().getButton();
        }

        public org.eclipse.swt.widgets.List list() {
            return this.build().getList();
        }

        public Spinner spinner() {
            return this.build().getSpinner();
        }

        public Scale scale() {
            return this.build().getScale();
        }
    }
}

