/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.service.TextService;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;

public class Mess_ {
    public static Builder on(Shell shell) {
        return new Builder(shell);
    }

    public static final class Builder {
        private Shell shell_;
        private int style_ = 65570;
        private PrintStream printStream_ = System.out;
        private String title_ = TextService.getInstance().get("general.information");
        private List<String> messages_ = new ArrayList<String>();
        private Exception exception_;
        private Control control_;
        private TabItem tabItem_;

        public Builder(Shell shell) {
            this.shell_ = shell;
        }

        public Builder txt(String txt) {
            this.messages_.add(txt);
            return this;
        }

        public Builder key(String key) {
            return this.txt(TextService.getInstance().get(key));
        }

        public Builder key(String key, String param) {
            return this.txt(TextService.getInstance().get(key, param));
        }

        public Builder key(String key, Object[] objs) {
            return this.txt(TextService.getInstance().get(key, objs));
        }

        public Builder exception(Exception e) {
            this.exception_ = e;
            return this;
        }

        public Builder bind(Control control) {
            if (this.control_ == null) {
                this.control_ = control;
            }
            return this;
        }

        public Builder bind(Control control, TabItem tabItem) {
            if (this.control_ == null) {
                this.control_ = control;
                this.tabItem_ = tabItem;
            }
            return this;
        }

        public int display() {
            String msg = StringRelatedUtils.stringArrayToString(this.messages_.toArray(new String[this.messages_.size()]), "\n");
            if (StringUtils.isBlank((CharSequence)msg) && this.exception_ != null) {
                msg = msg + StringRelatedUtils.toString(this.exception_);
            }
            this.printStream_.println(this.title_ + ": " + msg);
            if (this.exception_ != null) {
                this.exception_.printStackTrace(this.printStream_);
            }
            if (this.shell_ != null) {
                MessageBox messageBox = new MessageBox(this.shell_, this.style_);
                messageBox.setText(this.title_);
                messageBox.setMessage(msg);
                return messageBox.open();
            }
            return 128;
        }

        public void warning() {
            this.style_ = 65576;
            this.title_ = TextService.getInstance().get("general.warning");
            this.printStream_ = System.err;
            this.display();
        }

        public void fatal() {
            this.style_ = 65569;
            this.title_ = TextService.getInstance().get("general.fatalerror");
            this.printStream_ = System.err;
            this.display();
        }

        public boolean confirm() {
            this.style_ = 65736;
            this.title_ = TextService.getInstance().get("general.confirmation");
            return this.display() == 64;
        }

        public boolean noErrors() {
            return this.messages_.isEmpty();
        }

        public boolean valid() {
            if (this.noErrors()) {
                return true;
            }
            this.display();
            if (this.tabItem_ != null) {
                this.tabItem_.getParent().setSelection(this.tabItem_);
            }
            this.control_.setFocus();
            return false;
        }
    }
}

