/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.sql.SQLException;
import java.util.List;
import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.repository.ProfileRepository;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class DeleteProfilesDialog
extends SizeControlledTabbedDialog<List<Profile>> {
    private final List<Profile> profilesToBeDeleted_;

    public DeleteProfilesDialog(Shell parent, List<Profile> profs) {
        super(parent, "profiledeletedialog");
        this.profilesToBeDeleted_ = profs;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.deleteprofiles.title", new Object[]{this.profilesToBeDeleted_.size()});
    }

    @Override
    protected void onShellCreated() {
        Composite composite = this.createTabWithComposite("dialog.deleteprofiles.options", 2);
        Chain.on(composite).lbl(l -> l.key("dialog.deleteprofiles.confirm.removedatabaseentry")).but(b -> b.select(true)).button().setEnabled(false);
        final Button deleteConfs = Chain.on(composite).lbl(l -> l.key("dialog.deleteprofiles.confirm.removeprofileconf")).but(b -> b.select(true)).button();
        final Button deleteMapperfiles = Chain.on(composite).lbl(l -> l.key("dialog.deleteprofiles.confirm.removemapperfile")).but(b -> b.select(true)).button();
        final Button deleteCaptures = Chain.on(composite).lbl(l -> l.key("dialog.deleteprofiles.confirm.removeprofilecaptures")).but(b -> b.select(true)).button();
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (Mess_.on(DeleteProfilesDialog.this.shell_).key("dialog.deleteprofiles.confirm.removal", new Object[]{DeleteProfilesDialog.this.profilesToBeDeleted_.size()}).confirm()) {
                    for (Profile prof : DeleteProfilesDialog.this.profilesToBeDeleted_) {
                        try {
                            new ProfileRepository().remove(prof, deleteConfs.getSelection(), deleteMapperfiles.getSelection(), deleteCaptures.getSelection());
                        }
                        catch (SQLException e) {
                            Mess_.on(DeleteProfilesDialog.this.shell_).exception(e).warning();
                        }
                    }
                    DeleteProfilesDialog.this.result_ = DeleteProfilesDialog.this.profilesToBeDeleted_;
                }
                DeleteProfilesDialog.this.shell_.close();
            }
        });
    }
}

