/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.abstractdialog.EditConfigurableDialog;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Label_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.dialog.SettingsDialog;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.entity.TemplateProfileBase;
import org.dbgl.model.entity.TitledEntity;
import org.dbgl.model.factory.TemplateFactory;
import org.dbgl.model.repository.DosboxVersionRepository;
import org.dbgl.model.repository.TemplateRepository;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditTemplateDialog
extends EditConfigurableDialog<Template> {
    private static final boolean multiEdit = false;
    private Text title_;
    private Template template_;
    private final boolean editing_;

    public EditTemplateDialog(Shell parent, Template template) {
        super(parent, "templatedialog");
        this.template_ = template;
        this.editing_ = this.template_ != null;
    }

    @Override
    protected String getDialogTitle() {
        return this.editing_ ? this.text_.get("dialog.template.title.edit", new Object[]{this.template_.getTitle(), this.template_.getId()}) : this.text_.get("dialog.template.title.add");
    }

    @Override
    protected boolean prepare() {
        if (!super.prepare()) {
            return false;
        }
        try {
            if (this.editing_) {
                this.dbversionIndex_ = DosboxVersionRepository.indexOf(this.dbversionsList_, this.template_.getDosboxVersion());
            } else {
                this.template_ = TemplateFactory.create((DosboxVersion)DosboxVersionRepository.findDefault(this.dbversionsList_));
            }
            String warningsLog = this.template_.resetAndLoadConfiguration();
            if (StringUtils.isNotBlank((CharSequence)warningsLog)) {
                Mess_.on(this.getParent()).txt(warningsLog).warning();
            }
            return true;
        }
        catch (IOException e) {
            Mess_.on(this.getParent()).exception(e).warning();
            return false;
        }
    }

    private void updateControlsByTemplate() {
        this.metaControls_.forEach(x -> x.setControlByTemplate(this.template_, false));
        this.updateControlsByConfigurable(this.template_, false);
    }

    private void updateTemplateByControls() {
        this.metaControls_.forEach(x -> x.updateTemplateByControl(this.template_));
        this.updateConfigurableByControls(this.template_);
    }

    @Override
    protected void doPerformDosboxConfAction(EditConfigurableDialog.DosboxConfAction action, DosboxVersion newDosboxVersion) {
        try {
            this.updateConfigurableByControls(this.template_);
            StringBuffer warningsLog = new StringBuffer(newDosboxVersion.resetAndLoadConfiguration());
            if (action == EditConfigurableDialog.DosboxConfAction.SET) {
                warningsLog.append(this.template_.setToDosboxVersion(newDosboxVersion));
            } else if (action == EditConfigurableDialog.DosboxConfAction.SWITCH) {
                warningsLog.append(this.template_.switchToDosboxVersion(newDosboxVersion));
            } else if (action == EditConfigurableDialog.DosboxConfAction.RELOAD) {
                warningsLog.append(this.template_.reloadDosboxVersion(newDosboxVersion));
            }
            this.updateControlsByConfigurable(this.template_, false);
            if (StringUtils.isNotEmpty((CharSequence)warningsLog)) {
                Mess_.on(this.getParent()).txt(warningsLog.toString()).warning();
            }
        }
        catch (IOException e) {
            Mess_.on(this.getParent()).exception(e).warning();
        }
    }

    @Override
    protected void onShellCreated() {
        this.createInfoTab();
        this.createGeneralTab(this.text_.get("dialog.profile.automatic"), this.editing_ ? this.template_.getConfigurationCanonicalFile().getPath() : SettingsDialog.confFilenames[0]);
        this.createDisplayTab();
        this.createMachineTab();
        this.createAudioTab();
        this.createIOTab();
        this.createCustomCommandsTab(this.template_, false);
        this.createMountingTab(this.template_, false);
        this.createOkCancelButtons();
        this.updateControlsByTemplate();
        if (!this.editing_) {
            this.title_.setFocus();
        }
    }

    protected void createInfoTab() {
        Composite composite = this.createTabWithComposite("dialog.template.tab.info", 2);
        this.title_ = Chain.on(composite).lbl(l -> l.key("dialog.template.title")).txt(t -> t).meta(this.metaControls_).template(TitledEntity::getTitle, TitledEntity::setTitle).text();
        Chain.on(composite).lbl(l -> l.key("dialog.template.default")).but(b -> b).meta(this.metaControls_).template(Template::getDefault, Template::setDefault).build();
    }

    @Override
    protected void createMountingTab(TemplateProfileBase configurable, boolean multiEdit) {
        super.createMountingTab(configurable, multiEdit);
        Composite booterComposite = (Composite)this.booterExpandItem_.getControl();
        booterComposite.setLayout((Layout)new GridLayout());
        Label_.on(booterComposite).key("dialog.profile.booterimage1").build();
        Composite dosComposite = (Composite)this.dosExpandItem_.getControl();
        dosComposite.setLayout((Layout)new GridLayout());
        Label_.on(dosComposite).key("dialog.profile.mainexe").build();
    }

    protected void createOkCancelButtons() {
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditTemplateDialog.this.isValid()) {
                    return;
                }
                try {
                    EditTemplateDialog.this.updateTemplateByControls();
                    if (EditTemplateDialog.this.editing_) {
                        new TemplateRepository().update(EditTemplateDialog.this.template_);
                        EditTemplateDialog.this.result_ = EditTemplateDialog.this.template_;
                    } else {
                        EditTemplateDialog.this.result_ = new TemplateRepository().add(EditTemplateDialog.this.template_);
                    }
                }
                catch (Exception e) {
                    Mess_.on(EditTemplateDialog.this.shell_).exception(e).warning();
                }
                EditTemplateDialog.this.shell_.close();
            }
        });
    }

    private boolean isValid() {
        Mess_.Builder mess = Mess_.on(this.shell_);
        if (StringUtils.isBlank((CharSequence)this.title_.getText())) {
            mess.key("dialog.template.required.title").bind((Control)this.title_, this.getTabItemByControl((Control)this.title_));
        }
        if (this.setButton_.isEnabled()) {
            mess.key("dialog.template.required.dosboxassociation").bind((Control)this.setButton_, this.getTabItemByControl((Control)this.setButton_));
        }
        return mess.valid();
    }
}

