/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.thread;

import SevenZip.Archive.IArchiveExtractCallback;
import SevenZip.Archive.IInArchive;
import SevenZip.Archive.SevenZip.Handler;
import SevenZip.IInStream;
import SevenZip.MyRandomAccessFile;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.thread.UIThread;
import org.dbgl.model.GamePack;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.entity.GamePackEntry;
import org.dbgl.model.repository.ProfileRepository;
import org.dbgl.service.SettingsService;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.archive.SevenzipExtractFilesCallback;
import org.dbgl.util.archive.SevenzipUtils;
import org.dbgl.util.archive.ZipUtils;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public class ImportThread
extends UIThread<GamePackEntry> {
    private GamePack gamePack_;
    private boolean useExistingConf_;
    private boolean importFullSettings_;
    private boolean customValues_;
    private boolean customFields_;
    private boolean sevenzip_;
    private IInArchive zArchive_;
    private Map<Integer, File> sevenzipDstFileMap_;

    public ImportThread(Text log, ProgressBar progressBar, Label status, GamePack packageData, boolean useExistingConf, boolean fullSettings, boolean customValues, boolean customFields) throws IOException, SQLException {
        super(log, progressBar, status, true);
        this.gamePack_ = packageData;
        this.useExistingConf_ = useExistingConf;
        this.importFullSettings_ = fullSettings;
        this.customValues_ = customValues;
        this.customFields_ = customFields;
        File[] zipfiles = (File[])this.gamePack_.getEntries().stream().map(x -> x.getGamePack().getArchive()).distinct().toArray(File[]::new);
        long bytes = 0L;
        for (File zipfile : zipfiles) {
            this.sevenzip_ = zipfile.getPath().toLowerCase().endsWith(FilesUtils.ARCHIVES[1]);
            this.sevenzipDstFileMap_ = new TreeMap<Integer, File>();
            if (this.sevenzip_) {
                MyRandomAccessFile istream = new MyRandomAccessFile(zipfile.getPath(), "r");
                this.zArchive_ = new Handler();
                if (this.zArchive_.Open((IInStream)istream) != 0) {
                    throw new IOException(text_.get("general.error.opensevenzip", new Object[]{zipfile.getPath()}));
                }
                for (int i = 0; i < this.zArchive_.size(); ++i) {
                    bytes += this.zArchive_.getEntry(i).getSize();
                }
                continue;
            }
            for (GamePackEntry entry : this.gamePack_.getEntries()) {
                if (this.gamePack_.isCapturesAvailable()) {
                    bytes += ZipUtils.extractedSizeInBytes(zipfile, entry.getArchiveCapturesDir());
                }
                if (this.gamePack_.isMapperfilesAvailable() && entry.hasMapper()) {
                    bytes += ZipUtils.extractedSizeInBytes(zipfile, entry.getArchiveMapper());
                }
                if (!this.gamePack_.isGamedataAvailable()) continue;
                bytes += ZipUtils.extractedSizeInBytes(zipfile, entry.getArchiveGameDir());
            }
        }
        this.setObjects(this.gamePack_.getEntries());
        this.setTotal(bytes);
    }

    @Override
    public String work(GamePackEntry entry) throws IOException, SQLException {
        this.displayTitle(text_.get("dialog.import.importing", new Object[]{this.getTitle(entry)}));
        Profile prof = entry.getProfile();
        if (!this.customValues_) {
            prof.resetAllCustomValues();
        }
        if (!entry.getGamePack().isNativecommandsAvailable()) {
            prof.resetNativeCommands();
        }
        prof.loadConfigurationData(text_, this.importFullSettings_ ? entry.getFullConfig() : entry.getIncrConfig(), entry.getGamePack().getArchive());
        if (entry.getGamePack().isMapperfilesAvailable() && entry.hasMapper()) {
            prof.setValue("sdl", "mapperfile", entry.getNewMapper().getName());
        }
        prof.setBaseDir(entry.getBaseDir());
        prof = new ProfileRepository().add(prof, this.useExistingConf_);
        if (entry.getGamePack().isCapturesAvailable()) {
            if (this.sevenzip_) {
                this.sevenzipDstFileMap_.putAll(SevenzipUtils.findEntries(this.zArchive_, entry.getArchiveCapturesDir(), prof.getCanonicalCaptures()));
            } else {
                try {
                    ZipUtils.extractDirInZip(entry.getGamePack().getArchive(), entry.getArchiveCapturesDir(), prof.getCanonicalCaptures(), this);
                    this.messageLog_.append("  + ").append(text_.get("dialog.import.notice.extractedcaptures", new Object[]{prof.getCanonicalCaptures()})).append('\n');
                }
                catch (IOException e) {
                    this.messageLog_.append("  - ").append(text_.get("dialog.import.error.capturesextraction", new Object[]{StringRelatedUtils.toString(e)})).append('\n');
                }
            }
        }
        if (entry.getGamePack().isGamedataAvailable()) {
            File canonicalFullDir = entry.getCanonicalFullDir();
            if (!canonicalFullDir.exists()) {
                FilesUtils.createDir(canonicalFullDir);
                this.messageLog_.append("  + ").append(text_.get("dialog.import.notice.createddir", new Object[]{canonicalFullDir})).append('\n');
            }
            if (this.sevenzip_) {
                this.sevenzipDstFileMap_.putAll(SevenzipUtils.findEntries(this.zArchive_, entry.getArchiveGameDir(), canonicalFullDir));
            } else {
                try {
                    ZipUtils.extractDirInZip(entry.getGamePack().getArchive(), entry.getArchiveGameDir(), canonicalFullDir, this);
                    this.messageLog_.append("  + ").append(text_.get("dialog.import.notice.extractedgamedata", new Object[]{canonicalFullDir})).append('\n');
                }
                catch (IOException e) {
                    throw new IOException(text_.get("dialog.import.error.gamedataextraction", new Object[]{StringRelatedUtils.toString(e)}), e);
                }
            }
        }
        if (entry.getGamePack().isMapperfilesAvailable() && entry.hasMapper()) {
            File dstFile = entry.getNewMapper();
            if (this.sevenzip_) {
                Map.Entry<Integer, File> szEntry = SevenzipUtils.findEntry(this.zArchive_, entry.getArchiveMapper(), dstFile);
                if (szEntry != null) {
                    this.sevenzipDstFileMap_.put(szEntry.getKey(), szEntry.getValue());
                }
            } else {
                try {
                    ZipUtils.extractFileInZip(entry.getGamePack().getArchive(), entry.getArchiveMapper(), dstFile, this);
                    this.messageLog_.append("  + ").append(text_.get("dialog.import.notice.extractedmapperfile", new Object[]{dstFile})).append('\n');
                }
                catch (IOException e) {
                    this.messageLog_.append("  - ").append(text_.get("dialog.import.error.mapperfileextraction", new Object[]{StringRelatedUtils.toString(e)})).append('\n');
                }
            }
        }
        this.messageLog_.append("  + ").append(text_.get("dialog.import.notice.createddbentry", new Object[]{prof.getId(), prof.getConfigurationFile(), prof.getCapturesString(), prof.getDosboxVersion().getTitle()})).append('\n');
        return null;
    }

    @Override
    public String getTitle(GamePackEntry entry) {
        return entry.getProfile().getTitle();
    }

    @Override
    public void preFinish() throws IOException {
        if (this.customFields_) {
            for (int i = 0; i < 14; ++i) {
                String customField = this.gamePack_.getCustomFieldTitles()[i];
                if (!StringUtils.isNotBlank((CharSequence)customField) || customField.equalsIgnoreCase("Custom" + (i + 1))) continue;
                SettingsService.getInstance().setValue("gui", "custom" + (i + 1), customField);
            }
        }
        if (this.sevenzip_) {
            int[] entryIdsToBeExtracted_ = ArrayUtils.toPrimitive((Integer[])this.sevenzipDstFileMap_.keySet().toArray(new Integer[0]));
            SevenzipExtractFilesCallback extractCallback = new SevenzipExtractFilesCallback(this, this.zArchive_, this.sevenzipDstFileMap_);
            this.zArchive_.Extract(entryIdsToBeExtracted_, entryIdsToBeExtracted_.length, 0, (IArchiveExtractCallback)extractCallback);
            IntStream.of(entryIdsToBeExtracted_).forEach(id -> FilesUtils.setLastModified(this.sevenzipDstFileMap_.get(id), this.zArchive_.getEntry(id).getTime()));
            this.zArchive_.close();
        }
    }
}

