/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MixerCommand {
    public static final String[] CHANNELS = new String[]{"master", "spkr", "sb", "gus", "fm", "disney", "cdaudio"};
    public static final int DEFAULT_VOLUME_LEVEL = 100;
    public static final int MAX_VOLUME_LEVEL = 200;
    private List<ChannelVolume> volumes_ = new ArrayList<ChannelVolume>();

    public MixerCommand(String command) {
        for (String channel : CHANNELS) {
            this.volumes_.add(new ChannelVolume(channel));
        }
        String[] elements = StringUtils.split((String)command, (char)' ');
        for (int i = 0; i < elements.length; i += 2) {
            for (ChannelVolume vol : this.volumes_) {
                if (!elements[i].equalsIgnoreCase(vol.name_) || i + 1 >= elements.length) continue;
                vol.setVolume(elements[i + 1]);
            }
        }
    }

    public ChannelVolume getVolumeFor(String channel) {
        for (ChannelVolume vol : this.volumes_) {
            if (!channel.equalsIgnoreCase(vol.name_)) continue;
            return vol;
        }
        return null;
    }

    public void setVolumeFor(String channel, int left, int right) {
        for (ChannelVolume vol : this.volumes_) {
            if (!channel.equalsIgnoreCase(vol.name_)) continue;
            vol.setVolume(left, right);
        }
    }

    public String toString() {
        return StringUtils.join(this.volumes_, (char)' ').trim().replaceAll("\\s+", " ");
    }

    public static class ChannelVolume {
        private String name_;
        private int left_;
        private int right_;

        public ChannelVolume(String name) {
            this.name_ = name;
            this.left_ = 100;
            this.right_ = 100;
        }

        public void setVolume(String command) {
            try {
                String[] vols = StringUtils.split((String)command, (char)':');
                if (vols.length == 2) {
                    this.setVolume(Integer.parseInt(vols[0]), Integer.parseInt(vols[1]));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private void setVolume(int left, int right) {
            this.left_ = left;
            this.right_ = right;
        }

        public int getLeft() {
            return this.left_;
        }

        public int getRight() {
            return this.right_;
        }

        public String toString() {
            return this.left_ != 100 || this.right_ != 100 ? new StringBuffer(this.name_).append(' ').append(this.left_).append(':').append(this.right_).toString() : "";
        }
    }
}

