/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.dbgl.model.conf.Autoexec;
import org.dbgl.model.conf.SectionsCollection;
import org.dbgl.model.conf.Settings;
import org.dbgl.model.conf.mount.Mount;
import org.dbgl.service.ITextService;

public class Configuration
extends Settings {
    private static final String AUTOEXEC_SECTION_NAME = "autoexec";
    private Autoexec autoexec_ = new Autoexec();

    public Configuration() {
    }

    public Configuration(Configuration configuration) {
        this();
        this.sections_ = new SectionsCollection(configuration.getSections());
        this.autoexec_ = new Autoexec(configuration.getAutoexec());
    }

    public Autoexec getAutoexec() {
        return this.autoexec_;
    }

    public void setAutoexec(Autoexec autoexec) {
        this.autoexec_ = autoexec;
    }

    public String reloadWithAutoexec(ITextService text, List<Mount> dbMounts) throws IOException {
        return this.reloadWithAutoexec(text, dbMounts, null);
    }

    public String reloadWithAutoexec(ITextService text, List<Mount> dbMounts, File cwd) throws IOException {
        this.sections_ = new SectionsCollection();
        this.autoexec_ = new Autoexec();
        return this.loadWithAutoexec(text, dbMounts, cwd);
    }

    public String loadWithAutoexec(ITextService text, List<Mount> dbMounts, File cwd) throws IOException {
        File file = this.fileLocation_.getCanonicalFile();
        if (file == null || !file.isFile() || !file.canRead()) {
            throw new IOException(text.get("general.error.openfile", new Object[]{String.valueOf(file)}));
        }
        try (FileReader reader = new FileReader(file);){
            String string = this.loadDataWithAutoexec(text, reader, file, dbMounts, cwd);
            return string;
        }
    }

    public String loadDataWithAutoexec(ITextService text, String data, File file, List<Mount> dbMounts) throws IOException {
        return this.loadDataWithAutoexec(text, data, file, dbMounts, null);
    }

    public String loadDataWithAutoexec(ITextService text, String data, File file, List<Mount> dbMounts, File cwd) throws IOException {
        try (StringReader reader = new StringReader(data);){
            String string = this.loadDataWithAutoexec(text, reader, file, dbMounts, cwd);
            return string;
        }
    }

    private String loadDataWithAutoexec(ITextService text, Reader reader, File file, List<Mount> dbMounts, File cwd) throws IOException {
        StringBuffer warningsLog = new StringBuffer();
        ArrayList<String> autoexecLines = new ArrayList<String>();
        warningsLog.append(this.loadData(text, reader, file, AUTOEXEC_SECTION_NAME, autoexecLines));
        if (autoexecLines.size() > 0) {
            warningsLog.append(this.autoexec_.load(autoexecLines, dbMounts, cwd));
        }
        return warningsLog.toString();
    }

    public void save(boolean prepareOnly, List<Mount> combinedMountingPoints) throws IOException {
        File file = this.fileLocation_.getCanonicalFile();
        FileUtils.forceMkdirParent((File)file);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            this.writeData(writer, prepareOnly, combinedMountingPoints);
        }
    }

    private void writeData(BufferedWriter writer, boolean prepareOnly, List<Mount> combinedMountingPoints) throws IOException {
        writer.write(this.sections_.toString());
        writer.write(this.autoexec_.toString(prepareOnly, combinedMountingPoints));
    }

    public void removeUnequalValuesIn(Configuration configuration) {
        super.removeUnequalValuesIn(configuration);
        this.autoexec_.removeUnequalValuesIn(configuration.autoexec_);
    }

    public void removeUnnecessaryMounts(Configuration configuration) {
        this.autoexec_.removeUnnecessaryMounts(configuration.autoexec_);
    }

    public String toString(List<Mount> combinedMountingPoints) {
        StringWriter result = new StringWriter();
        try (BufferedWriter writer = new BufferedWriter(result);){
            this.writeData(writer, false, combinedMountingPoints);
        }
        catch (IOException e) {
            new RuntimeException(e);
        }
        return result.toString();
    }
}

