/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf;

import org.dbgl.model.conf.Configuration;

public class GenerationAwareConfiguration
extends Configuration {
    public Generation getGeneration() {
        if (this.isDosboxVersion073OrAbove()) {
            return Generation.Gen_073;
        }
        if (this.isDosboxVersion070_071_072()) {
            return Generation.Gen_070;
        }
        if (this.isDosboxVersion065()) {
            return Generation.Gen_065;
        }
        if (this.isDosboxVersion063()) {
            return Generation.Gen_063;
        }
        return null;
    }

    public boolean isDosboxVersion073OrAbove() {
        return this.hasValue("cpu", "cputype") && this.hasValue("midi", "mididevice") && this.hasValue("midi", "midiconfig") && this.hasValue("sblaster", "sbmixer") && this.hasValue("sblaster", "oplemu") && this.hasValue("gus", "gusirq") && this.hasValue("gus", "gusdma");
    }

    public boolean isDosboxVersion070_071_072() {
        return this.hasValue("joystick", "joysticktype") && this.hasValue("joystick", "timed") && this.hasValue("joystick", "autofire") && this.hasValue("joystick", "swap34") && this.hasValue("joystick", "buttonwrap") && this.hasValue("dos", "keyboardlayout");
    }

    public boolean isDosboxVersion065() {
        return this.hasValue("sdl", "windowresolution") && this.hasValue("sdl", "usescancodes") && this.hasValue("sblaster", "sbtype") && this.hasValue("sblaster", "sbbase") && this.hasValue("gus", "gusrate") && this.hasValue("gus", "gusbase") && this.hasValue("speaker", "tandy") && this.hasValue("bios", "joysticktype") && this.hasValue("serial", "serial1") && this.hasValue("dos", "umb");
    }

    public boolean isDosboxVersion063() {
        return this.hasValue("sdl", "fullfixed") && this.hasValue("sdl", "hwscale") && this.hasValue("midi", "intelligent") && this.hasValue("sblaster", "type") && this.hasValue("sblaster", "base") && this.hasValue("gus", "rate") && this.hasValue("gus", "base") && this.hasValue("modem", "modem") && this.hasValue("modem", "comport") && this.hasValue("modem", "listenport") && this.hasValue("directserial", "directserial");
    }

    public void downgradeOneGeneration(Generation generation) {
        switch (generation) {
            case Gen_073: {
                String mach;
                this.switchSetting("gus", "gusirq", "gus", "irq1");
                if (this.hasValue("gus", "irq1")) {
                    this.setValue("gus", "irq2", this.getValue("gus", "irq1"));
                }
                this.switchSetting("gus", "gusdma", "gus", "dma1");
                if (this.hasValue("gus", "dma1")) {
                    this.setValue("gus", "dma2", this.getValue("gus", "dma1"));
                }
                if (!(!this.hasValue("dosbox", "machine") || (mach = this.getValue("dosbox", "machine")).equalsIgnoreCase("cga") || mach.equalsIgnoreCase("hercules") || mach.equalsIgnoreCase("pcjr") || mach.equalsIgnoreCase("tandy"))) {
                    this.removeValue("dosbox", "machine");
                }
                if (this.hasValue("dos", "keyboardlayout") && this.getValue("dos", "keyboardlayout").equalsIgnoreCase("auto")) {
                    this.removeValue("dos", "keyboardlayout");
                }
                this.switchSetting("midi", "mididevice", "midi", "device");
                this.switchSetting("midi", "midiconfig", "midi", "config");
                this.switchSetting("sblaster", "sbmixer", "sblaster", "mixer");
                break;
            }
            case Gen_070: {
                this.switchSetting("joystick", "joysticktype", "bios", "joysticktype");
                break;
            }
            case Gen_065: {
                if (this.hasValue("midi", "mpu401")) {
                    String mpu = this.getValue("midi", "mpu401");
                    this.setValue("midi", "mpu401", !mpu.equalsIgnoreCase("none"));
                    this.setValue("midi", "intelligent", mpu.equalsIgnoreCase("intelligent"));
                }
                this.switchSetting("sblaster", "sbtype", "sblaster", "type");
                this.switchSetting("sblaster", "sbbase", "sblaster", "base");
                this.switchSetting("gus", "gusrate", "gus", "rate");
                this.switchSetting("gus", "gusbase", "gus", "base");
                break;
            }
            default: {
                throw new RuntimeException("Cannot downgrade below generation Gen_063");
            }
        }
    }

    public void upgradeOneGeneration(Generation generation) {
        switch (generation) {
            case Gen_063: {
                boolean intelli;
                boolean mpu = !this.hasValue("midi", "mpu401") || this.getBooleanValue("midi", "mpu401");
                boolean bl = intelli = !this.hasValue("midi", "intelligent") || this.getBooleanValue("midi", "intelligent");
                this.setValue("midi", "mpu401", mpu ? (intelli ? "intelligent" : "uart") : "none");
                this.removeValue("midi", "intelligent");
                this.switchSetting("sblaster", "type", "sblaster", "sbtype");
                this.switchSetting("sblaster", "base", "sblaster", "sbbase");
                this.switchSetting("gus", "rate", "gus", "gusrate");
                this.switchSetting("gus", "base", "gus", "gusbase");
                break;
            }
            case Gen_065: {
                this.switchSetting("bios", "joysticktype", "joystick", "joysticktype");
                break;
            }
            case Gen_070: {
                this.switchSetting("gus", "irq1", "gus", "gusirq");
                if (this.hasValue("gus", "irq2")) {
                    this.removeValue("gus", "irq2");
                }
                this.switchSetting("gus", "dma1", "gus", "gusdma");
                if (this.hasValue("gus", "dma2")) {
                    this.removeValue("gus", "dma2");
                }
                if (this.hasValue("dosbox", "machine") && this.getValue("dosbox", "machine").equalsIgnoreCase("vga")) {
                    this.removeValue("dosbox", "machine");
                }
                if (this.hasValue("dos", "keyboardlayout") && this.getValue("dos", "keyboardlayout").equalsIgnoreCase("none")) {
                    this.removeValue("dos", "keyboardlayout");
                }
                this.switchSetting("midi", "device", "midi", "mididevice");
                this.switchSetting("midi", "config", "midi", "midiconfig");
                this.switchSetting("sblaster", "mixer", "sblaster", "sbmixer");
                break;
            }
            default: {
                throw new RuntimeException("Cannot upgrade above generation Gen_073");
            }
        }
    }

    public boolean isUsingOldStyleMPU401() {
        return this.hasValue("midi", "intelligent");
    }

    public boolean isUsingOldStyleMidiConfig() {
        return this.hasValue("midi", "config");
    }

    public boolean isUsingOldStyleSoundblasterType() {
        return this.hasValue("sblaster", "type");
    }

    public boolean isUsingOldStyleSoundblasterBase() {
        return this.hasValue("sblaster", "base");
    }

    public boolean isUsingOldStyleSoundblasterMixer() {
        return this.hasValue("sblaster", "mixer");
    }

    public boolean isUsingOldStyleGusRate() {
        return this.hasValue("gus", "rate");
    }

    public boolean isUsingOldStyleGusBase() {
        return this.hasValue("gus", "base");
    }

    public boolean isUsingOldStyleGusIrq() {
        return this.hasValue("gus", "gusirq");
    }

    public boolean isUsingOldStyleGusDma() {
        return this.hasValue("gus", "gusdma");
    }

    public boolean isUsingOldStyleJoystickType() {
        return this.hasValue("bios", "joysticktype");
    }

    public boolean isUsingOldStyleGlidePort() {
        return this.hasValue("glide", "port");
    }

    public boolean hasPixelshaderSupport() {
        return this.hasValue("sdl", "pixelshader");
    }

    public boolean hasPS1AudioSupport() {
        return this.hasValue("speaker", "ps1audio");
    }

    public boolean hasMT32Support() {
        return this.hasValue("midi", "mt32.dac");
    }

    public boolean hasSoundBlasterGoldplaySupport() {
        return this.hasValue("sblaster", "goldplay");
    }

    public boolean hasHardwareOPLSupport() {
        return this.hasValue("sblaster", "hardwarebase");
    }

    public boolean hasParallelDongleSupport() {
        return this.hasValue("parallel", "dongle");
    }

    public static enum Generation {
        Gen_063,
        Gen_065,
        Gen_070,
        Gen_073;

    }
}

