/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.factory;

import java.io.File;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.exception.DrivelettersExhaustedException;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.model.FileLocation;
import org.dbgl.model.conf.mount.DirMount;
import org.dbgl.model.conf.mount.ImageMount;
import org.dbgl.model.conf.mount.Mount;
import org.dbgl.model.conf.mount.PhysFsMount;
import org.dbgl.model.helper.DriveLetterHelper;
import org.dbgl.service.FileLocationService;
import org.dbgl.util.FilesUtils;

public class MountFactory {
    private static final Pattern MOUNT_PATRN = Pattern.compile("^(?:mount)(?:(?:\\s+-u\\s+([a-y]))|(?:(?:\\s+([a-y]))(?:\\s+((?:\\S+)|(?:\"[^\"]+\")))(?:(?:(?:\\s+-t\\s+(dir|floppy|cdrom|iso))|(?:\\s+-label (\\S+))|(?:\\s+-(ioctl(?:_dx|_dio|_mci)?|noioctl|aspi))|(?:\\s+-freesize\\s+(\\d+))|(?:\\s+-usecd\\s+(\\d+))|(?:\\s+-size\\s+(\\d+,\\d+,\\d+,\\d+))){0,6})))\\s*$", 2);
    private static final Pattern IMGMOUNT_PATRN = Pattern.compile("^(?:imgmount)(?:\\s+([a-y0-3]))((?:\\s+(?:(?:[^-][^\\s]+)|(?:\"[^\"]+\"))\\s*)+)(?:(?:(?:\\s+-t\\s+(hdd|floppy|cdrom|iso))|(?:\\s+-fs\\s+(fat|iso|none))|(?:\\s+-size\\s+(\\d+,\\d+,\\d+,\\d+))){0,3})\\s*$", 2);

    public static Mount create(String mount) throws InvalidMountstringException {
        Matcher mountMatcher = MOUNT_PATRN.matcher(mount);
        Matcher imgmountMatcher = IMGMOUNT_PATRN.matcher(mount);
        if (mountMatcher.matches()) {
            if (mountMatcher.group(1) != null) {
                Mount mnt = new Mount();
                mnt.setDrive(Character.toUpperCase(mountMatcher.group(1).charAt(0)));
                mnt.setUnmounted(true);
                return mnt;
            }
            String drive = mountMatcher.group(2);
            String mountLocation = StringUtils.strip((String)FilesUtils.toNativePath(mountMatcher.group(3)), (String)"\"");
            String mountAs = mountMatcher.group(4);
            String label = mountMatcher.group(5);
            String lowlevelCD = mountMatcher.group(6);
            String freesize = mountMatcher.group(7);
            String useCD = mountMatcher.group(8);
            if (FilesUtils.isPhysFS(mountLocation)) {
                String write;
                String path;
                int colonIndex2;
                int colonIndex1 = mountLocation.indexOf(58);
                if (colonIndex1 == 1) {
                    colonIndex1 = mountLocation.indexOf(":", colonIndex1 + 1);
                }
                if (colonIndex1 == (colonIndex2 = mountLocation.lastIndexOf(":"))) {
                    path = mountLocation.substring(0, colonIndex2);
                    write = null;
                } else {
                    path = mountLocation.substring(colonIndex1 + 1, colonIndex2);
                    write = mountLocation.substring(0, colonIndex1);
                }
                return MountFactory.createPhysFsMount(drive, path, write, mountAs, label);
            }
            return MountFactory.createDirMount(drive, mountLocation, mountAs, label, lowlevelCD, freesize, useCD);
        }
        if (imgmountMatcher.matches()) {
            String drive = imgmountMatcher.group(1);
            String[] paths = StringUtils.stripAll((String[])FilesUtils.toNativePath(imgmountMatcher.group(2)).trim().split("\\s(?=([^\"]*\"[^\"]*\")*[^\"]*$)"), (String)"\"");
            String mountAs = imgmountMatcher.group(3);
            String fs = imgmountMatcher.group(4);
            String size = imgmountMatcher.group(5);
            return MountFactory.createImageMount(drive, paths, mountAs, fs, size);
        }
        throw new InvalidMountstringException();
    }

    public static DirMount createDefaultNewMount(char driveletter) {
        DirMount mnt = new DirMount();
        mnt.setDrive(Character.toUpperCase(driveletter));
        mnt.setPath(".");
        if (mnt.getDrive() == 'A' || mnt.getDrive() == 'B') {
            mnt.setMountAs("floppy");
        }
        return mnt;
    }

    public static DirMount createDirMount(String drive, String path, String mountAs, String label, String lowlevelCD, String freesize, String useCD) {
        DirMount mnt = new DirMount();
        mnt.setDrive(Character.toUpperCase(drive.charAt(0)));
        mnt.setPath(path);
        mnt.setMountAs(StringUtils.defaultString((String)mountAs));
        mnt.setLabel(StringUtils.defaultString((String)label));
        mnt.setLowlevelCD(StringUtils.defaultString((String)lowlevelCD));
        mnt.setFreesize(StringUtils.defaultString((String)freesize));
        mnt.setUseCD(StringUtils.defaultString((String)useCD));
        return mnt;
    }

    public static PhysFsMount createPhysFsMount(String drive, String path, String write, String mountAs, String label) {
        PhysFsMount mnt = new PhysFsMount();
        mnt.setDrive(Character.toUpperCase(drive.charAt(0)));
        mnt.setPath(path);
        mnt.setWrite(write);
        mnt.setMountAs(StringUtils.defaultString((String)mountAs));
        mnt.setLabel(StringUtils.defaultString((String)label));
        return mnt;
    }

    public static ImageMount createImageMount(String drive, String[] paths, String mountAs, String fs, String size) {
        ImageMount mnt = new ImageMount();
        mnt.setDrive(Character.toUpperCase(drive.charAt(0)));
        mnt.setImgPaths(paths);
        mnt.setMountAs(StringUtils.defaultString((String)mountAs));
        mnt.setFs(StringUtils.defaultString((String)fs));
        mnt.setSize(StringUtils.defaultString((String)size));
        return mnt;
    }

    public static Mount createUnmount(Mount mount) {
        return MountFactory.createUnmount(mount.getDrive());
    }

    public static Mount createUnmount(char drive) {
        Mount mnt = new Mount();
        mnt.setDrive(drive);
        mnt.setUnmounted(true);
        return mnt;
    }

    public static Mount createCopy(Mount mount) throws InvalidMountstringException {
        return MountFactory.create(mount.toString());
    }

    public static Mount create(boolean booter, String hostFile, Set<Character> usedDriveLetters) throws DrivelettersExhaustedException, InvalidMountstringException {
        char driveLetter = DriveLetterHelper.getFirstAvailable(booter, usedDriveLetters);
        if (FilesUtils.physFsIndex(hostFile) != -1) {
            return MountFactory.create("mount " + driveLetter + " \"" + hostFile.substring(0, FilesUtils.physFsIndex(hostFile)) + ":\\\"");
        }
        if (FilesUtils.cdImageIndex(hostFile) != -1) {
            return MountFactory.create("imgmount " + driveLetter + " \"" + hostFile.substring(0, FilesUtils.cdImageIndex(hostFile)) + "\" -t cdrom");
        }
        if (FilesUtils.fatImageIndex(hostFile) != -1) {
            driveLetter = DriveLetterHelper.getFirstAvailable(true, usedDriveLetters);
            return MountFactory.create("imgmount " + driveLetter + " \"" + hostFile.substring(0, FilesUtils.fatImageIndex(hostFile)) + "\" -t floppy");
        }
        File file = new FileLocation(hostFile, FileLocationService.getInstance().dosrootRelative()).getFile();
        File dir = file.getParentFile();
        if (dir == null) {
            dir = new File(".");
        }
        if (FilesUtils.isStoredOnFloppyDrive(file)) {
            return MountFactory.create("mount " + driveLetter + " \"" + dir + "\" -t floppy");
        }
        if (FilesUtils.isStoredOnCDRomDrive(file)) {
            return MountFactory.create("mount " + driveLetter + " \"" + dir + "\" -t cdrom");
        }
        return MountFactory.create("mount " + driveLetter + " \"" + dir + "\"");
    }

    public static Mount create(boolean booter, String hostFile, Set<Character> usedDriveLetters, File[] overrideFilesToMount) throws DrivelettersExhaustedException, InvalidMountstringException {
        Mount mount = MountFactory.create(booter, hostFile, usedDriveLetters);
        if (mount instanceof ImageMount) {
            ((ImageMount)mount).setImgPaths(FilesUtils.listFilePaths(Arrays.asList(overrideFilesToMount)));
        }
        return mount;
    }
}

