/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.repository;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.model.entity.ITitledEntity;
import org.dbgl.model.entity.TitledEntity;
import org.dbgl.model.repository.BaseRepository;
import org.dbgl.service.DatabaseService;
import org.dbgl.service.TextService;

public class TitledEntityRepository
extends BaseRepository<ITitledEntity> {
    private static final String CREATE_DEVELOPER_QRY = "INSERT INTO DEVELOPERS(NAME) VALUES (?)";
    private static final String CREATE_PUBLISHER_QRY = "INSERT INTO PUBLISHERS(NAME) VALUES (?)";
    private static final String CREATE_GENRE_QRY = "INSERT INTO GENRES(NAME) VALUES (?)";
    private static final String CREATE_YEAR_QRY = "INSERT INTO PUBLYEARS(YEAR) VALUES (?)";
    private static final String CREATE_STATUS_QRY = "INSERT INTO STATUS(STAT) VALUES (?)";
    private static final String[] CREATE_CUSTOM_QRY = new String[]{"INSERT INTO CUSTOM1(VALUE) VALUES (?)", "INSERT INTO CUSTOM2(VALUE) VALUES (?)", "INSERT INTO CUSTOM3(VALUE) VALUES (?)", "INSERT INTO CUSTOM4(VALUE) VALUES (?)"};
    private static final String DEVELOPER_LIST_QRY = "SELECT ID, NAME FROM DEVELOPERS ORDER BY NAME";
    private static final String PUBLISHER_LIST_QRY = "SELECT ID, NAME FROM PUBLISHERS ORDER BY NAME";
    private static final String GENRE_LIST_QRY = "SELECT ID, NAME FROM GENRES ORDER BY NAME";
    private static final String PUBLYEAR_LIST_QRY = "SELECT ID, YEAR FROM PUBLYEARS ORDER BY YEAR";
    private static final String STATUS_LIST_QRY = "SELECT ID, STAT FROM STATUS ORDER BY STAT";
    private static final String[] CUSTOM_LIST_QRY = new String[]{"SELECT ID, VALUE FROM CUSTOM1 ORDER BY VALUE", "SELECT ID, VALUE FROM CUSTOM2 ORDER BY VALUE", "SELECT ID, VALUE FROM CUSTOM3 ORDER BY VALUE", "SELECT ID, VALUE FROM CUSTOM4 ORDER BY VALUE"};
    private static final String CLEANUP_QRY = "DELETE FROM DEVELOPERS WHERE ID NOT IN (SELECT DISTINCT DEV_ID FROM GAMES);DELETE FROM PUBLISHERS WHERE ID NOT IN (SELECT DISTINCT PUBL_ID FROM GAMES); DELETE FROM GENRES WHERE ID NOT IN (SELECT DISTINCT GENRE_ID FROM GAMES);DELETE FROM PUBLYEARS WHERE ID NOT IN (SELECT DISTINCT YEAR_ID FROM GAMES); DELETE FROM STATUS WHERE ID NOT IN (SELECT DISTINCT STAT_ID FROM GAMES);DELETE FROM CUSTOM1 WHERE ID NOT IN (SELECT DISTINCT CUST1_ID FROM GAMES); DELETE FROM CUSTOM2 WHERE ID NOT IN (SELECT DISTINCT CUST2_ID FROM GAMES);DELETE FROM CUSTOM3 WHERE ID NOT IN (SELECT DISTINCT CUST3_ID FROM GAMES); DELETE FROM CUSTOM4 WHERE ID NOT IN (SELECT DISTINCT CUST4_ID FROM GAMES)";

    public List<ITitledEntity> listDevelopers(DatabaseService.Transaction transaction) throws SQLException {
        return this.listAll(DEVELOPER_LIST_QRY, transaction);
    }

    public List<ITitledEntity> listPublishers(DatabaseService.Transaction transaction) throws SQLException {
        return this.listAll(PUBLISHER_LIST_QRY, transaction);
    }

    public List<ITitledEntity> listGenres(DatabaseService.Transaction transaction) throws SQLException {
        return this.listAll(GENRE_LIST_QRY, transaction);
    }

    public List<ITitledEntity> listYears(DatabaseService.Transaction transaction) throws SQLException {
        return this.listAll(PUBLYEAR_LIST_QRY, transaction);
    }

    public List<ITitledEntity> listStatus(DatabaseService.Transaction transaction) throws SQLException {
        return this.listAll(STATUS_LIST_QRY, transaction);
    }

    public List<ITitledEntity> listCustomValues(int index, DatabaseService.Transaction transaction) throws SQLException {
        return this.listAll(CUSTOM_LIST_QRY[index], transaction);
    }

    public int findDeveloper(String developer, DatabaseService.Transaction transaction) throws SQLException {
        return TitledEntityRepository.findIdByValue(this.listDevelopers(transaction), developer);
    }

    public int findPublisher(String publisher, DatabaseService.Transaction transaction) throws SQLException {
        return TitledEntityRepository.findIdByValue(this.listPublishers(transaction), publisher);
    }

    public int findGenre(String genre, DatabaseService.Transaction transaction) throws SQLException {
        return TitledEntityRepository.findIdByValue(this.listGenres(transaction), genre);
    }

    public int findYear(String year, DatabaseService.Transaction transaction) throws SQLException {
        return TitledEntityRepository.findIdByValue(this.listYears(transaction), year);
    }

    public int findStatus(String status, DatabaseService.Transaction transaction) throws SQLException {
        return TitledEntityRepository.findIdByValue(this.listStatus(transaction), status);
    }

    public int findCustomValue(int index, String value, DatabaseService.Transaction transaction) throws SQLException {
        return TitledEntityRepository.findIdByValue(this.listCustomValues(index, transaction), value);
    }

    public int addDeveloper(DatabaseService.Transaction transaction, String developer) throws SQLException {
        return this.addValue(transaction, CREATE_DEVELOPER_QRY, developer);
    }

    public int addPublisher(DatabaseService.Transaction transaction, String publisher) throws SQLException {
        return this.addValue(transaction, CREATE_PUBLISHER_QRY, publisher);
    }

    public int addGenre(DatabaseService.Transaction transaction, String genre) throws SQLException {
        return this.addValue(transaction, CREATE_GENRE_QRY, genre);
    }

    public int addYear(DatabaseService.Transaction transaction, String year) throws SQLException {
        return this.addValue(transaction, CREATE_YEAR_QRY, year);
    }

    public int addStatus(DatabaseService.Transaction transaction, String status) throws SQLException {
        return this.addValue(transaction, CREATE_STATUS_QRY, status);
    }

    public int addCustomValue(DatabaseService.Transaction transaction, int index, String value) throws SQLException {
        return this.addValue(transaction, CREATE_CUSTOM_QRY[index], value);
    }

    /*
     * Exception decompiling
     */
    private List<ITitledEntity> listAll(String query, DatabaseService.Transaction transaction) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<ITitledEntity> listAll_(String query, Statement stmt) throws SQLException {
        try (ResultSet resultset = stmt.executeQuery(query);){
            ArrayList<ITitledEntity> customList = new ArrayList<ITitledEntity>();
            while (resultset.next()) {
                customList.add(new TitledEntity(resultset.getInt(1), resultset.getString(2)));
            }
            ArrayList<ITitledEntity> arrayList = customList;
            return arrayList;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int addValue(DatabaseService.Transaction transaction, String query, String value) throws SQLException {
        try (PreparedStatement stmt = transaction.prepareStatement(query);){
            stmt.setString(1, value);
            stmt.executeUpdate();
            int n = this.identity(transaction);
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(TextService.getInstance().get("database.error.query", new Object[]{"add " + value}));
        }
    }

    /*
     * Exception decompiling
     */
    public int cleanup() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int findIdByValue(List<ITitledEntity> list, String value) {
        return list.stream().filter(x -> x.getTitle().equals(value)).findFirst().map(x -> x.getId()).orElse(-1);
    }
}

