/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.service;

import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.dbgl.service.CustomEncodingResourceControl;
import org.dbgl.service.ITextService;
import org.dbgl.util.StringRelatedUtils;

public abstract class TextServiceBase
implements ITextService {
    protected static Locale locale_;
    protected static ResourceBundle mes_;

    protected TextServiceBase(Locale locale) {
        locale_ = locale;
        CustomEncodingResourceControl utf8Control = new CustomEncodingResourceControl(StandardCharsets.UTF_8.name());
        try {
            mes_ = ResourceBundle.getBundle("plugins/i18n/MessagesBundle", locale, utf8Control);
        }
        catch (MissingResourceException me) {
            mes_ = ResourceBundle.getBundle("i18n/MessagesBundle", locale, utf8Control);
        }
    }

    @Override
    public String get(String key) {
        try {
            return mes_.getString(key);
        }
        catch (MissingResourceException me) {
            return "[" + key + "]";
        }
    }

    @Override
    public String get(String key, String param) {
        return this.get(key, new Object[]{param});
    }

    @Override
    public String get(String key, Object[] objs) {
        try {
            return new MessageFormat(mes_.getString(key), locale_).format(objs);
        }
        catch (IllegalArgumentException | MissingResourceException e) {
            return StringRelatedUtils.toString(e) + "[" + this.get(key) + "]";
        }
    }

    @Override
    public String toString(boolean yesno) {
        return yesno ? this.get("general.yes") : this.get("general.no");
    }

    @Override
    public String toString(Date date) {
        if (date == null) {
            return "-";
        }
        return DateFormat.getDateInstance(3, locale_).format(date);
    }

    @Override
    public String toString(Date date, int timeStyle) {
        if (date == null) {
            return "-";
        }
        return DateFormat.getDateTimeInstance(3, timeStyle, locale_).format(date);
    }
}

