/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.searchengine;

import java.io.IOException;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.service.MetropolisDatabaseService;
import org.dbgl.service.SettingsService;
import org.dbgl.service.TextService;
import org.dbgl.util.searchengine.WebSearchEngine;

public class MetropolisSearchEngine
extends WebSearchEngine {
    private static final String READ_QRY = "SELECT Release.id_Moby_Releases, Game.id_Moby_Games, Game.Name_Prefix, Game.Name, MIN(AltTitle.Alternate_Title), Game.Description, Release.Year, Platform.Name, Release.URL FROM tbl_Moby_Games Game, tbl_Moby_Platforms Platform, tbl_Moby_Releases Release LEFT JOIN tbl_Moby_Games_Alternate_Titles AltTitle ON Game.id_Moby_Games = AltTitle.id_Moby_Games WHERE Release.id_Moby_Games = Game.id_Moby_Games AND Release.id_Moby_Platforms = Platform.id_Moby_Platforms AND (UCASE(Game.Name) LIKE ? OR UCASE(CONCAT(Game.Name_Prefix, ' ', Game.Name)) LIKE ? OR UCASE(AltTitle.Alternate_Title) LIKE ? OR UCASE(CONCAT(Game.Name_Prefix, ' ', Game.Name, ' (', AltTitle.Alternate_Title, ')')) LIKE ?) GROUP BY Release.id_Moby_Releases, Game.id_Moby_Games, Game.Name_Prefix, Game.Name, Game.Description, Release.Year, Platform.Name, Release.URL ORDER BY UCASE(CONCAT(Game.Name_Prefix, Game.Name));";
    private static final String READ_RELEASE_DETAILS_QRY = "SELECT Publ.Name, Dev.Name, Release.MobyRank FROM tbl_Moby_Releases Release LEFT JOIN tbl_Moby_Companies Publ ON Release.Publisher_id_Moby_Companies = Publ.id_Moby_Companies LEFT JOIN tbl_Moby_Companies Dev ON Release.Developer_id_Moby_Companies = Dev.id_Moby_Companies WHERE Release.id_Moby_Releases = ?";
    private static final String READ_GAME_GENRES_QRY = "SELECT Genre.Name FROM tbl_Moby_Games Game, tbl_Moby_Games_Genres GameGenre, tbl_Moby_Genres Genre WHERE GameGenre.id_Moby_Games = Game.id_Moby_Games AND Genre.id_Moby_Genres = GameGenre.id_Moby_Genres AND Game.id_Moby_Games = ?";
    private static final String LIMIT_CLAUSE = "LIMIT ?";
    private static final String READ_SCREENSHOT_DETAILS_QRY = "SELECT Screenshot.URL, Screenshot.Description FROM tbl_Moby_Releases Release, tbl_Moby_Releases_Screenshots Screenshot WHERE Screenshot.id_Moby_Releases = Release.id_Moby_Releases AND Release.id_Moby_Releases = ? LIMIT ?";
    private static final String READ_COVERART_DETAILS_BASE_QRY = "SELECT CoverArt.URL, CoverArtType.Name FROM tbl_Moby_Releases Release, tbl_Moby_Releases_Cover_Art CoverArt, tbl_Moby_Cover_Art_Types CoverArtType, tbl_Moby_Releases_Cover_Art_Regions CoverRegion, tbl_Moby_Regions Region WHERE CoverArtType.id_Moby_Cover_Art_Types = CoverArt.id_Moby_Cover_Art_Types AND CoverArt.id_Moby_Releases = Release.id_Moby_Releases AND CoverRegion.id_Moby_Releases_Cover_Art = CoverArt.id_Moby_Releases_Cover_Art AND CoverRegion.id_Moby_Regions = Region.id_Moby_Regions AND Release.id_Moby_Releases = ? ";
    private static final String READ_COVERART_DETAILS_ALL_REGIONS_QRY = "SELECT CoverArt.URL, CoverArtType.Name FROM tbl_Moby_Releases Release, tbl_Moby_Releases_Cover_Art CoverArt, tbl_Moby_Cover_Art_Types CoverArtType, tbl_Moby_Releases_Cover_Art_Regions CoverRegion, tbl_Moby_Regions Region WHERE CoverArtType.id_Moby_Cover_Art_Types = CoverArt.id_Moby_Cover_Art_Types AND CoverArt.id_Moby_Releases = Release.id_Moby_Releases AND CoverRegion.id_Moby_Releases_Cover_Art = CoverArt.id_Moby_Releases_Cover_Art AND CoverRegion.id_Moby_Regions = Region.id_Moby_Regions AND Release.id_Moby_Releases = ? LIMIT ?";
    private static final String READ_COVERART_DETAILS_QRY = "SELECT CoverArt.URL, CoverArtType.Name FROM tbl_Moby_Releases Release, tbl_Moby_Releases_Cover_Art CoverArt, tbl_Moby_Cover_Art_Types CoverArtType, tbl_Moby_Releases_Cover_Art_Regions CoverRegion, tbl_Moby_Regions Region WHERE CoverArtType.id_Moby_Cover_Art_Types = CoverArt.id_Moby_Cover_Art_Types AND CoverArt.id_Moby_Releases = Release.id_Moby_Releases AND CoverRegion.id_Moby_Releases_Cover_Art = CoverArt.id_Moby_Releases_Cover_Art AND CoverRegion.id_Moby_Regions = Region.id_Moby_Regions AND Release.id_Moby_Releases = ? AND Region.Region = ? LIMIT ?";
    private static final String READ_STAFF_QRY = "SELECT Staff.Name FROM tbl_Moby_Staff Staff, tbl_Moby_Releases_Staff RelStaff WHERE Staff.id_Moby_Staff = RelStaff.id_Moby_Staff AND RelStaff.id_Moby_Releases = ? LIMIT 1";

    private MetropolisSearchEngine() {
    }

    public static WebSearchEngine getInstance() {
        return SearchEngineHolder.instance_;
    }

    @Override
    public String getIcon() {
        return "metropolis.png";
    }

    @Override
    public String getName() {
        return "Metropolis Launcher MobyGames Database";
    }

    @Override
    public String getSimpleName() {
        return "metropolis";
    }

    @Override
    public boolean available() {
        boolean available;
        int[] version = MetropolisDatabaseService.getInstance().getVersion();
        boolean bl = available = version.length == 2 && (version[0] != 0 || version[1] != 0);
        if (!available) {
            Mess_.on(null).txt(this.getName() + " not available").display();
        }
        return available;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<WebProfile> getEntries(String title, String[] platforms) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public WebProfile getEntryDetailedInformation(WebProfile entry) throws UnknownHostException, IOException {
        try (Connection con = MetropolisDatabaseService.getInstance().getConnection();){
            Throwable throwable;
            ResultSet resultset;
            try (PreparedStatement pstmt = con.prepareStatement(READ_RELEASE_DETAILS_QRY);){
                pstmt.setInt(1, entry.getReleaseId());
                resultset = pstmt.executeQuery();
                throwable = null;
                try {
                    while (resultset.next()) {
                        entry.setPublisherName(resultset.getString(1) != null ? resultset.getString(1) : "");
                        entry.setDeveloperName(resultset.getString(2) != null ? resultset.getString(2) : "");
                        entry.setRank(resultset.getInt(3));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resultset != null) {
                        if (throwable != null) {
                            try {
                                resultset.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            resultset.close();
                        }
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)entry.getDeveloperName())) {
                pstmt = con.prepareStatement(READ_STAFF_QRY);
                var5_8 = null;
                try {
                    pstmt.setInt(1, entry.getReleaseId());
                    resultset = pstmt.executeQuery();
                    throwable = null;
                    try {
                        if (resultset.next()) {
                            entry.setDeveloperName(resultset.getString(1));
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (resultset != null) {
                            if (throwable != null) {
                                try {
                                    resultset.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                resultset.close();
                            }
                        }
                    }
                }
                catch (Throwable resultset2) {
                    var5_8 = resultset2;
                    throw resultset2;
                }
                finally {
                    if (pstmt != null) {
                        if (var5_8 != null) {
                            try {
                                pstmt.close();
                            }
                            catch (Throwable resultset2) {
                                var5_8.addSuppressed(resultset2);
                            }
                        } else {
                            pstmt.close();
                        }
                    }
                }
            }
            pstmt = con.prepareStatement(READ_GAME_GENRES_QRY);
            var5_8 = null;
            try {
                pstmt.setInt(1, entry.getGameId());
                resultset = pstmt.executeQuery();
                throwable = null;
                try {
                    ArrayList<String> genres = new ArrayList<String>();
                    while (resultset.next()) {
                        genres.add(resultset.getString(1));
                    }
                    entry.setGenre(StringUtils.join(genres, (String)", "));
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (resultset != null) {
                        if (throwable != null) {
                            try {
                                resultset.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            resultset.close();
                        }
                    }
                }
            }
            catch (Throwable throwable8) {
                var5_8 = throwable8;
                throw throwable8;
            }
            finally {
                if (pstmt != null) {
                    if (var5_8 != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable9) {
                            var5_8.addSuppressed(throwable9);
                        }
                    } else {
                        pstmt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IOException(TextService.getInstance().get("database.error.query", new Object[]{"read mobygameslocal game details"}));
        }
        return entry;
    }

    @Override
    public SearchEngineImageInformation[] getEntryImages(WebProfile entry, int coverArtMax, int screenshotsMax, boolean forceAllRegionsCoverArt) throws IOException {
        ArrayList<SearchEngineImageInformation> result = new ArrayList<SearchEngineImageInformation>();
        if (coverArtMax > 0) {
            result.addAll(this.getEntryCoverArtInformation(entry, coverArtMax, forceAllRegionsCoverArt, SettingsService.getInstance().getValue(this.getSimpleName(), "region")));
        }
        if (screenshotsMax > 0) {
            result.addAll(this.getEntryScreenshotInformation(entry, screenshotsMax));
        }
        entry.setWebImages(result.toArray(new SearchEngineImageInformation[0]));
        return entry.getWebImages();
    }

    private Collection<? extends SearchEngineImageInformation> getEntryCoverArtInformation(WebProfile entry, int coverArtMax, boolean forceAllRegionsCoverArt, String region) throws IOException {
        ArrayList<SearchEngineImageInformation> result = new ArrayList<SearchEngineImageInformation>();
        try (Connection con = MetropolisDatabaseService.getInstance().getConnection();
             PreparedStatement pstmt = con.prepareStatement(forceAllRegionsCoverArt ? READ_COVERART_DETAILS_ALL_REGIONS_QRY : READ_COVERART_DETAILS_QRY);){
            pstmt.setInt(1, entry.getReleaseId());
            if (!forceAllRegionsCoverArt) {
                pstmt.setString(2, region);
            }
            pstmt.setInt(forceAllRegionsCoverArt ? 2 : 3, coverArtMax);
            try (ResultSet resultset = pstmt.executeQuery();){
                while (resultset.next()) {
                    result.add(new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.CoverArt, "https://www.mobygames.com/images/covers/l/" + resultset.getString(1), resultset.getString(2)));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IOException(TextService.getInstance().get("database.error.query", new Object[]{"read mobygameslocal covertart details"}));
        }
        return result;
    }

    private Collection<? extends SearchEngineImageInformation> getEntryScreenshotInformation(WebProfile entry, int screenshotsMax) throws IOException {
        ArrayList<SearchEngineImageInformation> result = new ArrayList<SearchEngineImageInformation>();
        try (Connection con = MetropolisDatabaseService.getInstance().getConnection();
             PreparedStatement pstmt = con.prepareStatement(READ_SCREENSHOT_DETAILS_QRY);){
            pstmt.setInt(1, entry.getReleaseId());
            pstmt.setInt(2, screenshotsMax);
            try (ResultSet resultset = pstmt.executeQuery();){
                while (resultset.next()) {
                    result.add(new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.Screenshot, "https://www.mobygames.com/images/shots/l/" + resultset.getString(1), resultset.getString(2)));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IOException(TextService.getInstance().get("database.error.query", new Object[]{"read mobygameslocal screenshot details"}));
        }
        return result;
    }

    private static class SearchEngineHolder {
        private static WebSearchEngine instance_ = new MetropolisSearchEngine();

        private SearchEngineHolder() {
        }
    }
}

