/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.abstractdialog;

import org.dbgl.gui.abstractdialog.SizeControlledDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Composite_;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class WizardDialog<T>
extends SizeControlledDialog<T> {
    private static final int TAKE_ONE_STEP = 1;
    private final StackLayout wizardLayout_ = new StackLayout();
    protected Composite contents_;
    protected Button backButton_;
    protected Button nextButton_;
    protected Button cancelButton_;
    protected int step_ = 0;

    protected WizardDialog(Shell parent, String dialogName) {
        super(parent, dialogName);
    }

    @Override
    protected void onShellInit() {
        super.onShellInit();
        this.shell_.setLayout((Layout)new GridLayout());
        this.contents_ = ((Composite_.Builder)Composite_.on((Composite)this.shell_).layoutData(new GridData(4, 4, true, true))).layout((Layout)this.wizardLayout_).build();
        Composite buttons = ((Composite_.Builder)Composite_.on((Composite)this.shell_).layoutData(new GridData(4, 4, true, false))).innerLayout(2).build();
        Composite backNextButtons = ((Composite_.Builder)Composite_.on(buttons).layoutData(new GridData(1, 4, false, false))).innerLayout(2).build();
        this.backButton_ = Button_.on(backNextButtons).text().key("button.back").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WizardDialog.this.goBack();
            }
        }).ctrl();
        this.nextButton_ = Button_.on(backNextButtons).text().key("button.next").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WizardDialog.this.goForward();
            }
        }).ctrl();
        this.shell_.setDefaultButton(this.nextButton_);
        GridLayout gridLayoutOtherButtons = new GridLayout(2, true);
        gridLayoutOtherButtons.marginWidth = 80;
        gridLayoutOtherButtons.marginHeight = 0;
        Composite otherButtons = ((Composite_.Builder)Composite_.on(buttons).layoutData(new GridData(1, 4, false, false))).layout((Layout)gridLayoutOtherButtons).build();
        this.cancelButton_ = Button_.on(otherButtons).text().key("button.cancel").listen((SelectionListener)this.closeShellAdapter).ctrl();
        WizardDialog.setLayoutDataButtons(this.backButton_, this.nextButton_, this.cancelButton_);
    }

    protected void addStep(Group group) {
        group.setParent(this.contents_);
    }

    @Override
    protected void onShellOpened() {
        this.activateCurrentStep();
    }

    protected int stepSize(int step, boolean forward) {
        return 1;
    }

    protected void goBack() {
        this.step_ -= this.stepSize(this.step_, false);
        this.activateCurrentStep();
    }

    protected void goForward() {
        if (this.onNext(this.step_)) {
            if (this.step_ >= this.totalSteps() - 1) {
                this.shell_.close();
            } else {
                this.step_ += this.stepSize(this.step_, true);
                this.activateCurrentStep();
            }
        }
    }

    protected abstract boolean onNext(int var1);

    protected void activateCurrentStep() {
        this.backButton_.setEnabled(this.step_ > 0);
        this.nextButton_.setText(this.step_ < this.totalSteps() - 1 ? this.text_.get("button.next") : this.text_.get("button.finish"));
        if (this.step_ < this.contents_.getChildren().length) {
            this.wizardLayout_.topControl = this.contents_.getChildren()[this.step_];
            this.contents_.layout();
            this.wizardLayout_.topControl.setFocus();
        }
    }

    protected int totalSteps() {
        return this.contents_.getChildren().length;
    }
}

