/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import java.util.List;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.controls.ControlBuilder;
import org.dbgl.gui.controls.DarkTheme;
import org.dbgl.model.entity.ITitledEntity;
import org.dbgl.service.SettingsService;
import org.dbgl.service.TextService;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public final class Combo_ {
    public static final String DYN_OPT_SECTION = "dynOptSection";
    public static final String DYN_OPT_ITEM = "dynOptItem";
    private final Combo combo_;

    private Combo_(Builder builder) {
        this.combo_ = new Combo(builder.composite_, builder.style_);
        if (DarkTheme.forced()) {
            this.combo_.setBackground(DarkTheme.inputBackground);
            this.combo_.setForeground(DarkTheme.defaultForeground);
        }
        this.combo_.setLayoutData(builder.layoutData());
        this.combo_.setVisibleItemCount(builder.visibleItemCount_);
        if (builder.tooltip_ != null) {
            this.combo_.setToolTipText(builder.tooltip_);
        }
        if (builder.items_ != null) {
            this.combo_.setItems(builder.items_);
        }
        if (builder.select_ >= 0) {
            this.combo_.select(builder.select_);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{builder.dynOptSection_, builder.dynOptItem_})) {
            this.combo_.setData(DYN_OPT_SECTION, (Object)builder.dynOptSection_);
            this.combo_.setData(DYN_OPT_ITEM, (Object)builder.dynOptItem_);
        }
        if (builder.autoSelect_) {
            this.combo_.setData("currentLength", (Object)0);
            this.combo_.setData("mutex", (Object)false);
            this.combo_.addModifyListener(event -> {
                if (!((Boolean)this.combo_.getData("mutex")).booleanValue()) {
                    OptionalInt opt;
                    String text = this.combo_.getText();
                    int newLength = text.length();
                    if (newLength > (Integer)this.combo_.getData("currentLength") && (opt = IntStream.range(0, this.combo_.getItemCount()).filter(i -> this.combo_.getItem(i).toLowerCase().startsWith(text.toLowerCase())).findFirst()).isPresent()) {
                        this.combo_.setData("mutex", (Object)true);
                        this.combo_.setText(text + this.combo_.getItem(opt.getAsInt()).substring(newLength));
                        this.combo_.setSelection(new Point(newLength, this.combo_.getText().length()));
                        this.combo_.setData("mutex", (Object)false);
                    }
                    this.combo_.setData("currentLength", (Object)newLength);
                }
            });
        }
    }

    public Combo ctrl() {
        return this.combo_;
    }

    public static Builder on(Composite composite) {
        return new Builder(composite);
    }

    public static final class Builder
    extends ControlBuilder<Builder> {
        int visibleItemCount_ = 10;
        String tooltip_;
        String[] items_;
        int select_ = -1;
        boolean autoSelect_ = false;
        String dynOptSection_;
        String dynOptItem_;

        Builder(Composite composite) {
            super(composite, 8, 1, 0x1000000, false, false);
        }

        public Builder tooltip(String key) {
            this.tooltip_ = TextService.getInstance().get(key);
            return this;
        }

        public Builder editable() {
            return (Builder)this.style(0);
        }

        public Builder wide() {
            this.horizontalAlignment_ = 4;
            this.grabExcessHorizontalSpace_ = true;
            return this;
        }

        public Builder autoSelect(List<ITitledEntity> values) {
            this.autoSelect_ = true;
            this.items((String[])values.stream().map(ITitledEntity::getTitle).toArray(String[]::new));
            this.wide();
            this.editable();
            this.visibleItemCount(15);
            return this;
        }

        public Builder visibleItemCount(int count) {
            this.visibleItemCount_ = count;
            return this;
        }

        public Builder items(String[] items) {
            this.items_ = items;
            return this;
        }

        public Builder items(List<String> items) {
            this.items_ = items.toArray(new String[items.size()]);
            return this;
        }

        public Builder items(String section, String item) {
            this.items_ = SettingsService.getInstance().getValues(section, item);
            this.dynOptSection_ = section;
            this.dynOptItem_ = item;
            return this;
        }

        public Builder select(int select) {
            this.select_ = select;
            return this;
        }

        public Combo_ build() {
            return new Combo_(this);
        }

        public Combo ctrl() {
            return this.build().ctrl();
        }
    }
}

