/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog.wizard;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.GenericType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.abstractdialog.EditConfigurableDialog;
import org.dbgl.gui.abstractdialog.WizardDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Combo_;
import org.dbgl.gui.controls.Composite_;
import org.dbgl.gui.controls.DarkTheme;
import org.dbgl.gui.controls.Group_;
import org.dbgl.gui.controls.Label_;
import org.dbgl.gui.controls.List_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.controls.SearchEngineSelector;
import org.dbgl.gui.controls.Text_;
import org.dbgl.gui.dialog.BrowseSearchEngineDialog;
import org.dbgl.gui.dialog.LoadSharedConfDialog;
import org.dbgl.model.FileLocation;
import org.dbgl.model.Link;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.entity.SharedConf;
import org.dbgl.model.entity.TitledEntity;
import org.dbgl.model.factory.ProfileFactory;
import org.dbgl.model.repository.BaseRepository;
import org.dbgl.model.repository.DosboxVersionRepository;
import org.dbgl.model.repository.ProfileRepository;
import org.dbgl.model.repository.TemplateRepository;
import org.dbgl.service.FileLocationService;
import org.dbgl.service.ImageService;
import org.dbgl.util.DosGameUtils;
import org.dbgl.util.ExecuteUtils;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.iso.ISO9660FileSystem;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class AddGameWizardDialog
extends WizardDialog<Profile> {
    private List<DosboxVersion> dbversionsList_;
    private List<Template> templatesList_;
    private Profile profile_;
    private Text title_;
    private Text mainText_;
    private Text setupText_;
    private Text installExe_;
    private Text installParameters_;
    private Text patchExe_;
    private Text patchParameters_;
    private Text dstDirectory_;
    private Text imagesDstDirectory_;
    private SearchEngineSelector engineSelector_;
    private ToolItem loadSharedConfButton_;
    private Combo main_;
    private Combo setup_;
    private Combo machine_;
    private Combo core_;
    private Combo cycles_;
    private Combo mapper_;
    private Button moveImages_;
    private Button btnPreinstalledGame_;
    private Button btnGameNeedsToBeInstalled_;
    private Button btnInstallManual_;
    private Button btnPatchManual_;
    private org.eclipse.swt.widgets.List mountingpoints_;
    private org.eclipse.swt.widgets.List installedFilesList_;
    private org.eclipse.swt.widgets.List orgImagesList_;
    private List<FileLocation> orgImages_;
    private List<FileLocation> installedFiles_;
    private Composite webImagesSpaceHolder_;
    private SearchEngineImageInformation[] imageInformation_;
    private Button[] imgButtons_;

    public AddGameWizardDialog(Shell parent) {
        super(parent, "addgamewizard");
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.addgamewizard.title");
    }

    @Override
    protected boolean prepare() {
        try {
            this.dbversionsList_ = new DosboxVersionRepository().listAll();
            this.templatesList_ = new TemplateRepository().listAll(this.dbversionsList_);
            StringBuilder warningsLog = new StringBuilder();
            DosboxVersion dbVersion = BaseRepository.findDefault(this.dbversionsList_);
            warningsLog.append(dbVersion.resetAndLoadConfiguration());
            Template template = BaseRepository.findDefault(this.templatesList_);
            if (template != null) {
                warningsLog.append(template.resetAndLoadConfiguration());
            }
            this.profile_ = ProfileFactory.create(dbVersion, template);
            if (StringUtils.isNotBlank((CharSequence)warningsLog)) {
                Mess_.on(this.getParent()).txt(warningsLog.toString()).warning();
            }
            return true;
        }
        catch (Exception e) {
            Mess_.on(this.getParent()).exception(e).warning();
            return false;
        }
    }

    @Override
    protected void onShellCreated() {
        Group step0Group = Group_.on((Composite)this.shell_).layout((Layout)new GridLayout(3, false)).key("dialog.addgamewizard.step1").build();
        this.title_ = Chain.on((Composite)step0Group).lbl(l -> l.key("dialog.profile.title")).txt(t -> t).text();
        ToolBar toolBar = AddGameWizardDialog.createToolBar((Composite)step0Group);
        this.engineSelector_ = new SearchEngineSelector(toolBar, true);
        this.engineSelector_.addToggleSelectionListener(this.settings_.getBooleanValue("addgamewizard", "consultsearchengine"));
        boolean loadSharedConfEnabledByDefault = this.settings_.getBooleanValue("addgamewizard", "consultdbconfws");
        this.loadSharedConfButton_ = AddGameWizardDialog.createImageToolItem(toolBar, 8, loadSharedConfEnabledByDefault ? ImageService.getResourceImage(this.shell_.getDisplay(), "share.png") : ImageService.createDisabledImage(ImageService.getResourceImage(this.shell_.getDisplay(), "share.png")), this.text_.get("button.consultconfsearchengine", new String[]{"DBConfWS"}), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (Boolean.TRUE.equals(AddGameWizardDialog.this.loadSharedConfButton_.getData("selected"))) {
                    AddGameWizardDialog.this.loadSharedConfButton_.setImage(ImageService.createDisabledImage(ImageService.getResourceImage(AddGameWizardDialog.this.shell_.getDisplay(), "share.png")));
                    AddGameWizardDialog.this.loadSharedConfButton_.setData("selected", (Object)false);
                    AddGameWizardDialog.this.settings_.setBooleanValue("addgamewizard", "consultdbconfws", false);
                } else {
                    AddGameWizardDialog.this.loadSharedConfButton_.setImage(ImageService.getResourceImage(AddGameWizardDialog.this.shell_.getDisplay(), "share.png"));
                    AddGameWizardDialog.this.loadSharedConfButton_.setData("selected", (Object)true);
                    AddGameWizardDialog.this.settings_.setBooleanValue("addgamewizard", "consultdbconfws", true);
                }
            }
        });
        this.loadSharedConfButton_.setData("selected", (Object)loadSharedConfEnabledByDefault);
        boolean requiresInstallation = this.settings_.getBooleanValue("addgamewizard", "requiresinstallation");
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddGameWizardDialog.this.settings_.setBooleanValue("addgamewizard", "requiresinstallation", event.widget == AddGameWizardDialog.this.btnGameNeedsToBeInstalled_);
            }
        };
        Composite radios = ((Composite_.Builder)Composite_.on((Composite)step0Group).horSpan(3)).layout((Layout)new GridLayout(1, false)).build();
        this.btnPreinstalledGame_ = Chain.on(radios).lbl(l -> l).lbl(l -> l.key("dialog.addgamewizard.thisgame")).but(b -> b.radio().key("dialog.addgamewizard.preinstalled").select(!requiresInstallation).listen((SelectionListener)adapter)).button();
        this.btnGameNeedsToBeInstalled_ = Button_.on(radios).radio().key("dialog.addgamewizard.notyetinstalled").select(requiresInstallation).listen((SelectionListener)adapter).ctrl();
        this.addStep(step0Group);
        Group step1Group = Group_.on((Composite)this.shell_).layout((Layout)new GridLayout(3, false)).key("dialog.addgamewizard.step2").build();
        this.installExe_ = Chain.on((Composite)step1Group).lbl(l -> l.key("dialog.addgamewizard.installexe")).txt(t -> t).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.INSTALLER, false)).text();
        this.installExe_.addVerifyListener(event -> {
            if (event.text.length() > 1 && this.profile_.getRequiredMount(false, event.text, false, true) != null) {
                this.profile_.addRequiredMount(false, event.text, true);
                this.mountingpoints_.setItems(this.profile_.getMountStringsForUI());
            }
        });
        this.installParameters_ = Chain.on((Composite)step1Group).lbl(l -> l.key("dialog.profile.mainparameters")).txt(t -> (Text_.Builder)t.horSpan(2)).text();
        this.btnInstallManual_ = Chain.on((Composite)step1Group).lbl(l -> l.key("dialog.addgamewizard.manualmode")).but(b -> ((Button_.Builder)b.horSpan(2)).key("dialog.addgamewizard.manualmodeinfo")).button();
        ((Label_.Builder)Label_.on((Composite)step1Group).horSpan(3)).build();
        Group mountGroup = ((Group_.Builder)Group_.on((Composite)step1Group).layout((Layout)new GridLayout(2, false)).layoutData(new GridData(4, 0x1000000, true, false, 3, 1))).key("dialog.template.mountingoverview").build();
        this.mountingpoints_ = List_.on((Composite)mountGroup).ctrl();
        this.mountingpoints_.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (AddGameWizardDialog.this.mountingpoints_.getSelectionIndex() == -1) {
                    EditConfigurableDialog.doAddMount(AddGameWizardDialog.this.shell_, false, AddGameWizardDialog.this.mountingpoints_, AddGameWizardDialog.this.profile_);
                } else {
                    EditConfigurableDialog.doEditMount(AddGameWizardDialog.this.shell_, AddGameWizardDialog.this.mountingpoints_, AddGameWizardDialog.this.profile_);
                }
            }
        });
        Composite mntButComp = Composite_.on((Composite)mountGroup).innerLayout(1).build();
        Chain.on(mntButComp).but(b -> b.text().key("dialog.template.mount.add").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.doAddMount(AddGameWizardDialog.this.shell_, false, AddGameWizardDialog.this.mountingpoints_, AddGameWizardDialog.this.profile_);
            }
        })).but(b -> b.text().key("dialog.template.mount.edit").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.doEditMount(AddGameWizardDialog.this.shell_, AddGameWizardDialog.this.mountingpoints_, AddGameWizardDialog.this.profile_);
            }
        })).but(b -> b.text().key("dialog.template.mount.remove").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.doRemoveMount(AddGameWizardDialog.this.mountingpoints_, AddGameWizardDialog.this.profile_);
            }
        })).build();
        Group associationGroup = ((Group_.Builder)Group_.on((Composite)step1Group).layout((Layout)new GridLayout(2, false)).layoutData(new GridData(4, 0x1000000, true, false, 3, 1))).key("dialog.template.association").build();
        int dbversionIndex = BaseRepository.indexOf(this.dbversionsList_, this.profile_.getDosboxVersion());
        final Combo dbversion = Chain.on((Composite)associationGroup).lbl(l -> l.key("dialog.template.dosboxversion")).cmb(c -> c.items((String[])this.dbversionsList_.stream().map(TitledEntity::getTitle).toArray(String[]::new)).visibleItemCount(20).select(dbversionIndex)).combo();
        dbversion.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        dbversion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    String warningsLog = AddGameWizardDialog.this.profile_.switchToDosboxVersion((DosboxVersion)AddGameWizardDialog.this.dbversionsList_.get(dbversion.getSelectionIndex()));
                    AddGameWizardDialog.this.resetMounts();
                    if (StringUtils.isNotEmpty((CharSequence)warningsLog)) {
                        Mess_.on(AddGameWizardDialog.this.getParent()).txt(warningsLog).warning();
                    }
                }
                catch (IOException e) {
                    Mess_.on(AddGameWizardDialog.this.getParent()).exception(e).warning();
                }
            }
        });
        this.addStep(step1Group);
        Group step2Group = Group_.on((Composite)this.shell_).layout((Layout)new GridLayout(3, false)).key("dialog.addgamewizard.step3").build();
        this.patchExe_ = Chain.on((Composite)step2Group).lbl(l -> l.key("dialog.addgamewizard.patcherexe")).txt(t -> t).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.INSTALLER, false)).text();
        this.patchParameters_ = Chain.on((Composite)step2Group).lbl(l -> l.key("dialog.profile.mainparameters")).txt(t -> (Text_.Builder)t.horSpan(2)).text();
        this.btnPatchManual_ = Chain.on((Composite)step2Group).lbl(l -> l.key("dialog.addgamewizard.manualmode")).but(b -> ((Button_.Builder)b.horSpan(2)).key("dialog.addgamewizard.manualpatchmodeinfo")).button();
        this.addStep(step2Group);
        Group step3Group = Group_.on((Composite)this.shell_).layout((Layout)new GridLayout(2, false)).key("dialog.addgamewizard.step4").build();
        this.main_ = Chain.on((Composite)step3Group).lbl(l -> l.key("dialog.profile.mainexe")).cmb(c -> c.wide().visibleItemCount(20)).combo();
        this.setup_ = Chain.on((Composite)step3Group).lbl(l -> l.key("dialog.profile.setupexe")).cmb(c -> c.wide().visibleItemCount(20)).combo();
        this.addStep(step3Group);
        Group step4Group = Group_.on((Composite)this.shell_).layout((Layout)new GridLayout(3, false)).key("dialog.addgamewizard.step4").build();
        this.mainText_ = Chain.on((Composite)step4Group).lbl(l -> l.key("dialog.profile.mainexe")).txt(t -> t).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.EXE, false)).text();
        Chain chnSetup = Chain.on((Composite)step4Group).lbl(l -> l.key("dialog.profile.setupexe")).txt(t -> t).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.EXE, false)).build();
        this.setupText_ = chnSetup.getText();
        chnSetup.getButton().setData("altControl", (Object)this.mainText_);
        this.addStep(step4Group);
        Group step5Group = Group_.on((Composite)this.shell_).layout((Layout)new GridLayout()).key("dialog.addgamewizard.step5").build();
        Group installedFilesGroup = ((Group_.Builder)Group_.on((Composite)step5Group).layout((Layout)new GridLayout(3, false)).layoutData(new GridData(4, 0x1000000, true, false))).key("dialog.addgamewizard.installedfiles").build();
        this.installedFilesList_ = ((List_.Builder)List_.on((Composite)installedFilesGroup).multi().horSpan(3)).ctrl();
        this.dstDirectory_ = Chain.on((Composite)installedFilesGroup).lbl(l -> l.key("dialog.migration.to")).txt(t -> t.val(FileLocationService.getInstance().getDosroot().getPath())).but(b -> b.browse(false, Button_.BrowseType.DIR, Button_.CanonicalType.NONE, false)).text();
        Group orgImagesGroup = ((Group_.Builder)Group_.on((Composite)step5Group).layout((Layout)new GridLayout(2, false)).layoutData(new GridData(4, 0x1000000, true, false))).key("dialog.addgamewizard.originalimages").build();
        this.orgImagesList_ = ((List_.Builder)List_.on((Composite)orgImagesGroup).multi().horSpan(2)).ctrl();
        this.moveImages_ = Chain.on((Composite)orgImagesGroup).lbl(l -> l.key("dialog.addgamewizard.moveimages")).but(b -> b.select(false)).button();
        this.imagesDstDirectory_ = Chain.on((Composite)orgImagesGroup).lbl(l -> l.key("dialog.migration.to")).txt(t -> t).text();
        this.imagesDstDirectory_.setEnabled(this.moveImages_.getSelection());
        this.moveImages_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddGameWizardDialog.this.imagesDstDirectory_.setEnabled(AddGameWizardDialog.this.moveImages_.getSelection());
            }
        });
        this.addStep(step5Group);
        Group step6Group = Group_.on((Composite)this.shell_).layout((Layout)new GridLayout(3, false)).key("dialog.addgamewizard.step6").build();
        final Combo template = Chain.on((Composite)step6Group).lbl(l -> l.key("dialog.profile.template")).cmb(c -> c.wide().items((String[])this.templatesList_.stream().map(TitledEntity::getTitle).toArray(String[]::new)).select(BaseRepository.indexOfDefault(this.templatesList_))).combo();
        Button_.on((Composite)step6Group).text().key("dialog.profile.reloadsettings").tooltip("dialog.profile.reloadsettings.tooltip").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (template.getSelectionIndex() != -1) {
                    AddGameWizardDialog.this.doReloadTemplate((Template)AddGameWizardDialog.this.templatesList_.get(template.getSelectionIndex()));
                }
            }
        }).build();
        this.machine_ = Chain.on((Composite)step6Group).lbl(l -> l.key("dialog.template.machine")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items("profile", this.profile_.getDosboxVersion().isUsingNewMachineConfig() ? "machine073" : "machine").visibleItemCount(20).tooltip("dialog.template.machine.tooltip")).combo();
        this.core_ = Chain.on((Composite)step6Group).lbl(l -> l.key("dialog.template.core")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items("profile", "core").visibleItemCount(20).tooltip("dialog.template.core.tooltip")).combo();
        this.cycles_ = Chain.on((Composite)step6Group).lbl(l -> l.key("dialog.template.cycles")).cmb(c -> ((Combo_.Builder)c.editable().horSpan(2)).items("profile", "cycles").visibleItemCount(15).tooltip("dialog.template.cycles.tooltip")).combo();
        this.mapper_ = Chain.on((Composite)step6Group).lbl(l -> l.key("dialog.template.mapperfile")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items(new String[]{this.text_.get("dialog.addgamewizard.mapper.generic"), this.text_.get("dialog.addgamewizard.mapper.specific")}).visibleItemCount(5).tooltip("dialog.template.mapperfile.tooltip")).combo();
        this.mapper_.select(this.settings_.getBooleanValue("addgamewizard", "useuniquemapperfile") ? 1 : 0);
        this.mapper_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddGameWizardDialog.this.settings_.setBooleanValue("addgamewizard", "useuniquemapperfile", ((Combo)event.widget).getSelectionIndex() == 1);
            }
        });
        this.addStep(step6Group);
        this.updateControlsByProfile();
    }

    private static void swapImages(Button btn) {
        Image img1 = btn.getImage();
        Image img2 = (Image)btn.getData("selectedImage");
        btn.setImage(img2);
        btn.setData("selectedImage", (Object)img1);
    }

    @Override
    protected int stepSize(int step, boolean forward) {
        if (this.btnPreinstalledGame_.getSelection()) {
            if (forward && step == 0 || !forward && step == 4) {
                return 4;
            }
            if (forward && step == 4 || !forward && step == 6) {
                return 2;
            }
        } else if (forward && step == 3 || !forward && step == 5) {
            return 2;
        }
        return super.stepSize(step, forward);
    }

    @Override
    protected boolean onNext(int step) {
        Mess_.Builder mess = Mess_.on(this.shell_);
        if (step == 0) {
            return this.titleEntered(mess) && this.doWebSearch();
        }
        if (step == 1) {
            return this.installExeEntered(mess) && this.runInstallerAndCheckResults();
        }
        if (step == 2) {
            return this.determineMainAndSetup();
        }
        if (step == 3) {
            return this.mainExeEntered(mess) && this.setMain();
        }
        if (step == 4) {
            return this.mainExeEntered(mess) && this.setMain();
        }
        if (step == 5) {
            return this.conditionsOkForStep5(mess);
        }
        if (step == this.totalSteps() - 1) {
            return this.createProfile();
        }
        return step == 6;
    }

    @Override
    protected void onClose() {
        super.onClose();
        try {
            FileUtils.deleteDirectory((File)FileLocationService.getInstance().getTmpInstallDir());
        }
        catch (IOException e) {
            Mess_.on(this.shell_).exception(e).warning();
        }
    }

    private void updateControlsByProfile() {
        Configuration combinedConf = this.profile_.getCombinedConfiguration();
        this.machine_.setText(combinedConf.getValue("dosbox", "machine"));
        this.core_.setText(combinedConf.getValue("cpu", "core"));
        this.cycles_.setText(combinedConf.getValue("cpu", "cycles"));
    }

    private void updateProfileByControls() {
        this.profile_.setValue("dosbox", "machine", this.machine_.getText());
        this.profile_.setValue("cpu", "core", this.core_.getText());
        this.profile_.setValue("cpu", "cycles", this.cycles_.getText());
    }

    private void doReloadTemplate(Template template) {
        try {
            StringBuilder warningsLog = new StringBuilder();
            warningsLog.append(template.resetAndLoadConfiguration());
            warningsLog.append(this.profile_.reloadTemplate(this.profile_.getDosboxVersion(), template));
            this.updateControlsByProfile();
            if (StringUtils.isNotEmpty((CharSequence)warningsLog)) {
                Mess_.on(this.getParent()).txt(warningsLog.toString()).warning();
            }
        }
        catch (IOException e) {
            Mess_.on(this.getParent()).exception(e).warning();
        }
    }

    private boolean titleEntered(Mess_.Builder mess) {
        if (StringUtils.isBlank((CharSequence)this.title_.getText())) {
            mess.key("dialog.profile.required.title").bind((Control)this.title_);
        }
        return mess.valid();
    }

    private boolean doWebSearch() {
        String currTitle = this.title_.getText();
        if (Boolean.TRUE.equals(this.loadSharedConfButton_.getData("selected"))) {
            try {
                Client client = ClientBuilder.newClient();
                GenericType<List<SharedConf>> confType = new GenericType<List<SharedConf>>(){};
                List confs = (List)client.target(this.settings_.getValue("confsharing", "endpoint")).path("/configurations/bytitle/{i}").resolveTemplate("i", (Object)currTitle).request().accept(new String[]{"application/xml"}).get((GenericType)confType);
                client.close();
                if (confs.isEmpty()) {
                    Mess_.on(this.shell_).key("general.notice.searchenginenoresults", new String[]{"DBConfWS", currTitle}).display();
                } else {
                    LoadSharedConfDialog.SharedConfLoading result = (LoadSharedConfDialog.SharedConfLoading)new LoadSharedConfDialog(this.shell_, currTitle, confs).open();
                    if (result != null) {
                        if (result.reloadDosboxDefaults_) {
                            this.profile_.getConfiguration().clearSections();
                        }
                        this.profile_.loadConfigurationData(this.text_, result.conf_.getIncrConf(), new File(result.conf_.getGameTitle()));
                        this.updateControlsByProfile();
                    }
                }
            }
            catch (Exception e) {
                Mess_.on(this.shell_).key("general.error.retrieveinfosearchengine", new String[]{"DBConfWS", currTitle, StringRelatedUtils.toString(e)}).exception(e).warning();
            }
        }
        if (this.engineSelector_.isSelected()) {
            WebSearchEngine engine = WebSearchEngine.getBySimpleName(this.settings_.getValue("gui", "searchengine"));
            try {
                WebProfile thisGame;
                List<WebProfile> webGamesList = engine.getEntries(currTitle, this.settings_.getValues(engine.getSimpleName(), "platform_filter"));
                WebProfile webProfile = thisGame = webGamesList.isEmpty() ? null : (WebProfile)new BrowseSearchEngineDialog(this.shell_, currTitle, webGamesList, engine).open();
                if (thisGame != null) {
                    int ss;
                    engine.getEntryDetailedInformation(thisGame);
                    if (this.settings_.getBooleanValue(engine.getSimpleName(), "set_title")) {
                        this.title_.setText(thisGame.getTitle());
                    }
                    if (this.settings_.getBooleanValue(engine.getSimpleName(), "set_developer")) {
                        this.profile_.setDeveloper(thisGame.getDeveloperName());
                    }
                    if (this.settings_.getBooleanValue(engine.getSimpleName(), "set_publisher")) {
                        this.profile_.setPublisher(thisGame.getPublisherName());
                    }
                    if (this.settings_.getBooleanValue(engine.getSimpleName(), "set_year")) {
                        this.profile_.setYear(thisGame.getYear());
                    }
                    if (this.settings_.getBooleanValue(engine.getSimpleName(), "set_genre")) {
                        this.profile_.setGenre(thisGame.getGenre());
                    }
                    if (this.settings_.getBooleanValue(engine.getSimpleName(), "set_link")) {
                        this.profile_.getLinks()[0] = new Link(this.text_.get("dialog.profile.searchengine.link.maininfo", new String[]{engine.getName()}), thisGame.getUrl());
                    }
                    if (this.settings_.getBooleanValue(engine.getSimpleName(), "set_description")) {
                        this.profile_.setNotes(thisGame.getNotes());
                    }
                    if (this.settings_.getBooleanValue(engine.getSimpleName(), "set_rank")) {
                        this.profile_.getCustomInts()[0] = thisGame.getRank();
                    }
                    int WEB_IMAGE_WIDTH = this.settings_.getIntValue("mobygames", "image_width");
                    final int WEB_IMAGE_HEIGHT = this.settings_.getIntValue("mobygames", "image_height");
                    int ca = this.settings_.getBooleanValue(engine.getSimpleName(), "choose_coverart") ? Integer.MAX_VALUE : 0;
                    int n = ss = this.settings_.getBooleanValue(engine.getSimpleName(), "choose_screenshot") ? Integer.MAX_VALUE : 0;
                    if (ca > 0 || ss > 0) {
                        if (this.webImagesSpaceHolder_ == null) {
                            Group step7Group = Group_.on((Composite)this.shell_).layout((Layout)new GridLayout(1, false)).key("dialog.addgamewizard.step7").build();
                            this.webImagesSpaceHolder_ = ((Composite_.Builder)Composite_.on((Composite)step7Group).layoutData(new GridData(4, 4, true, true))).innerLayout(2).build();
                            this.addStep(step7Group);
                        } else {
                            Arrays.stream(this.webImagesSpaceHolder_.getChildren()).forEach(Widget::dispose);
                        }
                        boolean forceAllRegionsCoverArt = this.settings_.getBooleanValue(engine.getSimpleName(), "force_all_regions_coverart");
                        this.imageInformation_ = engine.getEntryImages(thisGame, ca, ss, forceAllRegionsCoverArt);
                        if (this.imageInformation_.length > 0) {
                            Chain.on(this.webImagesSpaceHolder_).but(b -> ((Button_.Builder)b.layoutData(new GridData(WEB_IMAGE_WIDTH + 10, -1))).text().key("button.all").listen((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    for (Button but : AddGameWizardDialog.this.imgButtons_) {
                                        if (!but.getSelection()) {
                                            AddGameWizardDialog.swapImages(but);
                                        }
                                        but.setSelection(true);
                                    }
                                }
                            })).but(b -> ((Button_.Builder)b.layoutData(new GridData(WEB_IMAGE_WIDTH + 10, -1))).text().key("button.none").listen((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    for (Button but : AddGameWizardDialog.this.imgButtons_) {
                                        if (but.getSelection()) {
                                            AddGameWizardDialog.swapImages(but);
                                        }
                                        but.setSelection(false);
                                    }
                                }
                            })).build();
                        }
                        final ScrolledComposite webImagesSpace = new ScrolledComposite(this.webImagesSpaceHolder_, 512);
                        if (DarkTheme.forced()) {
                            webImagesSpace.setBackground(DarkTheme.inputBackground);
                        }
                        webImagesSpace.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
                        RowLayout rowLayoutImagesGroup = new RowLayout(256);
                        rowLayoutImagesGroup.marginHeight = 0;
                        rowLayoutImagesGroup.marginWidth = 0;
                        final Composite webImagesComposite = Composite_.on((Composite)webImagesSpace).layout((Layout)rowLayoutImagesGroup).build();
                        webImagesSpace.setContent((Control)webImagesComposite);
                        webImagesSpace.setExpandVertical(true);
                        webImagesSpace.setExpandHorizontal(true);
                        webImagesSpace.addControlListener((ControlListener)new ControlAdapter(){

                            public void controlResized(ControlEvent e) {
                                webImagesSpace.setMinSize(webImagesComposite.computeSize(webImagesSpace.getClientArea().width, -1));
                            }
                        });
                        if (this.imageInformation_.length > 0) {
                            this.imgButtons_ = new Button[this.imageInformation_.length];
                            int i = 0;
                            while (i < this.imageInformation_.length) {
                                this.imgButtons_[i] = ((Button_.Builder)Button_.on(webImagesComposite).image(ImageService.getEmptyImage(this.display_, WEB_IMAGE_WIDTH, WEB_IMAGE_HEIGHT), true).toggle().tooltipTxt(this.imageInformation_[i].getDescription()).layoutData(new RowData())).ctrl();
                                final int j = i++;
                                Thread thread = new Thread(){

                                    @Override
                                    public void run() {
                                        try {
                                            ImageData imgData = thisGame.getWebImage(j);
                                            if (!AddGameWizardDialog.this.display_.isDisposed()) {
                                                AddGameWizardDialog.this.display_.asyncExec(() -> {
                                                    if (!AddGameWizardDialog.this.imgButtons_[j].isDisposed()) {
                                                        Image img = ImageService.getHeightLimitedImage(AddGameWizardDialog.this.display_, WEB_IMAGE_HEIGHT, imgData);
                                                        Image selectedImg = ImageService.createSelectedImage(img);
                                                        AddGameWizardDialog.this.imgButtons_[j].getImage().dispose();
                                                        AddGameWizardDialog.this.imgButtons_[j].setImage(img);
                                                        AddGameWizardDialog.this.imgButtons_[j].setData("selectedImage", (Object)selectedImg);
                                                        AddGameWizardDialog.this.imgButtons_[j].addSelectionListener((SelectionListener)new SelectionAdapter(){

                                                            public void widgetSelected(SelectionEvent e) {
                                                                AddGameWizardDialog.swapImages(AddGameWizardDialog.this.imgButtons_[j]);
                                                            }
                                                        });
                                                        webImagesComposite.setSize(webImagesComposite.computeSize(-1, -1));
                                                        webImagesComposite.layout();
                                                        AddGameWizardDialog.this.webImagesSpaceHolder_.layout(true);
                                                    }
                                                });
                                            }
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                };
                                thread.start();
                            }
                        } else {
                            ((Label_.Builder)((Label_.Builder)Label_.on(webImagesComposite).style(0x1000040)).layoutData(new RowData())).key("dialog.profile.notice.noimagesfound", engine.getName()).build();
                        }
                        webImagesComposite.pack();
                    }
                }
            }
            catch (Exception e) {
                Mess_.on(this.shell_).key("general.error.retrieveinfosearchengine", new String[]{engine.getName(), currTitle, StringRelatedUtils.toString(e)}).exception(e).warning();
            }
        }
        if (this.btnGameNeedsToBeInstalled_.getSelection() && StringUtils.isBlank((CharSequence)this.installExe_.getText())) {
            this.resetMounts();
        }
        return true;
    }

    private boolean installExeEntered(Mess_.Builder mess) {
        if (StringUtils.isBlank((CharSequence)this.installExe_.getText())) {
            mess.key("dialog.addgamewizard.required.installexe").bind((Control)this.installExe_);
        }
        return mess.valid();
    }

    private boolean runInstallerAndCheckResults() {
        try {
            File[] files;
            File[] firstImageMountPath;
            FileUtils.deleteDirectory((File)FileLocationService.getInstance().getTmpInstallDir());
            FilesUtils.createDir(FileLocationService.getInstance().getTmpInstallDir());
            this.profile_.setAutoexecSettings(this.installExe_.getText(), this.installParameters_.getText());
            ExecuteUtils.doRunProfile(ExecuteUtils.ProfileRunMode.INSTALLER, this.profile_, this.btnInstallManual_.getSelection(), this.display_);
            this.shell_.forceFocus();
            this.shell_.forceActive();
            this.orgImages_ = new ArrayList<FileLocation>();
            for (File file : firstImageMountPath = this.profile_.getConfiguration().getAutoexec().findFirstImageMountCanonicalPath()) {
                this.orgImages_.add(AddGameWizardDialog.toImageFileLocation(file));
            }
            ArrayList<FileLocation> additionalImageFiles = new ArrayList<FileLocation>();
            for (FileLocation orgImage : this.orgImages_) {
                File binFile;
                File file;
                file = orgImage.getCanonicalFile();
                if (!FilesUtils.isCueSheet(file.getName()) || (binFile = ISO9660FileSystem.parseCueSheet(file)) == null || !file.getParentFile().equals(binFile.getParentFile())) continue;
                additionalImageFiles.add(AddGameWizardDialog.toImageFileLocation(binFile));
            }
            this.orgImages_.addAll(additionalImageFiles);
            this.installedFiles_ = new ArrayList<FileLocation>();
            for (File file : files = FileLocationService.getInstance().getTmpInstallDir().listFiles()) {
                this.installedFiles_.add(AddGameWizardDialog.toImageFileLocation(file));
            }
            if (this.installedFiles_.isEmpty()) {
                Mess_.on(this.shell_).key("dialog.addgamewizard.error.nofilesinstalled").warning();
                return false;
            }
            return true;
        }
        catch (IOException e) {
            Mess_.on(this.shell_).exception(e).warning();
            return false;
        }
    }

    private static FileLocation toImageFileLocation(File file) {
        return new FileLocation(file.getPath(), FileLocationService.getInstance().dosrootRelative());
    }

    private boolean determineMainAndSetup() {
        int mainFileIndex;
        if (StringUtils.isNotBlank((CharSequence)this.patchExe_.getText())) {
            try {
                this.profile_.setAutoexecSettings(this.patchExe_.getText(), this.patchParameters_.getText());
                ExecuteUtils.doRunProfile(ExecuteUtils.ProfileRunMode.INSTALLER, this.profile_, this.btnPatchManual_.getSelection(), this.shell_.getDisplay());
                this.shell_.forceFocus();
                this.shell_.forceActive();
            }
            catch (IOException e) {
                Mess_.on(this.shell_).exception(e).warning();
                return false;
            }
        }
        this.orgImagesList_.removeAll();
        if (this.orgImages_ != null) {
            for (FileLocation fileLocation : this.orgImages_) {
                this.orgImagesList_.add(fileLocation.getFile().getPath());
            }
        }
        this.orgImagesList_.selectAll();
        this.orgImagesList_.pack();
        this.orgImagesList_.getParent().layout();
        this.installedFilesList_.removeAll();
        File gameDir = null;
        for (FileLocation installedFile : this.installedFiles_) {
            if (installedFile.getFile().isDirectory()) {
                this.installedFilesList_.add("[ " + installedFile.getFile().getPath() + " ]");
                if (gameDir != null) continue;
                gameDir = installedFile.getCanonicalFile();
                continue;
            }
            this.installedFilesList_.add(installedFile.getFile().getPath());
        }
        this.installedFilesList_.selectAll();
        this.installedFilesList_.pack();
        this.installedFilesList_.getParent().layout();
        this.moveImages_.setEnabled(this.profile_.getConfiguration().getAutoexec().countImageMounts() == 1L);
        String string = this.settings_.getValue("directory", "orgimages");
        File imagesSubDir = gameDir != null ? new File(gameDir.getName(), string) : new File(string);
        this.imagesDstDirectory_.setText(imagesSubDir.getPath());
        List<File> executables = FilesUtils.listExecutablesInDirRecursive(FileLocationService.getInstance().getTmpInstallDir());
        this.main_.removeAll();
        this.setup_.removeAll();
        this.setup_.add("");
        for (File f : executables) {
            String filename = AddGameWizardDialog.toImageFileLocation(f).getFile().getPath();
            this.main_.add(filename);
            this.setup_.add(filename);
        }
        if (executables.isEmpty()) {
            this.main_.add(this.installExe_.getText());
        }
        if ((mainFileIndex = DosGameUtils.findMostLikelyMainIndex(this.title_.getText(), executables)) != -1) {
            this.main_.select(mainFileIndex);
        } else {
            this.main_.select(0);
        }
        int setupFileIndex = DosGameUtils.findSetupIndex(executables);
        if (setupFileIndex != -1) {
            this.setup_.select(setupFileIndex + 1);
        } else {
            this.setup_.select(0);
        }
        this.setup_.setEnabled(this.setup_.getItemCount() > 1);
        return true;
    }

    private boolean mainExeEntered(Mess_.Builder mess) {
        if (this.btnPreinstalledGame_.getSelection()) {
            if (StringUtils.isBlank((CharSequence)this.mainText_.getText())) {
                mess.key("dialog.profile.required.mainexe").bind((Control)this.mainText_);
            }
        } else if (StringUtils.isBlank((CharSequence)this.main_.getText())) {
            mess.key("dialog.profile.required.mainexe").bind((Control)this.main_);
        }
        return mess.valid();
    }

    private boolean setMain() {
        if (this.btnPreinstalledGame_.getSelection()) {
            if (this.profile_.getRequiredMount(false, this.mainText_.getText(), false, false) != null) {
                this.profile_.addRequiredMount(false, this.mainText_.getText(), false);
            }
            this.profile_.setAutoexecSettings(this.mainText_.getText(), "");
        } else {
            if (this.profile_.getRequiredMount(false, this.main_.getText(), false, false) != null) {
                this.profile_.addRequiredMount(false, this.main_.getText(), false);
            }
            this.profile_.setAutoexecSettings(this.main_.getText(), "");
        }
        return true;
    }

    private boolean conditionsOkForStep5(Mess_.Builder mess) {
        if (this.btnPreinstalledGame_.getSelection()) {
            return true;
        }
        try {
            if (this.installedFilesList_.getSelectionCount() > 0) {
                File destDir = new File(this.dstDirectory_.getText());
                if (!destDir.isDirectory() && Mess_.on(this.shell_).key("dialog.addgamewizard.confirm.createdestinationdir", new String[]{destDir.toString()}).confirm()) {
                    destDir.mkdirs();
                }
                if (!destDir.isDirectory()) {
                    mess.key("dialog.addgamewizard.error.destinationdirmissing", destDir.toString()).bind((Control)this.dstDirectory_);
                } else {
                    for (int i = 0; i < this.installedFiles_.size(); ++i) {
                        File destFile;
                        if (!this.installedFilesList_.isSelected(i) || !FileUtils.directoryContains((File)destDir, (File)(destFile = new File(destDir, this.installedFiles_.get(i).getFile().getName())))) continue;
                        mess.key("dialog.addgamewizard.error.gamedatadirexists", destFile.toString()).bind((Control)this.dstDirectory_);
                    }
                }
            } else {
                mess.key("dialog.addgamewizard.error.gamedatamustbemoved").bind((Control)this.installedFilesList_);
            }
            return mess.valid();
        }
        catch (IOException e) {
            Mess_.on(this.shell_).exception(e).warning();
            return false;
        }
    }

    private boolean createProfile() {
        try {
            int i;
            String setupString = this.btnPreinstalledGame_.getSelection() ? this.setupText_.getText() : this.setup_.getText();
            this.profile_.setTitle(this.title_.getText());
            this.profile_.setSetupFileLocation(setupString);
            if (this.installedFilesList_.getSelectionCount() > 0) {
                FileLocation destDir = new FileLocation(this.dstDirectory_.getText(), FileLocationService.getInstance().dosrootRelative());
                this.profile_.migrate(FileLocationService.getInstance().getTmpInstallLocation(), destDir);
                this.profile_.removeFloppyMounts();
                this.profile_.removeUnnecessaryMounts();
                for (i = 0; i < this.installedFiles_.size(); ++i) {
                    File src = this.installedFiles_.get(i).getCanonicalFile();
                    if (!this.installedFilesList_.isSelected(i)) continue;
                    FileUtils.moveToDirectory((File)src, (File)destDir.getCanonicalFile(), (boolean)true);
                }
                if (this.moveImages_.getSelection()) {
                    File imgDestDir = new File(destDir.getCanonicalFile(), this.imagesDstDirectory_.getText());
                    for (int i2 = 0; i2 < this.orgImages_.size(); ++i2) {
                        FileLocation src = this.orgImages_.get(i2);
                        if (!this.orgImagesList_.isSelected(i2)) continue;
                        FileUtils.moveToDirectory((File)src.getCanonicalFile(), (File)imgDestDir, (boolean)true);
                        FileLocation dst = new FileLocation(FilesUtils.concat(imgDestDir, src.getFile().getName()), destDir.getCanonicalizer());
                        this.profile_.getConfiguration().getAutoexec().migrate(src, dst);
                    }
                }
            }
            if (this.mapper_.getSelectionIndex() == 1) {
                this.profile_.setValue("sdl", "mapperfile", this.settings_.getValue("profile", "uniquemapperfile"));
            }
            this.updateProfileByControls();
            this.result_ = new ProfileRepository().add(this.profile_);
            if (this.imageInformation_ != null) {
                File canonicalCapturesDir = this.profile_.getCanonicalCaptures();
                for (i = 0; i < this.imageInformation_.length; ++i) {
                    if (!this.imgButtons_[i].getSelection() || this.imageInformation_[i].getData() == null) continue;
                    String description = FilesUtils.toSafeFilenameForWebImages(this.imageInformation_[i].getDescription());
                    String filename = this.imageInformation_[i].getType() == SearchEngineImageInformation.SearchEngineImageType.COVER_ART ? this.text_.get("dialog.profile.mobygames.coverartfilename", new Object[]{i, description}) : this.text_.get("dialog.profile.mobygames.screenshotfilename", new Object[]{i, description});
                    File file = new File(canonicalCapturesDir, filename + ".png");
                    if (!FilesUtils.isExistingFile(file)) {
                        try {
                            ImageService.save(this.display_, this.imageInformation_[i].getData(), file.getPath());
                        }
                        catch (SWTException e) {
                            Mess_.on(this.shell_).key("general.error.savefile", file.getPath()).exception((Exception)((Object)e)).warning();
                        }
                        continue;
                    }
                    Mess_.on(this.shell_).key("dialog.profile.error.imagealreadyexists", new Object[]{file.getPath(), WebSearchEngine.getBySimpleName(this.settings_.getValue("gui", "searchengine")).getName()}).warning();
                }
            }
        }
        catch (IOException | SQLException e) {
            Mess_.on(this.shell_).exception(e).warning();
        }
        return true;
    }

    private void resetMounts() {
        this.profile_.getConfiguration().getAutoexec().getMountingpoints().clear();
        this.profile_.unmountDosboxMounts();
        this.profile_.addMount("mount C \"" + FileLocationService.getInstance().getTmpInstallDir() + "\"");
        this.mountingpoints_.setItems(this.profile_.getMountStringsForUI());
    }
}

