/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog.wizard;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.dbgl.gui.abstractdialog.JobWizardDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Combo_;
import org.dbgl.gui.controls.Group_;
import org.dbgl.gui.controls.Label_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.controls.ProgressBar_;
import org.dbgl.gui.controls.Table_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.gui.thread.ImportDirThread;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.entity.TitledEntity;
import org.dbgl.model.factory.ProfileFactory;
import org.dbgl.model.repository.BaseRepository;
import org.dbgl.model.repository.DosboxVersionRepository;
import org.dbgl.model.repository.GameFilesRepository;
import org.dbgl.model.repository.TemplateRepository;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.searchengine.MetropolisSearchEngine;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ImportDirDialog
extends JobWizardDialog<Object> {
    private static final String TRIANGLE_DOWN = "\u25be";
    private final File dir_;
    private final List<Profile> existingProfiles_;
    private DosboxVersion defaultDosboxVersion_;
    private List<Template> templatesList_;
    private Profile profile_;
    private ProgressBar progress_;
    private ProgressBar finished_;
    private Text scanInfo_;
    private List<GameFilesRepository.GameDirEntry> games_;
    private Table table_;
    private Combo machine_;
    private Combo core_;
    private Combo cycles_;
    private Combo mapper_;
    private Button consultConf_;

    public ImportDirDialog(Shell parent, File dir, List<Profile> exisitingProfiles) {
        super(parent, "importdirdialog");
        this.dir_ = dir;
        this.existingProfiles_ = exisitingProfiles;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.importdir.title");
    }

    @Override
    protected boolean prepare() {
        try {
            List<DosboxVersion> dbversionsList = new DosboxVersionRepository().listAll();
            this.templatesList_ = new TemplateRepository().listAll(dbversionsList);
            StringBuilder warningsLog = new StringBuilder();
            this.defaultDosboxVersion_ = BaseRepository.findDefault(dbversionsList);
            warningsLog.append(this.defaultDosboxVersion_.resetAndLoadConfiguration());
            Template template = BaseRepository.findDefault(this.templatesList_);
            if (template != null) {
                warningsLog.append(template.resetAndLoadConfiguration());
            }
            this.profile_ = ProfileFactory.create(this.defaultDosboxVersion_, template);
            if (StringUtils.isNotBlank((CharSequence)warningsLog)) {
                Mess_.on(this.getParent()).txt(warningsLog.toString()).warning();
            }
            return true;
        }
        catch (Exception e) {
            Mess_.on(this.getParent()).exception(e).warning();
            return false;
        }
    }

    @Override
    protected void onShellCreated() {
        Group progressGroup = Group_.on((Composite)this.shell_).layout((Layout)new GridLayout()).key("dialog.importdir.processing").build();
        progressGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label_.on((Composite)progressGroup).key("dialog.importdir.intro", this.dir_.getPath()).build();
        this.progress_ = ProgressBar_.on((Composite)progressGroup).indeterminate().ctrl();
        this.finished_ = ProgressBar_.on((Composite)progressGroup).sel(100).ctrl();
        ((GridData)this.finished_.getLayoutData()).exclude = true;
        this.finished_.setVisible(false);
        this.scanInfo_ = Text_.on((Composite)progressGroup).multi().wrap().readOnly().ctrl();
        this.addStep(progressGroup);
        Group gamesGroup = Group_.on((Composite)this.shell_).layout((Layout)new GridLayout(6, true)).key("dialog.importdir.selectgames").build();
        this.table_ = ((Table_.Builder)Table_.on((Composite)gamesGroup).horSpan(6)).check().scroll().header().ctrl();
        Listener sortListener = e -> {
            int selIndex = this.table_.getSelectionIndex();
            GameFilesRepository.GameDirEntry selWebProfile = selIndex != -1 ? this.games_.get(selIndex) : null;
            TableColumn column = (TableColumn)e.widget;
            int index = (Integer)column.getData();
            switch (index) {
                case 1: {
                    Collections.sort(this.games_, new GameFilesRepository.GameDirEntry.byDir());
                    break;
                }
                case 2: {
                    Collections.sort(this.games_, new GameFilesRepository.GameDirEntry.byTitle());
                    break;
                }
                case 3: {
                    Collections.sort(this.games_, new GameFilesRepository.GameDirEntry.byMain());
                    break;
                }
                case 4: {
                    Collections.sort(this.games_, new GameFilesRepository.GameDirEntry.bySetup());
                    break;
                }
                case 5: {
                    Collections.sort(this.games_, new GameFilesRepository.GameDirEntry.byPublisher());
                    break;
                }
                case 6: {
                    Collections.sort(this.games_, new GameFilesRepository.GameDirEntry.byYear());
                    break;
                }
                case 7: {
                    Collections.sort(this.games_, new GameFilesRepository.GameDirEntry.byScore());
                    break;
                }
            }
            this.table_.removeAll();
            this.populate(this.table_);
            this.table_.setSortColumn(column);
            this.table_.setSortDirection(128);
            for (int i = 0; i < this.games_.size(); ++i) {
                if (selWebProfile != this.games_.get(i)) continue;
                this.table_.setSelection(i);
                break;
            }
        };
        this.addColumn("dialog.importdir.column.choose", 0, sortListener);
        this.addColumn("dialog.importdir.column.folder", 1, sortListener);
        this.addColumn("dialog.importdir.column.title", 2, sortListener);
        this.addColumn("dialog.importdir.column.main", 3, sortListener);
        this.addColumn("dialog.importdir.column.setup", 4, sortListener);
        this.addColumn("dialog.importdir.column.publisher", 5, sortListener);
        this.addColumn("dialog.importdir.column.year", 6, sortListener);
        this.addColumn("dialog.importdir.column.score", 7, sortListener);
        Chain.on((Composite)gamesGroup).but(b -> b.text().key("button.all").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (TableItem item : ImportDirDialog.this.table_.getItems()) {
                    item.setChecked(true);
                }
            }
        })).but(b -> b.text().key("button.none").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (TableItem item : ImportDirDialog.this.table_.getItems()) {
                    item.setChecked(false);
                }
            }
        })).but(b -> b.text().key("dialog.importdir.button.deselectwithoutmain").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IntStream.range(0, ImportDirDialog.this.games_.size()).filter(x -> !((GameFilesRepository.GameDirEntry)ImportDirDialog.this.games_.get(x)).getOptMain().isPresent()).forEach(x -> ImportDirDialog.this.table_.getItem(x).setChecked(false));
            }
        })).but(b -> b.text().key("dialog.importdir.button.deselectexistinggames").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IntStream.range(0, ImportDirDialog.this.games_.size()).filter(x -> ImportDirDialog.this.existingProfiles_.stream().anyMatch(y -> ((GameFilesRepository.GameDirEntry)((ImportDirDialog)ImportDirDialog.this).games_.get((int)x)).dir_.equals(y.getCombinedConfiguration().getAutoexec().getCanonicalGameDir()))).forEach(x -> ImportDirDialog.this.table_.getItem(x).setChecked(false));
            }
        })).build();
        final Chain scoreFilter = Chain.on((Composite)gamesGroup).but(b -> b.text().key("dialog.importdir.button.deselectbelowscore")).spn(s -> s.min(10).max(100).select(35)).build();
        scoreFilter.getButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int score = scoreFilter.getSpinner().getSelection();
                IntStream.range(0, ImportDirDialog.this.games_.size()).filter(x -> ((GameFilesRepository.GameDirEntry)((ImportDirDialog)ImportDirDialog.this).games_.get((int)x)).score_ < score).forEach(x -> ImportDirDialog.this.table_.getItem(x).setChecked(false));
            }
        });
        this.addStep(gamesGroup);
        Group step6Group = Group_.on((Composite)this.shell_).layout((Layout)new GridLayout(3, false)).key("dialog.addgamewizard.step6").build();
        final Combo template = Chain.on((Composite)step6Group).lbl(l -> l.key("dialog.profile.template")).cmb(c -> c.wide().items((String[])this.templatesList_.stream().map(TitledEntity::getTitle).toArray(String[]::new)).select(BaseRepository.indexOfDefault(this.templatesList_))).combo();
        Button_.on((Composite)step6Group).text().key("dialog.profile.reloadsettings").tooltip("dialog.profile.reloadsettings.tooltip").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (template.getSelectionIndex() != -1) {
                    ImportDirDialog.this.doReloadTemplate((Template)ImportDirDialog.this.templatesList_.get(template.getSelectionIndex()));
                }
            }
        }).build();
        this.machine_ = Chain.on((Composite)step6Group).lbl(l -> l.key("dialog.template.machine")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items("profile", this.profile_.getDosboxVersion().isUsingNewMachineConfig() ? "machine073" : "machine").visibleItemCount(20).tooltip("dialog.template.machine.tooltip")).combo();
        this.core_ = Chain.on((Composite)step6Group).lbl(l -> l.key("dialog.template.core")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items("profile", "core").visibleItemCount(20).tooltip("dialog.template.core.tooltip")).combo();
        this.cycles_ = Chain.on((Composite)step6Group).lbl(l -> l.key("dialog.template.cycles")).cmb(c -> ((Combo_.Builder)c.editable().horSpan(2)).items("profile", "cycles").visibleItemCount(15).tooltip("dialog.template.cycles.tooltip")).combo();
        this.mapper_ = Chain.on((Composite)step6Group).lbl(l -> l.key("dialog.template.mapperfile")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items(new String[]{this.text_.get("dialog.addgamewizard.mapper.generic"), this.text_.get("dialog.addgamewizard.mapper.specific")}).visibleItemCount(5).tooltip("dialog.template.mapperfile.tooltip")).combo();
        this.mapper_.select(this.settings_.getBooleanValue("addgamewizard", "useuniquemapperfile") ? 1 : 0);
        this.mapper_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportDirDialog.this.settings_.setBooleanValue("addgamewizard", "useuniquemapperfile", ((Combo)event.widget).getSelectionIndex() == 1);
            }
        });
        this.consultConf_ = Chain.on((Composite)step6Group).lbl(l -> l).but(b -> ((Button_.Builder)((Button_.Builder)b.layoutData(new GridData(1, 0x1000000, false, false))).horSpan(2)).imageText("share.png", "button.consultconfsearchengine", "DBConfWS").toggle()).button();
        this.addStep(step6Group);
        this.addFinalStep("dialog.importdir.progress", "dialog.importdir.startimport");
        this.updateControlsByProfile();
    }

    private void addColumn(String title, int colIndex, Listener sortListener) {
        final String width = "importdir_column_" + (colIndex + 1) + "width";
        TableColumn column = ImportDirDialog.createTableColumn(this.table_, this.settings_.getIntValue("gui", width), title);
        column.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                ImportDirDialog.this.settings_.setIntValue("gui", width, ((TableColumn)event.widget).getWidth());
            }
        });
        column.addListener(13, sortListener);
        column.setData((Object)colIndex);
    }

    @Override
    protected void onShellOpened() {
        super.onShellOpened();
        this.nextButton_.setEnabled(false);
        new Thread(){

            @Override
            public void run() {
                try {
                    ImportDirDialog.this.defaultDosboxVersion_.resetAndLoadConfiguration();
                    GameFilesRepository repo = new GameFilesRepository();
                    List<String> knownFilenames = repo.listAllFilenames();
                    ImportDirDialog.this.display_.asyncExec(() -> ImportDirDialog.this.scanInfo_.append(ImportDirDialog.this.text_.get("dialog.importdir.notice.scandirforknownfiles", new Object[]{ImportDirDialog.this.dir_.getPath(), knownFilenames.size()}).concat("  ")));
                    ArrayList<ImmutablePair<File, byte[]>> fileMd5s = new ArrayList<ImmutablePair<File, byte[]>>();
                    for (File file : FileUtils.listFiles((File)ImportDirDialog.this.dir_, (IOFileFilter)new NameFileFilter(knownFilenames), (IOFileFilter)TrueFileFilter.INSTANCE)) {
                        fileMd5s.add((ImmutablePair<File, byte[]>)new ImmutablePair((Object)file, (Object)FilesUtils.md5(file)));
                    }
                    ImportDirDialog.this.display_.asyncExec(() -> {
                        ImportDirDialog.this.scanInfo_.append(ImportDirDialog.this.text_.get("dialog.importdir.notice.foundknownfiles", new Object[]{fileMd5s.size()}).concat(ImportDirDialog.this.scanInfo_.getLineDelimiter()));
                        ImportDirDialog.this.scanInfo_.append(ImportDirDialog.this.text_.get("dialog.importdir.notice.scoringfilesets").concat("  "));
                    });
                    Map<Integer, GameFilesRepository.GameData> games = repo.getGamesWithMd5Ids(fileMd5s);
                    ImportDirDialog.this.games_ = new ArrayList();
                    for (Map.Entry<File, List<ImmutablePair>> dirFile : fileMd5s.stream().collect(Collectors.groupingBy(x -> ((File)x.getKey()).getParentFile())).entrySet()) {
                        GameFilesRepository.GameDirEntry gameDirEntry = ImportDirDialog.constructGameDirEntry(dirFile.getKey(), dirFile.getValue(), games);
                        if (gameDirEntry == null) continue;
                        ImportDirDialog.this.games_.add(gameDirEntry);
                    }
                    Collections.sort(ImportDirDialog.this.games_);
                    ImportDirDialog.this.display_.syncExec(() -> {
                        ImportDirDialog.this.scanInfo_.append(ImportDirDialog.this.text_.get("dialog.importdir.notice.foundgames", new Object[]{ImportDirDialog.this.games_.size()}).concat(ImportDirDialog.this.scanInfo_.getLineDelimiter()));
                        ImportDirDialog.this.progress_.setVisible(false);
                        ((GridData)((ImportDirDialog)ImportDirDialog.this).progress_.getLayoutData()).exclude = true;
                        ImportDirDialog.this.finished_.setVisible(true);
                        ((GridData)((ImportDirDialog)ImportDirDialog.this).finished_.getLayoutData()).exclude = false;
                        ImportDirDialog.this.finished_.getParent().layout();
                        if (!ImportDirDialog.this.games_.isEmpty()) {
                            ImportDirDialog.this.constructGameList();
                            ImportDirDialog.this.nextButton_.setEnabled(true);
                            ImportDirDialog.this.goForward();
                        }
                    });
                }
                catch (IOException | NoSuchAlgorithmException | SQLException e) {
                    ImportDirDialog.this.display_.syncExec(() -> Mess_.on(ImportDirDialog.this.shell_).exception(e).warning());
                }
            }
        }.start();
    }

    private static GameFilesRepository.GameDirEntry constructGameDirEntry(File dir, List<ImmutablePair<File, byte[]>> files, Map<Integer, GameFilesRepository.GameData> games) throws IOException {
        for (Map.Entry<Integer, GameFilesRepository.GameData> gameData : games.entrySet()) {
            for (GameFilesRepository.FileSet set : gameData.getValue().fileSets_) {
                for (ImmutablePair<File, byte[]> file : files) {
                    String filename = ((File)file.getKey()).getName();
                    if (!set.set_.containsKey(filename)) continue;
                    GameFilesRepository.FileData fileData = set.set_.get(filename);
                    if (!Arrays.equals(fileData.md5_, (byte[])file.getValue())) continue;
                    fileData.scoreByType();
                }
            }
        }
        GameFilesRepository.FileSet set = games.values().stream().flatMap(x -> x.fileSets_.stream()).max(Comparator.comparing(GameFilesRepository.FileSet::getScore)).orElse(null);
        if (set == null || set.getScore() <= 0) {
            return null;
        }
        List<File> exes = FilesUtils.listExecutablesInDirRecursive(dir);
        if (exes.isEmpty()) {
            return null;
        }
        Map.Entry game = games.entrySet().stream().filter(x -> ((GameFilesRepository.GameData)x.getValue()).fileSets_.contains(set)).findFirst().orElse(null);
        if (game == null) {
            return null;
        }
        GameFilesRepository.GameDirEntry result = new GameFilesRepository.GameDirEntry(dir, set.set_.entrySet().stream().filter(x -> ((GameFilesRepository.FileData)x.getValue()).type_ == GameFilesRepository.FileType.MAIN && ((GameFilesRepository.FileData)x.getValue()).getScore() > 0 && exes.stream().anyMatch(y -> y.getName().equals(x.getKey()))).map(x -> new File(dir, (String)x.getKey())).findFirst(), set.set_.entrySet().stream().filter(x -> ((GameFilesRepository.FileData)x.getValue()).type_ == GameFilesRepository.FileType.SETUP && ((GameFilesRepository.FileData)x.getValue()).getScore() > 0 && exes.stream().anyMatch(y -> y.getName().equals(x.getKey()))).map(x -> new File(dir, (String)x.getKey())).findFirst(), exes, MetropolisSearchEngine.getInstance().getEntryDetailedInformation(((GameFilesRepository.GameData)game.getValue()).webProfile_), set.getScore(), set.set_.entrySet().stream().sorted((o1, o2) -> {
            int comp = Integer.compare(((GameFilesRepository.FileData)o2.getValue()).getScore(), ((GameFilesRepository.FileData)o1.getValue()).getScore());
            return comp == 0 ? ((String)o1.getKey()).compareTo((String)o2.getKey()) : comp;
        }).map(x -> (String)x.getKey() + " (" + ((GameFilesRepository.FileData)x.getValue()).getScore() + ")").collect(Collectors.joining(", ")));
        games.values().forEach(x -> x.fileSets_.forEach(y -> y.set_.values().forEach(GameFilesRepository.FileData::resetScore)));
        return result;
    }

    @Override
    protected boolean onNext(int step) {
        if (step == 1) {
            return this.conditionsForStep2Ok();
        }
        if (step != 2) {
            if (step == 3) {
                if (this.mapper_.getSelectionIndex() == 1) {
                    this.profile_.setValue("sdl", "mapperfile", this.settings_.getValue("profile", "uniquemapperfile"));
                }
                this.updateProfileByControls();
                List<GameFilesRepository.GameDirEntry> games = IntStream.range(0, this.games_.size()).filter(x -> this.table_.getItem(x).getChecked()).mapToObj(x -> this.games_.get(x)).collect(Collectors.toList());
                this.job_ = new ImportDirThread(this.log_, this.progressBar_, this.status_, games, this.profile_, this.consultConf_.getSelection());
            } else if (step == 4) {
                if (this.job_.isEverythingOk()) {
                    Mess_.on(this.shell_).key("dialog.import.notice.importok").display();
                } else {
                    Mess_.on(this.shell_).key("dialog.import.error.problem").warning();
                }
                this.status_.setText(this.text_.get("dialog.export.reviewlog"));
                this.status_.pack();
                this.result_ = this.job_ != null;
            }
        }
        return true;
    }

    private void populate(Table table) {
        for (GameFilesRepository.GameDirEntry game : this.games_) {
            TableItem newItemTableItem = new TableItem(table, 0);
            newItemTableItem.setChecked(game.getOptMain().isPresent() && this.existingProfiles_.stream().noneMatch(x -> game.dir_.equals(x.getCombinedConfiguration().getAutoexec().getCanonicalGameDir())));
            newItemTableItem.setText(1, game.dir_.getPath());
            newItemTableItem.setText(2, game.webProfile_.getTitle());
            newItemTableItem.setText(3, game.getOptMain().isPresent() ? game.getMain().getName() + (game.executables_.size() > 1 ? " \u25be" : "") : TRIANGLE_DOWN);
            newItemTableItem.setText(4, game.getOptSetup().isPresent() ? game.getSetup().getName() + (game.executables_.size() > 1 ? " \u25be" : "") : (game.executables_.size() > 1 ? TRIANGLE_DOWN : ""));
            newItemTableItem.setText(5, StringUtils.defaultString((String)game.webProfile_.getPublisherName()));
            newItemTableItem.setText(6, game.webProfile_.getYear());
            newItemTableItem.setText(7, Integer.toString(game.score_));
            newItemTableItem.setData((Object)game.explanation_);
        }
    }

    private void constructGameList() {
        this.populate(this.table_);
        TableEditor editor = new TableEditor(this.table_);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        this.table_.addListener(3, event -> {
            Control existingEditorControl = editor.getEditor();
            if (existingEditorControl != null) {
                existingEditorControl.dispose();
            }
            Rectangle clientArea = this.table_.getClientArea();
            Point pt = new Point(event.x, event.y);
            for (int index = this.table_.getTopIndex(); index < this.table_.getItemCount(); ++index) {
                boolean visible = false;
                TableItem item = this.table_.getItem(index);
                GameFilesRepository.GameDirEntry game = this.games_.get(index);
                for (int i = 0; i < this.table_.getColumnCount(); ++i) {
                    Rectangle rect = item.getBounds(i);
                    if (rect.contains(pt)) {
                        int column = i;
                        if (column == 2) {
                            Text title = new Text((Composite)this.table_, 0);
                            title.setText(item.getText(i));
                            title.selectAll();
                            title.setFocus();
                            editor.setEditor((Control)title, item, i);
                            Listener textListener = e -> {
                                if (e.type == 16) {
                                    game.webProfile_.setTitle(title.getText());
                                    title.dispose();
                                } else if (e.type == 31) {
                                    if (e.detail == 4) {
                                        game.webProfile_.setTitle(title.getText());
                                    }
                                    if (e.detail == 4 || e.detail == 2) {
                                        title.dispose();
                                        e.doit = false;
                                    }
                                }
                                item.setText(column, game.webProfile_.getTitle());
                            };
                            title.addListener(16, textListener);
                            title.addListener(31, textListener);
                            return;
                        }
                        if (column == 3 || column == 4) {
                            if (column == 3 && game.getOptMain().isPresent() && game.executables_.size() <= 1 || column == 4 && game.executables_.size() <= 1) {
                                return;
                            }
                            Combo combo = new Combo((Composite)this.table_, 8);
                            combo.setItems((String[])game.executables_.stream().map(File::getName).toArray(String[]::new));
                            combo.add("-", 0);
                            if (column == 3 && game.getOptMain().isPresent()) {
                                combo.setText(game.getMain().getName());
                            } else if (column == 4 && game.getOptSetup().isPresent()) {
                                combo.setText(game.getSetup().getName());
                            } else {
                                combo.select(0);
                            }
                            editor.setEditor((Control)combo, item, i);
                            combo.setFocus();
                            Listener comboListener = e -> {
                                Optional<File> optFile;
                                Optional<File> optional = optFile = combo.getSelectionIndex() == 0 ? Optional.empty() : Optional.of(new File(game.dir_, combo.getText()));
                                if (e.type == 13) {
                                    if (column == 3) {
                                        game.setOptMain(optFile);
                                    } else {
                                        game.setOptSetup(optFile);
                                    }
                                    combo.dispose();
                                } else if (e.type == 31) {
                                    if (e.detail == 4) {
                                        if (column == 3) {
                                            game.setOptMain(optFile);
                                        } else {
                                            game.setOptSetup(optFile);
                                        }
                                    }
                                    if (e.detail == 4 || e.detail == 2) {
                                        combo.dispose();
                                        e.doit = false;
                                    }
                                }
                                if (column == 3) {
                                    item.setText(column, game.getOptMain().isPresent() ? game.getMain().getName() + (game.executables_.size() > 1 ? " \u25be" : "") : TRIANGLE_DOWN);
                                } else {
                                    item.setText(column, game.getOptSetup().isPresent() ? game.getSetup().getName() + (game.executables_.size() > 1 ? " \u25be" : "") : (game.executables_.size() > 1 ? TRIANGLE_DOWN : ""));
                                }
                            };
                            combo.addListener(13, comboListener);
                            combo.addListener(31, comboListener);
                            return;
                        }
                    }
                    if (visible || !rect.intersects(clientArea)) continue;
                    visible = true;
                }
                if (visible) continue;
                return;
            }
        });
        final Listener labelListener = event -> {
            Label label = (Label)event.widget;
            Shell labelShell = label.getShell();
            if (event.type == 3) {
                Event e = new Event();
                e.item = (TableItem)label.getData("_TABLEITEM");
                this.table_.setSelection(new TableItem[]{(TableItem)e.item});
                this.table_.notifyListeners(13, e);
                labelShell.dispose();
                this.table_.setFocus();
            } else if (event.type == 7) {
                labelShell.dispose();
            }
        };
        Listener tableListener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        Rectangle rectColumnScore;
                        Point pt = new Point(event.x, event.y);
                        TableItem item = ImportDirDialog.this.table_.getItem(pt);
                        if (item == null) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        if (!(rectColumnScore = item.getBounds(7)).contains(pt)) break;
                        this.tip = new Shell(ImportDirDialog.this.shell_, 540676);
                        this.tip.setBackground(ImportDirDialog.this.display_.getSystemColor(29));
                        FillLayout layout = new FillLayout();
                        layout.marginWidth = 2;
                        this.tip.setLayout((Layout)layout);
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(ImportDirDialog.this.display_.getSystemColor(28));
                        this.label.setBackground(ImportDirDialog.this.display_.getSystemColor(29));
                        this.label.setData("_TABLEITEM", (Object)item);
                        this.label.setText((String)item.getData());
                        this.label.addListener(7, labelListener);
                        this.label.addListener(3, labelListener);
                        Point size = this.tip.computeSize(-1, -1);
                        Point p = ImportDirDialog.this.table_.toDisplay(rectColumnScore.x, rectColumnScore.y);
                        this.tip.setBounds(p.x - size.x - 5, p.y - 1, size.x, size.y);
                        this.tip.setVisible(true);
                        break;
                    }
                }
            }
        };
        this.table_.addListener(12, tableListener);
        this.table_.addListener(1, tableListener);
        this.table_.addListener(5, tableListener);
        this.table_.addListener(32, tableListener);
    }

    private boolean conditionsForStep2Ok() {
        Mess_.Builder mess = Mess_.on(this.shell_);
        if (Stream.of(this.table_.getItems()).noneMatch(TableItem::getChecked)) {
            mess.key("dialog.importdir.required.onegametoimport").bind((Control)this.table_);
        }
        for (int i = 0; i < this.games_.size(); ++i) {
            if (!this.table_.getItem(i).getChecked()) continue;
            GameFilesRepository.GameDirEntry game = this.games_.get(i);
            if (!game.getOptMain().isPresent() || StringUtils.isBlank((CharSequence)game.getMain().getName())) {
                mess.key("dialog.importdir.required.main").bind((Control)this.table_);
            }
            if (!StringUtils.isBlank((CharSequence)game.webProfile_.getTitle())) continue;
            mess.key("dialog.importdir.required.title").bind((Control)this.table_);
        }
        return mess.valid();
    }

    private void doReloadTemplate(Template template) {
        try {
            StringBuilder warningsLog = new StringBuilder();
            warningsLog.append(template.resetAndLoadConfiguration());
            warningsLog.append(this.profile_.reloadTemplate(this.profile_.getDosboxVersion(), template));
            this.updateControlsByProfile();
            if (StringUtils.isNotEmpty((CharSequence)warningsLog)) {
                Mess_.on(this.getParent()).txt(warningsLog.toString()).warning();
            }
        }
        catch (IOException e) {
            Mess_.on(this.getParent()).exception(e).warning();
        }
    }

    private void updateControlsByProfile() {
        Configuration combinedConf = this.profile_.getCombinedConfiguration();
        this.machine_.setText(combinedConf.getValue("dosbox", "machine"));
        this.core_.setText(combinedConf.getValue("cpu", "core"));
        this.cycles_.setText(combinedConf.getValue("cpu", "cycles"));
    }

    private void updateProfileByControls() {
        this.profile_.setValue("dosbox", "machine", this.machine_.getText());
        this.profile_.setValue("cpu", "core", this.core_.getText());
        this.profile_.setValue("cpu", "cycles", this.cycles_.getText());
    }
}

