/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.aggregate;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.dbgl.exception.DrivelettersExhaustedException;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.model.FileLocation;
import org.dbgl.model.Link;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.ProfileStats;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.conf.Autoexec;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.conf.GenerationAwareConfiguration;
import org.dbgl.model.conf.mount.Mount;
import org.dbgl.model.entity.TemplateProfileBase;
import org.dbgl.model.factory.MountFactory;
import org.dbgl.service.FileLocationService;
import org.dbgl.service.TextService;
import org.dbgl.util.FilesUtils;

public class Profile
extends TemplateProfileBase {
    public static final int NR_OF_CUSTOM_STRING_DROPDOWNS = 4;
    public static final int NR_OF_CUSTOM_STRING_FIELDS_1 = 4;
    public static final int NR_OF_CUSTOM_STRING_FIELDS_2 = 4;
    public static final int NR_OF_CUSTOM_STRING_FIELDS = 8;
    public static final int NR_OF_CUSTOM_STRINGS = 12;
    public static final int NR_OF_CUSTOM_INTS = 2;
    public static final int NR_OF_LINK_TITLES = 8;
    public static final int NR_OF_LINK_DESTINATIONS = 8;
    public static final int NR_OF_LINK_STRINGS = 16;
    public static final int NR_OF_ALT_EXECUTABLES = 2;
    private String developer_;
    private String publisher_;
    private String genre_;
    private String year_;
    private String status_;
    private String notes_;
    private String setupParams_;
    private Boolean favorite_;
    private String[] customStrings_;
    private String[] altExeParams_;
    private Integer[] customInts_;
    private Link[] links_;
    private FileLocation captures_;
    private FileLocation setup_;
    private FileLocation[] altExe_;
    private ProfileStats profileStats_;

    public String getDeveloper() {
        return this.developer_;
    }

    public void setDeveloper(String developer) {
        this.developer_ = developer;
    }

    public String getPublisher() {
        return this.publisher_;
    }

    public void setPublisher(String publisher) {
        this.publisher_ = publisher;
    }

    public String getGenre() {
        return this.genre_;
    }

    public void setGenre(String genre) {
        this.genre_ = genre;
    }

    public String getYear() {
        return this.year_;
    }

    public void setYear(String year) {
        this.year_ = year;
    }

    public String getStatus() {
        return this.status_;
    }

    public void setStatus(String status) {
        this.status_ = status;
    }

    public Boolean isFavorite() {
        return this.favorite_;
    }

    public String getFavorite() {
        return BooleanUtils.toStringTrueFalse((Boolean)this.favorite_);
    }

    public void setFavorite(Boolean favorite) {
        this.favorite_ = favorite;
    }

    public void setFavorite(String favorite) {
        this.favorite_ = StringUtils.isNotBlank((CharSequence)favorite) ? Boolean.valueOf(favorite) : null;
    }

    public String getNotes() {
        return this.notes_;
    }

    public void setNotes(String notes) {
        this.notes_ = notes;
    }

    public String getSetupParams() {
        return this.setupParams_;
    }

    public void setSetupParams(String setupParams) {
        this.setupParams_ = setupParams;
    }

    public String[] getAltExeParams() {
        return this.altExeParams_;
    }

    public void setAltExeParams(String[] altExeParams) {
        this.altExeParams_ = altExeParams;
    }

    public Link[] getLinks() {
        return this.links_;
    }

    public void setLinks(Link[] link) {
        this.links_ = link;
    }

    public String getLinkDestination(int index) {
        return this.links_[index].getDestination();
    }

    public void setLinkDestination(int index, String destination) {
        this.links_[index] = new Link(this.links_[index].getTitle(), destination);
    }

    public String getLinkTitle(int index) {
        return this.links_[index].getTitle();
    }

    public void setLinkTitle(int index, String title) {
        this.links_[index] = new Link(title, this.links_[index].getDestination());
    }

    public String[] getCustomStrings() {
        return this.customStrings_;
    }

    public void setCustomStrings(String[] customString) {
        this.customStrings_ = customString;
    }

    public String getCustomString(int index) {
        return this.customStrings_[index];
    }

    public void setCustomString(int index, String customString) {
        this.customStrings_[index] = customString;
    }

    public int[] getCustomInts() {
        return ArrayUtils.toPrimitive((Integer[])this.customInts_);
    }

    public void setCustomInts(int[] customInt) {
        this.customInts_ = ArrayUtils.toObject((int[])customInt);
    }

    public String getCustomInt(int index) {
        return Objects.toString(this.customInts_[index], null);
    }

    public void setCustomInt(int index, String customInt) {
        this.customInts_[index] = NumberUtils.createInteger((String)customInt);
    }

    public void resetAllCustomValues() {
        Object[] customStrings = new String[12];
        Arrays.fill(customStrings, "");
        this.setCustomStrings((String[])customStrings);
        this.setCustomInts(new int[]{0, 0});
    }

    public ProfileStats getProfileStats() {
        return this.profileStats_;
    }

    public void setProfileStats(ProfileStats profileStats) {
        this.profileStats_ = profileStats;
    }

    public boolean hasSetup() {
        return this.setup_ != null;
    }

    public String getSetupString() {
        return this.setup_ != null ? this.setup_.getFile().getPath() : "";
    }

    public void setSetupFileLocation(String setup) {
        this.setup_ = StringUtils.isNotBlank((CharSequence)setup) ? new FileLocation(FilenameUtils.separatorsToSystem((String)setup), FileLocationService.getInstance().dosrootRelative()) : null;
    }

    public String[] getAltExeFilenames() {
        return FilesUtils.listFileNames(this.altExe_);
    }

    public String[] getAltExeStrings() {
        return FilesUtils.listFilePaths(this.altExe_);
    }

    public boolean hasAltExe(int i) {
        return this.altExe_[i] != null;
    }

    public String getAltExeString(int index) {
        return this.getAltExeStrings()[index];
    }

    public void setAltExeFileLocations(String[] altExe) {
        this.altExe_ = new FileLocation[altExe.length];
        for (int i = 0; i < altExe.length; ++i) {
            this.altExe_[i] = StringUtils.isNotBlank((CharSequence)altExe[i]) ? new FileLocation(FilenameUtils.separatorsToSystem((String)altExe[i]), FileLocationService.getInstance().dataRelative()) : null;
        }
    }

    public void setAltExeFileLocation(int index, String altExe) {
        this.altExe_[index] = StringUtils.isNotBlank((CharSequence)altExe) ? new FileLocation(FilenameUtils.separatorsToSystem((String)altExe), FileLocationService.getInstance().dataRelative()) : null;
    }

    public String getAltExeParam(int index) {
        return this.altExeParams_[index];
    }

    public void setAltExeParam(int index, String altExeParams) {
        this.altExeParams_[index] = altExeParams;
    }

    public File getCapturesFile() {
        return this.captures_.getFile();
    }

    public String getCapturesString() {
        return this.captures_ != null ? this.captures_.getFile().getPath() : "";
    }

    public File getCanonicalCaptures() {
        return this.captures_.getCanonicalFile();
    }

    public String getCapturesUrl() {
        try {
            return FilesUtils.toUrl(this.getCanonicalCaptures());
        }
        catch (MalformedURLException e) {
            return this.getCanonicalCaptures().getPath();
        }
    }

    public void setCapturesFileLocation(String captures) {
        this.captures_ = StringUtils.isNotBlank((CharSequence)captures) ? new FileLocation(FilenameUtils.separatorsToSystem((String)captures), FileLocationService.getInstance().dataRelative()) : null;
    }

    public void setCapturesById() {
        this.captures_ = new FileLocation(FileLocationService.CAPTURES_DIR_STRING + String.valueOf(this.getId()), FileLocationService.getInstance().dataRelative());
    }

    public String getCapturesStringForConfig() {
        File baseDir = null;
        GenerationAwareConfiguration.Generation gen = this.getDosboxVersion().getGeneration();
        baseDir = gen.ordinal() < GenerationAwareConfiguration.Generation.GEN_073.ordinal() ? new FileLocation(this.getDosboxVersion().getCwd().getPath(), FileLocationService.getInstance().dataRelative()).getFile() : this.getConfigurationFile().getParentFile();
        return baseDir.isAbsolute() ? this.getCanonicalCaptures().getPath() : FilesUtils.relativize(baseDir, this.getCapturesFile());
    }

    public void setCapturesInConfig() {
        this.getConfiguration().setValue("dosbox", "captures", this.getCapturesStringForConfig());
    }

    public File getCustomMapperFile() {
        File mapperFile;
        String customMapperfile;
        if (this.getConfiguration().hasValue("sdl", "mapperfile") && StringUtils.isNotBlank((CharSequence)(customMapperfile = this.getConfiguration().getValue("sdl", "mapperfile"))) && FilesUtils.isExistingFile(mapperFile = new File(this.getConfigurationCanonicalFile().getParentFile(), customMapperfile))) {
            return mapperFile;
        }
        return null;
    }

    public void updateMapperFileInConfigByIdentifiers() {
        String oldMapperFile = this.getCombinedConfiguration().getValue("sdl", "mapperfile");
        if (StringUtils.isNotBlank((CharSequence)oldMapperFile)) {
            String newMapperFile = String.format(oldMapperFile, this.getId(), FilesUtils.toSafeFilename(this.getTitle()));
            this.getConfiguration().updateValue("sdl", "mapperfile", newMapperFile);
        }
    }

    public void setConfigurationFileLocation(String file) {
        this.getConfiguration().setFileLocation(StringUtils.isNotBlank((CharSequence)file) ? new FileLocation(FilenameUtils.separatorsToSystem((String)file), FileLocationService.getInstance().dataRelative()) : null);
    }

    @Override
    public void setConfigurationFileLocationByIdentifiers() {
        File gameDir = this.getCombinedConfiguration().getAutoexec().getCanonicalGameDir();
        this.getConfiguration().setFileLocation(FileLocationService.getInstance().getUniqueProfileConfigFileLocation(this.getId(), this.getTitle(), gameDir));
    }

    @Override
    public void setBooter(boolean booter) {
        if (booter) {
            this.getConfiguration().getAutoexec().setMain("");
            this.getConfiguration().getAutoexec().setParameters("");
        } else {
            this.getConfiguration().getAutoexec().setImg1("");
            this.getConfiguration().getAutoexec().setImg2("");
            this.getConfiguration().getAutoexec().setImg3("");
        }
    }

    public void setAutoexecSettings(String main, String parameters) {
        Autoexec autoexec = this.getConfiguration().getAutoexec();
        autoexec.setMain(main);
        autoexec.setParameters(parameters);
    }

    public void setAutoexecSettings(Boolean pause, Boolean exit) {
        Autoexec autoexec = this.getConfiguration().getAutoexec();
        autoexec.setPause(pause);
        autoexec.setExit(exit);
    }

    public void setAutoexecSettings(String img1, String img2, String img3, String imgDriveletter) {
        Autoexec autoexec = this.getConfiguration().getAutoexec();
        autoexec.setImg1(img1);
        autoexec.setImg2(img2);
        autoexec.setImg3(img3);
        autoexec.setImgDriveletter(imgDriveletter);
    }

    public Configuration getConfigurationForSharing() {
        Configuration conf = new Configuration(this.getConfiguration());
        conf.removeValueIfSet("sdl", "fullscreen");
        conf.removeValueIfSet("sdl", "fulldouble");
        conf.removeValueIfSet("sdl", "fullresolution");
        conf.removeValueIfSet("sdl", "windowresolution");
        conf.removeValueIfSet("sdl", "output");
        conf.removeValueIfSet("sdl", "mapperfile");
        conf.removeValueIfSet("dosbox", "language");
        conf.removeValueIfSet("dosbox", "captures");
        conf.removeValueIfSet("render", "scaler");
        conf.removeValueIfSet("midi", "midiconfig");
        conf.setAutoexec(new Autoexec());
        return conf;
    }

    @Override
    public String resetAndLoadConfiguration() throws IOException {
        StringBuilder warningsLog = new StringBuilder();
        warningsLog.append(super.resetAndLoadConfiguration());
        if (this.getConfiguration().getFileLocation() != null && this.isIncomplete()) {
            warningsLog.append(TextService.getInstance().get("general.error.profileincomplete", new String[]{this.getConfigurationCanonicalFile().getPath()}));
        }
        return warningsLog.toString();
    }

    public boolean isIncomplete() {
        return this.getConfiguration().getAutoexec().isIncomplete(this.getNettoMountingPoints());
    }

    public String getRequiredMount(boolean booter, String hostFileLocation, boolean pathOnly, boolean forInstaller) {
        if (this.getConfiguration().getAutoexec().canBeReachedUsingMounts(booter, hostFileLocation, this.getNettoMountingPoints())) {
            return null;
        }
        try {
            FileLocation fileLocation;
            File[] overrideFilesToMount;
            Mount mount = null;
            if (forInstaller && (overrideFilesToMount = FilesUtils.listFileSequence(FilesUtils.determineMainFile((fileLocation = new FileLocation(hostFileLocation, FileLocationService.getInstance().dosrootRelative())).getCanonicalFile()))).length > 1) {
                mount = MountFactory.create(booter, hostFileLocation, this.getNettoMountedDrives(), overrideFilesToMount);
            }
            if (mount == null) {
                mount = MountFactory.create(booter, hostFileLocation, this.getNettoMountedDrives());
            }
            return pathOnly ? mount.getPathString() : mount.toString();
        }
        catch (DrivelettersExhaustedException | InvalidMountstringException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void addRequiredMount(boolean booter, String hostFileLocation, boolean forInstaller) {
        this.addMount(this.getRequiredMount(booter, hostFileLocation, false, forInstaller));
    }

    public String loadTemplate(DosboxVersion dstDosboxVersion, Template template) throws IOException {
        this.getConfiguration().load(template.getConfiguration());
        this.getConfiguration().getAutoexec().setExit(template.getConfiguration().getAutoexec().isExit());
        for (int i = 0; i < Autoexec.SECTIONS; ++i) {
            String templCustom = template.getConfiguration().getAutoexec().getCustomSection(i);
            if (!StringUtils.isNotBlank((CharSequence)templCustom)) continue;
            this.getConfiguration().getAutoexec().setCustomSection(i, templCustom);
        }
        if (StringUtils.isBlank((CharSequence)this.getConfiguration().getAutoexec().getMain()) && StringUtils.isBlank((CharSequence)this.getConfiguration().getAutoexec().getImg1())) {
            this.getConfiguration().getAutoexec().setBooterByDefault(template.getConfiguration().getAutoexec().isBooter());
        }
        if (this.getMountingPointsForUI().isEmpty()) {
            this.getConfiguration().getAutoexec().setMountingpoints(template.getConfiguration().getAutoexec().getMountingpoints());
        }
        if (template.getNativeCommands().size() != 1) {
            this.setNativeCommands(template.getNativeCommands());
        }
        return this.setToDosboxVersion(dstDosboxVersion);
    }

    public String reloadTemplate(DosboxVersion dstDosboxVersion, Template template) throws IOException {
        this.getConfiguration().setSections(template.getConfiguration().getSections());
        this.getConfiguration().getAutoexec().setExit(template.getConfiguration().getAutoexec().isExit());
        this.getConfiguration().getAutoexec().setCustomSections(template.getConfiguration().getAutoexec().getCustomSections());
        if (StringUtils.isBlank((CharSequence)this.getConfiguration().getAutoexec().getMain()) && StringUtils.isBlank((CharSequence)this.getConfiguration().getAutoexec().getImg1())) {
            this.getConfiguration().getAutoexec().setBooterByDefault(template.getConfiguration().getAutoexec().isBooter());
        }
        if (this.getMountingPointsForUI().isEmpty()) {
            this.getConfiguration().getAutoexec().setMountingpoints(template.getConfiguration().getAutoexec().getMountingpoints());
        }
        this.setNativeCommands(template.getNativeCommands());
        return this.setToDosboxVersion(dstDosboxVersion);
    }

    public void setBaseDir(File baseDir) {
        this.getConfiguration().getAutoexec().setBaseDir(baseDir);
        for (Link link : this.getLinks()) {
            link.setBaseDir(baseDir);
        }
        if (this.hasSetup()) {
            this.setup_ = FilesUtils.concat(baseDir, this.setup_);
        }
        for (int i = 0; i < 2; ++i) {
            if (!this.hasAltExe(i)) continue;
            this.altExe_[i] = FilesUtils.concat(baseDir, this.altExe_[i]);
        }
    }

    public void migrate(FileLocation fromPath, FileLocation toPath) {
        this.getConfiguration().getAutoexec().migrate(fromPath, toPath);
        for (Link link : this.getLinks()) {
            link.migrate(fromPath, toPath);
        }
        if (this.hasSetup()) {
            this.setup_ = FilesUtils.migrate(this.setup_, fromPath, toPath);
        }
        for (int i = 0; i < 2; ++i) {
            if (!this.hasAltExe(i)) continue;
            this.altExe_[i] = FilesUtils.migrate(this.altExe_[i], fromPath, toPath);
        }
        FileLocation conf = this.getConfiguration().getFileLocation();
        if (conf != null) {
            this.getConfiguration().setFileLocation(FilesUtils.migrate(conf, fromPath, toPath));
        }
    }

    public void removeUnequalValuesIn(Profile prof) {
        int i;
        if (!StringUtils.equals((CharSequence)this.getTitle(), (CharSequence)prof.getTitle())) {
            this.setTitle(null);
        }
        if (!StringUtils.equals((CharSequence)this.getDeveloper(), (CharSequence)prof.getDeveloper())) {
            this.setDeveloper(null);
        }
        if (!StringUtils.equals((CharSequence)this.getPublisher(), (CharSequence)prof.getPublisher())) {
            this.setPublisher(null);
        }
        if (!StringUtils.equals((CharSequence)this.getGenre(), (CharSequence)prof.getGenre())) {
            this.setGenre(null);
        }
        if (!StringUtils.equals((CharSequence)this.getYear(), (CharSequence)prof.getYear())) {
            this.setYear(null);
        }
        if (!StringUtils.equals((CharSequence)this.getStatus(), (CharSequence)prof.getStatus())) {
            this.setStatus(null);
        }
        if (!StringUtils.equals((CharSequence)this.getNotes(), (CharSequence)prof.getNotes())) {
            this.setNotes(null);
        }
        if (!StringUtils.equals((CharSequence)this.getFavorite(), (CharSequence)prof.getFavorite())) {
            this.setFavorite((Boolean)null);
        }
        for (i = 0; i < 8; ++i) {
            if (!StringUtils.equals((CharSequence)this.getLinkTitle(i), (CharSequence)prof.getLinkTitle(i))) {
                this.setLinkTitle(i, null);
            }
            if (StringUtils.equals((CharSequence)this.getLinkDestination(i), (CharSequence)prof.getLinkDestination(i))) continue;
            this.setLinkDestination(i, null);
        }
        for (i = 0; i < 12; ++i) {
            if (StringUtils.equals((CharSequence)this.getCustomString(i), (CharSequence)prof.getCustomString(i))) continue;
            this.setCustomString(i, null);
        }
        for (i = 0; i < 2; ++i) {
            if (StringUtils.equals((CharSequence)this.getCustomInt(i), (CharSequence)prof.getCustomInt(i))) continue;
            this.setCustomInt(i, null);
        }
        List<NativeCommand> natvCtrls = this.getNativeCommands();
        List<NativeCommand> profNatvCtrls = prof.getNativeCommands();
        if (natvCtrls == null || profNatvCtrls == null || natvCtrls.size() != profNatvCtrls.size()) {
            this.setNativeCommands(null);
        } else {
            for (int i2 = 0; i2 < natvCtrls.size(); ++i2) {
                if (StringUtils.equals((CharSequence)natvCtrls.get(i2).toString(), (CharSequence)profNatvCtrls.get(i2).toString())) continue;
                this.setNativeCommands(null);
                break;
            }
        }
    }
}

