/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.repository;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.dbgl.model.entity.IEntity;
import org.dbgl.model.entity.ITitledEntity;
import org.dbgl.model.entity.TitledEntity;
import org.dbgl.model.repository.BaseRepository;
import org.dbgl.service.DatabaseService;
import org.dbgl.service.TextService;

public class TitledEntityRepository
extends BaseRepository<ITitledEntity> {
    private static final String CREATE_DEVELOPER_QRY = "INSERT INTO DEVELOPERS(NAME) VALUES (?)";
    private static final String CREATE_PUBLISHER_QRY = "INSERT INTO PUBLISHERS(NAME) VALUES (?)";
    private static final String CREATE_GENRE_QRY = "INSERT INTO GENRES(NAME) VALUES (?)";
    private static final String CREATE_YEAR_QRY = "INSERT INTO PUBLYEARS(YEAR) VALUES (?)";
    private static final String CREATE_STATUS_QRY = "INSERT INTO STATUS(STAT) VALUES (?)";
    private static final String[] CREATE_CUSTOM_QRY = new String[]{"INSERT INTO CUSTOM1(VALUE) VALUES (?)", "INSERT INTO CUSTOM2(VALUE) VALUES (?)", "INSERT INTO CUSTOM3(VALUE) VALUES (?)", "INSERT INTO CUSTOM4(VALUE) VALUES (?)"};
    private static final String DEVELOPER_LIST_QRY = "SELECT ID, NAME FROM DEVELOPERS ORDER BY NAME";
    private static final String PUBLISHER_LIST_QRY = "SELECT ID, NAME FROM PUBLISHERS ORDER BY NAME";
    private static final String GENRE_LIST_QRY = "SELECT ID, NAME FROM GENRES ORDER BY NAME";
    private static final String PUBLYEAR_LIST_QRY = "SELECT ID, YEAR FROM PUBLYEARS ORDER BY YEAR";
    private static final String STATUS_LIST_QRY = "SELECT ID, STAT FROM STATUS ORDER BY STAT";
    private static final String[] CUSTOM_LIST_QRY = new String[]{"SELECT ID, VALUE FROM CUSTOM1 ORDER BY VALUE", "SELECT ID, VALUE FROM CUSTOM2 ORDER BY VALUE", "SELECT ID, VALUE FROM CUSTOM3 ORDER BY VALUE", "SELECT ID, VALUE FROM CUSTOM4 ORDER BY VALUE"};
    private static final String CLEANUP_QRY = "DELETE FROM DEVELOPERS WHERE ID NOT IN (SELECT DISTINCT DEV_ID FROM GAMES);DELETE FROM PUBLISHERS WHERE ID NOT IN (SELECT DISTINCT PUBL_ID FROM GAMES); DELETE FROM GENRES WHERE ID NOT IN (SELECT DISTINCT GENRE_ID FROM GAMES);DELETE FROM PUBLYEARS WHERE ID NOT IN (SELECT DISTINCT YEAR_ID FROM GAMES); DELETE FROM STATUS WHERE ID NOT IN (SELECT DISTINCT STAT_ID FROM GAMES);DELETE FROM CUSTOM1 WHERE ID NOT IN (SELECT DISTINCT CUST1_ID FROM GAMES); DELETE FROM CUSTOM2 WHERE ID NOT IN (SELECT DISTINCT CUST2_ID FROM GAMES);DELETE FROM CUSTOM3 WHERE ID NOT IN (SELECT DISTINCT CUST3_ID FROM GAMES); DELETE FROM CUSTOM4 WHERE ID NOT IN (SELECT DISTINCT CUST4_ID FROM GAMES)";

    public List<ITitledEntity> listDevelopers(DatabaseService.Transaction transaction) throws SQLException {
        return this.listAll(DEVELOPER_LIST_QRY, transaction);
    }

    public List<ITitledEntity> listPublishers(DatabaseService.Transaction transaction) throws SQLException {
        return this.listAll(PUBLISHER_LIST_QRY, transaction);
    }

    public List<ITitledEntity> listGenres(DatabaseService.Transaction transaction) throws SQLException {
        return this.listAll(GENRE_LIST_QRY, transaction);
    }

    public List<ITitledEntity> listYears(DatabaseService.Transaction transaction) throws SQLException {
        return this.listAll(PUBLYEAR_LIST_QRY, transaction);
    }

    public List<ITitledEntity> listStatus(DatabaseService.Transaction transaction) throws SQLException {
        return this.listAll(STATUS_LIST_QRY, transaction);
    }

    public List<ITitledEntity> listCustomValues(int index, DatabaseService.Transaction transaction) throws SQLException {
        return this.listAll(CUSTOM_LIST_QRY[index], transaction);
    }

    public int findDeveloper(String developer, DatabaseService.Transaction transaction) throws SQLException {
        return TitledEntityRepository.findIdByValue(this.listDevelopers(transaction), developer);
    }

    public int findPublisher(String publisher, DatabaseService.Transaction transaction) throws SQLException {
        return TitledEntityRepository.findIdByValue(this.listPublishers(transaction), publisher);
    }

    public int findGenre(String genre, DatabaseService.Transaction transaction) throws SQLException {
        return TitledEntityRepository.findIdByValue(this.listGenres(transaction), genre);
    }

    public int findYear(String year, DatabaseService.Transaction transaction) throws SQLException {
        return TitledEntityRepository.findIdByValue(this.listYears(transaction), year);
    }

    public int findStatus(String status, DatabaseService.Transaction transaction) throws SQLException {
        return TitledEntityRepository.findIdByValue(this.listStatus(transaction), status);
    }

    public int findCustomValue(int index, String value, DatabaseService.Transaction transaction) throws SQLException {
        return TitledEntityRepository.findIdByValue(this.listCustomValues(index, transaction), value);
    }

    public static int addDeveloper(DatabaseService.Transaction transaction, String developer) throws SQLException {
        return TitledEntityRepository.addValue(transaction, CREATE_DEVELOPER_QRY, developer);
    }

    public static int addPublisher(DatabaseService.Transaction transaction, String publisher) throws SQLException {
        return TitledEntityRepository.addValue(transaction, CREATE_PUBLISHER_QRY, publisher);
    }

    public static int addGenre(DatabaseService.Transaction transaction, String genre) throws SQLException {
        return TitledEntityRepository.addValue(transaction, CREATE_GENRE_QRY, genre);
    }

    public static int addYear(DatabaseService.Transaction transaction, String year) throws SQLException {
        return TitledEntityRepository.addValue(transaction, CREATE_YEAR_QRY, year);
    }

    public static int addStatus(DatabaseService.Transaction transaction, String status) throws SQLException {
        return TitledEntityRepository.addValue(transaction, CREATE_STATUS_QRY, status);
    }

    public static int addCustomValue(DatabaseService.Transaction transaction, int index, String value) throws SQLException {
        return TitledEntityRepository.addValue(transaction, CREATE_CUSTOM_QRY[index], value);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<ITitledEntity> listAll(String query, DatabaseService.Transaction transaction) throws SQLException {
        try {
            if (transaction == null) {
                try (Connection con = this.dbService_.getConnection();){
                    List<ITitledEntity> list;
                    block21: {
                        Statement stmt = con.createStatement();
                        try {
                            list = TitledEntityRepository.listAllWithStatement(query, stmt);
                            if (stmt == null) break block21;
                        }
                        catch (Throwable throwable) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        stmt.close();
                    }
                    return list;
                }
            }
            try (Statement stmt = transaction.createStatement();){
                List<ITitledEntity> list = TitledEntityRepository.listAllWithStatement(query, stmt);
                return list;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(TextService.getInstance().get("database.error.query", new Object[]{"read KeyValuePairs"}));
        }
    }

    private static List<ITitledEntity> listAllWithStatement(String query, Statement stmt) throws SQLException {
        try (ResultSet resultset = stmt.executeQuery(query);){
            ArrayList<ITitledEntity> customList = new ArrayList<ITitledEntity>();
            while (resultset.next()) {
                customList.add(new TitledEntity(resultset.getInt(1), resultset.getString(2)));
            }
            ArrayList<ITitledEntity> arrayList = customList;
            return arrayList;
        }
    }

    private static int addValue(DatabaseService.Transaction transaction, String query, String value) throws SQLException {
        int n;
        block8: {
            PreparedStatement stmt = transaction.prepareStatement(query);
            try {
                stmt.setString(1, value);
                stmt.executeUpdate();
                n = TitledEntityRepository.identity(transaction);
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new SQLException(TextService.getInstance().get("database.error.query", new Object[]{"add " + value}));
                }
            }
            stmt.close();
        }
        return n;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int cleanup() throws SQLException {
        try (DatabaseService.Transaction transaction = this.dbService_.startTransaction();){
            int n;
            block15: {
                Statement stmt = transaction.createStatement();
                try {
                    for (String s : CLEANUP_QRY.split(";")) {
                        stmt.addBatch(s);
                    }
                    int[] results = stmt.executeBatch();
                    transaction.commit();
                    n = IntStream.of(results).sum();
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(TextService.getInstance().get("database.error.query", new Object[]{"cleanup"}));
        }
    }

    private static int findIdByValue(List<ITitledEntity> list, String value) {
        return list.stream().filter(x -> x.getTitle().equals(value)).findFirst().map(IEntity::getId).orElse(-1);
    }
}

