/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.FileLocation;
import org.dbgl.model.ICanonicalize;
import org.dbgl.model.SearchResult;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.factory.DosboxVersionFactory;
import org.dbgl.service.SettingsService;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.SystemUtils;

public class FileLocationService {
    public static final String PROFILES_DIR_STRING = "profiles" + File.separatorChar;
    public static final String TEMPLATES_DIR_STRING = "templates" + File.separatorChar;
    public static final String CAPTURES_DIR_STRING = "captures" + File.separatorChar;
    public static final String DOSROOT_DIR_STRING = "dosroot" + File.separatorChar;
    public static final String EXPORT_DIR_STRING = "export" + File.separatorChar;
    public static final String XSL_DIR_STRING = "xsl" + File.separatorChar;
    public static final String MAPPER_DIR_STRING = "mapper" + File.separatorChar;
    public static final String DATABASE_DIR_STRING = "db" + File.separatorChar;
    public static final String MOBYGAMES_DATABASE_DATA = "mobygames.data";
    public static final String MOBYGAMES_DATABASE_SCRIPT = "mobygames.script";
    public static final String MOBYGAMES_DATABASE_PROPERTIES = "mobygames.properties";
    public static final String SHADERS_DIR_STRING = "shaders" + File.separatorChar;
    public static final String DOSBOX_EXE_STRING = SystemUtils.IS_WINDOWS ? "DOSBox.exe" : (SystemUtils.IS_OSX ? "DOSBox" : "dosbox");
    public static final String DB_APP_EXT = ".app";
    public static final String DB_APP = "DOSBox.app";
    public static final String DB_APP_EXE = "/Contents/MacOS/" + DOSBOX_EXE_STRING;
    public static final String DOSBOX_CONF_STRING = "dosbox.conf";
    public static final String SETUP_CONF = "setup.conf";
    public static final String TEMPLATE_CONF = "template.conf";
    public static final String PROGRAM_FILES = SystemUtils.IS_WINDOWS ? System.getenv("ProgramFiles") : null;
    public static final String DFEND_PATH_STRING = StringUtils.isNotBlank((CharSequence)PROGRAM_FILES) ? FilesUtils.concat(PROGRAM_FILES, "D-Fend") : "D-Fend";
    public static final String DFEND_PROFILES_STRING = "Profiles.dat";
    public static final String DFEND_STRING = FilesUtils.concat(DFEND_PATH_STRING, "Profiles.dat");
    public static final String DFEND_RELOADED_PATH_STRING = FilesUtils.concat(SystemUtils.USER_HOME, "D-Fend Reloaded");
    private static final String DEFAULT_TEMPLATES_XML_STRING = "default.xml";
    private static final String[] SHADER_EXTS = new String[]{"fx"};
    private static final String XSL_EXT = "xsl";
    private final File dataDir_;
    private final File profilesDir_;
    private final File templatesDir_;
    private final File capturesDir_;
    private final File dosrootDir_;
    private final File exportDir_;
    private final File xslDir_;
    private final File dosboxDir_;
    private final File tmpInstDir_;
    private final File shadersDir_;

    private FileLocationService() {
        SettingsService settings = SettingsService.getInstance();
        File data = FileLocationService.replaceTildeInPath(settings.getValue("directory", "data"));
        boolean dataInUserDir = SystemUtils.USE_USER_HOME_DIR || !FilesUtils.isWritableDirectory(data);
        this.dataDir_ = FileLocationService.canonicalTo(new File("."), dataInUserDir ? new File(SystemUtils.USER_DATA_DIR, data.getPath()) : data);
        this.profilesDir_ = new File(this.dataDir_, PROFILES_DIR_STRING);
        this.templatesDir_ = new File(this.dataDir_, TEMPLATES_DIR_STRING);
        this.capturesDir_ = new File(this.dataDir_, CAPTURES_DIR_STRING);
        this.dosrootDir_ = new File(this.dataDir_, DOSROOT_DIR_STRING);
        this.exportDir_ = new File(this.dataDir_, EXPORT_DIR_STRING);
        this.xslDir_ = new File(this.dataDir_, XSL_DIR_STRING);
        this.dosboxDir_ = FileLocationService.canonicalTo(new File("."), FileLocationService.replaceTildeInPath(settings.getValue("directory", "dosbox")));
        this.tmpInstDir_ = new File(this.dosrootDir_, settings.getValue("directory", "tmpinstall"));
        this.shadersDir_ = new File(this.dosrootDir_, SHADERS_DIR_STRING);
        if (dataInUserDir) {
            File mobygamesDbFile;
            FilesUtils.copyDirIfDestinationDoesNotExist(new File(data, PROFILES_DIR_STRING), this.profilesDir_);
            FilesUtils.copyDirIfDestinationDoesNotExist(new File(data, TEMPLATES_DIR_STRING), this.templatesDir_);
            FilesUtils.copyDirIfDestinationDoesNotExist(new File(data, CAPTURES_DIR_STRING), this.capturesDir_);
            FilesUtils.copyDirIfDestinationDoesNotExist(new File(data, DOSROOT_DIR_STRING), this.dosrootDir_);
            FilesUtils.copyDirIfDestinationDoesNotExist(new File(data, EXPORT_DIR_STRING), this.exportDir_);
            FilesUtils.copyDirIfDestinationDoesNotExist(new File(data, XSL_DIR_STRING), this.xslDir_);
            File databaseFile = FileLocationService.getFileFromConnectionString(settings.getValue("database", "connectionstring"));
            if (databaseFile != null) {
                FilesUtils.copyDirIfDestinationDoesNotExist(new File(data, databaseFile.getParent()), new File(this.dataDir_, databaseFile.getParent()));
            }
            if ((mobygamesDbFile = FileLocationService.getFileFromConnectionString(settings.getValue("mobygames_database", "connectionstring"))) != null) {
                FilesUtils.copyFileIfDestinationDoesNotExist(new File(mobygamesDbFile.getParentFile(), MOBYGAMES_DATABASE_DATA), new File(this.dataDir_, mobygamesDbFile.getParent()));
                FilesUtils.copyFileIfDestinationDoesNotExist(new File(mobygamesDbFile.getParentFile(), MOBYGAMES_DATABASE_SCRIPT), new File(this.dataDir_, mobygamesDbFile.getParent()));
                FilesUtils.copyFileIfDestinationDoesNotExist(new File(mobygamesDbFile.getParentFile(), MOBYGAMES_DATABASE_PROPERTIES), new File(this.dataDir_, mobygamesDbFile.getParent()));
            }
        }
        FilesUtils.createDirIfNonExisting(this.profilesDir_);
        FilesUtils.createDirIfNonExisting(this.templatesDir_);
        FilesUtils.createDirIfNonExisting(this.capturesDir_);
        FilesUtils.createDirIfNonExisting(this.dosrootDir_);
        FilesUtils.createDirIfNonExisting(this.exportDir_);
        FilesUtils.createDirIfNonExisting(this.xslDir_);
        FilesUtils.createDirIfNonExisting(this.dosboxDir_);
    }

    public static FileLocationService getInstance() {
        return FileLocationServiceHolder.instance_;
    }

    private static File canonicalTo(File base, File file) {
        if (base.isAbsolute() || file.isAbsolute()) {
            return new File(FilesUtils.concat(base, file));
        }
        try {
            return new File(base, file.getPath()).getCanonicalFile();
        }
        catch (IOException e) {
            return new File(base, file.getPath()).getAbsoluteFile();
        }
    }

    public ICanonicalize dataRelative() {
        return new ICanonicalize(){

            @Override
            public File initialize(String location) {
                return FilesUtils.makeRelativeTo(FileLocationService.this.dataDir_, new File(location));
            }

            @Override
            public File canonicalize(File file) {
                return FileLocationService.canonicalTo(FileLocationService.this.dataDir_, file);
            }
        };
    }

    public ICanonicalize dosrootRelative() {
        return new ICanonicalize(){

            @Override
            public File initialize(String location) {
                return FilesUtils.makeRelativeTo(FileLocationService.this.dosrootDir_, new File(location));
            }

            @Override
            public File canonicalize(File file) {
                return FileLocationService.canonicalTo(FileLocationService.this.dosrootDir_, file);
            }
        };
    }

    public ICanonicalize dosboxRelative() {
        return new ICanonicalize(){

            @Override
            public File initialize(String location) {
                return FilesUtils.makeRelativeTo(FileLocationService.this.dosboxDir_, new File(location));
            }

            @Override
            public File canonicalize(File file) {
                return FileLocationService.canonicalTo(FileLocationService.this.dosboxDir_, file);
            }
        };
    }

    public static ICanonicalize standard() {
        return new ICanonicalize(){

            @Override
            public File initialize(String location) {
                return new File(location);
            }

            @Override
            public File canonicalize(File file) {
                return file;
            }
        };
    }

    public File getDosroot() {
        return this.dosrootDir_;
    }

    public File getProfilesDir() {
        return this.profilesDir_;
    }

    public File getTmpInstallDir() {
        return this.tmpInstDir_;
    }

    public FileLocation getDosrootLocation() {
        return new FileLocation(".", this.dosrootRelative());
    }

    public FileLocation getTmpInstallLocation() {
        return new FileLocation(this.tmpInstDir_.getPath(), this.dosrootRelative());
    }

    public String getCanonicalConnectionString(String connString) {
        File file = FileLocationService.getFileFromConnectionString(connString);
        if (file != null) {
            int start = connString.indexOf("file:") + 5;
            int end = connString.indexOf(59, start);
            if (end == -1) {
                end = connString.length();
            }
            return connString.substring(0, start) + new FileLocation(file.getPath(), this.dataRelative()).getCanonicalFile() + connString.substring(end);
        }
        return connString;
    }

    public static File getFileFromConnectionString(String connString) {
        if (connString.contains("file:")) {
            int start = connString.indexOf("file:") + 5;
            int end = connString.indexOf(59, start);
            if (end == -1) {
                end = connString.length();
            }
            return FileLocationService.replaceTildeInPath(connString.substring(start, end));
        }
        return null;
    }

    private static File replaceTildeInPath(String path) {
        if ((SystemUtils.IS_LINUX || SystemUtils.IS_OSX) && (path.equals("~") || path.startsWith("~/"))) {
            return new File(path.replaceAll("^~", SystemUtils.USER_HOME));
        }
        return new File(path);
    }

    public FileLocation getUniqueTemplateConfigFileLocation(int templateId) {
        return new FileLocation(TEMPLATES_DIR_STRING + templateId + ".conf", this.dataRelative());
    }

    public FileLocation getUniqueProfileConfigFileLocation(int profileId, String profileTitle, File mainDir) {
        SettingsService settings = SettingsService.getInstance();
        File path = settings.getIntValue("profiledefaults", "confpath") == 0 || mainDir == null ? this.profilesDir_ : mainDir;
        String prefix = settings.getIntValue("profiledefaults", "conffile") == 0 ? String.valueOf(profileId) : profileTitle;
        File candidate = null;
        int nr = 1;
        do {
            candidate = new File(path, FilesUtils.toSafeFilename(prefix + (nr > 1 ? "(" + nr + ")" : "")) + ".conf");
            ++nr;
        } while (FilesUtils.isExistingFile(this.dataRelative().canonicalize(candidate)));
        return new FileLocation(candidate.getPath(), this.dataRelative());
    }

    public FileLocation getTmpConfLocation() {
        return new FileLocation(PROFILES_DIR_STRING + SETUP_CONF, this.dataRelative());
    }

    public File getDefaultTemplatesXmlFile() {
        return new File(this.templatesDir_, DEFAULT_TEMPLATES_XML_STRING);
    }

    public static String getGpaExportFile(String fullPath, String title) {
        if (StringUtils.isBlank((CharSequence)title)) {
            return title;
        }
        File base = new File(fullPath).getParentFile();
        if (base == null) {
            base = new File(EXPORT_DIR_STRING);
        }
        return new File(base, FilesUtils.toSafeFilename(title) + ".dbgl.zip").getPath();
    }

    public String[] listGlShaderFilenames() {
        return new String[0];
    }

    public String[] listShaderFilenames() {
        if (this.shadersDir_.exists() && this.shadersDir_.isDirectory()) {
            return (String[])FileUtils.listFiles((File)this.shadersDir_, (String[])SHADER_EXTS, (boolean)false).stream().sorted().map(File::getName).toArray(String[]::new);
        }
        return new String[0];
    }

    public boolean hasXslDir() {
        return this.xslDir_.exists() && this.xslDir_.isDirectory();
    }

    public String[] listXslBaseNames() {
        if (this.hasXslDir()) {
            return (String[])FileUtils.listFiles((File)this.xslDir_, (String[])new String[]{XSL_EXT}, (boolean)false).stream().sorted().map(x -> FilenameUtils.getBaseName((String)x.getName())).toArray(String[]::new);
        }
        return new String[0];
    }

    public File xslBaseNameToFile(String baseName) {
        return new File(this.xslDir_, baseName + '.' + XSL_EXT);
    }

    public SearchResult findDosbox() {
        ArrayList<String> allVersions = new ArrayList<String>(SettingsService.SUPPORTED_DOSBOX_RELEASES);
        Collections.reverse(allVersions);
        return allVersions.stream().map(this::findDosbox).filter(x -> x.result_ != SearchResult.ResultType.NOTFOUND).findFirst().orElse(new SearchResult(SearchResult.ResultType.NOTFOUND, null));
    }

    private SearchResult findDosbox(String versionToSearch) {
        File exe;
        File canExePath = null;
        File canConf = null;
        File canConfSuggestion = null;
        String version = null;
        String dosboxDirectoryString = "DOSBox-" + versionToSearch;
        File dosboxDirectory = new File(this.dosboxDir_, dosboxDirectoryString);
        if (FilesUtils.isExistingDirectory(dosboxDirectory) && FilesUtils.isExistingFile(exe = new File(dosboxDirectory, DOSBOX_EXE_STRING))) {
            canExePath = exe.getParentFile();
            version = versionToSearch;
        }
        if (canExePath == null) {
            File exePF;
            if (SystemUtils.IS_WINDOWS) {
                File exePF2;
                String programFiles = System.getenv("ProgramFiles(x86)");
                if (programFiles == null) {
                    programFiles = System.getenv("ProgramFiles");
                }
                if (FilesUtils.isExistingFile(exePF2 = new File(new File(programFiles, dosboxDirectoryString), DOSBOX_EXE_STRING))) {
                    canExePath = exePF2.getParentFile();
                    version = versionToSearch;
                }
            } else if (SystemUtils.IS_LINUX) {
                exePF = new File("/usr/bin", DOSBOX_EXE_STRING);
                if (FilesUtils.isExistingFile(exePF)) {
                    canExePath = exePF.getParentFile();
                }
            } else if (SystemUtils.IS_OSX && FilesUtils.isExistingFile(exePF = new File("/Applications/DOSBox.app/Contents/MacOS", DOSBOX_EXE_STRING))) {
                canExePath = exePF.getParentFile();
            }
        }
        if (canExePath != null) {
            File confLAD;
            File conf = new File(canExePath, DOSBOX_CONF_STRING);
            if (FilesUtils.isExistingFile(conf)) {
                canConf = conf;
            } else if (SystemUtils.IS_WINDOWS) {
                confLAD = new File(new File(System.getenv("LOCALAPPDATA"), "DOSBox"), "dosbox-" + versionToSearch + ".conf");
                if (FilesUtils.isExistingFile(confLAD)) {
                    canConf = confLAD;
                    version = versionToSearch;
                } else {
                    canConfSuggestion = confLAD;
                }
            } else if (SystemUtils.IS_LINUX) {
                confLAD = new File(new File(SystemUtils.USER_HOME, ".dosbox"), "dosbox-" + versionToSearch + ".conf");
                if (FilesUtils.isExistingFile(confLAD)) {
                    canConf = confLAD;
                    version = versionToSearch;
                } else {
                    canConfSuggestion = confLAD;
                }
            } else if (SystemUtils.IS_OSX) {
                confLAD = new File(new File(SystemUtils.USER_HOME, "Library/Preferences"), "DOSBox " + versionToSearch + " Preferences");
                if (FilesUtils.isExistingFile(confLAD)) {
                    canConf = confLAD;
                    version = versionToSearch;
                } else {
                    canConfSuggestion = confLAD;
                }
            }
        }
        FileLocation exePath = null;
        if (canExePath != null) {
            exePath = new FileLocation(canExePath.getPath(), this.dosboxRelative());
        }
        FileLocation confPath = null;
        if (canConf != null) {
            confPath = new FileLocation(canConf.getPath(), this.dosboxRelative());
        } else if (canConfSuggestion != null) {
            confPath = new FileLocation(canConfSuggestion.getPath(), this.dosboxRelative());
        }
        DosboxVersion db = DosboxVersionFactory.create("DOSBox " + (version != null ? version : SettingsService.LATEST_SUPPORTED_DOSBOX_RELEASE), version != null ? version : SettingsService.LATEST_SUPPORTED_DOSBOX_RELEASE, true, true, false, null, exePath != null ? exePath.getFile().getPath() : "", "", "", confPath != null ? confPath.getFile().getPath() : "");
        SearchResult.ResultType res = SearchResult.ResultType.NOTFOUND;
        if (canExePath != null) {
            res = SearchResult.ResultType.EXEONLY;
            if (canConf != null && version != null) {
                res = SearchResult.ResultType.COMPLETE;
            }
        }
        return new SearchResult(res, db);
    }

    private static class FileLocationServiceHolder {
        private static final FileLocationService instance_ = new FileLocationService();

        private FileLocationServiceHolder() {
        }
    }
}

