/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.model.FileLocation;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.entity.TemplateProfileBase;
import org.dbgl.model.factory.ProfileFactory;
import org.dbgl.model.factory.TemplateFactory;
import org.dbgl.service.FileLocationService;
import org.dbgl.service.SettingsService;
import org.dbgl.service.TextService;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.SystemUtils;
import org.eclipse.swt.widgets.Display;

public class ExecuteUtils {
    public static void doRunDosbox(DosboxVersion dbversion) throws IOException {
        ExecuteUtils.doRunDosbox(dbversion, new String[0], true, dbversion.getCwd(), false);
    }

    public static void doCreateDosboxConf(DosboxVersion dbversion) throws IOException {
        char quote = SystemUtils.IS_WINDOWS ? (char)'\'' : '\"';
        ExecuteUtils.doRunDosbox(dbversion, new String[]{"-c", "config -writeconf " + quote + dbversion.getConfigurationCanonicalFile() + quote, "-c", "exit"}, false, dbversion.getCwd(), true);
    }

    public static void doRunTemplate(Template template, Display display) throws IOException {
        Template preparedTemplate = TemplateFactory.createCopy(template);
        preparedTemplate.loadConfigurationData(TextService.getInstance(), template.getConfigurationString(), template.getConfigurationCanonicalFile());
        preparedTemplate.getConfiguration().setFileLocation(FileLocationService.getInstance().getTmpConfLocation());
        preparedTemplate.saveConfiguration(true);
        new ConfigurableExecutor(preparedTemplate, preparedTemplate.getDosboxVersion(), preparedTemplate.getConfigurationCanonicalFile(), display).start();
    }

    public static void doRunProfile(ProfileRunMode mode, Profile prof, boolean prepareOnly, Display display) throws IOException {
        ExecuteUtils.doRunProfile(mode, prof, prof.getDosboxVersion(), prepareOnly, display);
    }

    public static void doRunProfile(ProfileRunMode mode, Profile prof, DosboxVersion dosboxVersion, boolean prepareOnly, Display display) throws IOException {
        Profile preparedProfile = prof;
        if (mode != ProfileRunMode.NORMAL || prepareOnly) {
            preparedProfile = ProfileFactory.createCopy(prof);
            preparedProfile.loadConfigurationData(TextService.getInstance(), prof.getConfigurationString(), mode == ProfileRunMode.INSTALLER ? new File("") : prof.getConfigurationCanonicalFile());
            switch (mode) {
                case SETUP: {
                    preparedProfile.setAutoexecSettings(preparedProfile.getSetupString(), preparedProfile.getSetupParams());
                    break;
                }
                case ALT1: {
                    preparedProfile.setAutoexecSettings(preparedProfile.getAltExeStrings()[0], preparedProfile.getAltExeParams()[0]);
                    break;
                }
                case ALT2: {
                    preparedProfile.setAutoexecSettings(preparedProfile.getAltExeStrings()[1], preparedProfile.getAltExeParams()[1]);
                    break;
                }
                case INSTALLER: {
                    preparedProfile.setAutoexecSettings(true, true);
                    break;
                }
            }
            preparedProfile.getConfiguration().setFileLocation(FileLocationService.getInstance().getTmpConfLocation());
            preparedProfile.saveConfiguration(prepareOnly);
        }
        if (mode == ProfileRunMode.INSTALLER) {
            ExecuteUtils.doRunDosbox(dosboxVersion, new String[]{"-conf", preparedProfile.getConfigurationCanonicalFile().getPath()}, false, dosboxVersion.getCwd(), true);
        } else {
            new ConfigurableExecutor(preparedProfile, dosboxVersion, preparedProfile.getConfigurationCanonicalFile(), display).start();
        }
    }

    public static void createShortcut(Profile profile) throws IOException {
        File desktopDir;
        DosboxVersion dbversion = profile.getDosboxVersion();
        String strictFilename = profile.getTitle().replaceAll("[\\/:*?\"<>|]", " ").trim();
        StringBuilder params = new StringBuilder(128);
        if (dbversion.isMultiConfig()) {
            params.append("-conf \"\"").append(dbversion.getConfigurationCanonicalFile()).append("\"\" ");
        }
        params.append("-conf \"\"").append(profile.getConfigurationCanonicalFile()).append("\"\"");
        if (SettingsService.getInstance().getBooleanValue("dosbox", "hideconsole")) {
            params.append(" -noconsole");
        }
        if (SystemUtils.IS_WINDOWS) {
            File desktopDir2 = FileSystemView.getFileSystemView().getHomeDirectory();
            File lnkFile = new File(desktopDir2, strictFilename + ".lnk");
            File vbsFile = new FileLocation("shortcut.vbs", FileLocationService.getInstance().dataRelative()).getCanonicalFile();
            try (BufferedWriter vbsWriter = new BufferedWriter(new FileWriter(vbsFile));){
                vbsWriter.write("Set oWS = WScript.CreateObject(\"WScript.Shell\")" + SystemUtils.EOLN);
                vbsWriter.write("Set oLink = oWS.CreateShortcut(\"" + lnkFile.getCanonicalPath() + "\")" + SystemUtils.EOLN);
                vbsWriter.write("oLink.TargetPath = \"" + dbversion.getCanonicalExecutable() + "\"" + SystemUtils.EOLN);
                vbsWriter.write("oLink.Arguments = \"" + params.toString() + "\"" + SystemUtils.EOLN);
                vbsWriter.write("oLink.Description = \"" + TextService.getInstance().get("general.shortcut.title", new Object[]{strictFilename}) + "\"" + SystemUtils.EOLN);
                vbsWriter.write("oLink.WorkingDirectory = \"" + FileLocationService.getInstance().getDosroot() + "\"" + SystemUtils.EOLN);
                vbsWriter.write("oLink.Save" + SystemUtils.EOLN);
            }
            Process proc = Runtime.getRuntime().exec(new String[]{"CSCRIPT", vbsFile.getPath()}, null, vbsFile.getParentFile());
            try (InputStream err = proc.getErrorStream();
                 InputStream out = proc.getInputStream();){
                StreamGobbler errorGobbler = new StreamGobbler(err, "CSCRIPT stderr");
                StreamGobbler outputGobbler = new StreamGobbler(out, "CSCRIPT stdout");
                outputGobbler.start();
                errorGobbler.start();
                proc.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            FilesUtils.removeFile(vbsFile);
        } else if (SystemUtils.IS_LINUX && (desktopDir = ExecuteUtils.determineLinuxDesktopDir()) != null) {
            File desktopFile = new File(desktopDir, strictFilename + ".desktop");
            try (BufferedWriter desktopWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(desktopFile), StandardCharsets.UTF_8));){
                desktopWriter.write("[Desktop Entry]" + SystemUtils.EOLN);
                desktopWriter.write("Version=1.0" + SystemUtils.EOLN);
                desktopWriter.write("Type=Application" + SystemUtils.EOLN);
                desktopWriter.write("Name=" + strictFilename + SystemUtils.EOLN);
                desktopWriter.write("Comment=" + TextService.getInstance().get("general.shortcut.title", new Object[]{strictFilename}) + SystemUtils.EOLN);
                desktopWriter.write("Icon=" + new File(dbversion.getExecutable().getParent(), "dosbox.ico").getPath() + SystemUtils.EOLN);
                desktopWriter.write("TryExec=" + dbversion.getExecutable().getPath() + SystemUtils.EOLN);
                desktopWriter.write("Exec=" + dbversion.getExecutable().getPath() + " " + StringUtils.replace((String)params.toString(), (String)"\"\"", (String)"\"") + SystemUtils.EOLN);
                desktopWriter.write("Path=" + FileLocationService.getInstance().getDosroot() + SystemUtils.EOLN);
            }
            if (!desktopFile.setExecutable(true)) {
                throw new IOException(TextService.getInstance().get("general.error.savefile", new Object[]{desktopDir.getPath()}));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File determineLinuxDesktopDir() {
        try {
            Process process = Runtime.getRuntime().exec("xdg-user-dir DESKTOP");
            try (InputStream is = process.getInputStream();){
                File desktopDirFile;
                process.waitFor();
                String xdgDesktopDir = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                if (xdgDesktopDir != null && !(xdgDesktopDir = xdgDesktopDir.replace(SystemUtils.EOLN, "")).isEmpty() && (desktopDirFile = new File(xdgDesktopDir)).exists() && desktopDirFile.isDirectory()) {
                    File file = desktopDirFile;
                    return file;
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File defaultDesktopDir = new File(SystemUtils.USER_HOME, "Desktop");
        if (!defaultDesktopDir.exists()) return null;
        if (!defaultDesktopDir.isDirectory()) return null;
        return defaultDesktopDir;
    }

    private static void doRunDosbox(DosboxVersion dbversion, String[] parameters, boolean forceDBConf, File cwd, boolean waitFor) throws IOException {
        ArrayList<String> commandItems = new ArrayList<String>();
        if (dbversion.isUsingCurses()) {
            if (SystemUtils.IS_WINDOWS) {
                commandItems.add("rundll32");
                commandItems.add("SHELL32.DLL,ShellExec_RunDLL");
            } else if (SystemUtils.IS_LINUX) {
                commandItems.add("xterm");
                commandItems.add("-e");
            }
        }
        commandItems.add(dbversion.getCanonicalExecutable().getPath());
        if (dbversion.isMultiConfig() && FilesUtils.isReadableFile(dbversion.getConfiguration().getFile()) || forceDBConf) {
            commandItems.add("-conf");
            commandItems.add(dbversion.getConfigurationCanonicalFile().getPath());
        }
        commandItems.addAll(Arrays.asList(parameters));
        if (dbversion.getExecutableParameters().length() > 0) {
            Collections.addAll(commandItems, StringUtils.split((String)dbversion.getExecutableParameters(), (char)' '));
        }
        if (SettingsService.getInstance().getBooleanValue("dosbox", "hideconsole")) {
            commandItems.add("-noconsole");
        }
        if (SystemUtils.IS_OSX && dbversion.isUsingCurses()) {
            String command = StringUtils.join(commandItems, (char)' ');
            commandItems.clear();
            commandItems.add("osascript");
            commandItems.add("-e");
            commandItems.add("tell application \"Terminal\" to do script \"cd '" + cwd + "'; " + command + "; exit;\"");
        }
        try {
            ExecuteUtils.execute(commandItems, cwd, waitFor);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException(TextService.getInstance().get("general.error.startdosbox", new Object[]{StringUtils.join(commandItems, (char)' ')}));
        }
    }

    private static void execute(List<String> execCommands, File cwd, boolean waitFor) throws IOException {
        Map<String, String> env;
        System.out.print(StringUtils.join(execCommands, (char)' '));
        ProcessBuilder pb = new ProcessBuilder(execCommands.toArray(new String[execCommands.size()]));
        pb.directory(cwd);
        Map<String, String> environment = pb.environment();
        Map<String, String> map = env = SettingsService.getInstance().getBooleanValue("environment", "use") ? StringRelatedUtils.stringArrayToMap(SettingsService.getInstance().getValues("environment", "value")) : null;
        if (env != null) {
            environment.putAll(env);
            System.out.print(env);
        }
        System.out.println();
        Process proc = pb.start();
        try {
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "DOSBox stderr");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "DOSBox stdout");
            outputGobbler.start();
            errorGobbler.start();
            if (waitFor) {
                proc.waitFor();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static class ConfigurableExecutor
    extends Thread {
        private final TemplateProfileBase templateOrProfile_;
        private final DosboxVersion dosboxVersion_;
        private final File conf_;
        private final Display display_;

        public ConfigurableExecutor(TemplateProfileBase templateOrProfile, DosboxVersion dosboxVersion, File conf, Display display) {
            this.templateOrProfile_ = templateOrProfile;
            this.dosboxVersion_ = dosboxVersion;
            this.conf_ = conf;
            this.display_ = display;
        }

        @Override
        public void run() {
            block4: {
                try {
                    for (NativeCommand cmd : this.templateOrProfile_.getNativeCommands()) {
                        if (cmd.isDosboxCommand()) {
                            ExecuteUtils.doRunDosbox(this.dosboxVersion_, new String[]{"-conf", this.conf_.getPath()}, false, this.dosboxVersion_.getCwd(), true);
                            continue;
                        }
                        ExecuteUtils.execute(cmd.getCanonicalCommandAndParameters(), cmd.getCanonicalCwd(), cmd.isWaitFor());
                    }
                }
                catch (IOException e) {
                    if (this.display_.isDisposed()) break block4;
                    this.display_.syncExec(() -> Mess_.on(this.display_.getActiveShell()).exception(e).warning());
                }
            }
        }
    }

    public static enum ProfileRunMode {
        NORMAL,
        SETUP,
        ALT1,
        ALT2,
        INSTALLER;

    }

    private static class StreamGobbler
    extends Thread {
        private final InputStream istream_;
        private final String logType_;

        public StreamGobbler(InputStream istream, String logType) {
            this.istream_ = istream;
            this.logType_ = logType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (BufferedReader bReader = new BufferedReader(new InputStreamReader(this.istream_));){
                String line = null;
                while ((line = bReader.readLine()) != null) {
                    System.out.println(this.logType_ + "> " + line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                try {
                    this.istream_.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

