/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.iso;

import java.io.IOException;
import org.dbgl.util.iso.ISO9660FileSystem;
import org.dbgl.util.iso.Util;

public class ISO9660FileEntry {
    private static final char ID_SEPARATOR = ';';
    private final int entryLength_;
    private final long startSector_;
    private final int dataLength_;
    private final int flags_;
    private final String identifier_;
    private ISO9660FileSystem fileSystem_;
    private String parentPath_;

    public ISO9660FileEntry(ISO9660FileSystem fileSystem, byte[] block, int pos) {
        this(fileSystem, null, block, pos);
    }

    public ISO9660FileEntry(ISO9660FileSystem fileSystem, String parentPath, byte[] block, int startPos) {
        this.fileSystem_ = fileSystem;
        this.parentPath_ = parentPath;
        int offset = startPos - 1;
        this.entryLength_ = Util.getUInt8(block, offset);
        this.startSector_ = Util.getUInt32(block, offset + 2);
        this.dataLength_ = (int)Util.getUInt32(block, offset + 10);
        this.flags_ = Util.getUInt8(block, offset + 25);
        this.identifier_ = this.getFileIdentifier(block, offset, this.isDirectory());
    }

    private String getFileIdentifier(byte[] block, int offset, boolean isDir) {
        int fidLength = Util.getUInt8(block, offset + 32);
        if (isDir) {
            int buff34 = Util.getUInt8(block, offset + 33);
            if (fidLength == 1 && buff34 == 0) {
                return ".";
            }
            if (fidLength == 1 && buff34 == 1) {
                return "..";
            }
        }
        try {
            String id = Util.getDChars(block, offset + 34, fidLength, this.fileSystem_.getEncoding());
            int sepIdx = id.indexOf(59);
            return sepIdx >= 0 ? id.substring(0, sepIdx) : id;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getPath() {
        if (".".equals(this.getName())) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        if (this.parentPath_ != null) {
            buf.append(this.parentPath_);
        }
        buf.append(this.getName());
        if (this.isDirectory()) {
            buf.append("/");
        }
        return buf.toString();
    }

    public boolean isDirectory() {
        return (this.flags_ & 2) != 0;
    }

    String getName() {
        return this.identifier_;
    }

    int getSize() {
        return this.dataLength_;
    }

    long getStartBlock() {
        return this.startSector_;
    }

    int getEntryLength() {
        return this.entryLength_;
    }
}

