/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import org.dbgl.gui.controls.ControlBuilder;
import org.dbgl.gui.controls.DarkTheme;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scale;

public class Scale_ {
    private Scale_() {
    }

    public static Builder on(Composite composite) {
        return new Builder(composite);
    }

    public static class Builder
    extends ControlBuilder<Builder> {
        String tooltip_;
        Integer minimum_ = null;
        Integer maximum_ = null;
        Integer increment_ = null;
        Integer pageIncrement_ = null;
        Integer selection_ = null;

        Builder(Composite composite) {
            super(composite, 256, 4, 0x1000000, true, false);
        }

        public Builder tooltip(String tooltip) {
            this.tooltip_ = tooltip;
            return this;
        }

        public Builder vertical() {
            this.style_ = 512;
            this.horizontalAlignment_ = 0x1000000;
            this.verticalAlignment_ = 4;
            this.grabExcessHorizontalSpace_ = false;
            this.grabExcessVerticalSpace_ = true;
            return this;
        }

        public Builder min(int min) {
            this.minimum_ = min;
            return this;
        }

        public Builder max(int max) {
            this.maximum_ = max;
            return this;
        }

        public Builder incr(int incr) {
            this.increment_ = incr;
            return this;
        }

        public Builder pageIncr(int pageIncr) {
            this.pageIncrement_ = pageIncr;
            return this;
        }

        public Builder select(int select) {
            this.selection_ = select;
            return this;
        }

        public Scale build() {
            Scale scale = new Scale(this.composite_, this.style_);
            if (DarkTheme.forced()) {
                scale.setBackground(this.composite_.getBackground());
                scale.setForeground(DarkTheme.defaultForeground);
            }
            scale.setLayoutData(this.layoutData());
            if (this.minimum_ != null) {
                scale.setMinimum(this.minimum_.intValue());
            }
            if (this.maximum_ != null) {
                scale.setMaximum(this.maximum_.intValue());
            }
            if (this.increment_ != null) {
                scale.setIncrement(this.increment_.intValue());
            }
            if (this.pageIncrement_ != null) {
                scale.setPageIncrement(this.pageIncrement_.intValue());
            }
            if (this.tooltip_ != null) {
                scale.setToolTipText(this.tooltip_);
            }
            if (this.selection_ != null) {
                scale.setSelection(this.selection_.intValue());
            }
            return scale;
        }
    }
}

