/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import org.dbgl.gui.controls.ControlBuilder;
import org.dbgl.gui.controls.DarkTheme;
import org.dbgl.service.TextService;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public final class Text_ {
    private static Integer averageCharacterWidth_;

    private Text_() {
    }

    public static Builder on(Composite composite) {
        return new Builder(composite);
    }

    public static final class Builder
    extends ControlBuilder<Builder> {
        private String tooltip_;
        private String value_;
        private boolean editable_ = true;
        private boolean focus_;

        Builder(Composite composite) {
            super(composite, 2048, 4, 0x1000000, true, false);
        }

        public Builder tooltip(String tooltip) {
            this.tooltip_ = TextService.getInstance().get(tooltip);
            return this;
        }

        public Builder tooltip(String tooltip, String param) {
            this.tooltip_ = TextService.getInstance().get(tooltip, param);
            return this;
        }

        public Builder multi() {
            this.style_ |= 2;
            this.style_ |= 0x100;
            this.style_ |= 0x200;
            this.verticalAlignment_ = 4;
            this.grabExcessVerticalSpace_ = true;
            return this;
        }

        public Builder readOnly() {
            this.style_ |= 8;
            return this;
        }

        public Builder wrap() {
            this.style_ &= 0xFFFFFEFF;
            this.style_ |= 0x40;
            return this;
        }

        public Builder nonEditable() {
            this.editable_ = false;
            return this;
        }

        public Builder val(String value) {
            this.value_ = value;
            return this;
        }

        public Builder focus() {
            this.focus_ = true;
            return this;
        }

        public Text build() {
            Text text = new Text(this.composite_, this.style_);
            if (DarkTheme.forced()) {
                text.setBackground(DarkTheme.inputBackground);
                text.setForeground(DarkTheme.defaultForeground);
            }
            if (averageCharacterWidth_ == null) {
                GC gc = new GC((Drawable)text);
                averageCharacterWidth_ = (int)gc.getFontMetrics().getAverageCharacterWidth();
                gc.dispose();
            }
            this.widthHint(averageCharacterWidth_ * 8);
            text.setLayoutData(this.layoutData());
            if (this.focus_) {
                text.setFocus();
            }
            if (this.tooltip_ != null) {
                text.setToolTipText(this.tooltip_);
            }
            if (this.value_ != null) {
                text.setText(this.value_);
            }
            if (!this.editable_) {
                text.setEditable(false);
            }
            return text;
        }
    }
}

