/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.thread;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.dbgl.gui.thread.UIThread;
import org.dbgl.model.GamePack;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.entity.GamePackEntry;
import org.dbgl.service.ImportExportProfilesService;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.archive.ZipUtils;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public class ExportThread
extends UIThread<GamePackEntry> {
    private GamePack gamePack_;
    private ZipOutputStream zipOutputStream_;

    public ExportThread(Text log, ProgressBar progressBar, Label status, GamePack gamePack, File target) throws IOException, ParserConfigurationException, TransformerException {
        super(log, progressBar, status, false);
        this.gamePack_ = gamePack;
        long bytes = 0L;
        for (GamePackEntry entry : gamePack.getEntries()) {
            if (this.gamePack_.isCapturesAvailable()) {
                bytes += FileUtils.sizeOfDirectory((File)entry.getProfile().getCanonicalCaptures());
            }
            if (this.gamePack_.isMapperfilesAvailable() && entry.getProfile().getCustomMapperFile() != null) {
                bytes += entry.getProfile().getCustomMapperFile().length();
            }
            if (this.gamePack_.isGamedataAvailable() && gamePack.getEntries().stream().noneMatch(x -> entry != x && entry.getGameDir().equals(x.getGameDir()) && entry.getId() > x.getId())) {
                bytes += FileUtils.sizeOfDirectory((File)entry.getCanonicalGameDir());
            }
            ++bytes;
        }
        this.setObjects(gamePack.getEntries());
        this.setTotal(bytes);
        this.zipOutputStream_ = new ZipOutputStream(new FileOutputStream(target));
        ImportExportProfilesService.export(gamePack, this.zipOutputStream_);
    }

    @Override
    public String work(GamePackEntry entry) throws IOException {
        this.displayTitle(text_.get("dialog.export.exporting", new Object[]{this.getTitle(entry)}));
        Profile prof = entry.getProfile();
        if (this.gamePack_.isCapturesAvailable()) {
            try {
                ZipUtils.zipDir(this.zipOutputStream_, prof.getCanonicalCaptures(), entry.getArchiveCapturesDir(), prof.getCanonicalCaptures(), this);
            }
            catch (IOException e) {
                throw new IOException(text_.get("dialog.export.error.exportcaptures", new Object[]{prof.getTitle(), StringRelatedUtils.toString(e)}), e);
            }
        }
        if (this.gamePack_.isMapperfilesAvailable() && entry.getProfile().getCustomMapperFile() != null) {
            try {
                ZipUtils.zipEntry(this.zipOutputStream_, entry.getProfile().getCustomMapperFile(), entry.getArchiveMapper(), this);
            }
            catch (IOException e) {
                throw new IOException(text_.get("dialog.export.error.exportmapper", new Object[]{prof.getTitle(), StringRelatedUtils.toString(e)}), e);
            }
        }
        if (this.gamePack_.isGamedataAvailable() && this.getObjects().stream().noneMatch(x -> entry != x && entry.getGameDir().equals(x.getGameDir()) && entry.getId() > x.getId())) {
            try {
                ZipUtils.zipDir(this.zipOutputStream_, entry.getCanonicalGameDir(), entry.getArchiveGameDir(), entry.getCanonicalGameDir(), this);
            }
            catch (IOException e) {
                throw new IOException(text_.get("dialog.export.error.exportgamedata", new Object[]{prof.getTitle(), StringRelatedUtils.toString(e)}), e);
            }
        }
        return null;
    }

    @Override
    public String getTitle(GamePackEntry entry) {
        return entry.getProfile().getTitle();
    }

    @Override
    public void preFinish() throws IOException {
        this.zipOutputStream_.close();
    }
}

