/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.dbgl.model.ICanonicalize;
import org.dbgl.service.FileLocationService;

public class FileLocation {
    protected final String location_;
    protected final ICanonicalize canonicalizer_;
    protected File file_;
    protected File canonicalFile_;

    public FileLocation(String location, ICanonicalize canonicalizer) {
        this.location_ = location;
        this.canonicalizer_ = canonicalizer;
        if (this.location_ != null) {
            this.file_ = this.canonicalizer_.initialize(this.location_);
        }
    }

    public FileLocation(String location) {
        this(location, FileLocationService.standard());
    }

    public File getFile() {
        return this.file_;
    }

    public String getFileAsDosString() {
        if (this.file_ == null) {
            return null;
        }
        return FilenameUtils.separatorsToWindows((String)this.file_.getPath());
    }

    public File getCanonicalFile() {
        if (this.canonicalFile_ == null && this.file_ != null) {
            this.canonicalFile_ = this.canonicalizer_.canonicalize(this.file_);
        }
        return this.canonicalFile_;
    }

    public ICanonicalize getCanonicalizer() {
        return this.canonicalizer_;
    }

    public String toString() {
        return "location:[" + this.location_ + "], file:[" + this.file_ + "], canonical:[" + this.getCanonicalFile() + "]";
    }
}

