/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import org.apache.commons.lang3.StringUtils;

public class ImgSizeCommand {
    private static final int DEFAULT_BYTES_PER_SECTOR = 512;
    private static final int DEFAULT_SECTORS_PER_TRACK = 63;
    private static final int DEFAULT_HEADS = 16;
    private static final int DEFAULT_CYLINDERS = 142;
    private final int bytesPerSector_;
    private final int sectorsPerTrack_;
    private final int heads_;
    private final int cylinders_;

    public ImgSizeCommand(String command) {
        String[] elements;
        if (command != null && (elements = StringUtils.split((String)command, (char)',')).length == 4) {
            this.bytesPerSector_ = ImgSizeCommand.tryParse(elements[0]);
            this.sectorsPerTrack_ = ImgSizeCommand.tryParse(elements[1]);
            this.heads_ = ImgSizeCommand.tryParse(elements[2]);
            this.cylinders_ = ImgSizeCommand.tryParse(elements[3]);
            return;
        }
        this.bytesPerSector_ = 512;
        this.sectorsPerTrack_ = 63;
        this.heads_ = 16;
        this.cylinders_ = 142;
    }

    public ImgSizeCommand(int bytesPerSector, int sectorsPerTrack, int heads, int cylinders) {
        this.bytesPerSector_ = bytesPerSector;
        this.sectorsPerTrack_ = sectorsPerTrack;
        this.heads_ = heads;
        this.cylinders_ = cylinders;
    }

    private static int tryParse(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public int getBytesPerSector() {
        return this.bytesPerSector_;
    }

    public int getSectorsPerTrack() {
        return this.sectorsPerTrack_;
    }

    public int getHeads() {
        return this.heads_;
    }

    public int getCylinders() {
        return this.cylinders_;
    }

    public long getTotalSize() {
        return (long)(this.bytesPerSector_ * this.sectorsPerTrack_ * this.heads_) * (long)this.cylinders_;
    }

    public long getTotalSizeInMB() {
        return this.getTotalSize() / 0x100000L;
    }

    public String toString() {
        return this.bytesPerSector_ + "," + this.sectorsPerTrack_ + "," + this.heads_ + "," + this.cylinders_;
    }
}

