/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.model.FileLocation;
import org.dbgl.model.ICanonicalize;
import org.dbgl.model.conf.mount.DirMount;
import org.dbgl.model.conf.mount.ImageMount;
import org.dbgl.model.conf.mount.Mount;
import org.dbgl.model.factory.MountFactory;
import org.dbgl.service.FileLocationService;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.SystemUtils;

public class Autoexec {
    private static final String DFR_4DOS_PREFIX = "C:\\FREEDOS\\4DOS.COM /C ";
    private static final String DFR_DOS32A_PREFIX = "C:\\FREEDOS\\DOS32A.EXE ";
    private static final String[] CUSTOM_SECTION_MARKERS = new String[]{"@REM START", "@REM /START", "@REM PRE-LAUNCH", "@REM /PRE-LAUNCH", "@REM POST-LAUNCH", "@REM /POST-LAUNCH", "@REM FINISH", "@REM /FINISH"};
    public static final int SECTIONS = CUSTOM_SECTION_MARKERS.length / 2;
    private static final Pattern LOADHIGH_PATRN = Pattern.compile("^(?:lh|loadhigh)\\s+(.*)$", 2);
    private static final Pattern LOADFIX_PATRN = Pattern.compile("^(?:loadfix\\s+(-f)\\s*|loadfix(\\s+-\\d+)?(\\s+.*)?)$", 2);
    private static final Pattern BOOT_PATRN = Pattern.compile("^(?:boot)(?=\\s+.\\S+)((?:\\s+[^-][^\\s]*)*)(?:\\s+-l\\s+([acd]):?)?\\s*$", 2);
    private static final Pattern BOOTIMGS_PATRN = Pattern.compile("^((?:\"[^\"]+\")|(?:[^\\s]+))(?:\\s((?:\"[^\"]+\")|(?:[^\\s]+)))?(?:\\s((?:\"[^\"]+\")|(?:[^\\s]+)))?$", 2);
    private static final int DEFAULT_LOADFIX_VALUE = 64;
    private String main_;
    private String parameters_;
    private String img1_;
    private String img2_;
    private String img3_;
    private String imgDriveletter_;
    private String mixer_;
    private String keyb_;
    private String ipxnet_;
    private Boolean loadfix_;
    private Boolean loadhigh_;
    private Boolean exit_;
    private Boolean pause_;
    private Boolean booterByDefault_;
    private Integer loadfixValue_;
    private String[] customSections_;
    private List<Mount> mountingpoints_;

    public Autoexec() {
        this.main_ = "";
        this.parameters_ = "";
        this.img1_ = "";
        this.img2_ = "";
        this.img3_ = "";
        this.imgDriveletter_ = "";
        this.mixer_ = "";
        this.keyb_ = "";
        this.ipxnet_ = "";
        this.loadfix_ = false;
        this.loadhigh_ = false;
        this.exit_ = false;
        this.pause_ = false;
        this.booterByDefault_ = false;
        this.loadfixValue_ = 0;
        this.customSections_ = new String[SECTIONS];
        for (int i = 0; i < SECTIONS; ++i) {
            this.customSections_[i] = "";
        }
        this.mountingpoints_ = new ArrayList<Mount>();
    }

    public Autoexec(Autoexec autoexec) {
        this.main_ = autoexec.main_;
        this.parameters_ = autoexec.parameters_;
        this.img1_ = autoexec.img1_;
        this.img2_ = autoexec.img2_;
        this.img3_ = autoexec.img3_;
        this.imgDriveletter_ = autoexec.imgDriveletter_;
        this.mixer_ = autoexec.mixer_;
        this.keyb_ = autoexec.keyb_;
        this.ipxnet_ = autoexec.ipxnet_;
        this.loadfix_ = autoexec.loadfix_;
        this.loadhigh_ = autoexec.loadhigh_;
        this.exit_ = autoexec.exit_;
        this.pause_ = autoexec.pause_;
        this.booterByDefault_ = autoexec.booterByDefault_;
        this.loadfixValue_ = autoexec.loadfixValue_;
        this.customSections_ = Arrays.copyOf(autoexec.customSections_, SECTIONS);
        this.mountingpoints_ = new ArrayList<Mount>();
    }

    public String getMain() {
        return this.main_;
    }

    public void setMain(String main) {
        this.main_ = main;
    }

    public String getParameters() {
        return this.parameters_;
    }

    public void setParameters(String parameters) {
        this.parameters_ = parameters;
    }

    public String getImg1() {
        return this.img1_;
    }

    public void setImg1(String img1) {
        this.img1_ = img1;
    }

    public String getImg2() {
        return this.img2_;
    }

    public void setImg2(String img2) {
        this.img2_ = img2;
    }

    public String getImg3() {
        return this.img3_;
    }

    public void setImg3(String img3) {
        this.img3_ = img3;
    }

    public String getImgDriveletter() {
        return this.imgDriveletter_;
    }

    public void setImgDriveletter(String imgDriveletter) {
        this.imgDriveletter_ = imgDriveletter;
    }

    public String getMixer() {
        return this.mixer_;
    }

    public void setMixer(String mixer) {
        this.mixer_ = mixer;
    }

    public String getKeyb() {
        return this.keyb_;
    }

    public void setKeyb(String keyb) {
        this.keyb_ = keyb;
    }

    public String getIpxnet() {
        return this.ipxnet_;
    }

    public void setIpxnet(String ipxnet) {
        this.ipxnet_ = ipxnet;
    }

    public Boolean isLoadfix() {
        return this.loadfix_;
    }

    public String getLoadfix() {
        return BooleanUtils.toStringTrueFalse((Boolean)this.loadfix_);
    }

    public void setLoadfix(Boolean loadfix) {
        this.loadfix_ = loadfix;
    }

    public void setLoadfix(String loadfix) {
        this.loadfix_ = StringUtils.isNotBlank((CharSequence)loadfix) ? Boolean.valueOf(loadfix) : null;
    }

    public Boolean isLoadhigh() {
        return this.loadhigh_;
    }

    public String getLoadhigh() {
        return BooleanUtils.toStringTrueFalse((Boolean)this.loadhigh_);
    }

    public void setLoadhigh(Boolean loadhigh) {
        this.loadhigh_ = loadhigh;
    }

    public void setLoadhigh(String loadhigh) {
        this.loadhigh_ = StringUtils.isNotBlank((CharSequence)loadhigh) ? Boolean.valueOf(loadhigh) : null;
    }

    public Boolean isExit() {
        return this.exit_;
    }

    public String getExit() {
        return BooleanUtils.toStringTrueFalse((Boolean)this.exit_);
    }

    public void setExit(Boolean exit) {
        this.exit_ = exit;
    }

    public void setExit(String exit) {
        this.exit_ = StringUtils.isNotBlank((CharSequence)exit) ? Boolean.valueOf(exit) : null;
    }

    public Boolean getPause() {
        return this.pause_;
    }

    public void setPause(Boolean pause) {
        this.pause_ = pause;
    }

    public Boolean getBooterByDefault() {
        return this.booterByDefault_;
    }

    public void setBooterByDefault(Boolean booterByDefault) {
        this.booterByDefault_ = booterByDefault;
    }

    public int getLoadfixValue() {
        return this.loadfixValue_;
    }

    public String getLoadfixValueAsString() {
        return Objects.toString(this.loadfixValue_, null);
    }

    public void setLoadfixValue(String loadfixValue) {
        try {
            this.loadfixValue_ = NumberUtils.createInteger((String)loadfixValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String[] getCustomSections() {
        return this.customSections_;
    }

    public String getCustomSection(int index) {
        return this.customSections_[index];
    }

    public void setCustomSections(String[] customSections) {
        this.customSections_ = customSections;
    }

    public void setCustomSection(int index, String customSection) {
        this.customSections_[index] = customSection;
    }

    public String[] getSetPathsFromCustomSections() {
        for (String section : this.customSections_) {
            String[] commands;
            for (String command : commands = section.split(SystemUtils.EOLN)) {
                if (command.toLowerCase().startsWith("set path=")) {
                    return command.substring(9).trim().split(";");
                }
                if (!command.toLowerCase().startsWith("path=")) continue;
                return command.substring(5).trim().split(";");
            }
        }
        return new String[0];
    }

    private void insertCustomSection(StringBuilder sb, int sectionNr) {
        if (StringUtils.isNotEmpty((CharSequence)this.customSections_[sectionNr])) {
            sb.append(CUSTOM_SECTION_MARKERS[sectionNr * 2 + 0]).append(SystemUtils.EOLN);
            sb.append(StringUtils.chomp((String)this.customSections_[sectionNr])).append(SystemUtils.EOLN);
            sb.append(CUSTOM_SECTION_MARKERS[sectionNr * 2 + 1]).append(SystemUtils.EOLN);
        }
    }

    public List<Mount> getMountingpoints() {
        return this.mountingpoints_;
    }

    public void setMountingpoints(List<Mount> mountingpoints) {
        this.mountingpoints_ = mountingpoints;
    }

    public long countImageMounts() {
        return this.mountingpoints_.stream().filter(ImageMount.class::isInstance).count();
    }

    public File[] findFirstImageMountCanonicalPath() {
        return this.mountingpoints_.stream().filter(ImageMount.class::isInstance).findFirst().map(x -> ((ImageMount)x).getCanonicalImgPaths()).orElse(new File[0]);
    }

    private boolean hasImageMountMatch(String file) {
        return this.mountingpoints_.stream().anyMatch(x -> x instanceof ImageMount && ((ImageMount)x).matchesImgPath(file));
    }

    private String findImageMatchByDrive(char driveLetter) {
        return this.mountingpoints_.stream().filter(x -> x instanceof ImageMount && driveLetter == x.getDrive()).findFirst().map(x -> ((ImageMount)x).getImgPaths()[0].getPath()).orElse(null);
    }

    public void addMount(String mount, File baseDir) {
        try {
            Mount mnt = MountFactory.create(mount);
            mnt.setBaseDir(baseDir);
            this.mountingpoints_.add(mnt);
        }
        catch (InvalidMountstringException e) {
            System.err.println("Invalid mount command \"" + mount + "\"");
        }
    }

    public void addMount(String mount) {
        try {
            this.mountingpoints_.add(MountFactory.create(mount));
        }
        catch (InvalidMountstringException e) {
            System.err.println("Invalid mount command \"" + mount + "\"");
        }
    }

    public boolean isDos() {
        if (StringUtils.isBlank((CharSequence)this.main_) && StringUtils.isBlank((CharSequence)this.img1_)) {
            return BooleanUtils.isNotTrue((Boolean)this.booterByDefault_);
        }
        return StringUtils.isNotBlank((CharSequence)this.main_);
    }

    public boolean isBooter() {
        if (StringUtils.isBlank((CharSequence)this.main_) && StringUtils.isBlank((CharSequence)this.img1_)) {
            return BooleanUtils.isTrue((Boolean)this.booterByDefault_);
        }
        return StringUtils.isNotBlank((CharSequence)this.img1_);
    }

    public String getGameMain() {
        return this.isDos() ? this.main_ : this.img1_;
    }

    public File getCanonicalGameDir() {
        if (this.isDos() || this.isBooter()) {
            File file = new FileLocation(this.isDos() ? this.main_ : this.img1_, FileLocationService.getInstance().dosrootRelative()).getCanonicalFile();
            File main = FilesUtils.determineMainFile(file);
            return main != null && !main.equals(file) && main.getParentFile() != null ? main.getParentFile() : file.getParentFile();
        }
        return null;
    }

    public void setGameMain(String file) {
        if (this.isDos()) {
            this.main_ = file;
        } else {
            this.img1_ = file;
        }
    }

    public boolean isIncomplete(List<Mount> combinedMountingpoints) {
        if (this.isDos()) {
            return !this.canBeReachedUsingMounts(false, this.main_, combinedMountingpoints);
        }
        if (this.isBooter()) {
            return !this.canBeReachedUsingMounts(true, this.img1_, combinedMountingpoints);
        }
        return true;
    }

    public String getDosFilename(String location, List<Mount> combinedMountingpoints) {
        return (Autoexec)this.new DosPath((FileLocation)new FileLocation((String)location, (ICanonicalize)FileLocationService.getInstance().dosrootRelative()), combinedMountingpoints).file_;
    }

    public boolean canBeReachedUsingMounts(boolean booter, String location, List<Mount> combinedMountingpoints) {
        return booter && this.hasImageMountMatch(location) || (Autoexec)this.new DosPath((FileLocation)new FileLocation((String)location, (ICanonicalize)FileLocationService.getInstance().dosrootRelative()), combinedMountingpoints).drive_ != null;
    }

    public String load(List<String> lines, List<Mount> dbMounts, File cwd) {
        StringBuilder warningsLog = new StringBuilder();
        File baseDir = cwd == null ? FileLocationService.getInstance().getDosroot() : cwd;
        char driveletter = '\u0000';
        String directory = "";
        String executable = "";
        String image1 = "";
        String image2 = "";
        String image3 = "";
        int exeIndex = -1;
        StringBuilder customEchos = new StringBuilder();
        ArrayList<String> leftOvers = new ArrayList<String>();
        int customSection = -1;
        block2: for (String orgLine : lines) {
            String line;
            orgLine = orgLine.trim();
            for (int i = 0; i < SECTIONS; ++i) {
                if (!orgLine.startsWith(CUSTOM_SECTION_MARKERS[i * 2])) continue;
                customSection = i;
                continue block2;
            }
            if (customSection > -1) {
                if (orgLine.startsWith(CUSTOM_SECTION_MARKERS[customSection * 2 + 1])) {
                    customSection = -1;
                    continue;
                }
                int n = customSection;
                this.customSections_[n] = this.customSections_[n] + orgLine + SystemUtils.EOLN;
                continue;
            }
            orgLine = StringUtils.stripStart((String)orgLine, (String)"@").trim();
            Matcher loadhighMatcher = LOADHIGH_PATRN.matcher(orgLine);
            Matcher loadfixMatcher = LOADFIX_PATRN.matcher(orgLine);
            Matcher bootMatcher = BOOT_PATRN.matcher(orgLine);
            if (loadhighMatcher.matches()) {
                this.loadhigh_ = true;
                orgLine = loadhighMatcher.group(1).trim();
            }
            if (loadfixMatcher.matches()) {
                if (BooleanUtils.isNotTrue((Boolean)this.loadfix_)) {
                    this.loadfixValue_ = 64;
                    this.loadfix_ = true;
                }
                if (loadfixMatcher.group(1) != null) continue;
                if (loadfixMatcher.group(2) != null) {
                    try {
                        this.loadfixValue_ = Integer.parseInt(loadfixMatcher.group(2).trim().substring(1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (loadfixMatcher.group(3) == null) continue;
                orgLine = loadfixMatcher.group(3).trim();
            }
            if ((line = orgLine.toLowerCase()).startsWith("mount ") || line.startsWith("imgmount ")) {
                if (cwd == null) {
                    this.addMount(orgLine);
                    continue;
                }
                this.addMount(orgLine, baseDir);
                continue;
            }
            if (line.endsWith(":") && line.length() == 2 || line.endsWith(":\\") && line.length() == 3) {
                if (driveletter == Character.toUpperCase(line.charAt(0))) continue;
                driveletter = Character.toUpperCase(line.charAt(0));
                directory = "";
                continue;
            }
            if (line.startsWith("cd\\")) {
                if (driveletter == '\u0000') continue;
                directory = FilenameUtils.separatorsToSystem((String)orgLine).substring(2);
                continue;
            }
            if (line.startsWith("cd ")) {
                if (driveletter == '\u0000') continue;
                String add = FilenameUtils.separatorsToSystem((String)orgLine).substring(3);
                if (add.startsWith(File.separator)) {
                    directory = add;
                    continue;
                }
                directory = new File(directory, add).getPath();
                continue;
            }
            if (line.startsWith("cd.")) {
                if (driveletter == '\u0000') continue;
                String add = FilenameUtils.separatorsToSystem((String)orgLine).substring(2);
                if (directory.equals("") && add.equals("..")) continue;
                directory = new File(directory, add).getPath();
                continue;
            }
            if (line.startsWith("keyb ") || line.startsWith("keyb.com ")) {
                this.keyb_ = orgLine.substring(line.indexOf(32) + 1);
                continue;
            }
            if (line.startsWith("mixer ") || line.startsWith("mixer.com ")) {
                this.mixer_ = orgLine.substring(line.indexOf(32) + 1);
                continue;
            }
            if (line.startsWith("ipxnet ") || line.startsWith("ipxnet.com ")) {
                this.ipxnet_ = orgLine.substring(line.indexOf(32) + 1);
                continue;
            }
            if (line.equals("pause")) {
                this.pause_ = true;
                continue;
            }
            if (line.startsWith("z:\\config.com")) continue;
            exeIndex = StringUtils.indexOfAny((CharSequence)line, (CharSequence[])FilesUtils.dosExecutables());
            if (exeIndex != -1) {
                int spaceAfterIndex;
                int spaceBeforeIndex;
                executable = orgLine;
                if (executable.startsWith(DFR_4DOS_PREFIX)) {
                    executable = executable.substring(DFR_4DOS_PREFIX.length());
                }
                if (executable.startsWith(DFR_DOS32A_PREFIX)) {
                    executable = executable.substring(DFR_DOS32A_PREFIX.length());
                }
                if ((spaceBeforeIndex = executable.lastIndexOf(32, exeIndex)) != -1) {
                    executable = executable.substring(spaceBeforeIndex + 1);
                }
                if ((spaceAfterIndex = executable.indexOf(32)) == -1) continue;
                this.parameters_ = orgLine.substring(spaceBeforeIndex + spaceAfterIndex + 2);
                executable = executable.substring(0, spaceAfterIndex);
                continue;
            }
            if (bootMatcher.matches()) {
                Matcher bootImgsMatcher = BOOTIMGS_PATRN.matcher(bootMatcher.group(1).trim());
                if (bootImgsMatcher.matches()) {
                    if (bootImgsMatcher.group(1) != null) {
                        image1 = FilenameUtils.separatorsToSystem((String)StringUtils.strip((String)bootImgsMatcher.group(1), (String)"\""));
                    }
                    if (bootImgsMatcher.group(2) != null) {
                        image2 = FilenameUtils.separatorsToSystem((String)StringUtils.strip((String)bootImgsMatcher.group(2), (String)"\""));
                    }
                    if (bootImgsMatcher.group(3) != null) {
                        image3 = FilenameUtils.separatorsToSystem((String)StringUtils.strip((String)bootImgsMatcher.group(3), (String)"\""));
                    }
                }
                if (bootMatcher.group(2) != null) {
                    this.imgDriveletter_ = bootMatcher.group(2).trim().toUpperCase();
                }
                if (StringUtils.isEmpty((CharSequence)image1) && StringUtils.isNotEmpty((CharSequence)this.imgDriveletter_)) {
                    String matchingImageMount = this.findImageMatchByDrive(this.imgDriveletter_.charAt(0));
                    if (matchingImageMount != null) {
                        image1 = matchingImageMount;
                    } else {
                        char driveNumber = (char)(this.imgDriveletter_.charAt(0) - 17);
                        matchingImageMount = this.findImageMatchByDrive(driveNumber);
                        if (matchingImageMount != null) {
                            image1 = matchingImageMount;
                        }
                    }
                }
                if (!(File.separator + "file").equals(image1)) continue;
                this.img1_ = "file";
                continue;
            }
            if (line.equals("exit") || line.startsWith("exit ")) {
                this.exit_ = true;
                break;
            }
            if (line.equals("echo off")) continue;
            if (line.equals("echo") || line.startsWith("echo ") || line.startsWith("echo.")) {
                customEchos.append(orgLine).append(SystemUtils.EOLN);
                continue;
            }
            if (line.startsWith(":") || line.equals("cd") || line.equals("cls") || line.startsWith("cls ") || line.startsWith("cls\\") || line.equals("rem") || line.startsWith("rem ") || line.startsWith("goto ") || line.startsWith("if errorlevel ") || !StringUtils.isNotBlank((CharSequence)line)) continue;
            leftOvers.add(orgLine);
        }
        if (StringUtils.isNotEmpty((CharSequence)customEchos) && !customEchos.toString().equalsIgnoreCase("echo." + SystemUtils.EOLN)) {
            this.customSections_[1] = this.customSections_[1] + "@echo off" + SystemUtils.EOLN + customEchos;
            this.customSections_[1] = this.customSections_[1] + "pause" + SystemUtils.EOLN;
        }
        if (executable.equals("") && !leftOvers.isEmpty()) {
            int spaceAfterIndex;
            for (int i = 0; i < leftOvers.size() - 1; ++i) {
                this.customSections_[1] = this.customSections_[1] + ((String)leftOvers.get(i)).trim() + SystemUtils.EOLN;
            }
            executable = ((String)leftOvers.get(leftOvers.size() - 1)).trim();
            boolean isCalledBatch = executable.toLowerCase().startsWith("call ");
            if (isCalledBatch) {
                executable = executable.substring(5);
            }
            if ((spaceAfterIndex = executable.indexOf(32)) != -1) {
                this.parameters_ = executable.substring(spaceAfterIndex + 1);
                executable = executable.substring(0, spaceAfterIndex);
            }
            executable = executable + (isCalledBatch ? FilesUtils.dosExecutables()[2] : FilesUtils.dosExecutables()[0]);
        }
        if (executable.length() > 2 && executable.charAt(1) == ':') {
            driveletter = executable.charAt(0);
            executable = executable.substring(2);
        } else if (image1.length() > 2 && image1.charAt(1) == ':') {
            driveletter = image1.charAt(0);
            image1 = image1.substring(2);
            if (image2.length() > 2 && image2.charAt(1) == ':') {
                image2 = image2.substring(2);
            }
            if (image3.length() > 2 && image3.charAt(1) == ':') {
                image3 = image3.substring(2);
            }
        }
        List<Mount> mountingpointsForExecutables = dbMounts != null ? Stream.concat(dbMounts.stream(), this.mountingpoints_.stream()).collect(Collectors.toList()) : this.mountingpoints_;
        for (Mount mount : mountingpointsForExecutables) {
            if (mount instanceof DirMount) {
                if (StringUtils.isNotBlank((CharSequence)executable) && mount.matchesDrive(driveletter)) {
                    this.main_ = Autoexec.constructPath(((DirMount)mount).getPath(), directory, executable);
                }
                if (StringUtils.isNotBlank((CharSequence)image1) && mount.matchesDrive(driveletter)) {
                    this.img1_ = Autoexec.constructPath(((DirMount)mount).getPath(), directory, image1);
                }
                if (StringUtils.isNotBlank((CharSequence)image2) && mount.matchesDrive(driveletter)) {
                    this.img2_ = Autoexec.constructPath(((DirMount)mount).getPath(), directory, image2);
                }
                if (!StringUtils.isNotBlank((CharSequence)image3) || !mount.matchesDrive(driveletter)) continue;
                this.img3_ = Autoexec.constructPath(((DirMount)mount).getPath(), directory, image3);
                continue;
            }
            if (!(mount instanceof ImageMount)) continue;
            if (StringUtils.isNotBlank((CharSequence)executable) && mount.matchesDrive(driveletter)) {
                this.main_ = Autoexec.constructPath(((ImageMount)mount).getImgPaths()[0], directory, executable);
            }
            if (StringUtils.isNotBlank((CharSequence)image1) && ((ImageMount)mount).matchesImgPath(image1)) {
                this.img1_ = image1;
            }
            if (StringUtils.isNotBlank((CharSequence)image2) && ((ImageMount)mount).matchesImgPath(image2)) {
                this.img2_ = image2;
            }
            if (!StringUtils.isNotBlank((CharSequence)image3) || !((ImageMount)mount).matchesImgPath(image3)) continue;
            this.img3_ = image3;
        }
        if (StringUtils.isBlank((CharSequence)this.main_) && StringUtils.isBlank((CharSequence)this.img1_)) {
            if (StringUtils.isNotBlank((CharSequence)image1)) {
                if (cwd == null) {
                    this.addMount("imgmount a \"" + image1 + "\"");
                } else {
                    this.addMount("imgmount a \"" + image1 + "\"", baseDir);
                }
                this.img1_ = image1;
            }
            if (StringUtils.isNotBlank((CharSequence)image2)) {
                if (cwd == null) {
                    this.addMount("imgmount b \"" + image2 + "\"");
                } else {
                    this.addMount("imgmount b \"" + image2 + "\"", baseDir);
                }
                this.img2_ = image2;
            }
            if (StringUtils.isNotBlank((CharSequence)image3)) {
                if (cwd == null) {
                    this.addMount("imgmount c \"" + image3 + "\"");
                } else {
                    this.addMount("imgmount c \"" + image3 + "\"", baseDir);
                }
                this.img3_ = image3;
            }
        }
        if (this.exit_ == null) {
            this.exit_ = false;
        }
        return warningsLog.toString();
    }

    private static String constructPath(File mountDir, String dosPath, String executable) {
        String normalizedPath = Paths.get(mountDir.getPath(), dosPath, executable).normalize().toString();
        FileLocation location = new FileLocation(normalizedPath, FileLocationService.getInstance().dosrootRelative());
        return location.getFile().getPath();
    }

    public void setGameMainPath(File mainParentFile) {
        if (this.isDos()) {
            this.main_ = new File(mainParentFile, new File(this.main_).getName()).getPath();
        } else if (this.isBooter()) {
            this.img1_ = new File(mainParentFile, new File(this.img1_).getName()).getPath();
            if (StringUtils.isNotEmpty((CharSequence)this.img2_)) {
                this.img2_ = new File(mainParentFile, new File(this.img2_).getName()).getPath();
            }
            if (StringUtils.isNotEmpty((CharSequence)this.img3_)) {
                this.img3_ = new File(mainParentFile, new File(this.img3_).getName()).getPath();
            }
        }
    }

    public void setBaseDir(File baseDir) {
        for (Mount mount : this.mountingpoints_) {
            mount.setBaseDir(baseDir);
        }
        if (this.isDos()) {
            this.setMain(FilesUtils.concat(baseDir, this.main_));
        } else if (this.isBooter()) {
            this.setImg1(FilesUtils.concat(baseDir, this.img1_));
            if (StringUtils.isNotEmpty((CharSequence)this.img2_)) {
                this.setImg2(FilesUtils.concat(baseDir, this.img2_));
            }
            if (StringUtils.isNotEmpty((CharSequence)this.img3_)) {
                this.setImg3(FilesUtils.concat(baseDir, this.img3_));
            }
        }
    }

    public void migrate(FileLocation fromPath, FileLocation toPath) {
        for (Mount mount : this.mountingpoints_) {
            mount.migrate(fromPath, toPath);
        }
        if (this.isDos()) {
            FileLocation main = new FileLocation(this.main_, FileLocationService.getInstance().dosrootRelative());
            String newMainString = FilesUtils.migrate(main, fromPath, toPath).getFile().getPath();
            if (this.canBeReachedUsingMounts(false, newMainString, this.mountingpoints_)) {
                this.main_ = newMainString;
            }
        } else {
            FileLocation img3;
            String newImg3String;
            FileLocation img2;
            String newImg2String;
            FileLocation img1 = new FileLocation(this.img1_, FileLocationService.getInstance().dosrootRelative());
            String newImg1String = FilesUtils.migrate(img1, fromPath, toPath).getFile().getPath();
            if (this.canBeReachedUsingMounts(true, newImg1String, this.mountingpoints_)) {
                this.img1_ = newImg1String;
            }
            if (StringUtils.isNotEmpty((CharSequence)this.img2_) && this.canBeReachedUsingMounts(true, newImg2String = FilesUtils.migrate(img2 = new FileLocation(this.img2_, FileLocationService.getInstance().dosrootRelative()), fromPath, toPath).getFile().getPath(), this.mountingpoints_)) {
                this.img2_ = newImg2String;
            }
            if (StringUtils.isNotEmpty((CharSequence)this.img3_) && this.canBeReachedUsingMounts(true, newImg3String = FilesUtils.migrate(img3 = new FileLocation(this.img3_, FileLocationService.getInstance().dosrootRelative()), fromPath, toPath).getFile().getPath(), this.mountingpoints_)) {
                this.img3_ = newImg3String;
            }
        }
    }

    public void removeUnequalValuesIn(Autoexec autoexec) {
        if (!StringUtils.equals((CharSequence)this.getMixer(), (CharSequence)autoexec.getMixer())) {
            this.setMixer(null);
        }
        if (!StringUtils.equals((CharSequence)this.getKeyb(), (CharSequence)autoexec.getKeyb())) {
            this.setKeyb(null);
        }
        if (!StringUtils.equals((CharSequence)this.getIpxnet(), (CharSequence)autoexec.getIpxnet())) {
            this.setIpxnet(null);
        }
        if (!StringUtils.equals((CharSequence)this.getLoadfix(), (CharSequence)autoexec.getLoadfix())) {
            this.setLoadfix((String)null);
        }
        if (!StringUtils.equals((CharSequence)this.getLoadhigh(), (CharSequence)autoexec.getLoadhigh())) {
            this.setLoadhigh((String)null);
        }
        if (!StringUtils.equals((CharSequence)this.getExit(), (CharSequence)autoexec.getExit())) {
            this.setExit((String)null);
        }
        if (!StringUtils.equals((CharSequence)this.getLoadfixValueAsString(), (CharSequence)autoexec.getLoadfixValueAsString())) {
            this.setLoadfixValue(null);
        }
        for (int i = 0; i < SECTIONS; ++i) {
            if (StringUtils.equals((CharSequence)this.getCustomSection(i), (CharSequence)autoexec.getCustomSection(i))) continue;
            this.setCustomSection(i, null);
        }
    }

    public void removeUnnecessaryMounts(Autoexec autoexec) {
        this.mountingpoints_ = this.mountingpoints_.stream().filter(x -> !x.isUnmounted() && autoexec.mountingpoints_.stream().noneMatch(y -> y.getDrive() == x.getDrive())).collect(Collectors.toList());
    }

    public String toString() {
        return this.toString(false, null);
    }

    public String toString(boolean prepareOnly, List<Mount> combinedMountingpoints) {
        DosPath dosLocation;
        StringBuilder result = new StringBuilder();
        List<Mount> mountingpointsForExecutables = combinedMountingpoints != null ? combinedMountingpoints : this.mountingpoints_;
        this.insertCustomSection(result, 0);
        if (StringUtils.isNotBlank((CharSequence)this.keyb_)) {
            result.append("keyb.com ").append(this.keyb_).append(SystemUtils.EOLN);
        }
        if (StringUtils.isNotBlank((CharSequence)this.ipxnet_)) {
            result.append("ipxnet.com ").append(this.ipxnet_).append(SystemUtils.EOLN);
        }
        for (Mount mount : this.mountingpoints_) {
            result.append(mount.toString()).append(SystemUtils.EOLN);
        }
        if (StringUtils.isNotBlank((CharSequence)this.mixer_)) {
            result.append("mixer.com ").append(this.mixer_).append(SystemUtils.EOLN);
        }
        if (StringUtils.isNotBlank((CharSequence)this.main_)) {
            FileLocation main = new FileLocation(this.main_, FileLocationService.getInstance().dosrootRelative());
            dosLocation = new DosPath(main, mountingpointsForExecutables);
            if (dosLocation.drive_ != null) {
                result.append(dosLocation.drive_ + SystemUtils.EOLN);
                result.append("cd \\" + dosLocation.directory_ + SystemUtils.EOLN);
                if (BooleanUtils.isTrue((Boolean)this.loadfix_)) {
                    result.append("loadfix -").append(this.loadfixValue_ != null && this.loadfixValue_ > 0 ? this.loadfixValue_ : 64).append(SystemUtils.EOLN);
                }
                this.insertCustomSection(result, 1);
                if (!prepareOnly) {
                    if (BooleanUtils.isTrue((Boolean)this.loadhigh_)) {
                        result.append("loadhigh ");
                    }
                    if (this.main_.toLowerCase().endsWith(FilesUtils.dosExecutables()[2])) {
                        result.append("call ");
                    }
                    result.append(dosLocation.file_);
                    if (StringUtils.isNotBlank((CharSequence)this.parameters_)) {
                        result.append(' ').append(this.parameters_);
                    }
                    result.append(SystemUtils.EOLN);
                    this.insertCustomSection(result, 2);
                }
            }
        } else if (StringUtils.isNotBlank((CharSequence)this.img1_)) {
            if (BooleanUtils.isTrue((Boolean)this.loadfix_)) {
                result.append("loadfix -").append(this.loadfixValue_ > 0 ? this.loadfixValue_ : 64).append(SystemUtils.EOLN);
            }
            this.insertCustomSection(result, 1);
            if (!prepareOnly) {
                String q;
                result.append("boot");
                if (this.img1_.equals("file")) {
                    result.append(" \\file");
                } else if (this.hasImageMountMatch(this.img1_)) {
                    result.append(" \"").append(this.img1_).append("\"");
                } else {
                    FileLocation img1 = new FileLocation(this.img1_, FileLocationService.getInstance().dosrootRelative());
                    dosLocation = new DosPath(img1, mountingpointsForExecutables);
                    if (dosLocation.drive_ != null) {
                        q = dosLocation.file_.indexOf(32) == -1 ? "" : "\"";
                        result.append(" ").append(q).append(dosLocation.drive_).append('\\').append(dosLocation.directory_);
                        if (StringUtils.isNotBlank((CharSequence)dosLocation.directory_)) {
                            result.append('\\');
                        }
                        result.append(dosLocation.file_).append(q);
                    }
                }
                if (this.hasImageMountMatch(this.img2_)) {
                    result.append(" \"").append(this.img2_).append("\"");
                } else if (StringUtils.isNotBlank((CharSequence)this.img2_)) {
                    FileLocation img2 = new FileLocation(this.img2_, FileLocationService.getInstance().dosrootRelative());
                    dosLocation = new DosPath(img2, mountingpointsForExecutables);
                    if (dosLocation.drive_ != null) {
                        q = dosLocation.file_.indexOf(32) == -1 ? "" : "\"";
                        result.append(" ").append(q).append(dosLocation.drive_).append('\\').append(dosLocation.directory_);
                        if (StringUtils.isNotBlank((CharSequence)dosLocation.directory_)) {
                            result.append('\\');
                        }
                        result.append(dosLocation.file_).append(q);
                    }
                }
                if (this.hasImageMountMatch(this.img3_)) {
                    result.append(" \"").append(this.img3_).append("\"");
                } else if (StringUtils.isNotBlank((CharSequence)this.img3_)) {
                    FileLocation img3 = new FileLocation(this.img3_, FileLocationService.getInstance().dosrootRelative());
                    dosLocation = new DosPath(img3, mountingpointsForExecutables);
                    if (dosLocation.drive_ != null) {
                        q = dosLocation.file_.indexOf(32) == -1 ? "" : "\"";
                        result.append(" ").append(q).append(dosLocation.drive_).append('\\').append(dosLocation.directory_);
                        if (StringUtils.isNotBlank((CharSequence)dosLocation.directory_)) {
                            result.append('\\');
                        }
                        result.append(dosLocation.file_).append(q);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)this.imgDriveletter_)) {
                    result.append(" -l ").append(this.imgDriveletter_);
                }
                result.append(SystemUtils.EOLN);
                this.insertCustomSection(result, 2);
            }
        } else {
            this.insertCustomSection(result, 1);
            this.insertCustomSection(result, 2);
        }
        if (!prepareOnly) {
            if (BooleanUtils.isTrue((Boolean)this.loadfix_)) {
                result.append("loadfix -f").append(SystemUtils.EOLN);
            }
            this.insertCustomSection(result, 3);
            if (BooleanUtils.isTrue((Boolean)this.pause_)) {
                result.append("pause").append(SystemUtils.EOLN);
            }
            if (BooleanUtils.isTrue((Boolean)this.exit_)) {
                result.append("exit").append(SystemUtils.EOLN);
            }
        }
        if (result.length() > 0) {
            result.insert(0, "[autoexec]" + SystemUtils.EOLN);
        }
        return result.toString();
    }

    class DosPath {
        String drive_;
        String directory_;
        String file_;

        public DosPath(FileLocation hostFileLocation, List<Mount> mountingpoints) {
            int minLengthMount = Integer.MAX_VALUE;
            for (Mount mount : mountingpoints) {
                File dosboxDir = mount.canBeUsedFor(hostFileLocation);
                if (dosboxDir == null || dosboxDir.getPath().length() >= minLengthMount) continue;
                this.drive_ = mount.getDrive() + ":";
                this.directory_ = dosboxDir.getParent() == null ? "" : FilenameUtils.separatorsToWindows((String)dosboxDir.getParent());
                this.file_ = hostFileLocation.getFile().getName();
                minLengthMount = dosboxDir.getPath().length();
            }
        }
    }
}

