/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.ShortFile;

public class ShortFilenameUtils {
    private static final Pattern VALID_DOS_FILENAME_REGEXP = Pattern.compile("^[_$#@()!%{}`~_\\-&+^\\u00F7\\u00A0\\u00E5\\u00BDa-zA-Z0-9]{1,8}(\\.[_$#@()!%{}`~_\\-&+^\\u00F7\\u00A0\\u00E5\\u00BDa-zA-Z0-9]{1,3}){0,1}$");

    private ShortFilenameUtils() {
    }

    public static Set<String> convertToShortFileSet(Set<String> fileList) {
        TreeSet<ShortFile> result = new TreeSet<ShortFile>();
        for (String file : fileList) {
            result.add(ShortFilenameUtils.createShortFile(file, result));
        }
        return result.stream().map(x -> new File(x.getFile().getParentFile(), x.getName()).getPath()).collect(Collectors.toCollection(HashSet::new));
    }

    private static ShortFile createShortFile(String path, Set<ShortFile> curDir) {
        String filename = FilenameUtils.getName((String)path);
        boolean createShort = false;
        if (StringUtils.contains((CharSequence)filename, (int)32)) {
            filename = StringUtils.remove((String)filename, (char)' ');
            createShort = true;
        }
        int len = 0;
        int idx = filename.indexOf(46);
        if (idx != -1) {
            if (filename.length() - idx - 1 > 3) {
                filename = StringUtils.stripStart((String)filename, (String)".");
                createShort = true;
            }
            len = (idx = filename.indexOf(46)) != -1 ? idx : filename.length();
        } else {
            len = filename.length();
        }
        boolean bl = len > 8;
        ShortFile shortFile = null;
        if (!(createShort |= bl)) {
            shortFile = new ShortFile(new File(path), StringUtils.removeEnd((String)filename, (String)"."));
        } else {
            StringBuilder sb;
            int i = 1;
            do {
                String nr = String.valueOf(i++);
                sb = new StringBuilder(StringUtils.left((String)filename, (int)Math.min(8 - nr.length() - 1, len)));
                sb.append('~').append(nr);
                idx = filename.lastIndexOf(46);
                if (idx == -1) continue;
                sb.append(StringUtils.left((String)filename.substring(idx), (int)4));
            } while ((shortFile = new ShortFile(new File(path), StringUtils.removeEnd((String)sb.toString(), (String)"."))).isContainedIn(curDir));
        }
        return shortFile;
    }

    public static boolean valid(String dosFilename) {
        return dosFilename != null && VALID_DOS_FILENAME_REGEXP.matcher(dosFilename).matches();
    }
}

