/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.archive;

import SevenZip.Archive.IInArchive;
import java.io.File;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dbgl.util.FilesUtils;

public class SevenzipUtils {
    private SevenzipUtils() {
    }

    public static Map<Integer, File> findEntries(IInArchive zArchive, File dirToBeExtracted, File dstDir) {
        LinkedHashMap<Integer, File> result = new LinkedHashMap<Integer, File>();
        for (int i = 0; i < zArchive.size(); ++i) {
            File entryFile = new File(zArchive.getEntry(i).getName());
            if (!FilesUtils.areRelated(dirToBeExtracted, entryFile)) continue;
            String relativeFile = FilesUtils.relativize(dirToBeExtracted, entryFile);
            File dstFile = new File(dstDir, relativeFile);
            result.put(i, dstFile);
        }
        return result;
    }

    public static Map.Entry<Integer, File> findEntry(IInArchive zArchive, File fileToBeExtracted, File dstFile) {
        String entryName = FilesUtils.toArchivePath(fileToBeExtracted, false);
        for (int i = 0; i < zArchive.size(); ++i) {
            if (!zArchive.getEntry(i).getName().equals(entryName)) continue;
            return new AbstractMap.SimpleEntry<Integer, File>(i, dstFile);
        }
        return null;
    }
}

