/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.iso;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.dbgl.util.iso.ISO9660FileEntry;
import org.dbgl.util.iso.ISO9660FileSystem;
import org.dbgl.util.iso.Util;

class EntryIterator
implements Iterator<ISO9660FileEntry> {
    private final ISO9660FileSystem fileSystem_;
    private final List<ISO9660FileEntry> queue_;

    public EntryIterator(ISO9660FileSystem fileSystem, ISO9660FileEntry rootEntry) {
        this.fileSystem_ = fileSystem;
        this.queue_ = new LinkedList<ISO9660FileEntry>();
        this.queue_.add(rootEntry);
    }

    @Override
    public boolean hasNext() {
        return !this.queue_.isEmpty();
    }

    @Override
    public ISO9660FileEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ISO9660FileEntry entry = this.queue_.remove(0);
        if (entry.isDirectory()) {
            byte[] content;
            try {
                content = this.fileSystem_.getBytes(entry);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            int offset = 0;
            boolean paddingMode = false;
            while (offset < content.length) {
                if (Util.getUInt8(content, offset) <= 0) {
                    paddingMode = true;
                    offset += 2;
                    continue;
                }
                ISO9660FileEntry child = new ISO9660FileEntry(this.fileSystem_, entry.getPath(), content, offset + 1);
                if (paddingMode && child.getSize() < 0) continue;
                offset += child.getEntryLength();
                if (".".equals(child.getName()) || "..".equals(child.getName())) continue;
                this.queue_.add(child);
            }
        }
        return entry;
    }
}

