/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.searchengine;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.util.searchengine.WebSearchEngine;

public class MobyGamesSearchEngine
extends WebSearchEngine {
    static final String MOBY_GAMES_HOST_NAME = "www.mobygames.com";
    private static final String HTML_MULTIPLE_RESULT_MARKER_START = "<div class=\"searchResult\">";
    private static final String HTML_GAME_TITLE_START = "<div class=\"searchTitle\">";
    private static final String HTML_GAME_END_MARKER = "<br clear=\"all\"></div>";
    private static final int RESULTS_PER_PAGE = 50;

    private MobyGamesSearchEngine() {
    }

    public static WebSearchEngine getInstance() {
        return SearchEngineHolder.instance_;
    }

    @Override
    public String getIcon() {
        return "moby.png";
    }

    @Override
    public String getName() {
        return "MobyGames";
    }

    @Override
    public String getSimpleName() {
        return "mobygames";
    }

    @Override
    public boolean available() {
        return true;
    }

    @Override
    public List<WebProfile> getEntries(String title, String[] platforms) throws IOException {
        int pages = 1;
        ArrayList<WebProfile> allEntries = new ArrayList<WebProfile>();
        for (int pageIdx = 0; pageIdx < pages; ++pageIdx) {
            String content = MobyGamesSearchEngine.getResponseContent("https://www.mobygames.com/search/quick?sFilter=1&p=-1&sG=on&q=" + URLEncoder.encode(title.replace("/", " "), "UTF-8") + "&offset=" + pageIdx * 50, StandardCharsets.UTF_8);
            if (pageIdx == 0) {
                pages = MobyGamesSearchEngine.getPages(content);
            }
            allEntries.addAll(MobyGamesSearchEngine.extractEntries(content));
        }
        return MobyGamesSearchEngine.filterEntries(platforms, allEntries);
    }

    private static int getPages(String htmlChunk) {
        int i = htmlChunk.indexOf("\"> Games (");
        int j = htmlChunk.indexOf(")</label>", i);
        if (i == -1 || j == -1) {
            return 0;
        }
        int entries = Integer.parseInt(htmlChunk.substring(i + 10, j));
        return (entries + 50 - 1) / 50;
    }

    private static List<WebProfile> extractEntries(String html) {
        ArrayList<WebProfile> allEntries = new ArrayList<WebProfile>();
        int gameMatchEntryIndex = (html = html.replace("\\\\\"", "\"")).indexOf(HTML_MULTIPLE_RESULT_MARKER_START);
        if (gameMatchEntryIndex != -1) {
            gameMatchEntryIndex += HTML_MULTIPLE_RESULT_MARKER_START.length();
        }
        while (gameMatchEntryIndex != -1) {
            gameMatchEntryIndex = html.indexOf("<div", gameMatchEntryIndex);
            int gameTitleIdx = html.indexOf(HTML_GAME_TITLE_START, gameMatchEntryIndex);
            String gameTitleData = MobyGamesSearchEngine.extractNextContent(html, gameTitleIdx, "<div", "</div>");
            String gameTitle = MobyGamesSearchEngine.unescapeHtml(MobyGamesSearchEngine.removeAllTags(gameTitleData)).substring(6);
            String url = MobyGamesSearchEngine.extractNextHrefContent(html, gameTitleIdx);
            String details = MobyGamesSearchEngine.extractNextContent(html, gameTitleIdx + gameTitleData.length(), "<div", "</div>");
            int platformIdx = details.indexOf("<span ");
            while (platformIdx != -1) {
                String platform = MobyGamesSearchEngine.extractNextContent(details, platformIdx, "<span ", "</span>");
                if (platform.indexOf("<a ") != -1) {
                    platform = MobyGamesSearchEngine.extractNextContent(details, platformIdx, "<a ", "</a>");
                    url = MobyGamesSearchEngine.extractNextHrefContent(details, platformIdx);
                } else {
                    int yrIdx = platform.indexOf(" (");
                    if (yrIdx != -1) {
                        platform = platform.substring(0, yrIdx);
                    }
                }
                url = MobyGamesSearchEngine.absoluteUrl(MOBY_GAMES_HOST_NAME, url);
                String year = MobyGamesSearchEngine.extractNextContent(details, platformIdx, "<em>", "</em>");
                WebProfile gameEntry = new WebProfile();
                gameEntry.setTitle(gameTitle);
                gameEntry.setUrl(url);
                gameEntry.setPlatform(platform);
                gameEntry.setYear(year);
                allEntries.add(gameEntry);
                platformIdx = details.indexOf("<span ", platformIdx + 1);
            }
            int endIdx = html.indexOf(HTML_GAME_END_MARKER, gameTitleIdx);
            gameMatchEntryIndex = html.indexOf(HTML_MULTIPLE_RESULT_MARKER_START, endIdx + HTML_GAME_END_MARKER.length());
        }
        return allEntries;
    }

    @Override
    public WebProfile getEntryDetailedInformation(WebProfile entry) throws IOException {
        String responseEntry = MobyGamesSearchEngine.getResponseContent(entry.getUrl(), StandardCharsets.UTF_8);
        entry.setDeveloperName(MobyGamesSearchEngine.extractCategory(responseEntry, ">Developed by</div>"));
        entry.setPublisherName(MobyGamesSearchEngine.extractCategory(responseEntry, ">Published by</div>"));
        entry.setGenre(MobyGamesSearchEngine.extractCategory(responseEntry, ">Genre</div>"));
        entry.setNotes(MobyGamesSearchEngine.extractDescription(responseEntry));
        entry.setRank(MobyGamesSearchEngine.extractRank(entry));
        entry.setCoreGameCoverUrl(MobyGamesSearchEngine.extractCoreGameCoverUrl(responseEntry));
        if (StringUtils.isEmpty((CharSequence)entry.getDeveloperName())) {
            entry.setDeveloperName(MobyGamesSearchEngine.extractCredits(responseEntry, "<h2> Credits"));
        }
        return entry;
    }

    private static String extractCredits(String htmlChunk, String marker) {
        String result;
        String credits;
        int endIndex;
        int startIndex = htmlChunk.indexOf(marker);
        if (startIndex != -1 && (endIndex = htmlChunk.indexOf("</div></div>", startIndex + marker.length())) != -1 && (startIndex = MobyGamesSearchEngine.idxNextHrefContent(credits = htmlChunk.substring(startIndex + marker.length(), endIndex), 0)) != -1 && MobyGamesSearchEngine.idxNextHrefContent(credits, startIndex + (result = MobyGamesSearchEngine.extractNextContent(credits, startIndex, "<a ", "</a>")).length()) == -1 && !result.equalsIgnoreCase("add credits")) {
            return MobyGamesSearchEngine.unescapeHtml(result);
        }
        return "";
    }

    @Override
    public SearchEngineImageInformation[] getEntryImages(WebProfile entry, int coverArtMax, int screenshotsMax, boolean forceAllRegionsCoverArt) throws IOException {
        ArrayList<SearchEngineImageInformation> result = new ArrayList<SearchEngineImageInformation>();
        if (coverArtMax > 0) {
            result.addAll(MobyGamesSearchEngine.getEntryCoverArtInformation(entry, coverArtMax, forceAllRegionsCoverArt));
        }
        if (screenshotsMax > 0) {
            result.addAll(MobyGamesSearchEngine.getEntryScreenshotInformation(entry, screenshotsMax));
        }
        entry.setWebImages(result.toArray(new SearchEngineImageInformation[0]));
        return entry.getWebImages();
    }

    private static String extractCoreGameCoverUrl(String htmlChunk) {
        String beginMarker = "<div id=\"coreGameCover\">";
        String endMarker = "<div class=\"links\">";
        int beginIndex = htmlChunk.indexOf(beginMarker) + beginMarker.length();
        int endIndex = htmlChunk.indexOf(endMarker, beginIndex);
        if (beginIndex == -1 || endIndex == -1) {
            return null;
        }
        String smallChunk = htmlChunk.substring(beginIndex, endIndex);
        if ((beginIndex = MobyGamesSearchEngine.idxNextHrefContent(smallChunk, 0)) == -1) {
            return null;
        }
        return MobyGamesSearchEngine.extractNextHrefContent(smallChunk, beginIndex);
    }

    private static String extractCategory(String htmlChunk, String marker) {
        int startIndex = htmlChunk.indexOf(marker);
        if (startIndex != -1) {
            int endIndex = htmlChunk.indexOf("</div>", startIndex + marker.length());
            return MobyGamesSearchEngine.unescapeHtml(MobyGamesSearchEngine.removeAllTags(htmlChunk.substring(startIndex + marker.length(), endIndex + "</div>".length())));
        }
        return "";
    }

    private static String extractDescription(String htmlChunk) {
        String marker = "<h2>Description</h2>";
        int startIndex = htmlChunk.indexOf(marker) + marker.length();
        int endIndex = htmlChunk.indexOf("<div", startIndex);
        return MobyGamesSearchEngine.unescapeHtml(MobyGamesSearchEngine.removeAllTags(htmlChunk.substring(startIndex, endIndex)));
    }

    private static Integer extractRank(WebProfile entry) throws IOException {
        String html = MobyGamesSearchEngine.getResponseContent(entry.getUrl() + "/mobyrank", StandardCharsets.UTF_8);
        int idx = html.indexOf("Overall User Score");
        if (idx == -1) {
            return 0;
        }
        try {
            return (int)(Double.valueOf(MobyGamesSearchEngine.extractNextContent(html, idx, "<th", "</th>")) * 20.0);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static List<SearchEngineImageInformation> getEntryScreenshotInformation(WebProfile entry, int max) throws IOException {
        String endMarker;
        int endIndex;
        String marker;
        ArrayList<SearchEngineImageInformation> result = new ArrayList<SearchEngineImageInformation>();
        String htmlChunk = MobyGamesSearchEngine.getResponseContent(entry.getScreenshotsUrl(), StandardCharsets.UTF_8);
        int startIndex = htmlChunk.indexOf(marker = "<div class=\"thumbnail\">");
        if (startIndex != -1 && (endIndex = htmlChunk.indexOf(endMarker = "<div id=\"footer-menu\">", startIndex)) != -1) {
            htmlChunk = htmlChunk.substring(startIndex, endIndex);
            startIndex = htmlChunk.indexOf("background-image:url(");
            for (int found = 0; found < max && startIndex != -1; ++found) {
                String imgUrl = MobyGamesSearchEngine.extractNextSrcContentParentheses(htmlChunk, startIndex);
                imgUrl = MobyGamesSearchEngine.absoluteUrl(MOBY_GAMES_HOST_NAME, imgUrl.replace("/images/shots/s/", "/images/shots/l/"));
                String imgDescription = MobyGamesSearchEngine.extractNextContent(htmlChunk, startIndex, "<small>", "</small>").replace("<br>", " ").replace("<br/>", " ").trim();
                result.add(new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.SCREENSHOT, imgUrl, imgDescription));
                startIndex = htmlChunk.indexOf("background-image:url(", startIndex + 1);
            }
        }
        return result;
    }

    private static List<SearchEngineImageInformation> getEntryCoverArtInformation(WebProfile entry, int max, boolean forceAllRegionsCoverArt) throws IOException {
        ArrayList<SearchEngineImageInformation> result = new ArrayList<SearchEngineImageInformation>();
        if (entry.getCoreGameCoverUrl() == null) {
            return result;
        }
        int found = 0;
        String htmlChunk = MobyGamesSearchEngine.getResponseContent(entry.getCoverArtUrl(), StandardCharsets.UTF_8);
        String marker = forceAllRegionsCoverArt ? "<div class=\"thumbnail\">" : entry.getCoreGameCoverUrlWithoutPathPrefix();
        int startIndex = htmlChunk.indexOf(marker);
        while (startIndex != -1) {
            String endMarker = "</div>    </div>  </div></div>";
            int endIndex = htmlChunk.indexOf(endMarker, startIndex);
            if (endIndex != -1) {
                String divPart = htmlChunk.substring(startIndex, endIndex);
                startIndex = divPart.indexOf("background-image:url(");
                while (found < max && startIndex != -1) {
                    String imgUrl = MobyGamesSearchEngine.extractNextSrcContentParentheses(divPart, startIndex);
                    imgUrl = MobyGamesSearchEngine.absoluteUrl(MOBY_GAMES_HOST_NAME, imgUrl.replace("/images/covers/s/", "/images/covers/l/"));
                    String imgDescription = MobyGamesSearchEngine.extractNextContent(divPart, startIndex, "<p>", "</p>").replace("<br>", " ").replace("<br/>", " ").trim();
                    result.add(new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.COVER_ART, imgUrl, imgDescription));
                    startIndex = divPart.indexOf("background-image:url(", startIndex + 1);
                    ++found;
                }
            }
            startIndex = forceAllRegionsCoverArt ? htmlChunk.indexOf(marker, endIndex) : -1;
        }
        return result;
    }

    private static class SearchEngineHolder {
        private static WebSearchEngine instance_ = new MobyGamesSearchEngine();

        private SearchEngineHolder() {
        }
    }
}

