/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.abstractdialog;

import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import org.dbgl.gui.controls.Composite_;
import org.dbgl.gui.controls.DarkTheme;
import org.dbgl.gui.controls.GridData_;
import org.dbgl.gui.controls.MenuItem_;
import org.dbgl.service.ITextService;
import org.dbgl.service.ImageService;
import org.dbgl.service.SettingsService;
import org.dbgl.service.TextService;
import org.dbgl.util.SystemUtils;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;

public abstract class BaseDialog<T>
extends Dialog {
    private static final int MIN_BUTTON_WIDTH = 80;
    private static Integer averageCharacterWidth_;
    protected final SelectionAdapter closeShellAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            BaseDialog.this.shell_.close();
        }
    };
    protected final SelectionAdapter browseAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            SystemUtils.openForBrowsing(event.text);
        }
    };
    protected final Display display_;
    protected final int shellStyle_;
    protected Shell shell_;
    protected final ITextService text_;
    protected T result_;

    protected BaseDialog(Shell parent, int shellStyle) {
        super(parent, 0);
        this.display_ = parent.getDisplay();
        this.shellStyle_ = shellStyle;
        this.text_ = TextService.getInstance();
    }

    protected BaseDialog(Shell parent) {
        this(parent, 67696);
    }

    public T open() {
        if (!this.prepare()) {
            return null;
        }
        Shell shell = this.shell_ = this.shellStyle_ == 32768 ? this.getParent() : new Shell(this.getParent(), this.shellStyle_);
        if (DarkTheme.forced()) {
            this.shell_.setBackground(DarkTheme.dialogBackground);
        }
        this.shell_.setText(this.getDialogTitle());
        this.onShellInit();
        this.onShellCreated();
        this.shell_.open();
        this.onShellOpened();
        while (!this.shell_.isDisposed()) {
            this.shellDispatchCallback();
            if (this.display_.readAndDispatch()) continue;
            this.display_.sleep();
        }
        this.onClose();
        return this.result_;
    }

    protected boolean prepare() {
        return true;
    }

    protected void onShellInit() {
    }

    protected abstract String getDialogTitle();

    protected abstract void onShellCreated();

    protected void onShellOpened() {
    }

    protected void shellDispatchCallback() {
    }

    protected void onClose() {
    }

    protected static Font stringToFont(Device device, String[] font, Font defaultFont) {
        try {
            return new Font(device, font[0], Integer.parseInt(font[1]), Integer.parseInt(font[2]));
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultFont;
        }
    }

    protected static String fontToString(Font font) {
        FontData data = font.getFontData()[0];
        return data.getName() + "|" + data.getHeight() + "|" + data.getStyle();
    }

    protected static void setLayoutDataButtons(Button ... buttons) {
        Optional<Integer> maxWidth = Stream.of(buttons).map(x -> x.computeSize((int)-1, (int)-1).x).max(Comparator.naturalOrder());
        if (maxWidth.isPresent()) {
            if (averageCharacterWidth_ == null) {
                GC gc = new GC((Drawable)buttons[0]);
                averageCharacterWidth_ = (int)gc.getFontMetrics().getAverageCharacterWidth();
                gc.dispose();
            }
            int width = 4 * averageCharacterWidth_ + Math.max(maxWidth.get(), 80);
            for (Button button : buttons) {
                button.setLayoutData((Object)new GridData_(1, 4, true, false).widthHint(width).build());
            }
        }
    }

    protected static ExpandItem createExpandItem(ExpandBar expandBar, String text, boolean expanded, Composite composite) {
        ExpandItem expandItem = new ExpandItem(expandBar, 0);
        expandItem.setText(TextService.getInstance().get(text));
        expandItem.setExpanded(expanded);
        expandItem.setControl((Control)composite);
        expandItem.setHeight(composite.computeSize((int)-1, (int)-1).y);
        return expandItem;
    }

    protected static Link createLink(Composite composite, String text, SelectionListener listener) {
        Link link = new Link(composite, 0);
        if (DarkTheme.forced()) {
            link.setBackground(composite.getBackground());
            link.setLinkForeground(DarkTheme.linkForeground);
        }
        link.setText(text);
        link.addSelectionListener(listener);
        return link;
    }

    protected static ToolItem createImageToolItem(ToolBar toolBar, int style, Image image, String tooltip, SelectionListener listener) {
        ToolItem toolItem = new ToolItem(toolBar, style);
        toolItem.setImage(image);
        toolItem.setToolTipText(tooltip);
        if (listener != null) {
            toolItem.addSelectionListener(listener);
        }
        return toolItem;
    }

    protected static ToolItem createImageToolItem(ToolBar toolBar, String title, String img, SelectionListener listener) {
        ToolItem toolItem = new ToolItem(toolBar, 2056);
        int displaySelection = SettingsService.getInstance().getIntValue("gui", "buttondisplay");
        if (displaySelection != 1) {
            toolItem.setImage(ImageService.getResourceImage(toolBar.getDisplay(), img));
        }
        if (displaySelection == 2) {
            toolItem.setToolTipText(TextService.getInstance().get(title));
        } else {
            toolItem.setText(TextService.getInstance().get(title));
        }
        toolItem.addSelectionListener(listener);
        return toolItem;
    }

    protected static ToolItem createSeparatorToolItem(ToolBar toolBar, int width) {
        ToolItem toolItem = new ToolItem(toolBar, 2050);
        toolItem.setWidth(width);
        return toolItem;
    }

    protected static Menu createMenu(Menu parentMenu, String text, String img) {
        MenuItem menuItem = MenuItem_.on(parentMenu).key(text).image(img).build();
        Menu menu = new Menu(menuItem);
        menuItem.setMenu(menu);
        return menu;
    }

    protected static Menu createMenu(Menu parentMenu, String text) {
        MenuItem menuItem = MenuItem_.on(parentMenu).key(text).build();
        Menu menu = new Menu(menuItem);
        menuItem.setMenu(menu);
        return menu;
    }

    protected static TableColumn createTableColumn(Table table, int width, String text) {
        TableColumn column = new TableColumn(table, 0);
        column.setWidth(width);
        column.setText(TextService.getInstance().get(text));
        return column;
    }

    protected static SashForm createSashForm(Composite composite, int horSpan) {
        SashForm sashForm = new SashForm(composite, 256);
        if (DarkTheme.forced()) {
            sashForm.setBackground(composite.getBackground());
        }
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, horSpan, 1));
        return sashForm;
    }

    protected static Tree createTree(Composite composite) {
        Tree tree = new Tree(composite, 2080);
        if (DarkTheme.forced()) {
            tree.setBackground(composite.getBackground());
            tree.setForeground(DarkTheme.defaultForeground);
        }
        return tree;
    }

    protected static Composite createRow(Composite composite) {
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 20;
        rowLayout.marginLeft = 0;
        rowLayout.marginBottom = 0;
        rowLayout.marginBottom = 4;
        rowLayout.marginTop = 4;
        return ((Composite_.Builder)Composite_.on(composite).layoutData(new GridData(16384, 128, false, false))).layout((Layout)rowLayout).build();
    }

    protected static ToolBar createToolBar(Composite composite) {
        ToolBar toolBar = new ToolBar(composite, 0x800000);
        if (DarkTheme.forced()) {
            toolBar.setBackground(DarkTheme.toolbarBackground);
            toolBar.setForeground(DarkTheme.defaultForeground);
        }
        return toolBar;
    }

    protected static ExpandBar createExpandBar(Composite composite) {
        ExpandBar expandBar = new ExpandBar(composite, 512);
        if (DarkTheme.forced()) {
            expandBar.setBackground(composite.getBackground());
        }
        return expandBar;
    }
}

