/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.util.Collections;
import java.util.List;
import org.dbgl.gui.abstractdialog.SizeControlledButtonDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.CTabFolder_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Composite_;
import org.dbgl.gui.controls.Table_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.model.entity.SharedConf;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class LoadSharedConfDialog
extends SizeControlledButtonDialog<SharedConfLoading> {
    private String title_;
    private List<SharedConf> confs_;

    public LoadSharedConfDialog(Shell parent, String title, List<SharedConf> confs) {
        super(parent, "sharedconfbrowser");
        this.title_ = title;
        this.confs_ = confs;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.loadsharedconf.title");
    }

    @Override
    protected void onShellCreated() {
        this.contents_.setLayout((Layout)new GridLayout());
        SashForm sashForm = LoadSharedConfDialog.createSashForm(this.contents_, 1);
        sashForm.setLayout((Layout)new FillLayout());
        final Table table = Table_.on((Composite)sashForm).header().build();
        Listener sortListener = e -> {
            SharedConf selWebProfile = this.confs_.get(table.getSelectionIndex());
            TableColumn column = (TableColumn)e.widget;
            switch ((Integer)column.getData()) {
                case 0: {
                    Collections.sort(this.confs_, new SharedConf.byTitle());
                    break;
                }
                case 1: {
                    Collections.sort(this.confs_, new SharedConf.byYear());
                    break;
                }
                case 2: {
                    Collections.sort(this.confs_, new SharedConf.byVersion());
                    break;
                }
            }
            table.removeAll();
            this.populate(table);
            table.setSortColumn(column);
            table.setSortDirection(128);
            for (int i = 0; i < this.confs_.size(); ++i) {
                if (selWebProfile != this.confs_.get(i)) continue;
                table.setSelection(i);
                break;
            }
        };
        String[] titles = new String[]{this.text_.get("dialog.profile.title"), this.text_.get("dialog.profile.year"), this.text_.get("dialog.confsharing.gameversion")};
        for (int i = 0; i < titles.length; ++i) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(titles[i]);
            column.setData((Object)i);
            column.addListener(13, sortListener);
            if (i == 0) {
                table.setSortColumn(column);
                table.setSortDirection(128);
            }
            Collections.sort(this.confs_, new SharedConf.byTitle());
        }
        CTabFolder tabFolder = CTabFolder_.on((Composite)sashForm).ctrl();
        sashForm.setWeights(new int[]{40, 60});
        Composite composite = Composite_.on((Composite)tabFolder).layout((Layout)new GridLayout(3, false)).tab("dialog.confsharing.tab.info").build();
        Text author = Chain.on(composite).lbl(l -> l.key("dialog.confsharing.author")).txt(t -> ((Text_.Builder)t.horSpan(2)).nonEditable()).text();
        Text dosbox = Chain.on(composite).lbl(l -> l.key("dialog.loadsharedconf.dosboxversion")).txt(t -> ((Text_.Builder)t.horSpan(2)).nonEditable()).text();
        Text incrConf = Chain.on(composite).lbl(l -> l.key("dialog.confsharing.explanation")).txt(t -> t.multi().readOnly()).text();
        Text explanation = Text_.on(composite).multi().readOnly().wrap().build();
        Text notes = Chain.on(composite).lbl(l -> l.key("dialog.confsharing.notes")).txt(t -> (Text_.Builder)t.multi().wrap().readOnly().horSpan(2)).text();
        final Button reloadDosboxDefaults = ((Button_.Builder)Button_.on(composite).horSpan(3)).key("dialog.loadsharedconf.reloaddefaults").ctrl();
        table.addListener(13, e -> this.displaySharedConfData(table, author, dosbox, incrConf, explanation, notes));
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                LoadSharedConfDialog.this.result_ = new SharedConfLoading(LoadSharedConfDialog.this.confs_.get(table.getSelectionIndex()), reloadDosboxDefaults.getSelection());
                LoadSharedConfDialog.this.shell_.close();
            }
        });
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LoadSharedConfDialog.this.result_ = new SharedConfLoading(LoadSharedConfDialog.this.confs_.get(table.getSelectionIndex()), reloadDosboxDefaults.getSelection());
                LoadSharedConfDialog.this.shell_.close();
            }
        });
        this.populate(table);
        for (int i = 0; i < titles.length; ++i) {
            table.getColumn(i).pack();
        }
        table.setSelection(LoadSharedConfDialog.getEntryBestMatchIndex(this.title_, this.confs_));
        table.showSelection();
        this.displaySharedConfData(table, author, dosbox, incrConf, explanation, notes);
    }

    private void populate(Table table) {
        for (SharedConf p : this.confs_) {
            TableItem item = new TableItem(table, 0);
            item.setText(0, p.getGameTitle());
            item.setText(1, p.getGameYear());
            item.setText(2, p.getGameVersion());
        }
    }

    public static int getEntryBestMatchIndex(String search, List<SharedConf> confs) {
        String[] titles = new String[confs.size()];
        for (int i = 0; i < confs.size(); ++i) {
            titles[i] = confs.get(i).getGameTitle();
        }
        return StringRelatedUtils.findBestMatchIndex(search, titles);
    }

    private void displaySharedConfData(Table table, Text author, Text dosbox, Text incrConf, Text explanation, Text notes) {
        int selection = table.getSelectionIndex();
        if (selection != -1) {
            SharedConf conf = this.confs_.get(selection);
            author.setText(conf.getAuthor());
            dosbox.setText(conf.getDosboxTitle() + " (" + conf.getDosboxVersion() + ")");
            incrConf.setText(conf.getIncrConf());
            explanation.setText(conf.getExplanation());
            notes.setText(conf.getNotes());
        }
    }

    public class SharedConfLoading {
        public final SharedConf conf_;
        public final boolean reloadDosboxDefaults_;

        public SharedConfLoading(SharedConf conf, boolean reloadDosboxDefaults) {
            this.conf_ = conf;
            this.reloadDosboxDefaults_ = reloadDosboxDefaults;
        }
    }
}

