/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.util.List;
import org.dbgl.gui.abstractdialog.SizeControlledButtonDialog;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Group_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.controls.ProgressBar_;
import org.dbgl.gui.thread.LoaderThread;
import org.dbgl.model.aggregate.Profile;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProfileLoader
extends SizeControlledButtonDialog<List<Profile>> {
    private LoaderThread job_;
    private ProgressBar progressBar_;
    private Label status_;
    private Text log_;
    private final List<Profile> profs_;
    private boolean warningsDisplayed_;

    public ProfileLoader(Shell parent, List<Profile> profs) {
        super(parent, "profileloaderdialog");
        this.profs_ = profs;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.profileloader.title", new Object[]{this.profs_.size()});
    }

    @Override
    protected void onShellOpened() {
        this.job_ = new LoaderThread(this.log_, this.progressBar_, this.status_, this.profs_);
        this.job_.start();
    }

    @Override
    protected void shellDispatchCallback() {
        if (this.job_ != null && !this.job_.isAlive() && !this.warningsDisplayed_) {
            if (!this.job_.isEverythingOk()) {
                Object msg = this.text_.get("dialog.profileloader.error.reading");
                if (!this.job_.getResult().isEmpty()) {
                    this.okButton_.setEnabled(true);
                    msg = (String)msg + "\n\n" + this.text_.get("dialog.profileloader.confirm.continue", new Object[]{this.job_.getResult().size()});
                }
                Mess_.on(this.shell_).txt((String)msg).warning();
                this.status_.setText(this.text_.get("dialog.migration.reviewlog"));
                this.status_.pack();
            } else {
                this.result_ = this.job_.getResult();
                this.shell_.close();
            }
            this.warningsDisplayed_ = true;
        }
    }

    @Override
    protected void onShellCreated() {
        this.contents_.setLayout((Layout)new GridLayout());
        Group progressGroup = ((Group_.Builder)Group_.on(this.contents_).layoutData(new GridData(4, 4, true, true))).layout((Layout)new GridLayout()).key("dialog.migration.progress").build();
        this.progressBar_ = ProgressBar_.on((Composite)progressGroup).max(this.profs_.size()).build();
        Chain chain = Chain.on((Composite)progressGroup).lbl(l -> l).txt(t -> t.multi().wrap().readOnly()).build();
        this.status_ = chain.getLabel();
        this.log_ = chain.getText();
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProfileLoader.this.result_ = ProfileLoader.this.job_.getResult();
                ProfileLoader.this.shell_.close();
            }
        });
        this.okButton_.setEnabled(false);
    }
}

